<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */


# функция автоподключения плагина
function file_manager_autoload($args = array())
{	
	mso_create_allow('file_manager',  t('Админ-доступ к менеджеру файлов (плагин)', 'admin'));
	mso_hook_add( 'admin_init', 'file_manager_admin_init');
	mso_hook_add( 'admin_head', 'file_manager_admin_head');
}


function file_manager_admin_head($args = array()) 
{
	echo mso_load_jquery('alerts/jquery.alerts.js');
	echo mso_load_jquery('cornerz.js');
	echo '	<link href="' . getinfo('common_url') . 'jquery/alerts/jquery.alerts.css" rel="stylesheet" type="text/css" media="screen">';
	return $args;
}

# функция выполняется при указаном хуке admin_init
function file_manager_admin_init($args = array()) 
{	
	if ( !mso_check_allow('file_manager') ) 
	{
		return $args;
	}

	$this_plugin_url = 'file_manager'; // url и hook
	mso_admin_menu_add('plugins', $this_plugin_url, '' . t('Менеджер файлов', 'admin') . '');
	mso_admin_url_hook ($this_plugin_url, 'file_manager_admin');
	
	return $args;
}

# функция вызываемая при хуке, указанном в mso_admin_url_hook
function file_manager_admin($args = array()) 
{
	if ( !mso_check_allow('file_manager') ) 
	{
		echo 'Доступ запрещен';
		return $args;
	}
	
	# выносим админские функции отдельно в файл
	global $MSO;
	
	mso_hook_add_dinamic( 'mso_admin_header', ' return $args . "' . t('Загрузки. Файлы. Галереи', 'admin') . '"; ' );
	mso_hook_add_dinamic( 'admin_title', ' return "' . t('Загрузки. Файлы. Галереи', 'admin') . ' - " . $args; ' );
	
	require($MSO->config['plugins_dir'] . 'file_manager/admin.php');
}

function file_manager_mso_options() 
{
	# ключ, тип, ключи массива
	mso_admin_plugin_options('plugin_file_manager', 'plugins', 
		array(
			'allowed_types' => array(
						'type' => 'text', 
						'name' => 'Разрешенные типы файлов', 
						'description' => 'Список типов файлов, которые можно загружать через плагин (типы указывать через |).',
						'default' => 'mp3|gif|jpg|jpeg|png|zip|txt|rar|doc|rtf|pdf|html|htm|css|xml|odt|avi|wmv|flv|swf|wav|xls|7z|gz|bz2|tgz'
			),
			'hide_options' => array(
						'type' => 'select',
						'name' => t('Прятать настройки в спойлер', 'plugins'),
						'description' => t('Прячет настройки обработки картинок и создания/удаления папок под спойлер', 'plugins'),
						'values' => t('1||Да #2||Нет', 'plugins'),
						'default' => '1'					
			),
			'tree_expand' => array(
						'type' => 'select',
						'name' => t('Разворачивать дерево', 'plugins'),
						'description' => t('При навигации по папкам дерево всегда полностью разверачивается. При смене настройки обязательно нужно очистить кэш', 'plugins'),
						'values' => t('1||Да #2||Нет', 'plugins'),
						'default' => '1'					
			),
			'show_size' => array(
						'type' => 'select',
						'name' => t('Показывать размер', 'plugins'),
						'description' => t('Показывать размер файлов возле имени?', 'plugins'),
						'values' => t('1||Да #2||Нет', 'plugins'),
						'default' => '1'					
			),
		),
		'Настройки плагина "Менеджер файлов"', // титул
		'Укажите необходимые опции.'   // инфо
	);
}
?>