<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 *
 * Alexander Schilling
 * (c) http://alexanderschilling.net/
 */
 
 
# функция автоподключения плагина
function dignity_businessquote_autoload($args = array())
{
	# регистрируем виджет
	mso_register_widget('dignity_businessquote_widget', t('Бизнес цитата', 'plugins')); 
}

function dignity_businessquote_uninstall($args = array())
{	
	mso_delete_option_mask('dignity_businessquote_widget_', 'plugins'); // удалим созданные опции
	return $args;
}

# функция виджета
function dignity_businessquote_widget($num = 1)
{
	$widget = 'dignity_businessquote_widget_' . $num; // имя для опций = виджет + номер
	$options = mso_get_option($widget, 'plugins', array() ); // получаем опции
	
	// заменим заголовок, чтобы был в  h2 class="box"
	if ( isset($options['header']) and $options['header'] ) 
		$options['header'] = mso_get_val('widget_header_start', '<h2 class="box"><span>') . $options['header'] . mso_get_val('widget_header_end', '</span></h2>');
	else $options['header'] = '';
	
	return dignity_businessquote_widget_custom($options, $num);
}

# функция вывода формы настройки виджета
function dignity_businessquote_widget_form($num = 1)
{
	$widget = 'dignity_businessquote_widget_' . $num; // имя для формы и опций = виджет + номер
	
	// получаем опции 
	$options = mso_get_option($widget, 'plugins', array());
	
	if ( !isset($options['header']) ) $options['header'] = '';
	if ( !isset($options['once_daily']) ) $options['once_daily'] = 'random';
	
	// вывод самой формы
	$CI = & get_instance();
	$CI->load->helper('form');
	
	$form = '<p><div class="t150">' . t('Заголовок:', 'plugins') . '</div> '. 
			form_input( array( 'name'=>$widget . 'header', 'value'=>$options['header'] ) ) ;
	
	$form .= '<p><div class="t150">' . t('Способ вывода:', 'plugins') . '</div> '. form_dropdown( $widget . 'once_daily', array( 'random'=>t('Случайным образом', 'plugins'), 'day'=>t('Раз в сутки', 'plugins')), $options['once_daily']);
	
	$form .= '<br><div class="t150">&nbsp</div> ' . 
			t('При выборе «Раз в сутки» выводится строчка, номер которой совпадает с сегодняшним числом.', 'plugins');
	
	return $form;
}


# сюда приходят POST из формы настройки виджета
# имя функции = виджет_update
function dignity_businessquote_widget_update($num = 1) 
{
	$widget = 'dignity_businessquote_widget_' . $num; // имя для опций = виджет + номер
	
	// получаем опции
	$options = $newoptions = mso_get_option($widget, 'plugins', array());
	
	# обрабатываем POST
	$newoptions['header'] = mso_widget_get_post($widget . 'header');
	$newoptions['once_daily'] = mso_widget_get_post($widget . 'once_daily');
	
	if ( $options != $newoptions ) 
		mso_add_option($widget, $newoptions, 'plugins');
}


# основная функция
function dignity_businessquote_widget_custom($arg = array(), $num = 1)
{
	if ( !isset($arg['header'])) $arg['header'] = mso_get_val('widget_header_start', '<h2 class="box"><span>') . t('Бизнес цитата', 'plugins') . mso_get_val('widget_header_end', '</span></h2>') ;
	if ( !isset($arg['block_start']) ) $arg['block_start'] = '<div class="random-text">';
	if ( !isset($arg['block_end']) ) $arg['block_end'] = '</div>';
	if ( !isset($arg['once_daily']) ) $arg['once_daily'] = 'random';
	
	$text = '';
	
	# если есть ушка dignity_businessquote, то берем текст из неё
	if (function_exists('ushka')) 
	{
		$text = ushka('dignity_businessquote', "\n");
	}
	
	if (!$text)
	{
		$text ='«Если у Вас нет бизнеса в интернет – у Вас вообще нет бизнеса!» - Билл Гейтс.
		«Тот, кто хочет видеть результаты своего труда немедленно, должен идти в сапожники.» - Альберт Эйнштейн
		«Если вы считаете, что обучение стоит дорого, попробуйте узнать, сколько стоит невежество.» - Роберт Кийосаки
		«Все можно сделать лучше, чем делалось до сих пор.» - Генри Форд
		«Что вы должны сделать - так это создать великолепный продукт или сервис с целью изменить мир. Если вы сделаете это, вы можете стать легендой.» - Гай Кавасаки
		«Выбирая ваших клиентов, вы выбираете свое будущее.» - Сет Годин
		«Есть главный секрет успеха, с которым не может потерпеть неудачу ни один человек. Его имя - простота, уменьшающая каждую проблему до самого простого.» - Генри Детердинг
		«Высшее руководство должно тратить 40-50 процентов времени на обучение и мотивацию своих людей.» - Бак Роджерс
		«Благоприятная возможность скрывается среди трудностей и проблем.» - Альберт Эйнштейн
		«Есть 2 вида денежных проблем: одна — когда их недостаточно, и другая — когда их слишком много. Какую проблему выбираете Вы?» - Роберт Кийосаки
		«Начните с мелких сделок. Только образование и опыт делают человека богаче и богаче.» - Роберт Кийосаки
		«Если говорят о рекламе, это плохая реклама. Если говорят о товаре, это хорошая реклама.» - Дэйвид Огилви
		«Стремись не к тому, чтобы добиться успеха, а к тому, чтобы твоя жизнь имела смысл.» - Альберт Эйнштейн
		«Cамая трудная для понимания вещь на свете — это подоходный налог.» - Альберт Эйнштейн
		«Я предпочел бы получать доход от 1% усилий ста человек, чем от 100% своих собственных усилий.» - Джон Дэвисон Рокфеллер
		«Во всякой организации по меньшей мере 50% всего расходуется впустую - 50% людей, 50% усилий, 50% пространства и 50% времени.» - Роберт Таунзенд
		«Человек, который не умеет улыбаться, не должен заниматься торговлей.» - Китайская пословица
		«Если хотите придумать отличные идеи, знайте: лучшие из них вы можете позаимствовать.» - Томас Эдисон
		«Никогда не упускайте из виду тот факт, что самый важный критерий вашего успеха - это то, как вы относитесь к другим людям.» - Барбара Буш
		«Какой бы ни была ваша цель, вы сможете ее достигнуть, если только захотите потрудиться.» - Опра Уинфри
		«Господи, огради меня от человека, никогда не совершающего ошибок, а также от человека, который совершает одну ошибку дважды.» - Уильям Майо
		«Вы можете быть автором прекрасных идей, однако этого мало, надо уметь довести их до ума людей, иначе вы ничего не добьетесь.» - Ли Якокка
		«Слово "кризис", написанное по-китайски, состоит из двух иероглифов: один означает "опасность", другой – "благоприятная возможность".» - Джон Кеннеди
		«Правило номер один для того, кто хочет стать предпринимателем: никогда не устраивайся на работу ради денег.» - Роберт Кийосаки
		«Цели должны быть ясными, простыми и записанными на бумаге. Если они не записаны на бумаге и их каждый день пересматриваешь - это не цели. Это пожелания.» - Роберт Кийосаки
		«Самым важным слагаемым формулы успеха является умение ладить с людьми.» - Теодор Рузвельт
		«Лидер действует открыто, босс — за закрытыми дверьми. Лидер ведет за собой, а босс управляет.» - Теодор Рузвельт
		«Если подчиненный всегда соглашается со своим начальником, то он - бесполезная часть организации.» - Хайман Джордж Риковер
		«Дайте клиенту выбор, и он оставит у вас все свои деньги.» - Филип Котлер
		«Если человек говорит, что его слово также твёрдо, как его залог, возьми с него залог.» - Томас Роберт Дьюар
		«Когда необходимо сделать выбор, а вы его не делаете, - это тоже выбор.» - Уильям Джеймс
		«В любом проекте важнейшим фактором является вера в успех. Без веры успех невозможен.» - Уильям Джеймс
		«Сделайте свою жизнь работой вместо того, чтобы наполнять работой свою жизнь.» - Стивен Кови
		«Самую большую ошибку в жизни люди делают, когда они не пытаются зарабатывать на жизнь тем, что им больше всего нравится.» - Малкольм Форбс
		«Мне все равно, откуда человек: из тюрьмы Синг-Синг или из Гарварда. Мы нанимаем человека, а не его биографию.» - Малкольм Форбс
		«Ваш самый главный актив - это вы сами. Вложите свое время, свои усилия и деньги в обучение, подготовку и поддержку вашего самого главного актива.» - Том Хопкинс
		«Время - это единственное, что нельзя накопить, оно не сохраняется и не увеличивается. Его можно только обменять - на деньги или на знания. Время - это вообще самое важное.» - Ямагучи Тадао
		«Большинство людей сдается как раз в то самое время, когда они уже почти достигли успеха.» - Росс Перо
		«Идите и делайте - оправдаться вы всегда успеете позже.» - Грейс Мюррей Хоппер
		«Не почитай денег ни больше, ни меньше, чем они того стоят; это хороший слуга и плохой господин. » - Александр Дюма-сын
		«Компания ничего не достигнет, если думать будет только руководство.» - Акио Морита
		«Ты можешь послать сына в колледж, но ты не можешь научить его думать.» - Томас Роберт Дьюар
		«Человек, который не делает ошибок, обычно вообще ничего не делает.» - Эдвард Фелпс
		«Если вы видите цену, то она автоматически оказывает на вас влияние.» - Уоррен Баффетт
		«Тот, кто в совершенстве овладеет электронной почтой, будет миллионером в двадцать первом веке.» - Билл Гейтс
		«Невозможность - слово из словаря глупцов.» - Наполеон Бонапарт
		«В будущем на рынке останется два вида компаний: те, кто в Интернет и те, кто вышел из бизнеса.» - Билл Гейтс
		«Что есть поражение? Не что иное, как урок, не что иное, как первый шаг к чему-то лучшему.» - Уэнделл Филлипс
		«Счастье за деньги не купишь. А вот некоторую независимость - да.» - Роман Абрамович
		«Одна из самых глупых вещей, которую вы можете сделать с деньгами - это потратить их.» - Роберт Антон Уилсон
		«Деньги не нужны: эти бумажки уже в современной экономике никому не нужны – нам нужны активы.» - Владимир Путин
		«Любая хорошая в теории стратегия оказывается глупой на практике.» - Скотт Адамс
		«Кто боится неудач, тот ограничивает свою деятельность.» - Генри Форд
		«Нет ничего более преступного для финансового благополучия, чем придумать отличную идею и не удосужиться реализовать ее.» - Дональд Трамп
		«Только два стимула заставляют работать людей: жажда заработной платы и боязнь ее потерять.» - Генри Форд
		«Искусство управления состоит в том, чтобы не позволять людям состариться в своей должности.» - Наполеон Бонапарт
		«Конкуренция - жизнь торговли и смерть торговцев.» - Элберт Хаббард
		«Неудача – это возможность начать заново, но уже более мудро.» - Генри Форд
		«Маленькая течь топит большой корабль.» - Бенджамин Франклин
		«Успешные лидеры строят свои организации из людей, желающих взобраться на самую вершину.» - Джефф О-Лири
		«Прибыль есть прибыль, как бы мала она ни была.» - Роберт Браунинг
		«Никогда не вкладывайте деньги в идею, которую вы не можете объяснить на пальцах.» - Питер Линч
		«Бизнес захватывает сильнее, чем любая игра.» - Лорд Бивербрук
		«Всем, кто открывает новое дело, регистрирует предприятия, нужно давать медаль за личное мужество.» - Владимир Путин
		«Дружба, основанная на бизнесе, лучше, чем бизнес, основанный на дружбе.» - Джон Дэвисон Рокфеллер
		«Ваше благополучие зависит от ваших собственных решений.» - Джон Дэвисон Рокфеллер
		«Люди не знают, чего хотят, до тех пор, пока им это не предложат.» - Теренс Конран
		«Деньги для людей умных составляют средство, для глупцов - цель.» - Адриан Декурсель';
	}
	
	
	$text = str_replace("\r", "", $text);
	$text = str_replace("\n\n", "\n", $text);
	
	$text = explode("\n", $text); // массив строк
	
	if ($arg['once_daily'] == 'day') // вывод раз в сутки
	{
		$d = date('d') + 1; // текущее число + 1
		if ($d <= sizeof($text)) $out = $text[$d];
			else $out = $text[sizeof($text)-1];
	}
	else // случайным образом
	{
		$out = trim($text[ mt_rand(0, count($text) - 1) ] );
	}
	
	return $arg['header'] . $arg['block_start'] . $out . $arg['block_end'];
}

# end file
