<?

/**
 *   MaxSite CMS
 *      
 * (c) http://kerzoll.org.ua/
 */

$path = getinfo('uploads_dir').'iptocountry/';

define('FILENAME', $path.'iptocountry');

function ip2country($Addr)
{
	$ip = ip2long($Addr);
	$ip = intval($ip < 0 ? 2147483648 + $ip : $ip - 2147483648);

	if (!$handle = fopen(FILENAME.".dat", 'r'))
	{
		trigger_error(t('ip2country()     : ', __FILE__).$fname, E_USER_WARNING);
		return null;
	}
	$low = 0;
	$upper = fstat($handle);
	$upper = $upper['size'] / 10;

	while (($upper - $low) > 1)
	{
		$mid = (int) (($upper + $low) / 2);

		fseek($handle, $mid * 10);
		$data = unpack('V2ip/a2code', fread($handle, 10));

		if ($ip >= $data['ip1'])
		{
			if ($ip <= $data['ip2']) break;
			$low = $mid;
		}
		else $upper = $mid;
	}
	fclose($handle);
	return ($ip >= $data['ip1'] && $ip <= $data['ip2']) ? $data['code'] : null;
}

$country_list = array(
  'AF'=>"Afghanistan",
  'AX'=>"Aland Islands",
  'AL'=>"Albania",
  'DZ'=>"Algeria",
  'AS'=>"American Samoa",
  'AD'=>"Andorra",
  'AO'=>"Angola",
  'AI'=>"Anguilla",
  'AQ'=>"Antarctica",
  'AG'=>"Antigua and Barbuda",
  'AR'=>"Argentina",
  'AM'=>"Armenia",
  'AW'=>"Aruba",
  'AU'=>"Australia",
  'AT'=>"Austria",
  'AZ'=>"Azerbaijan",
  'BS'=>"Bahamas",
  'BH'=>"Bahrain",
  'BD'=>"Bangladesh",
  'BB'=>"Barbados",
  'BY'=>"Belarus",
  'BE'=>"Belgium",
  'BZ'=>"Belize",
  'BJ'=>"Benin",
  'BM'=>"Bermuda",
  'BT'=>"Bhutan",
  'BO'=>"Bolivia",
  'BA'=>"Bosnia and Herzegovina",
  'BW'=>"Botswana",
  'BV'=>"Bouvet Island",
  'BR'=>"Brazil",
  'IO'=>"British Indian Ocean Territory",
  'BN'=>"Brunei Darussalam",
  'BG'=>"Bulgaria",
  'BF'=>"Burkina Faso",
  'BI'=>"Burundi",
  'KH'=>"Cambodia",
  'CM'=>"Cameroon",
  'CA'=>"Canada",
  'CV'=>"Cape Verde",
  'KY'=>"Cayman Islands",
  'CF'=>"Central African Republic",
  'TD'=>"Chad",
  'CL'=>"Chile",
  'CN'=>"China",
  'CX'=>"Christmas Island",
  'CC'=>"Cocos (keeling) Islands",
  'CO'=>"Colombia",
  'KM'=>"Comoros",
  'CG'=>"Congo",
  'CD'=>"Congo Democratic Republic of",
  'CK'=>"Cook Islands",
  'CR'=>"Costa Rica",
  'CI'=>"Cote D'ivoire",
  'HR'=>"Croatia",
  'CU'=>"Cuba",
  'CY'=>"Cyprus",
  'CZ'=>"Czech Republic",
  'DK'=>"Denmark",
  'DJ'=>"Djibouti",
  'DM'=>"Dominica",
  'DO'=>"Dominican Republic",
  'EC'=>"Ecuador",
  'EG'=>"Egypt",
  'SV'=>"El Salvador",
  'GQ'=>"Equatorial Guinea",
  'ER'=>"Eritrea",
  'EE'=>"Estonia",
  'ET'=>"Ethiopia",
  'EU'=>"European Union",
  'FK'=>"Falkland Islands (Malvinas)",
  'FO'=>"Faroe Islands",
  'FJ'=>"Fiji",
  'FI'=>"Finland",
  'FR'=>"France",
  'FX'=>"France, Metropolitan",
  'GF'=>"French Guyana",
  'PF'=>"French Polynesia",
  'TF'=>"French Southern Territories",
  'GA'=>"Gabon",
  'GM'=>"Gambia",
  'GE'=>"Georgia",
  'DE'=>"Germany",
  'GH'=>"Ghana",
  'GI'=>"Gibraltar",
  'GR'=>"Greece",
  'GL'=>"Greenland",
  'GD'=>"Grenada",
  'GP'=>"Guadeloupe",
  'GU'=>"Guam",
  'GT'=>"Guatemala",
  'GG'=>"Guernsey",
  'GN'=>"Guinea",
  'GW'=>"Guinea-Bissau",
  'GY'=>"Guyana",
  'HT'=>"Haiti",
  'HM'=>"Heard and Mcdonald Islands",
  'HN'=>"Honduras",
  'HK'=>"Hong Kong",
  'HU'=>"Hungary",
  'IS'=>"Iceland",
  'IN'=>"India",
  'ID'=>"Indonesia",
  'IR'=>"Iran (Islamic Republic of)",
  'IQ'=>"Iraq",
  'IE'=>"Ireland",
  'IM'=>"Isle of Man",
  'IL'=>"Israel",
  'IT'=>"Italy",
  'JM'=>"Jamaica",
  'JP'=>"Japan",
  'JE'=>"Jersey",
  'JO'=>"Jordan",
  'KZ'=>"Kazakhstan",
  'KE'=>"Kenya",
  'KI'=>"Kiribati",
  'KP'=>"Korea, Democratic Ppl's Republic",
  'KR'=>"Korea, Republic of",
  'KW'=>"Kuwait",
  'KG'=>"Kyrgyzstan",
  'LA'=>"Lao Ppl's Democratic Republic",
  'LV'=>"Latvia",
  'LB'=>"Lebanon",
  'LS'=>"Lesotho",
  'LR'=>"Liberia",
  'LY'=>"Libyan Arab Jamahiriya",
  'LI'=>"Liechtenstein",
  'LT'=>"Lithuania",
  'LU'=>"Luxembourg",
  'MO'=>"Macao",
  'MK'=>"Macedonia The Republic",
  'MG'=>"Madagascar",
  'MW'=>"Malawi",
  'MY'=>"Malaysia",
  'MV'=>"Maldives",
  'ML'=>"Mali",
  'MT'=>"Malta",
  'MH'=>"Marshall Islands",
  'MQ'=>"Martinique",
  'MR'=>"Mauritania",
  'MU'=>"Mauritius",
  'YT'=>"Mayotte",
  'MX'=>"Mexico",
  'FM'=>"Micronesia",
  'MD'=>"Moldova, Republic of",
  'MC'=>"Monaco",
  'MN'=>"Mongolia",
  'ME'=>"Montenegro",
  'MS'=>"Montserrat",
  'MA'=>"Morocco",
  'MZ'=>"Mozambique",
  'MM'=>"Myanmar",
  'NA'=>"Namibia",
  'NR'=>"Nauru",
  'NP'=>"Nepal",
  'NL'=>"Netherlands",
  'AN'=>"Netherlands Antilles",
  'NC'=>"New Caledonia",
  'NZ'=>"New Zealand",
  'NI'=>"Nicaragua",
  'NE'=>"Niger",
  'NG'=>"Nigeria",
  'NU'=>"Niue",
  'NF'=>"Norfolk Island",
  'MP'=>"Northern Mariana Islands",
  'NO'=>"Norway",
  'OM'=>"Oman",
  'PK'=>"Pakistan",
  'PW'=>"Palau",
  'PS'=>"Palestinian Territory, Occupied",
  'PA'=>"Panama",
  'PG'=>"Papua New Guinea",
  'PY'=>"Paraguay",
  'PE'=>"Peru",
  'PH'=>"Philippines",
  'PN'=>"Pitcairn",
  'PL'=>"Poland",
  'PT'=>"Portugal",
  'PR'=>"Puerto Rico",
  'QA'=>"Qatar",
  'RE'=>"Reunion",
  'RO'=>"Romania",
  'RU'=>"Russian Federation",
  'RW'=>"Rwanda",
  'GS'=>"S. Georgia and S. Sandwich Islands",
  'BL'=>"Saint Barthelemy",
  'KN'=>"Saint Kitts and Nevis",
  'LC'=>"Saint Lucia",
  'MF'=>"Saint Martin (French part)",
  'WS'=>"Samoa",
  'SM'=>"San Marino",
  'ST'=>"Sao Tome and Principe",
  'SA'=>"Saudi Arabia",
  'SN'=>"Senegal",
  'RS'=>"Serbia",
  'SC'=>"Seychelles",
  'SL'=>"Sierra Leone",
  'SG'=>"Singapore",
  'SK'=>"Slovakia",
  'SI'=>"Slovenia",
  'SB'=>"Solomon Islands",
  'SO'=>"Somalia",
  'ZA'=>"South Africa",
  'ES'=>"Spain",
  'LK'=>"Sri Lanka",
  'SH'=>"St. Helena",
  'PM'=>"St. Pierre and Miquelon",
  'VC'=>"St. Vincent and The Grenadines",
  'SD'=>"Sudan",
  'SR'=>"Suriname",
  'SJ'=>"Svalbard and Jan Mayen Islands",
  'SZ'=>"Swaziland",
  'SE'=>"Sweden",
  'CH'=>"Switzerland",
  'SY'=>"Syrian Arab Republic",
  'TW'=>"Taiwan, Republic of China",
  'TJ'=>"Tajikistan",
  'TZ'=>"Tanzania, United Republic of",
  'TH'=>"Thailand",
  'TP'=>"Timor-Leste",
  'TG'=>"Togo",
  'TK'=>"Tokelau",
  'TO'=>"Tonga",
  'TT'=>"Trinidad and Tobago",
  'TN'=>"Tunisia",
  'TR'=>"Turkey",
  'TM'=>"Turkmenistan",
  'TC'=>"Turks and Caicos Islands",
  'TV'=>"Tuvalu",
  'UG'=>"Uganda",
  'UA'=>"Ukraine",
  'AE'=>"United Arab Emirates",
  'GB'=>"United Kingdom",
  'US'=>"United States",
  'UY'=>"Uruguay",
  'UM'=>"Us Minor Outlying Islands",
  'UZ'=>"Uzbekistan",
  'VU'=>"Vanuatu",
  'VA'=>"Vatican City State",
  'VE'=>"Venezuela",
  'VN'=>"Viet Nam",
  'VG'=>"Virgin Islands (British)",
  'VI'=>"Virgin Islands (US)",
  'WF'=>"Wallis And Futuna Islands",
  'EH'=>"Western Sahara",
  'YE'=>"Yemen",
  'ZM'=>"Zambia",
  'ZW'=>"Zimbabwe"
);

//$country_default = ip2country($_SERVER['REMOTE_ADDR']);
//if (!array_key_exists($country_default, $country_list)) $country_default = 'US';

?>