<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 



/**

 * MaxSite CMS

 * (c) http://max-3000.com/

 */



# функция автоподключения плагина

function friendly_urls_autoload()

{

	mso_hook_add('init', 'friendly_urls_init'); # хук на init для редиректа старых адресов

	mso_hook_add('global_cache_start', 'friendly_urls_start');

	mso_hook_add('custom_page_404', 'friendly_urls_404'); # хук на 404-страницу

	mso_hook_add('mso_get_pages', 'friendly_urls_get_pages_params'); # хук на mso_get_pages



	# обработка sitemap.xml

	mso_hook_add('edit_category', 'friendly_urls_sitemap_xml', 0);

	mso_hook_add('new_category', 'friendly_urls_sitemap_xml', 0);

	mso_hook_add('delete_category', 'friendly_urls_sitemap_xml', 0);

	mso_hook_add('new_page', 'friendly_urls_sitemap_xml', 0);

	mso_hook_add('edit_page', 'friendly_urls_sitemap_xml', 0);

	

	# хук для конвертации урлов

	mso_hook_add('furl', 'friendly_urls_parse');

}



# функция выполняется при активации (вкл) плагина

function friendly_urls_activate($args = array())

{	

	mso_create_allow(basename(dirname(__FILE__)).'_options', 'Админ-доступ к настройкам Friendly URLs');

	return $args;

}



# функция выполняется при деактивации (выкл) плагина

function friendly_urls_deactivate($args = array())

{	

	return $args;

}



# функция выполняется при деинсталяции плагина

function friendly_urls_uninstall($args = array())

{	

	mso_delete_option('plugin_'.basename(dirname(__FILE__)), 'plugins'); # удалим созданные опции

	mso_remove_allow(basename(dirname(__FILE__)).'_options'); # удалим созданные разрешения

	return $args;

}



# функция отрабатывающая миниопции плагина (function плагин_mso_options)

# если не нужна, удалите целиком

function friendly_urls_mso_options() 

{

	if ( !mso_check_allow('friendly_urls_options') ) 

	{

		echo t('Доступ запрещен');

		return;

	}

		

	$CI = & get_instance();



	if( $CI->config->item('mso_permalink_no_slug') === "yes" || $CI->config->item('mso_permalink_slug_cat') === "yes" )

	{

		echo '<h1><a href="">Настройки плагина Friendly URLs</a></h1>'.NR;

		echo '<div class="error">В данный момент в настройках сайта ещё не запрещены синонимы страниц! Подробнее о настройке читайте <a href="http://vizr.ru/page/spravka-po-plaginu-friendly-urls">здесь</a></div>'.NR;

		

		return;

	}



	# ключ, тип, ключи массива

	mso_admin_plugin_options('plugin_friendly_urls', 'plugins', 

		array(

		

			'non-default-urls' => array(

							'type' => 'checkbox', 

							'name' => t('Использовать нестандартные шаблоны URI'), 

							'description' => 'В этом случае будут использоваться описанные ниже правила. Иначе будут работать только стандартные для движка URL-ы.', 

							'default' => '0'

						),

								

			'pages-urls' => array(

							'type' => 'text',

							'name' => 'Шаблон URI для записей',

							'description' => 'Укажите шаблон для замены стандартных адресов «/page/page-slug». Можно использовать макросы: <b>{page-slug}</b>, <b>{page-id}</b>, <b>{cat-slug}</b>, <b>{sub-cat-slug}</b>, <b>{cat-sub-cat-slug}</b>, <b>{year}</b>, <b>{month}</b>, <b>{day}</b>, <b>{hour}</b>, <b>{minute}</b>, <b>{second}</b>, <b>{author}</b>, <b>{type}</b>.',

							'default' => '/{cat-slug}/{page-slug}.html'

						),



			'pages-urls-no-cat' => array(

							'type' => 'text',

							'name' => 'Шаблон URI для записей без рубрик',

							'description' => 'Укажите шаблон для замены адресов «/page/page-slug» страниц, у которых нет хотя бы одной присвоенной рубрики. Можно использовать макросы: <b>{page-slug}</b>, <b>{page-id}</b>, <b>{year}</b>, <b>{month}</b>, <b>{day}</b>, <b>{hour}</b>, <b>{minute}</b>, <b>{second}</b>, <b>{author}</b>, <b>{type}</b>.',

							'default' => '/{page-slug}.html'

						),



			'categories-urls' => array(

							'type' => 'text',

							'name' => 'Шаблон URI для категорий',

							'description' => 'Укажите шаблон для замены у категорий адрес вида «/category/category-slug». Можно использовать макросы: <b>{cat-id}</b>, <b>{cat-slug}</b>, <b>{cat-parent-id}</b>, <b>{cat-parent-slug}</b>, <b>{parent-child-cat-slug}</b>.',

							'default' => '/{cat-slug}/'

						),

			'next-slug-tmpl' => array(

							'type' => 'text',

							'name' => 'Учитывать нестандартные next-сегменты в адресах',

							'description' => 'Если на сайте иcпользуются плагины, которые для своих нужд генерируют адреса с пагинацией, отличной от стандартной ("/next/"), то для корректной работы чпу нужно перечислить используемые сегменты. Например, «comment-next, more». Оставьте поле пустым, если вы не поняли о чём идёт речь.',

							'default' => ''

						),

			),

		t('Настройки плагина Friendly URLs'), # титул

		t('Плагин позволяет задавать новые шаблоны URI (URL) для рубрик и записей. Для правильной настройки плагина ознакомьтесь со <a href="http://vizr.ru/page/spravka-po-plaginu-friendly-urls" target=_blank>справочной информацией</a>.')   // инфо

	);

}



# функция редиректа старых адресов

function friendly_urls_init( $args = array() )

{

	global $MSO;

		

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());

		

	# ничего не делаем если ЧПУ не разрешено использовать

	if( !isset($options['non-default-urls']) || !$options['non-default-urls'] ) return $args;

	

	if( preg_match('!^\/admin\/(.*?)!is', $_SERVER['REQUEST_URI'], $parts) ) return $args;



	# используем кэширование

	$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

	$cache_key = basename(dirname(__FILE__)).'-pages';



	if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

	{

		$MSO->data[basename(dirname(__FILE__))]['pages'] = unserialize(str_replace('_serialize_', '', $cache));

	}



	#if( is_login() ) pr($MSO->data[basename(dirname(__FILE__))]['pages']);

	

	if( isset($options['pages-urls']) && $options['pages-urls'] != '' )

	{

		if( preg_match('!(\/)(page\/)(.*?)([\/\?\#](.*?)$|$)!is', $_SERVER['REQUEST_URI'], $parts) )

		{

			$uri = friendly_urls_pages( $parts );

			if( $parts[0] != $uri )

			{

				$uri = substr($uri, 0, 1) == '/' ? substr($uri, 1) : $uri; # игнорируем слеш в начале uri

				mso_redirect($uri, false, 301);

			}

		}



		if( preg_match('!\/feed$!is', $_SERVER['REQUEST_URI']) )

		{

			$pg = friendly_urls_parse_page_uri( $_SERVER['REQUEST_URI'] ); 

			if( $pg )

			{

				$MSO->data['type'] = 'page';

			

				if( $f = mso_find_ts_file('type/feed/page.php') )

				{

					require($f);

					die();

				}

			}

		}

	}

	

	if( isset($options['categories-urls']) && $options['categories-urls'] != '' )

	{

		if( preg_match('!(\/)(category\/)(.*?)([\/\?\#](.*?)$|$)!is', $_SERVER['REQUEST_URI'], $parts) )

		{

			$uri = friendly_urls_cats( $parts );

			if( $parts[0] != $uri )

			{

				$uri = substr($uri, 0, 1) == '/' ? substr($uri, 1) : $uri; # игнорируем слеш в начале uri

				mso_redirect($uri, false, 301);

			}

		}

			

		if( preg_match('!\/feed$!is', $_SERVER['REQUEST_URI']) )

		{

			$cat = friendly_urls_parse_cat_uri( $_SERVER['REQUEST_URI'] ); 

			if( $cat )

			{

				$MSO->data['type'] = 'category';

			

				if( $f = mso_find_ts_file('type/feed/category.php') )

				{

					require($f);

					die();

				}

			}

		}

	}

		

	return $args;

}



# функция обработки sitemap.xml

function friendly_urls_sitemap_xml( $args = array() )

{

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());



	$CI = & get_instance();

	$CI->load->helper('file'); # хелпер для работы с файлами

	

	$fn = getinfo('FCPATH').'sitemap.xml';

	

	$out = read_file( $fn ); if( !$out ) return $args;

	

	$out = friendly_urls_parse( $out );



	write_file($fn, $out);



	return $args;

}



# функция начала захвата тела страниц

function friendly_urls_start( $args = array() )

{

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());

		

	# ничего не делаем если не ЧПУ не разрешено использовать

	if( !isset($options['non-default-urls']) || !$options['non-default-urls'] ) return $args;



	# используем кэширование

	if( !isset($MSO->data[basename(dirname(__FILE__))]['pages']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-pages'.str_replace('/', '-', $_SERVER['REQUEST_URI']);



		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['pages'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

		

	if( !isset($MSO->data[basename(dirname(__FILE__))]['categories']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-categories'.str_replace('/', '-', $_SERVER['REQUEST_URI']);



		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['categories'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

		

        mso_hook_add('global_cache_end', 'friendly_urls_end');

        ob_start();

        	

	return $args;

}



# функция завершения захвата тела страниц

function friendly_urls_end( $args = array() )

{

	global $MSO;

		

	$content = ob_get_contents();

	ob_end_clean();

	

	if( stripos($content, "<html") === false )

	{

		echo $content;

		exit;

	}

		

	$content = preg_replace(

		'/value\=\"(.{32})\" name\=\"comments_session\"/msi',

		'value="'.$MSO->data['session']['session_id'].'" name="comments_session"',

		$content

	);

		

	echo friendly_urls_parse( $content );



	# сохраняем кеш на диск

	$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

	if( isset($MSO->data[basename(dirname(__FILE__))]['pages']) )

	{

		$cache_key = basename(dirname(__FILE__)).'-pages'.str_replace('/', '-', $_SERVER['REQUEST_URI']);

		mso_add_cache($cache_key, '_serialize_'.serialize( $MSO->data[basename(dirname(__FILE__))]['pages'] ), $cache_time * 60); 

	}

	if( isset($MSO->data[basename(dirname(__FILE__))]['categories']) )

	{

		$cache_key = basename(dirname(__FILE__)).'-categories'.str_replace('/', '-', $_SERVER['REQUEST_URI']);

		mso_add_cache($cache_key, '_serialize_'.serialize( $MSO->data[basename(dirname(__FILE__))]['categories'] ), $cache_time * 60); 

	}

		

	return $args;

}



# функция переделки ссылок в теле страниц

function friendly_urls_parse( $text = '' )

{

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());



	if( isset($options['pages-urls']) && $options['pages-urls'] != '' )

	{

		$text = preg_replace_callback('!('.getinfo('siteurl').'|[\"\']|[\"\']\/)(page\/)(.*?)([\?\#\"\'\<\s]|$)!is', 'friendly_urls_pages', $text);

	}

	

	if( isset($options['categories-urls']) && $options['categories-urls'] != '' )

	{

			

		$text = preg_replace_callback('!('.getinfo('siteurl').'|[\"\']|[\"\']\/)(category\/)(.*?)([\?\#\"\'\<\s]|$)!is', 'friendly_urls_cats', $text);

			

		# фиксим ссылки feed для категорий

		$text = preg_replace_callback('!\/([^\/]*?)(\/feed)!is', 'friendly_urls_cats_feed', $text);



		# фиксим //next ссылки для категорий

		$text = preg_replace_callback('!('.getinfo('siteurl').'|[\"\']|[\"\']\/)([^\s]+?)\/\/next\/(.*?)([\?\#\"\'\<\s]|$)!is', 'friendly_urls_cats_bad_next', $text);



		# боремся с глюком next-ссылки на первую страницу категории

		if( 

			preg_match( '!^(.+?)\/next\/(.+?)!is', $_SERVER['REQUEST_URI'], $next ) && 

			( preg_match( '!\/$!is', $options['categories-urls'] ) || preg_match( '!\/\$$!is', $options['categories-urls'] ) )

		)

		{

			if( friendly_urls_parse_cat_uri($next[1]) )

			{

				$url = getinfo('siteurl').( substr($next[1], 0, 1) == '/' ? substr($next[1], 1) : $next[1] );

				$text = preg_replace('!('.$url.')([\?\#\"\'\<\s]|$)!is', $url.'/\\2', $text);

			}

		}

		

	}

		

	# фиксим баг с link rel="canonical"

	$text = preg_replace_callback('!\<link rel\=\"canonical\" href\=\"(.*?)\"\>!is', 'friendly_urls_replace_canonical', $text);

		

	return $text;

}



function friendly_urls_pages( $matches )

{

	global $MSO;

		

	# проверяем кеш

	if( isset($MSO->data[basename(dirname(__FILE__))][md5($matches[0])]) )

	{

		return $MSO->data[basename(dirname(__FILE__))][md5($matches[0])];

	}



	# получаем опции плагина

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());



	$options['next-slug-tmpl'] = isset($options['next-slug-tmpl']) && $options['next-slug-tmpl'] ? $options['next-slug-tmpl'] : '';

	$options['next-slug-tmpl'] = $options['next-slug-tmpl'] ? array_map('trim', explode(',', $options['next-slug-tmpl'])) : false;

	$options['next-slug-tmpl'] = $options['next-slug-tmpl'] ? implode('|', $options['next-slug-tmpl']) : false;

		

	# удаляем следы пагинации сторонних плагинов

	if( isset($matches[3]) && $options['next-slug-tmpl'] && preg_match( '!\/('.$options['next-slug-tmpl'].')\/(.+?)($|\/)!is', $matches[3], $next ) )

	{

		$matches[3] = preg_replace('!\/('.$options['next-slug-tmpl'].')\/(.+?)($|\/|#)!is', '', $matches[3]);

		$matches[4] = $next[0].$matches[4];

	}

		

	# обрабатываем next у записей

	if( isset($matches[3]) && preg_match( '!\/next\/(.+?)!is', $matches[3], $next) )

	{

		$matches[3] = preg_replace('!\/next\/(.+?)!is', '', $matches[3]);

		$matches[4] = $next[0].$matches[4];

	}

	

	# обрабатываем feed у записей

	if( isset($matches[3]) && preg_match( '!\/feed$!is', $matches[3], $feed) )

	{

		$matches[3] = preg_replace('!\/feed$!is', '', $matches[3]);

		$matches[4] = $feed[0].$matches[4];

	}



	# обрабатываем сложный слуг после page

	if( isset($matches[3]) && preg_match( '!\/!is', $matches[3]) )

	{

		if( isset($options['pages-urls']) && $options['pages-urls'] != '' )

		{

			$options['pages-urls'] = substr($options['pages-urls'], 0, 1) == '/' ? $options['pages-urls'] : '/'.$options['pages-urls'];

		

			$tmps = array(

					preg_replace('!\{cat\-sub\-cat\-slug\}!is', '{cat-slug}/{sub-cat-slug}', $options['pages-urls']),

					preg_replace('!\{cat\-sub\-cat\-slug\}!is', '{cat-slug}', $options['pages-urls'])

				);

	

			if( isset($options['pages-urls-no-cat']) && $options['pages-urls-no-cat'] != '' )

			{

				$tmps[] = $options['pages-urls-no-cat'];

			}

				

			foreach( $tmps as $tpl )

			{

				$tpl = substr($tpl, 0, 1) == '/' ? substr($tpl, 1) : $tpl;

				$tmpl = preg_replace('!\{(.*?)\}!is', '(.*?)', $tpl);	



				if( preg_match( '!\/$!is', $tmpl ) )

				{

					$tmpl .= '$';

				}

					

				if( isset($matches[4]) && preg_match( '!\/next\/(.+?)!is', $matches[4] ) && !preg_match( '!\/$!is', $matches[3] ) )

				{

					$matches[3] .= '/';

				}

				

				# боремся с глюком next-ссылки на первую страницу в multipage

				if( 

					preg_match( '!\/next\/(.+?)!is', $_SERVER['REQUEST_URI'] ) && 

					isset($matches[3]) && 

					!preg_match( '!\/$!is', $matches[3] ) &&

					( preg_match( '!\/$!is', $tmpl ) || preg_match( '!\/\$$!is', $tmpl ) )

				)

				{

					$matches[3] .= '/';

				}



				if( preg_match( '!'.$tmpl.'!is', $matches[3], $parts) )

				{

					preg_match_all( '!\{(.+?)\}!', $tpl, $codes);	

					

					foreach( $codes[1] as $pos => $bb )

					{

						if( preg_match('!page-(slug|id)!is', $bb, $m) && isset($parts[($pos + 1)]) && !preg_match('!\/!is', $parts[($pos + 1)] ) )

						{

							if( $m[0] == 'page-slug' )

							{

								$matches[3] = $parts[($pos + 1)];

								break;

							}

							elseif( $m[0] == 'page-id' )

							{

								$matches[3] = friendly_urls_get_slug_from_id($parts[($pos + 1)]);

								break;

							}

						}

					}

				}

			}

		}

	}



	if( isset($matches[4]) && preg_match( '!\/next\/(.+?)!is', $matches[4] ) && preg_match( '!\/$!is', $matches[3] ) )

	{

		$matches[3] = preg_replace('!\/$!is', '', $matches[3]);

			

		if( preg_match( '!\/$!is', $_SERVER['REQUEST_URI'] ) )

		{

			$matches[4] = substr($matches[4], 0, 1) == '/' ? substr($matches[4], 1) : $matches[4];

		}

	}



	if( 

		preg_match( '!\/next\/(.+?)!is', $_SERVER['REQUEST_URI'] ) && 

		isset($matches[4]) && 

		!preg_match( '!\/$!is', $matches[4] ) &&

		!preg_match( '!\/$!is', $matches[0] )

	)

	{

		$matches[3] = preg_replace('!\/$!is', '', $matches[3]);

	}



	$page = friendly_urls_get_page_from_slug( isset($matches[3]) ? $matches[3] : '' );

	

	if( $page )

	{

		# поиск значений для {cat-slug} и {sub-cat-slug}

		$cat_slug = 'no-cat'; $sub_cat_slug = 'no-subcat';

		if( isset($page['page_categories']) && count($page['page_categories']) > 0 )

		{

			foreach( $page['page_categories'] as $i => $cat )

			{

				if( $sub_cat_slug == 'no-subcat' && $cat['category_id_parent'] != 0 )

				{

					foreach( $page['page_categories'] as $k => $rub )

					{

						if( $cat['category_id_parent'] == $rub['category_id'] )

						{

							$sub_cat_slug = $i;

							$cat_slug = $k;

							break;

						}

					}

						

					if( strval($cat_slug) != 'no-cat' && strval($sub_cat_slug) != 'no-subcat' ) break;

				}

			}

			

			if( strval($cat_slug) != 'no-cat' && strval($sub_cat_slug) != 'no-subcat' )

			{

				$cat_slug = $page['page_categories'][$cat_slug]['category_slug'];

				$sub_cat_slug = $page['page_categories'][$sub_cat_slug]['category_slug'];

			}

			else

			{

				$cat_slug = $page['page_categories'][0]['category_slug'];

			}

		}

		

		if( isset($options['pages-urls']) && $options['pages-urls'] != '' )

		{

			# шаблон нового адреса страницы

			$out = strval($cat_slug) == 'no-cat' && isset($options['pages-urls-no-cat']) && $options['pages-urls-no-cat'] != '' ? $options['pages-urls-no-cat'] : $options['pages-urls'] ;

			

			$out = substr($out, 0, 1) == '/' ? substr($out, 1) : $out; # игнорируем слеш в начале шаблона



			$out = str_replace('{page-id}', $page['page_id'], $out);



			$out = str_replace('{page-slug}', $page['page_slug'], $out);

	

			$out = str_replace('{cat-slug}', $cat_slug, $out);

		

			$out = str_replace('{sub-cat-slug}', $sub_cat_slug, $out);

			

			if( $sub_cat_slug == 'no-subcat' )

			{

				$out = str_replace('{cat-sub-cat-slug}', $cat_slug, $out);

			}

			else

			{

				$out = str_replace('{cat-sub-cat-slug}', $cat_slug.'/'.$sub_cat_slug, $out);

			}



			$out = str_replace('{author}', $page['users_nik'], $out);



			$out = str_replace('{type}', $page['page_type_name'], $out);

			

			$pub_time = strtotime($page['page_date_publish']);



			$out = str_replace('{year}', date('Y', $pub_time), $out);



			$out = str_replace('{month}', date('m', $pub_time), $out);



			$out = str_replace('{day}', date('d', $pub_time), $out);

	

			$out = str_replace('{hour}', date('H', $pub_time), $out);



			$out = str_replace('{minute}', date('i', $pub_time), $out);



			$out = str_replace('{second}', date('s', $pub_time), $out);

			

			$out = $matches[1].$out.$matches[4];



			$MSO->data[basename(dirname(__FILE__))][md5($matches[0])] = $out; # сохраняем в кеш новый адрес страницы

				

			return $out;

		}

	}

	

	return $matches[0]; # если запись найти не удалось или шаблон пустой, то возвращаем исходный адрес

}



function friendly_urls_cats( $matches )

{

	global $MSO;

		

	# проверяем кеш

	if( isset($MSO->data[basename(dirname(__FILE__))][md5($matches[0])]) )

	{

		return $MSO->data[basename(dirname(__FILE__))][md5($matches[0])];

	}

		

	# получаем опции плагина

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());

		

	# обрабатываем next

	if( isset($matches[3]) && preg_match( '!\/next\/(.+?)!is', $matches[3], $next) )

	{

		$matches[3] = preg_replace('!\/next\/(.+?)!is', '', $matches[3]);

		$matches[4] = $next[0].$matches[4];

	}



	if( 

		isset($options['categories-urls']) && 

		preg_match( '!\{parent\-child\-cat\-slug\}!is', $options['categories-urls']) && 

		preg_match( '!(.+?)\/(.+?)$!is', $matches[3], $t)

	)

	{

		$matches[3] = $t[2];

	}

		

	$cat_slug = isset($matches[3]) ? $matches[3] : '';

	$cat = friendly_urls_get_cat_from_slug( $cat_slug );

	

	if( $cat )

	{

		if( isset($options['categories-urls']) && $options['categories-urls'] != '' )

		{

			# поиск значений для {parent-cat-slug} и {parent-cat-id}

			$cat_parent_id = 'no-parent-cat-id';

			$cat_parent_slug = 'no-parent-cat-slug';



			if( isset($cat['category_id_parent']) && $cat['category_id_parent'] != 0 )

			{

				$cat_parent = friendly_urls_get_cat_from_id( $cat['category_id_parent'] );

				if( $cat_parent )

				{

					$cat_parent_id = $cat_parent['category_id'];

					$cat_parent_slug = $cat_parent['category_slug'];

				}

			}



			$out = $options['categories-urls']; # шаблон нового адреса страницы

		

			$out = substr($out, 0, 1) == '/' ? substr($out, 1) : $out; # игнорируем слеш в начале шаблона



			$out = str_replace('{cat-id}', $cat['category_id'], $out);



			$out = str_replace('{cat-slug}', $cat_slug, $out);

		

			$out = str_replace('{cat-parent-slug}', $cat_parent_slug, $out);



			$out = str_replace('{cat-parent-id}', $cat_parent_id, $out);

			

			if( $cat_parent_slug == 'no-parent-cat-slug' )

			{

				$out = str_replace('{parent-child-cat-slug}', $cat_slug, $out);

			}

			else

			{

				$out = str_replace('{parent-child-cat-slug}', $cat_parent_slug.'/'.$cat_slug, $out);

			}

				

			$out = $matches[1].$out.( substr($out, -1, 1) == '/' && substr($matches[4], 0, 1) == '/' ? substr($matches[4], 1) : $matches[4] );

			

			$MSO->data[basename(dirname(__FILE__))][md5($matches[0])] = $out; # сохраняем в кеш новый адрес страницы

				

			return $out;

		}

	}

		

	return $matches[0]; # если запись найти не удалось или шаблон пустой, то возвращаем исходный адрес

}



# фиксим баги с link rel="canonical"

function friendly_urls_replace_canonical( $matches )

{

	# /next/next/

	$matches[1] = preg_replace('!\/next\/next\/(\d+?)$!is', '/next/\\1', $matches[1]);



	if( friendly_urls_parse_page_uri( $_SERVER['REQUEST_URI'] ) || friendly_urls_parse_cat_uri( $_SERVER['REQUEST_URI'] ) )

	{

		$matches[1] = getinfo('siteurl').substr( $_SERVER['REQUEST_URI'], 1 );

	}



	return '<link rel="canonical" href="'.$matches[1].'">';

}



# фиксим ссылки //feed и /next/feed в рубриках с {parent-child-cat-slug} и просто при пагинации

function friendly_urls_cats_feed( $matches )

{

	if( $matches[1] == '' || $matches[1] == 'next' )

	{

		return $matches[2];

	}

		

	return $matches[0];

}



# фиксим ссылки //next в пагинации рубрик

function friendly_urls_cats_bad_next( $matches )

{

	if( $matches[2] != '' || $matches[3] != '' )

	{

		return $matches[2].'/next/'.$matches[3];

	}

		

	return $matches[0];

}



# функция открытия страниц с адресами чпу

function friendly_urls_404( $args = false )

{

	global $MSO, $page;

	

	if( $args ) return $args; # страница уже найдена

	

	# получаем опции плагина

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());

		

	# ничего не делаем если ЧПУ не разрешено использовать

	if( !isset($options['non-default-urls']) || !$options['non-default-urls'] ) return $args;



	# используем кэширование

	if( !isset($MSO->data[basename(dirname(__FILE__))]['pages']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-pages'.str_replace('/', '-', $_SERVER['REQUEST_URI']);



		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['pages'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

	

	# ищем страницы

	if( isset($options['pages-urls']) && $options['pages-urls'] != '' )

	{

		$pg = friendly_urls_parse_page_uri( $_SERVER['REQUEST_URI'] );

		

		# если стоит лишний слеш в конце адреса

		$uri_ = preg_replace('!\/$!is', '', $_SERVER['REQUEST_URI']);

		if( !$pg && $uri_ != $_SERVER['REQUEST_URI'] )

		{

			$pg = friendly_urls_parse_page_uri( $uri_ );

			if( $pg )

			{

				$uri = substr($uri_, 0, 1) == '/' ? substr($uri_, 1) : $uri_; # игнорируем слеш в начале uri

				mso_redirect($uri, false, 301);

				exit;

			}

		}

		

		# если лишний слеш перед QUERY_STRING

		$uri_ = isset($_SERVER['QUERY_STRING']) && $_SERVER['QUERY_STRING'] != '' ? preg_replace('!\?(.*?)$!is', '', $_SERVER['REQUEST_URI']) : $_SERVER['REQUEST_URI'];

		if( !$pg && $uri_ != $_SERVER['REQUEST_URI'] )

		{

			$pg = friendly_urls_parse_page_uri( $uri_ );

			if( !$pg )

			{

				$uri_ = preg_replace('!\/$!is', '', $uri_);

				$pg = friendly_urls_parse_page_uri( $uri_ );



				if( $pg )

				{

					$uri = substr($uri_, 0, 1) == '/' ? substr($uri_, 1) : $uri_; # игнорируем слеш в начале uri

					$uri .= isset($_SERVER['QUERY_STRING']) && $_SERVER['QUERY_STRING'] != '' ? '?'.$_SERVER['QUERY_STRING'] : '';

					mso_redirect($uri, false, 301);

					exit;

				}

			}

		}

			

		if( $pg )

		{

			$MSO->data['type'] = 'page';



			# обрабатываем ситуацию, когда запустились не все привязки к хукам в автозагрузке плагинов

			$d = $MSO->active_plugins;

			foreach( $d as $plugin )

			{

				#pr($plugin);

				$auto_load = $plugin . '_autoload';

				if( !in_array($plugin, array('samborsky_polls')) && function_exists($auto_load) ) $auto_load();

			}

			

			if( $f = mso_find_ts_file('type/page/page.php') )

			{

				if( !$page && function_exists('mso_get_pages') )

				{

					if( !isset($MSO->data[basename(dirname(__FILE__))]['pages'][ $MSO->data[basename(dirname(__FILE__))]['page']['id'] ] ) )

					{

						$par = array(

						'furi' => true,

						'cut' => false,

						'page_id' => $MSO->data[basename(dirname(__FILE__))]['page']['id'],

						'get_page_count_comments' => false,

						'custom_type' => 'page',

						'type' => false);

		                                	

						$pages = mso_get_pages($par, $pagination); # получим страницу по slug

						if( isset($pages[0]) )

						{

							$page = $pages[0];

							$MSO->data[basename(dirname(__FILE__))]['pages'][ $MSO->data[basename(dirname(__FILE__))]['page']['id'] ] = $page;

						}

						

					}

					else

					{

						$page = $MSO->data[basename(dirname(__FILE__))]['pages'][ $MSO->data[basename(dirname(__FILE__))]['page']['id'] ];

					}

				}

					

				@header('HTTP/1.1 200 OK'); # перебиваем заголовок, иначе выдаст 404

				

				require($f);

				return true;

			}

		}

	}

		

	# ищем рубрику

	if( isset($options['categories-urls']) && $options['categories-urls'] != '' )

	{

		$cat = friendly_urls_parse_cat_uri( $_SERVER['REQUEST_URI'] );

		if( $cat )

		{

			$MSO->data['type'] = 'category';

			

			# подделываем данные о запросе, чтобы стандартные функции думали, что всё по старому

			if( preg_match( '!\/next\/(.+?)!is', $_SERVER['REQUEST_URI'], $next) )

			{ 

				$_SERVER['REQUEST_URI'] = '/category/'.$cat['slug'].'/next/'.$next[1];

				$MSO->data['uri_segment'][1] = 'category';

				$MSO->data['uri_segment'][2] = $cat['slug'];

				$MSO->data['uri_segment'][3] = 'next';

				$MSO->data['uri_segment'][4] = $next[1];

			}

			else

			{

				$_SERVER['REQUEST_URI'] = '/category/'.$cat['slug'];

				$MSO->data['uri_segment'][1] = 'category';

				$MSO->data['uri_segment'][2] = $cat['slug'];

			}

			

			# обрабатываем ситуацию, когда запустились не все привязки к хукам в автозагрузке плагинов

			$d = $MSO->active_plugins;

			foreach( $d as $plugin )

			{

				#pr($plugin);

				$auto_load = $plugin . '_autoload';

				if( !in_array($plugin, array('samborsky_polls')) && function_exists($auto_load) ) $auto_load();

			}



			if( $f = mso_find_ts_file('type/category/category.php') )

			{

				@header('HTTP/1.1 200 OK'); # перебиваем заголовок, иначе выдаст 404



				require($f);

				return true;

			}

		}

	}

	

	return false;

}



# парсинг uri для определения записи

function friendly_urls_parse_page_uri( $uri = '', $onlycheck = false )

{

	global $MSO;

		

	# проверяем кеш

	if( isset($MSO->data[basename(dirname(__FILE__))]['page']) )

	{

		return $MSO->data[basename(dirname(__FILE__))]['page'];

	}

		

	if( $uri == '' ) return false;

	if( isset($options['pages-urls']) && $options['pages-urls'] != '' ) return false; 

	

	# получаем опции плагина

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());



	$options['pages-urls'] = substr($options['pages-urls'], 0, 1) == '/' ? $options['pages-urls'] : '/'.$options['pages-urls'];

		

	$tmps = array(

			preg_replace('!\{cat\-sub\-cat\-slug\}!is', '{cat-slug}/{sub-cat-slug}', $options['pages-urls']),

			preg_replace('!\{cat\-sub\-cat\-slug\}!is', '{cat-slug}', $options['pages-urls'])

		);



	if( isset($options['pages-urls-no-cat']) && $options['pages-urls-no-cat'] != '' )

	{

		$tmps[] = $options['pages-urls-no-cat'];

	}



	$options['next-slug-tmpl'] = isset($options['next-slug-tmpl']) && $options['next-slug-tmpl'] ? $options['next-slug-tmpl'] : '';

	$options['next-slug-tmpl'] = $options['next-slug-tmpl'] ? array_map('trim', explode(',', $options['next-slug-tmpl'])) : false;

	$options['next-slug-tmpl'] = $options['next-slug-tmpl'] ? implode('|', $options['next-slug-tmpl']) : false;

		

	foreach( $tmps as $tpl )

	{

		$tmpl = preg_replace('!\{(.+?)\}!is', '(.*?)', $tpl);

			

		# удаляем следы пагинации сторонних плагинов

		if( $options['next-slug-tmpl'] && preg_match( '!\/('.$options['next-slug-tmpl'].')\/(.+?)($|\/)!is', $uri ) )

		{	

			$uri = preg_replace('!\/('.$options['next-slug-tmpl'].')\/(.+?)($|\/)!is', '', $uri);

		}



		if( preg_match( '!\/next\/(.+?)!is', $uri ) || preg_match( '!\/feed$!is', $uri ) )

		{

			$uri = preg_replace('!\/next\/(.+?)!is', '', $uri);

			$uri = preg_replace('!\/feed!is', '', $uri);

			$uri .= substr($tmpl, -1, 1) == '/' || substr($tmpl, -2, 2) == '/$' ? '/' : '';

		}

			

		if( preg_match( '!'.$tmpl.'$!is', $uri, $parts) )

		{

			# получаем массив использованных в шаблоне кодов

			preg_match_all( '!\{(.+?)\}!', $tpl, $codes);

				

			if( in_array('cat-sub-cat-slug', $codes[1]) )

			{

				$bb = array();

				foreach( $codes[1] as $k => $code )

				{

					if( $code == 'cat-sub-cat-slug' )

					{

						$bb[] = 'cat-slug';

						$bb[] = 'sub-cat-slug';

					}

					else

					{

						$bb[] = $code;

					}

				}

				$codes[1] = $bb;

			}

				

			if( 

				in_array('cat-slug', $codes[1]) && in_array('no-cat', $parts) && 

				isset($options['pages-urls-no-cat']) && $options['pages-urls-no-cat'] != '' 

			)

			{

				continue;

			}



			if( in_array('page-slug', $codes[1]) )

			{

				$pos = 0;

				foreach( $codes[1] as $k => $code )

				{

					if( $code == 'page-slug' )

					{

						$pos = $k + 1;

						break;

					}

				}

					

				if( $pos != 0 && isset($parts[$pos]) )

				{

					$page_slug = $parts[$pos]; # определили slug записи

							

					$page_id = friendly_urls_get_id_from_slug( $page_slug );

					if( $page_id )

					{

						if( $onlycheck ) return true;

							

						$MSO->data[basename(dirname(__FILE__))]['page']['id'] = $page_id; # сохраняем в кеш

						$MSO->data[basename(dirname(__FILE__))]['page']['slug'] = $page_slug; # сохраняем в кеш



						return $MSO->data[basename(dirname(__FILE__))]['page'];

					}

				}

			}

			elseif( in_array('page-id', $codes[1]) )

			{

				$pos = 0;

				foreach( $codes[1] as $k => $code )

				{

					if( $code == 'page-id' )

					{

						$pos = $k + 1;

						break;

					}

				}

					

				if( $pos != 0 )

				{

					$page_id = $parts[$pos]; # определили id записи

	

					$page_slug = friendly_urls_get_slug_from_id( $page_id );

					if( $page_slug )

					{

						if( $onlycheck ) return true;



						$MSO->data[basename(dirname(__FILE__))]['page']['id'] = $page_id; # сохраняем в кеш

						$MSO->data[basename(dirname(__FILE__))]['page']['slug'] = $page_slug; # сохраняем в кеш



						return $MSO->data[basename(dirname(__FILE__))]['page'];

					}

				}

			}

		}

	}

		

	return false; # ничего не определили

}



# парсинг uri для определения категорий

function friendly_urls_parse_cat_uri( $uri = '', $onlycheck = false )

{

	global $MSO;

	

	# проверяем кеш

	if( isset($MSO->data[basename(dirname(__FILE__))]['category']) )

	{

		return $MSO->data[basename(dirname(__FILE__))]['category'];

	}

		

	if( $uri == '' ) return false;

	if( isset($options['categories-urls']) && $options['categories-urls'] != '' ) return false; 

	

	# получаем опции плагина

	$options = mso_get_option('plugin_friendly_urls', 'plugins', array());

	

	$options['categories-urls'] = substr($options['categories-urls'], 0, 1) == '/' ? $options['categories-urls'] : '/'.$options['categories-urls'];

		

	$tmps = array(

			preg_replace('!\{parent\-child\-cat\-slug\}!is', '{cat-parent-slug}/{cat-slug}\$', $options['categories-urls']),

			preg_replace('!\{parent\-child\-cat\-slug\}!is', '{cat-slug}\$', $options['categories-urls'])

		);



	$options['next-slug-tmpl'] = isset($options['next-slug-tmpl']) && $options['next-slug-tmpl'] ? $options['next-slug-tmpl'] : '';

	$options['next-slug-tmpl'] = $options['next-slug-tmpl'] ? array_map('trim', explode(',', $options['next-slug-tmpl'])) : false;

	$options['next-slug-tmpl'] = $options['next-slug-tmpl'] ? implode('|', $options['next-slug-tmpl']) : false;

		

	foreach( $tmps as $tpl )

	{

		#if( is_login() ) pr($tpl);

		$tmpl = preg_replace('!\{(.+?)\}!is', '(.*?)', $tpl);



		if( preg_match( '!\)\$!is', $tmpl ) )

		{

			$tmpl = preg_replace('!\)\$!is', ')', $tmpl);

			$tmpl .= '$';

		}



		# удаляем следы пагинации сторонних плагинов

		if( $options['next-slug-tmpl'] && preg_match( '!\/('.$options['next-slug-tmpl'].')\/(.+?)($|\/)!is', $uri ) )

		{	

			$uri = preg_replace('!\/('.$options['next-slug-tmpl'].')\/(.+?)($|\/)!is', '', $uri);

		}



		if( preg_match( '!\/next\/(.+?)!is', $uri ) || preg_match( '!\/feed$!is', $uri ) )

		{

			$uri = preg_replace('!\/next\/(.+?)!is', '', $uri);

			$uri = preg_replace('!\/feed!is', '', $uri);

			$uri .= substr($tmpl, -1, 1) == '/' || substr($tmpl, -2, 2) == '/$' ? '/' : '';

		}

			

               	if( preg_match('!'.$tmpl.'!is', $uri, $parts) )

		{

			# полчаем массив использованных в шаблоне кодов

			preg_match_all( '!\{(.+?)\}!', $tpl, $codes);

			

			if( in_array('parent-child-cat-slug', $codes[1]) )

			{

				$bb = array();

				foreach( $codes[1] as $k => $code )

				{

					if( $code == 'parent-child-cat-slug' )

					{

						$bb[] = 'cat-parent-slug';

						$bb[] = 'cat-slug';

					}

					else

					{

						$bb[] = $code;

					}

				}

				$codes[1] = $bb;

			}

			

			if( in_array('cat-slug', $codes[1]) )

			{

				$pos = 0;

				foreach( $codes[1] as $k => $code )

				{

					if( $code == 'cat-slug' )

					{

						$pos = $k + 1;

						break;

					}

				}

				

				if( $pos != 0 && isset($parts[$pos]) )

				{

					$cat_slug = $parts[$pos]; # определили slug категории

							

					$cat_id = friendly_urls_get_cat_from_slug( $cat_slug ); $cat_id = $cat_id['category_id'];

					if( $cat_id )

					{

						if( $onlycheck ) return true;

							

						$MSO->data[basename(dirname(__FILE__))]['category']['id'] = $cat_id; # сохраняем в кеш

						$MSO->data[basename(dirname(__FILE__))]['category']['slug'] = $cat_slug; # сохраняем в кеш

							

						return $MSO->data[basename(dirname(__FILE__))]['category'];

					}

				}

			}

			elseif( in_array('cat-id', $codes[1]) && !isset($MSO->data[basename(dirname(__FILE__))]['category']) )

			{

				$pos = 0;

				foreach( $codes[1] as $k => $code )

				{

					if( $code == 'cat-id' )

					{

						$pos = $k + 1;

						break;

					}

				}

					

				if( $pos != 0 && isset($parts[$pos]) )

				{

					$cat_id = $parts[$pos]; # определили id категории

					

					$cat_slug = friendly_urls_get_cat_from_id( $cat_id );

					if( $cat_slug )

					{

						if( $onlycheck ) return true;



						$cat_slug = $cat_slug['category_slug'];

						$MSO->data[basename(dirname(__FILE__))]['category']['id'] = $cat_id; # сохраняем в кеш

						$MSO->data[basename(dirname(__FILE__))]['category']['slug'] = $cat_slug; # сохраняем в кеш

							

						return $MSO->data[basename(dirname(__FILE__))]['category'];

					}

				}

			}

		}

	}

		

	return false; # ничего не определили

}



# обработка хука mso_get_pages

function friendly_urls_get_pages_params( $args = array() )

{

	global $MSO;

		

	if( isset($args['furi']) )

	{

		# подменяем параметры выборки для записи

		if( isset($MSO->data[basename(dirname(__FILE__))]['page']) )

		{

			$args['page_id'] = $MSO->data[basename(dirname(__FILE__))]['page']['id'];

			$args['slug'] = $MSO->data[basename(dirname(__FILE__))]['page']['slug'];

			$args['custom_type'] = 'page';#pr($args);

		}

	}

	elseif( 

		isset($MSO->data[basename(dirname(__FILE__))]['page']['id']) && 

		( !$args['custom_type'] || $args['custom_type'] == 'page' ) &&

		#$args['custom_type'] != 'category' &&

		( 

			!isset($args['function_add_custom_sql']) || 

			( 

				$args['function_add_custom_sql'] != '_sql_next_page' && 

				$args['function_add_custom_sql'] != '_sql_prev_page' 

			) 

		) 

	)

	{

		$args['page_id'] = $MSO->data[basename(dirname(__FILE__))]['page']['id'];

		$args['slug'] = $MSO->data[basename(dirname(__FILE__))]['page']['slug'];

		$args['custom_type'] = 'page';

		$args['type'] = false;

	}

	elseif( isset($args['function_add_custom_sql']) && $args['function_add_custom_sql'] == '_sql_next_page' )

	{

		$args['page_id'] = 0;

		$args['custom_type'] = 'home';

		$args['type'] = 'blog';

	}

	elseif( isset($args['function_add_custom_sql']) && $args['function_add_custom_sql'] == '_sql_prev_page' )

	{

		$args['page_id'] = 0;

		$args['custom_type'] = 'home';

		$args['type'] = 'blog';

	}

		

	# slug должен быть простым (без /), иначе пытаемся поправить слуг проверя на чпу

	if( isset($args['slug']) && $args['slug'] && strpos($args['slug'], '/') !== false )

	{

		$tslug = substr($args['slug'], 0, 1) == '/' ? $args['slug'] : '/'.$args['slug'];



		if( $slug = friendly_urls_parse_page_uri($tslug) )

		{

			$args['slug'] = $slug['slug'];

		}

		elseif( $slug = friendly_urls_parse_cat_uri($tslug) )

		{

			$args['slug'] = $slug['slug'];

		}

	}

		

	# подменяем параметры выборки для категории

	if( isset($MSO->data[basename(dirname(__FILE__))]['category']) )

	{

		$args['cat_id'] = $MSO->data[basename(dirname(__FILE__))]['category']['id'];

		$args['custom_type'] = 'category';

		$args['slug'] = $MSO->data[basename(dirname(__FILE__))]['category']['slug'];

	}

		

	return $args;	

}



# получаем id страницы по slug

function friendly_urls_get_id_from_slug( $slug = '' )

{

	if( !$slug ) return false;



	global $MSO;



	# используем кэширование

	if( !isset($MSO->data[basename(dirname(__FILE__))]['pages']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-pages'.str_replace('/', '-', $_SERVER['REQUEST_URI']);

		

		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['pages'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

	

	if( !isset($MSO->data[basename(dirname(__FILE__))]['pages'][$slug]) )

	{

		$CI = & get_instance();

			

		$CI->db->select('*'); #

		$CI->db->from('page pg');

		$CI->db->join('users u', 'pg.page_id_autor = u.users_id', 'left');

		$CI->db->join('page_type pt', 'pg.page_type_id = pt.page_type_id', 'left');

		$CI->db->where('pg.page_slug', $slug);



		$qry = $CI->db->get();

			

		if( is_object($qry) && $qry->num_rows() > 0 )

		{

			$res = $qry->result_array();



			$MSO->data[basename(dirname(__FILE__))]['pages'][$slug] = $res[0]['page_id'];

			$MSO->data[basename(dirname(__FILE__))]['pages'][$res[0]['page_id']] = $res[0];



			$CI->db->select('*');

			$CI->db->from('category ca');

			$CI->db->join('cat2obj c2o', 'ca.category_id = c2o.category_id', 'left');

			$CI->db->where('c2o.page_id', $res[0]['page_id']);

			

			$qry = $CI->db->get();

			

			if( is_object($qry) && $qry->num_rows() > 0 )

			{

				$r = $qry->result_array();

				$MSO->data[basename(dirname(__FILE__))]['pages'][$res[0]['page_id']]['page_categories'] = $r;

			}



			return $res[0]['page_id'];

		}

		else

		{

			return false;

		}

	}

	else

	{

		return $MSO->data[basename(dirname(__FILE__))]['pages'][$slug];

	}

}



# получаем slug страницы по id

function friendly_urls_get_slug_from_id( $id = 0 )

{

	if( $id == 0 ) return false;



	global $MSO;



	# используем кэширование

	if( !isset($MSO->data[basename(dirname(__FILE__))]['pages']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-pages'.str_replace('/', '-', $_SERVER['REQUEST_URI']);

		

		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['pages'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

	

	if( !isset($MSO->data[basename(dirname(__FILE__))]['pages'][$id]) )

	{

		$CI = & get_instance();

			

		$CI->db->select('*');

		$CI->db->from('page pg');

		$CI->db->join('users u', 'pg.page_id_autor = u.users_id', 'left');

		$CI->db->join('page_type pt', 'pg.page_type_id = pt.page_type_id', 'left');

		$CI->db->where('pg.page_id', $id);

		$qry = $CI->db->get();

			

		if( is_object($qry) && $qry->num_rows() > 0 )

		{

			$res = $qry->result_array();

			$MSO->data[basename(dirname(__FILE__))]['pages'][$id] = $res[0];

			$MSO->data[basename(dirname(__FILE__))]['pages'][$res[0]['page_slug']] = $id;



			$CI->db->select('*');

			$CI->db->from('category ca');

			$CI->db->join('cat2obj c2o', 'ca.category_id = c2o.category_id', 'left');

			$CI->db->where('c2o.page_id', $id);

			

			$qry = $CI->db->get();

			

			if( is_object($qry) && $qry->num_rows() > 0 )

			{

				$r = $qry->result_array();

				$MSO->data[basename(dirname(__FILE__))]['pages'][$id]['page_categories'] = $r;

			}



			return $res[0]['page_slug'];

		}

		else

		{

			return false;

		}

	}

	else

	{

		return $MSO->data[basename(dirname(__FILE__))]['pages'][$id]['page_slug'];

	}

}



# получаем страницу по slug

function friendly_urls_get_page_from_slug( $slug = '' )

{

	if( !$slug ) return false;



	global $MSO;



	$id = friendly_urls_get_id_from_slug( $slug );



	if( $id && isset($MSO->data[basename(dirname(__FILE__))]['pages'][$id]) )

	{

		return $MSO->data[basename(dirname(__FILE__))]['pages'][$id];

	}



	return false;

}



# получаем категорию по slug

function friendly_urls_get_cat_from_slug( $slug = '' )

{

	if( !$slug ) return false;

		

	global $MSO;



	# используем кэширование

	if( !isset($MSO->data[basename(dirname(__FILE__))]['categories']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-categories'.str_replace('/', '-', $_SERVER['REQUEST_URI']);

		

		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['categories'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

		

	if( !isset($MSO->data[basename(dirname(__FILE__))]['categories'][$slug]) )

	{

		$CI = & get_instance();



		$CI->db->select('*');

		$CI->db->from('category');

		$CI->db->where('category_slug', $slug);

		$qry = $CI->db->get();

			

		if( is_object($qry) && $qry->num_rows() > 0 )

		{

			$res = $qry->result_array();

			$MSO->data[basename(dirname(__FILE__))]['categories'][$slug] = $res[0]['category_id'];

			$MSO->data[basename(dirname(__FILE__))]['categories'][$res[0]['category_id']] = $res[0];

				

			return $MSO->data[basename(dirname(__FILE__))]['categories'][$res[0]['category_id']];

		}

		else

		{

			return false;

		}

	}

	else

	{

		$id = $MSO->data[basename(dirname(__FILE__))]['categories'][$slug];

		return $MSO->data[basename(dirname(__FILE__))]['categories'][$id];

	}

}



# получаем категорию по id

function friendly_urls_get_cat_from_id( $id = 0 )

{

	if( $id == 0 ) return false;



	global $MSO;



	# используем кэширование

	if( !isset($MSO->data[basename(dirname(__FILE__))]['categories']) )

	{

		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 0);

		$cache_key = basename(dirname(__FILE__)).'-categories'.str_replace('/', '-', $_SERVER['REQUEST_URI']);

		

		if( $cache_time > 0 and $cache = mso_get_cache($cache_key) )

		{

			$MSO->data[basename(dirname(__FILE__))]['categories'] = unserialize(str_replace('_serialize_', '', $cache));

		}

	}

	

	if( !isset($MSO->data[basename(dirname(__FILE__))]['categories'][$id]) )

	{

		$CI = & get_instance();



		$CI->db->select('*');

		$CI->db->from('category');

		$CI->db->where('category_id', $id);

		$qry = $CI->db->get();

		if( is_object($qry) && $qry->num_rows() > 0 )

		{

			$res = $qry->result_array();

			$MSO->data[basename(dirname(__FILE__))]['categories'][$res[0]['category_slug']] = $id;

			$MSO->data[basename(dirname(__FILE__))]['categories'][$id] = $res[0];

				

			return $MSO->data[basename(dirname(__FILE__))]['categories'][$id];

		}

		else

		{

			return false;

		}

	}

	else

	{

		return $MSO->data[basename(dirname(__FILE__))]['categories'][$id];

	}

}



function friendly_urls_page_view_count_first($unique = false, $name_cookies = 'maxsite-cms', $expire = 2592000)

{

	global $_COOKIE, $_SESSION;



	if ( !mso_get_option('page_view_enable', 'templates', '1') AND !$unique) return true; //если нет такой опции или не пришло в функцию, то выходим

	if ( !$unique ) $unique = mso_get_option('page_view_enable', 'templates', '1');

	

	if( !$pg = friendly_urls_parse_page_uri( $_SERVER['REQUEST_URI'] ) ) return true;



	#pr($pg);



	$slug = $pg && isset($pg['slug']) ? $pg['slug'] : mso_segment(2);

	$all_slug = array();



	if( $unique == 0 ) return false; // не вести подсчет

	elseif ($unique == 1) //с помощью куки

	{

		if (isset($_COOKIE[$name_cookies]))	$all_slug = explode('|', $_COOKIE[$name_cookies]); // значения текущего кука

		if ( in_array($slug, $all_slug) ) return false; // уже есть текущий урл - не увеличиваем счетчик

	}

	elseif ($unique == 2) //с помощью сессии

	{

		session_start();

		if (isset($_SESSION[$name_cookies]))	 $all_slug = explode('|', $_SESSION[$name_cookies]); // значения текущей сессии

		if ( in_array($slug, $all_slug) ) return false; // уже есть текущий урл - не увеличиваем счетчик

	}



	// нужно увеличить счетчик

	$all_slug[] = $slug; // добавляем текущий slug

	$all_slug = array_unique($all_slug); // удалим дубли на всякий пожарный

	$all_slug = implode('|', $all_slug); // соединяем обратно в строку

	$expire = time() + $expire;



	if ($unique == 1) @setcookie($name_cookies, $all_slug, $expire); // записали в кук

	elseif ($unique == 2) $_SESSION[$name_cookies]=$all_slug; // записали в сессию

	

	// получим текущее значение page_view_count

	// и увеличиваем значение на 1

	$CI = & get_instance();

	$CI->db->select('page_view_count');

	

	if(is_numeric($slug)) // ссылка вида http://site.com/page/1 

		$CI->db->where('page_id', $slug);

	else

		$CI->db->where('page_slug', $slug);



	$CI->db->limit(1);

	$query = $CI->db->get('page');

	

	if( is_object($query) && $query->num_rows() > 0 )

	{

		$pages = $query->row_array();

		$page_view_count = $pages['page_view_count'] + 1;



		$CI->db->where('page_slug', $slug);

		$CI->db->update('page', array('page_view_count'=>$page_view_count));

		$CI->db->cache_delete('page', $slug);



		return true;

	}

}





# end file