<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Plugin «Sticky» for maxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-sticky
 */
# ключ, тип, ключи массива
$settings = array(
	# Общие
	'group_1' => array(
		'type' => 'info',
		'title' => 'Основные параметры',
		'text' => '',
	),
	'widgets' => array(
		'type' => 'textarea',
		'name' => 'Настройка «плавающих» виджетов',
		'description' => 'Настройки «плавающего» виджета (или групп виджетов) задавайте для каждого сайдбара с помощью парного псевдокода <b>[widget][/widget]</b> и следующих параметров:'.
						'<ul>'.
						'<li><b>selector</b> - селектор (ID или css класс) виджета, для которого будет применяться «липкучесть»</li>'.
						'<li><b>topSpacing</b> - отступ (в пикселях) сверху при выводе «прилипшего виджета». По-умолчанию имеет значение «<b>20</b>»</li>'.
						'<li><b>stopper</b> - селектор блока, при достижении верхней границы которого виджет будет останавливаться и/или исчезать. По-умолчанию имеет значение «<b>.footer</b>»</li>'.
						'<li><b>marginBottom</b> - отступ (в пикселях) от нижней границы страницы, дальше которого виджет не сможет «продвинуться». По-умолчанию имеет значение «<b>150</b>»</li>'.
						'<li><b>styler</b> - class, который будет приписываться блоку при залипании (название указывать без точки)</li>'.
						'<li><b>unlockWidth</b> - заставляет «разблокировать» ширину прилипшего блока (т.е. не сохранять исходную ширину блока). Для активации укажите «<b>true</b>» или «<b>1</b>». Параметр в основном применяется при реализации залипания горизонтального меню в шапке сайта.</li>'.
						'<li><b>animDuration</b> - продолжительность анимации при способе залипания «afterall». По-умолчанию имеет значение «<b>500</b>». Для отключения анимации укажите «<b>0</b>»</li>'.
						'<li><b>stickType</b> - способ («тип») залипания. Доступно три значения: <b>afterall</b>, <b>alonemenu</b>, <b>directly</b>. Вот описание типов:'. 
						'<ul><li>При способе «<b>afterall</b>» виджет будет проявляться только после того, как все виджеты сайдбара уйдут за верхнюю границу экрана.</li><li>Чтобы блок залипал сразу и не ждал исчезновения с экрана последнего виджета укажите «<b>directly</b>».</li><li>Значение «<b>alonemenu</b>» предназначено только для работы с горизонтальным меню в шапке и приводит к залипанию блока при первом касании верхней границы экрана верхней границы блока.</li></ul></li>'.
						'<li><b>screenlimit</b> - опция, указывающая прекращать ли работу плагина на низких разрешениях экрана? К низким разрешениям относятся: ширина экрана меньше 1024 пикселей, высота экрана меньше 500 пикселей. Также работа останавливается на мобильных устройствах (имеющим в подписи браузера метки: android, webos, iphone, ipad, ipod или blackberry). По-умолчанию имеет значение «<b>true</b>»</li>'.
						'<li><b>minwidth</b> - опция, указывающая на какой ширине экрана прекращать работу плагина. По-умолчанию имеет значение «<b>1024</b>». Параметр действует при screenlimit = true.</li>'.
						'<li><b>minheight</b> - опция, указывающая на какой высоте экрана прекращать работу плагина. По-умолчанию имеет значение «<b>500</b>». Параметр действует при screenlimit = true.</li>'.
						'<li><b>stick</b> - callback-функция, которая вызывается в момент «залипания». Код должен быть указан в одну строку и оформлен в виде описания безымянной функции с одним передаваемым в неё параметром (в него передаётся информация и залипающем блоке), например, так: <pre>function (el) { alert("show!"); }</pre></li>'.
						'<li><b>unstick</b> - callback-функция, которая вызывается в момент окончания «залипания». Код оформляется аналогично функции <b>stick</b>.</li>'.
						'</ul>'.
						'Пример настройки для случая двух липкучих блоков (в рамках одного сайдбара) и липкучего горизонтального меню:<pre>'.
						'[widget]'.NR.
							'selector = .text_block_widget_0, .text_block_widget_2'.NR.
							'topSpacing = 50'.NR.
							'stopper = #footer'.NR.
							'marginBottom = 100'.NR.
							'stickType = afterall'.NR.
							'stick = function (el) { alert("простое сообщение в момент залипания!"); }'.NR.
						'[/widget]'.NR.
						'[widget]'.NR.
							'selector = .menu-only'.NR.
							'topSpacing = 0'.NR.
							'marginBottom = 0'.NR.
							'styler = topMenuStyler'.NR.
							'unlockWidth = true'.NR.
							'animDuration = 0'.NR.
							'stickType = alonemenu'.NR.
						'[/widget]'.NR.
						'</pre>',
		'default' => '[widget]'.NR.
						'selector = '.NR.
						'topSpacing = '.NR.
						'stopper = '.NR.
						'marginBottom = '.NR.
						'styler = '.NR.
						'unlockWidth = '.NR.
						'animDuration = '.NR.
						'stickType = '.NR.
						'stick = '.NR.
						'unstick = '.NR.
					'[/widget]'.NR,
	),
	'embedhere' => array(
		'type' => 'select',
		'name' => 'Место подключения js-скрипта',
		'description' => 'Укажите хук, при котором будет происходить подключение js-скрипта.',
		'values' => '1||head (в секции HEAD)#2||body_end (перед закрывающим тэгом BODY)',
		'default' => '1'
	),
);

?>