<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */

$CI = & get_instance();
		
require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/backend-menu.php' ); # подключяем файл вывода меню
?>
<h1>Присланные статьи</h1>
<p class="info">На данной странице вы можете видеть материалы, присланные посетителями с помощью <a href="<?= getinfo('siteurl').$options['slug'] ?>">формы</a> плагина «Прислать статью».</p>
<?
if( !isset($options['admin_row_limit']) ) $options['admin_row_limit'] = 10; # количесвто статей на страницу

$CI->load->library('table');
$tmpl = array (
				'table_open'		  => '<table class="page" border="0" width="100%">',
				'row_alt_start'		  => '<tr class="alt">',
				'cell_alt_start'	  => '<td class="alt" style="vertical-align: top;">',
				'cell_start'	  => '<td style="vertical-align: top;">',
		  );

$CI->table->set_template($tmpl); # шаблон таблицы

# заголовки таблицы
$caption = array();
$caption[] = 'id';
$caption[] = 'Заголовок / Описание';
if( isset($options['show_field_message_to_editor']) && $options['show_field_message_to_editor'] == 1 ) $caption[] = '<div class="editormsg" style="width:200px;">Сообщение редактору</div>';
$caption[] = 'Дата';
$caption[] = 'Статус';
$caption[] = '<div style="width:130px;">Автор / IP</div>';
$caption[] = 'Действия';

$CI->table->set_heading($caption);

# вначале определим общее количество присланных статей
$pag = array(); # пагинация
$pag['limit'] = $options['admin_row_limit']; # статей на страницу
$pag['type'] = ''; # тип

$CI->db->select('meta_id_obj');
$CI->db->from('meta');
$CI->db->where('meta_key', 'submit_article');
$CI->db->where('meta_value', '1');
$CI->db->where('meta_table', 'page');
$qry = $CI->db->get();
$pag['allrows'] = $qry->num_rows();

if( $pag['allrows'] > 0 )
{
	$pag['maxcount'] = ceil($pag['allrows'] / $pag['limit']); // всего страниц пагинации
		
	$pag['current'] = mso_current_paged();
	if( $pag['current'] > $pag['maxcount'] ) $pag['current'] = $pag['maxcount'];
		
	$offset = $pag['current'] * $pag['limit'] - $pag['limit'];
}
else
{
	$pag = false;
}

# теперь получаем записи текущей страницы
$CI->db->select('meta_id_obj');
$CI->db->from('meta');
$CI->db->where('meta_key', 'submit_article');
$CI->db->where('meta_value', '1');
$CI->db->where('meta_table', 'page');
$CI->db->order_by('meta_id_obj', 'desc');
if( $pag && $offset ) 
	$CI->db->limit($pag['limit'], $offset);
else
	$CI->db->limit($pag['limit']);
			
$qry = $CI->db->get();
	
if( $qry->num_rows() > 0 )
{	
	$pagesid = array();
	# получаем массив id статей
	$res = $qry->result_array();
		
	foreach( $res as $pid )
	{
		$pagesid[] = $pid['meta_id_obj'];
	}
		
	# получаем все мета
	$CI->db->from('meta');
	$CI->db->where_in('meta_id_obj', $pagesid);
	$CI->db->join('comusers', 'meta.meta_value = comusers.comusers_id and `mso_meta`.`meta_key` = \'comusers_id\'', 'left'); 
	$qry = $CI->db->get();
	if( $qry->num_rows() > 0 )	
	{	
		$meta = array();
		$res = $qry->result_array();
		foreach( $res as $val )
		{
			#pr($val);
			$meta[$val['meta_id_obj']][$val['meta_key']][] = $val['meta_value'];
			if( $val['meta_key'] == 'comusers_id' )
			{
				if( isset($val['comusers_nik']) && $val['comusers_nik'] <> '' )
				{
					$meta[$val['meta_id_obj']]['comusers_nik'][] = $val['comusers_nik'];
				}
				else
				{
					$meta[$val['meta_id_obj']]['comusers_nik'][] = 'Удалённый №'.$val['meta_id_obj'];
					$meta[$val['meta_id_obj']]['deleted'][] = true;
				}
			}
		}
	}
	# задаём пустое поле description, там где его совсем нет
	foreach( $meta as $k => $me )
	{
		if( !isset($me['description'][0]) )
		{
			$meta[$k]['description'][0] = '';
		}
	}
		
	# получаем статьи
	$CI->db->from('page');
	$CI->db->where_in('page_id', $pagesid);
	$CI->db->order_by('page_id', 'desc');
	$qry = $CI->db->get();
	if( $qry->num_rows() > 0 )	
	{
		# формируем массив статей
		$pages = $qry->result_array();
			
		foreach( $pages as $page )
		{
			$author_name = '';
			if( isset($meta[$page['page_id']]['anonymous'][0]) )
			{
				$author_name = '<a id="author-'.$page['page_id'].'" class="label label-anonym author" href="">'.htmlspecialchars($meta[$page['page_id']]['anonymous'][0]).'</a>';
			}
			elseif( isset($meta[$page['page_id']]['comusers_id'][0]) && !isset($meta[$page['page_id']]['deleted'][0]) )
			{
				$author_name =	'<a id="author-'.$page['page_id'].'" class="label label-comuser author" href="">'.$meta[$page['page_id']]['comusers_nik'][0].'</a>'.
								'<a class="comuser-page" href="'.getinfo('site_admin_url').'comusers/edit/'.$meta[$page['page_id']]['comusers_id'][0].'" target="_blank"><img src="'.getinfo('plugins_url').'submit_article/images/profile.png" width="16" height="16" border=0 title="Редактировать комюзера"></a>';
			}
			elseif( isset($meta[$page['page_id']]['comusers_nik'][0]) )
			{
				$author_name = '<a class="label label-deleted author" id="author-'.$page['page_id'].'" href="">'.$meta[$page['page_id']]['comusers_nik'][0].'</a>';	
			}
			else
			{
				$author_name = '<a id="author-'.$page['page_id'].'" class="label label-deleted author" href="">Нет имени</a>';
			}
				
			$row = array();
			# id
			$row[] = $page['page_id'];
			
			# Заголовок / Описание
			$row[] =	'<a href="'.getinfo('site_admin_url').'page_edit/'.$page['page_id'].'" rel="nofollow" class="" title="Редактировать">'.$page['page_title'].'</a> '.
						'[<a href="'.getinfo('site_url').$options['slug'].'/'.$page['page_id'].'" rel="nofollow" class="" title="Посмотреть на сайте через форму">Через форму</a>]'.
						'[<a href="'.getinfo('site_url').'page/'.$page['page_slug'].'" rel="nofollow" class="" title="Посмотреть на сайте">Просмотр</a>]'.
						'[<a href="/" rel="nofollow" class="meta meta-'.$page['page_id'].'" title="Мета-информация">Мета</a>]'.
						'<p class="admin_page_qhint"><small>'.($meta[$page['page_id']]['description'][0]!=''?str_replace("\n", "<br>", htmlspecialchars($meta[$page['page_id']]['description'][0])):'<span class="label label-err">нет описания!</span>').'</small></p>'.
						'<div class="meta meta-'.$page['page_id'].'"></div>';
				
				
			# Сообщение редактору
			if( isset($options['show_field_message_to_editor']) && $options['show_field_message_to_editor'] == 1 )
			{
				if( isset($meta[$page['page_id']]['editormsg'][0]) )
				{
					$editormsg =  $meta[$page['page_id']]['editormsg'][0];
					$row[] = '<div class="msg">'.str_replace("\n", "<br>", htmlspecialchars($editormsg)).'</div>';
				}
				else
				{
					$row[] = '';
				}	
			}
				
			# Дата
			$row[] = '<span class="date">'.mso_date_convert('Y-m-d H:i:s', $page['page_last_modified']).'</span>';
				
			# Статус
			if( isset($meta[$page['page_id']]['comusers_id'][0]) && ($options['comuser_can_edit_published'] || $options['comuser_can_edit_draft']) )
			{
				$drft = isset($meta[$page['page_id']]['draft'][0]) ? ' label label-draft' : '';
				$edable = '<span class="editable id-'.$page['page_id'].(isset($meta[$page['page_id']]['editable'][0])?' true':'').'"><span class="rw'.$drft.'">R/W</span><button class="rw">R/O</button><button class="ro">R/W</button><span class="ro">R/O</span></span>';
			}
			else
			{
				$edable = '';
			}
			$row[] = '<div id="label-'.$page['page_id'].'" class="status label'.($page['page_status']=='publish'?' label-ok':'').'">'.$page['page_status'].'</div><br>'.$edable;
				
			# Автор / IP
			$row[] = $author_name.'<br><p class="admin_page_qhint"><small>'.$meta[$page['page_id']]['author_ip'][0].'</small></p>';
				
			# Действия
			$row[] = '<span id="button-'.$page['page_id'].'"><button class="publish">Опубликовать</button><br><button class="draft">Скрыть</button><br><button class="del">Удалить</button><input id="delete-'.$page['page_id'].'" type="checkbox" class="delete" value="go" title="Подтвердите удаление"></span>'.'<br><button class="detach id-'.$page['page_id'].'" title="Убрать страницу из списка присланных">Открепить</button>';
			
			$CI->table->add_row( $row );
		}
			
		mso_hook('pagination', $pag);
		echo $CI->table->generate(); // вывод подготовленной таблицы
		mso_hook('pagination', $pag);
	}
}
else
{
	echo '<div class="warninfo">Пока ничего не присылали!</div>';
}
	require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/author-info.php' ); # подключаем файл информации об авторе плагина
?>