<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */

# читаем опции плагина
$options = submit_article_get_options();
if( count($options) == 0 )
{
	echo false;
	die();
}
		
$CI = & get_instance();
mso_checkreferer();
global $MSO;
		
# показать мета, сменить статус публикации или удалить
if( $post = mso_check_post(array('do', 'title', 'content')))
{
	# публикуем
	if( $post['do'] == 'preview' )
	{
		$preview_title = $post['title'];
			
		$preview_content = $post['content'];
			
		# готовим контент - обрабатываем переносы строк
		if( mso_hook_present('content_replace_chr10_br') )
		{
			# если нужно задать свое начально форматирование, задайте хук content_replace_chr10_br
			$preview_content = mso_hook('content_replace_chr10_br', $preview_content);
		}
		else
		{
			$preview_content = trim($preview_content);
			$preview_content = str_replace(chr(10), "<br>", $preview_content);
			$preview_content = str_replace(chr(13), "", $preview_content);
		}
			
		# глюк FireFox исправлем замену абсолютного пути src на абсолютный
		$preview_content = str_replace('src="../../', 'src="'.$MSO->config['site_url'], $preview_content);
		$preview_content = str_replace('src="../', 'src="'.$MSO->config['site_url'], $preview_content);
			
		# замены из-за мусора FireFox
		$preview_content = str_replace('-moz-background-clip: -moz-initial;', '', $preview_content);
		$preview_content = str_replace('-moz-background-origin: -moz-initial;', '', $preview_content);
		$preview_content = str_replace('-moz-background-inline-policy: -moz-initial;', '', $preview_content);
			
		$preview_content = str_replace('<!-- pagebreak -->', '<br><br>', $preview_content); # совместимость с TinyMCE
		$preview_content = str_replace('<!--more-->', '<br><br>', $preview_content); # совместимость с Wordpress
		$preview_content = str_replace('[cut]', '<br><br>', $preview_content);
		$preview_content = str_replace('[xcut]', '<br><br>', $preview_content);
		$preview_content = str_replace('[mso_xcut]', '<br><br>', $preview_content);
			
		$preview_content = mso_hook('content', $preview_content);
		$preview_content = mso_hook('content_in', $preview_content);
		$preview_content = mso_hook('content', $preview_content);
		$preview_content = mso_hook('content_auto_tag', $preview_content);
		$preview_content = mso_hook('content_balance_tags', $preview_content);
		$preview_content = mso_hook('content_out', $preview_content);
		$preview_content = mso_hook('content_complete', $preview_content);
			
		ob_start();
			
		if( $f = mso_page_foreach('submit-article-page-preview') )
		{
			require($f);
		}
		else
		{
			echo
				'<div class="type type_submit_article_preview"><div class="page_only"><div class="wrap">'.
					'<div class="info info-top"><div class="page_title"><h1>'.$preview_title.'</h1></div></div>'.
					'<div class="page_content type_page">'.$preview_content.'<div class="break"></div></div>'.
				'</div></div></div>';
		}
			
		$out = ob_get_contents(); ob_end_clean();		
			
		die(json_encode(array(
			'res' => true,
			'html' => $out
		)));
	}
}
		
die();
?>