<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */
	# Проверка прав доступа
	if( !mso_check_allow('submit_article_edit') ){
		echo false;
		die();
	}
		
	# читаем опции плагина
	$options = submit_article_get_options();
	if( count($options)==0 )
	{
		echo false;
		die();
	}
		
	$CI = & get_instance();
	mso_checkreferer();
	global $MSO;
		
	# показать мета, сменить статус публикации или удалить
	if( $post = mso_check_post(array('do', 'id')))
	{
		# переносим в черновики
		if( $post['do'] == 'draft' && is_numeric($post['id']) )
		{
			# обновляем адрес сайта комюзера
			$uptd = array(
				'page_status' => 'draft',
			);
			$CI->db->where(array('page_id' => $post['id']) );
			if( !$CI->db->update('page', $uptd) )
			{
				die(false);
			}
			else
			{
				die('draft');
			}
		}
			
		# публикуем
		if( $post['do'] == 'publish' && is_numeric($post['id']) )
		{
			# удаляем пользовательский статус черновика
			$CI->db->where( array('meta_id_obj' => $post['id'], 'meta_table' => 'page', 'meta_key' => 'draft') );
			$CI->db->delete('meta');
				
			# обновляем адрес сайта комюзера
			$uptd = array(
				'page_status' => 'publish',
			);
			$CI->db->where(array('page_id' => $post['id']) );
			if( !$CI->db->update('page', $uptd) )
			{
				die(false);
			}
			else
			{
				die('publish');
			}
		}
			
		# меняем статус editable
		if( $post['do'] == 'editable' && is_numeric($post['id']) && ($post['setup'] == 'true' || $post['setup'] == 'false' ))
		{
			if( $post['setup'] == 'false' )
			{
				$CI->db->where( array('meta_id_obj' => $post['id'], 'meta_table' => 'page', 'meta_key' => 'editable') );
				$CI->db->delete('meta');
				echo json_encode(array(
					'res' => false,
				));
				die();
			}
			else
			{
				$cell = array('meta_id_obj' => $post['id'], 'meta_table' => 'page', 'meta_key' => 'editable');
				$CI->db->from('meta');
				$CI->db->where($cell);
				$qry = $CI->db->get();
				if( $qry->num_rows() > 0 )
				{
					$CI->db->where($cell);
					if( !$CI->db->update('meta', array('meta_value' => '1')) )
					{
						die('can`t update db record');
					}
				}
				else
				{
					$cell['meta_value'] = 1;
					$this->db->insert('meta', $cell);
				}
					
				# получить пользовательский статус материала
				$CI->db->select('meta_value');
				$CI->db->where(array('meta_id_obj' => $post['id'], 'meta_table' => 'page', 'meta_key' => 'draft'));
				$CI->db->from('meta');
				$qry = $CI->db->get();
				$draft = ( $qry->num_rows() > 0 ) ? true : false;
				echo json_encode(array(
					'draft' => $draft,
					'res' => true,
				));
				die();
			}
		}
			
		# Удаляем страницу
		if( $post['do'] == 'delete' && is_numeric($post['id']) )
		{
			$code = 0;
				
			require_once( getinfo('common_dir').'functions-edit.php' ); // функции редактирования
			$data = array(
				'user_login' => $MSO->data['session']['users_login'],
				'password' => $MSO->data['session']['users_password'],
				'page_id' => $post['id'],
			);
			$res = mso_delete_page($data);
				
			if( $res )
			{
				# если страницу удалось успешно удалить, то надо удалить и папку с изображениями и файлами
				$page_dir = getinfo('uploads_dir').'_pages/'.$post['id'];
				if( is_dir($page_dir) ) del_folder( $page_dir );
					
				if( $res['result'] == 1 )
				{	
					$code = 1;
					$out = 'Удаление выполнено успешно! Удалена запись №'.$post['id'].'.';
					mso_hook('new_category'); # вызываем переформирование sitemap.xml
				}
				else
				{
					$out = $res['description'];
				}
			} 
			else
			{
				$out = 'Возникла ошибка при удалении. Проверьте наличие данных для удаления и/или правильность функционирования браузера, веб-сервера и плагина.';
			}
				
			echo json_encode(array('msg' => $out, 'res' => $code));
			die();
		}
			
		# Открепляем страницу
		if( $post['do'] == 'detach' && is_numeric($post['id']) )
		{
			$code = 0;
				
			# удалим meta
			$CI->db->where( array('meta_id_obj' => $post['id'], 'meta_table' => 'page') );
			$CI->db->where_in('meta_key', array('comusers_id', 'author_ip', 'editable', 'submit_article', 'anonymous', 'editormsg', 'godmode', 'draft', 'subscribe_submited'));
			$CI->db->delete('meta');
				
			$res = $CI->db->affected_rows();

			if( $res > 0 )
			{	
				$code = 1;
					
				$CI->db->where( array('page_id' => $post['id']) );
				$uptd = array(
					'page_status' => 'draft',
				);
					
				if( $CI->db->update('page', $uptd) )
				{
					$out = 'Открепление выполнено успешно! Запись №'.$post['id'].' убрана из списка присланных материалов.';
				}
				else
				{
					$out = 'Открепление выполнено частично (не удалось сменить статус материала на «draft»)! Запись №'.$post['id'].' убрана из списка присланных материалов.';
				}
			}
			else
			{
				$out = 'Возникла ошибка при удалении. Проверьте наличие данных для удаления и/или правильность функционирования браузера, веб-сервера и плагина.';
			}
				
			echo json_encode(array('msg' => $out, 'res' => $code));
			die();
		}
			
		# показать мета информацию
		if( $post['do'] == 'showmeta' && is_numeric($post['id']) )
		{
			$res = false;
				
			$CI->db->from('meta');
			$CI->db->where('meta_table', 'page');
			$CI->db->where('meta_id_obj', $post['id']);
			$qry = $CI->db->get();
				
			if( $qry->num_rows() > 0 )
			{
				$meta = $qry->result_array();
				$out = '<table class="meta" border=1>'.NR;
					
				foreach( $meta as $row )
				{
					$out .= '<tr><td class="key">'.$row['meta_key'].'</td><td width=80%>'.$row['meta_value'].'</td></tr>'.NR;
				}
				$out .= '</table>'.NR;
					
				$res = true;
			}
			else
			{
				$out = 'Нет нужной мета-информации для материала с ID '.$post['id'].'!';
			}
				
			echo json_encode(array(
				'msg' => $out,
				'res' => $res,
			));
			die();
		}
	}
		
	# сменить автора публикации
	if( $post = mso_check_post(array('do', 'id', 'comuser', 'anonym')) )
	{
		$post = mso_clean_post(array('comuser' => 'int', 'anonym' => 'xss|trim'), $post);
			
		if( $post['do'] == 'changeauthor' && is_numeric($post['id']) )
		{
			# проверить наличие мета-информации для данной страницы и устновить тип автора
			$CI->db->from('meta');
			$CI->db->where("meta_table = 'page' AND meta_id_obj = '".$post['id']."' AND ( meta_key = 'anonymous' OR meta_key = 'comusers_id' )");
			$qry = $CI->db->get();
				
			if( $qry->num_rows() > 0 )
			{
				$row = $qry->row_array();
				$tuser = $row['meta_key'];
			}
			$errmsg = '';
			$nik = '';
				
			if( isset($tuser) ) # если тип автора установить удалось - комюзер или анонимус
			{
				if( $post['comuser'] <> 'комюзер ID' && is_numeric($post['comuser']) ) # прислали id комюзера
				{
					# получаем инофрмацию о новом комюзере
					#$CI->db->select('comusers_nik');
					$CI->db->where('comusers_id', $post['comuser']);
					$qry = $CI->db->get('comusers');
						
					if( $qry->num_rows() ) # есть такой комюзер
					{
						$row = $qry->row_array(1);
						$nik = $row['comusers_nik'];
							
						if( $tuser == 'comusers_id' ) # если тип автора был комюзер
						{
							# просто обновляем идентификатор комюзера
							$uptd = array(
								'meta_value' => $post['comuser'],
							);
							$CI->db->where(array('meta_key' => 'comusers_id', 'meta_id_obj' => $post['id'], 'meta_table' => 'page' ) );
							if( $CI->db->update('meta', $uptd) )
							{
								echo json_encode(array(
									'html' => 	'<a id="author-'.$post['id'].'" class="label label-comuser author" href="">'.$nik.'</a>'.
												'<a class="comuser-page" href="'.getinfo('site_admin_url').'comusers/edit/'.$post['comuser'].'"><img src="'.getinfo('plugins_url').'submit_article/images/profile.png" width="16" height="16" border=0 title="Редактировать комюзера"></a>',
									'res' => true,
								));
								die();
							}
						}
						elseif( $tuser == 'anonymous' ) # если тип автора был анонимус
						{
							# меняем тип автора на комюзера и устанавливаем ему ID
							$uptd = array(
								'meta_key' => 'comusers_id',
								'meta_value' => $post['comuser'],
							);
							$CI->db->where(array('meta_key' => 'anonymous', 'meta_id_obj' => $post['id'], 'meta_table' => 'page' ) );
							if( $CI->db->update('meta', $uptd) )
							{
								echo json_encode(array(
									'html' => 	'<a id="author-'.$post['id'].'" class="label label-comuser author" href="">'.$nik.'</a>'.
												'<a class="comuser-page" href="'.getinfo('site_admin_url').'comusers/edit/'.$post['comuser'].'"><img src="'.getinfo('plugins_url').'submit_article/images/profile.png" width="16" height="16" border=0 title="Редактировать комюзера"></a>',
									
									'res' => true,
								));
								die();
							}
							else
							{
								$errmsg = 'Не найден материал с ID '.$post['id'].' где автором числится исходный комюзер!';
							}
						}
						else # если типа автора был неизвестный плагину - не комюзер и не анонимус
						{
							$errmsg = 'В таблице мета-информации для материала с ID '.$post['id'].' найден автор неизвестного типа ('.$tuser.')!';
						}
					}
					else
					{
						$errmsg = 'Комюзера с ID '.$post['comuser'].' не существует!';
					}
				}
					
				# если с комюзером не сложилось, то пытаемся порешать с анонимусом
				if( $post['anonym'] <> 'Имя анонимуса' && $post['anonym'] <> '' ) # прислали имя анонима
				{
					$nik = $post['anonym'];
						
					if( $tuser == 'comusers_id' ) # если тип автора был комюзер
					{
						# меняем типа автора на анонимуса и устанавливаем имя на присланное
						$uptd = array(
							'meta_key' => 'anonymous',
							'meta_value' => $nik,
						);
						$CI->db->where(array('meta_key' => 'comusers_id', 'meta_id_obj' => $post['id'], 'meta_table' => 'page' ) );
						if( $CI->db->update('meta', $uptd) )
						{
							echo json_encode(array(
								'html' => '<a id="author-'.$post['id'].'" class="label label-anonym author" href="">'.$nik.'</a>',
								'res' => true,
							));
							die();
						}
						else
						{
							$errmsg = 'Не найден материал с ID '.$post['id'].' где автором числится удалённый комюзер!';
						}
					}
					elseif( $tuser == 'anonymous' ) # если типа автора был анонимус
					{
						# просто устанавливаем нове имя
						$uptd = array(
							'meta_value' => $nik,
						);
						$CI->db->where(array('meta_key' => $tuser, 'meta_id_obj' => $post['id'], 'meta_table' => 'page' ) );
						if( $CI->db->update('meta', $uptd) )
						{
							echo json_encode(array(
								'html' => '<a id="author-'.$post['id'].'" class="label label-anonym author" href="">'.$nik.'</a>',
								'res' => true,
							));
							die();
						}
						else
						{
							$errmsg = 'Не найден материал с ID '.$post['id'].' где автором числится удалённый комюзер!';
						}
					}
					else # если имевшийся типа автора не изевестен плагину
					{
						$errmsg = 'В таблице мета-информации для материала с ID '.$post['id'].' найден автор неизвестного типа ('.$tuser.')!';
					}
				}
			}
			else # не удалось найти мета-информацию для автора материала с присланным ID
			{
				$errmsg = 'Нет нужной мета-информации для материала с ID '.$post['id'].'!';
			}
				
			if( $errmsg ) # если обработать запрос не получилось, то возможно возникли ошибки - возварщаем текст ошибки
			{
				echo json_encode(array(
					'msg' => $errmsg,
					'res' => false,
				));
				die();
			}
		}
	}
		
	die();
	
###
function del_folder( $dir ) # функция удаления папки вместе со всем содержимым
{
	if( is_dir($dir) )
	{ 
		$objects = scandir($dir);
		foreach( $objects as $object )
		{
			if( $object != "." && $object != "..")
			{
				if( filetype($dir."/".$object) == "dir")
					del_folder($dir."/".$object);
				else
					unlink($dir."/".$object);
			}
		}
		reset($objects);
			
		rmdir($dir);
	}
}
?>