<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for maxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */
	# формируем список обязательных полей
	$fields = array('sa_session', 'submit', 'text', 'title');
	
	# если для критичных полей значения не прислали, то дадим значения по-умолчанию
	if( !isset($_POST['title']) || $_POST['title'] == '' ) # title
	{
		$CI->db->select_max('page_id');
		$qry = $CI->db->get('page');
		
		if( $qry->num_rows() ) # есть такой комюзер
		{
			$row = $qry->row_array(1);
			$_POST['title'] = 'Публикация №'.($row['page_id']+1);
		}
		else
		{
			$_POST['title'] = 'Безымянная публикация';
		}
	}
		
	if( isset($options['show_rules']) && $options['show_rules'] && !is_login() && !is_login_comuser() && ( !isset($options['hide_auth_block']) || !$options['hide_auth_block'] ) ) # Требуется согласиться с правилами сайта
	{
		array_push( $fields, 'rules' );
	}
		
	if( !is_login() && !$options['anonymous'] && !is_login_comuser() && ( !isset($options['hide_auth_block']) || !$options['hide_auth_block'] ) ) # Если не разрешен анонимный сабмитинг
	{
		array_push( $fields, 'email', 'password', 'comusers_nik' );
			
		if( $options['show_field_site'] ) # Если надо спросить сайт автора
		{
			array_push( $fields, 'comusers_url' );
		}
		if( $options['show_field_author_info'] ) # Если надо спросить инфу об авторе
		{
			array_push( $fields, 'about' );
		}
	}
	
	if( $options['show_field_description'] ) # Если нужно вводить значение поля DESCRIPTION
	{
		array_push( $fields, 'desc' );
	}
	
	if( $options['show_categories'] && isset($_POST['category']) ) # Если разрешено выбирать категорию
	{
		array_push( $fields, 'category' );
	}
	
	if( $options['show_field_message_to_editor'] ) # Если надо спросить поле сообщения для редактора
	{
		array_push( $fields, 'editormsg' );
	}
	
	if( !is_login() && !is_login_comuser() && $options['captcha'] <> 0 )
	{
		array_push( $fields, 'captcha' );
	}
	
	# корректируем список обязательных полей на основе списка в поле «fields_prefs»
	$allfileds = $fields;
	$lnprefs = explode(NR, trim($options['fields_prefs']));
	foreach($lnprefs as $ln){
		$param = array_map('trim', explode('|', trim($ln)));
		if( isset($param) && $param[0] <> '' )
		{
			if( $k = array_search($param[0], $fields) && !isset($param[2]) )
			{
				unset($fields[$k]);# = null;
			}
		}
	}
		
	# определение времени последнего постинга и сравниваем с текущим
	# нужно чтобы было не более 15 секунд - защита от частых постингов
	$good_activity = false;
	if( !isset($MSO->data['session']['last_activity_submit_article']) )
	{
		$good_activity = true;	# предыдущего постинга  не было - это первый
	}
	else
	{
		$delta = time() - $MSO->data['session']['last_activity_submit_article']; # время в секундах между последним комментарием и текущим в секундах
		$good_activity = ($delta < 15) ? false : true;
	}
		
	if( $good_activity && $post = mso_check_post( $fields ) ) # проверка частоты постинга и наличия обязательных полей
	{
		# копирование в $post необязательных полей
		foreach( $_POST as $k => $v )
		{
			if( array_search($k, $allfileds) && !isset($post[$k]) )
			{
				$post[$k] = $v;
			}
		}
	
		mso_checkreferer();
		# обработка post
			
		$check_rules = array(
		#	'email' => 'email', # обработаем чуть ниже отдельно
			'password' => 'base',
			'comusers_nik' => 'base|not_url',
			'comusers_url' => 'base',
			'captcha' => 'int',
			'title' => 'xss|trim',
			'text' => 'xss|trim',
			'desc' => 'xss|trim',
			'editormsg' => 'xss|trim',
			'about' => 'xss|trim',
			'rules' => 'int',
			'draft' => 'int'
			);
			
		if( isset($options['show_categories']) && $options['show_categories'] )
		{
			if( isset($post['category']) && is_array($post['category']) )
			{
				# надо проверить целый массив значений
				foreach( $post['category'] as $k => $v )
				{
					$post['category'][$k] = mso_clean_str($post['category'][$k], 'int');
				}
			}
			else
			{
				$post['category'][0] = 0;
			}
		}
			
		$post = mso_clean_post($check_rules, $post);
			
		if( isset($options['can_upload']) && $options['can_upload'] == 1 && isset($_POST['ins_files']) )
		{
			# надо проверить целый массив значений
			foreach( $_POST['ins_files'] as $k => $v )
			{
				$post['ins_files'][$k] = mso_clean_str($_POST['ins_files'][$k], 'base');
			}
		}
			
		$edit = false;
		if( isset($pid) || isset($_POST['page_id']) )
		{
			$edit = true;
				
			$post['page_id'] = $pid; #mso_clean_str($_POST['page_id'], 'int');
				
			# Читаем из базы информацию о статье
			$CI->db->select('*');
			$CI->db->from('page');
			$CI->db->where('page_id', $pid);
				
			$qry = $CI->db->get();
			if( $qry->num_rows() > 0 )
			{	
				$res = $qry->result_array();
				$pg = $res[0];
					
				# загружаем мета-информацию
				$CI->db->select('meta_key, meta_value');
				$CI->db->from('meta');
				$CI->db->where('meta_id_obj', $pid);
				$CI->db->where('meta_table', 'page');
					
				$qry = $CI->db->get();
				if( $qry->num_rows() > 0 )	
				{	
					$meta = $qry->result_array();
					foreach( $meta as $val )
					{	
						if( !isset($pg['meta'][$val['meta_key']]) )
						{
							$pg['meta'][$val['meta_key']] = $val['meta_value'];
						}
						else
						{
							if( !is_array($pg['meta'][$val['meta_key']]) )
							{
								$pg['meta'][$val['meta_key']] = array($pg['meta'][$val['meta_key']]);
							}
							$pg['meta'][$val['meta_key']][] = $val['meta_value'];
						}
					}
				}
					
				# загружаем рубрики
				$CI->db->select('category_id');
				$CI->db->from('cat2obj');
				$CI->db->where('page_id', $pid);
					
				$qry = $CI->db->get();
				if( $qry->num_rows() > 0 )	
				{	
					$cat = $qry->result_array();
					foreach( $cat as $val )
					{
						$pg['category'][] = $val['category_id'];
					}
				}
					
				# Приведение строк с <br> в первозданный вид
				$pg['page_content'] = htmlspecialchars($pg['page_content']);
				$pg['page_content'] = preg_replace('"&lt;br\s?/?&gt;"i', "\n", $pg['page_content']);
				$pg['page_content'] = preg_replace('"&lt;br&gt;"i', "\n", $pg['page_content']);
			}
		}
			
		# проверка введённых значений на пустоту и т.п.
		$error = '';
			
		if( !is_login_comuser() && !is_login() && ( !isset($options['hide_auth_block']) || !$options['hide_auth_block'] ) ) # у авторизованного комюзера емайл, пароль и капча не спрашиваются и значит провреять нечего
		{
			if( !$options['anonymous'] ) # если не разрешён анонимный постинг, то надо проверить корректность присланного емайла и пароля
			{
				# email
				if(!$post['email'])
				{
					$error .= '<div class="message error small">Не указан email</div>';
				}
				else
				{
					# email указан, проверим его корректность
					$post['email'] = mso_clean_str($post['email'], 'email'); # если емайл некорректен, то будет возвращена пустая строка
					
					if (!$post['email'])
					{
						$error .= '<div class="message error small">Неверный email</div>';
					}
				}
					
				# password
				if(!$post['password'])
				{
					$error .= '<div class="message error small">Не указан пароль</div>';
					$post['password'] = ''; # для повторного вывода формы опусташаем пароль, чтобы постетитель ввёл его заново
				}
				else
				{
					if ( strlen($post['password']) < 6) 
						$error .= '<div class="message error small">Длина пароля должна быть более 6 символов</div>';
				}
			}
				
			# captcha
			$post['captcha'] = isset($post['captcha']) ? $post['captcha'] : '';
			if( $options['captcha'] != 0 && !$post['captcha'] )
			{
				$error .= '<div class="message error small">Не задано значение проверочного кода (значение капчи)</div>';
			}
			else
			{
				$captcha = false;
					
				# проверяем значение капчи
				if( $options['captcha'] == 1 )
				{
					$char = mso_md5($MSO->data['session']['session_id'].mso_current_url());
					$char = str_replace(array('a', 'b', 'c', 'd', 'e', 'f'), array('1', '5', '8', '2', '7', '9'), $char);
					$char = substr( $char, 1, 4);
					$captcha = $post['captcha'] == $char ? true : false; # сравниваем
				}
					
				if( $options['captcha'] == 2 )
				{
					$antispam1s = (int) $post['antispam1'];
					$antispam2s = (int) $post['antispam2'];
					$antispam3s = (int) $post['captcha'];
						
					$captcha = ($antispam1s/984 + $antispam2s/765) == $antispam3s ? true : false; # сравним
				}
				
				if( $options['captcha'] != 0 && !$captcha ) $error .= '<div class="message error small">Неверное значение проверочного кода</div>';
			}
		}
		elseif( isset($options['hide_auth_block']) && $options['hide_auth_block'] && !is_login_comuser() && !is_login() )
		{
			$error .= '<div class="message error small">Вы не авторизованы для сохранения данных!</div>';
		}
			
		# title
		if( !$post['title'] )
		{
			$error .= '<div class="message error small">Не указан заголовок материала</div>';
		}
			
		# text
		if( !$post['text'] )
		{
			$error .= '<div class="message error small">Не задано содержимое материала</div>';
		}
			
		# text
		if( $post['text'] && $options['max_text_chars'] > 0 && mb_strlen($post['text']) > $options['max_text_chars'] )
		{
			$error .= '<div class="message error small">Длина материала ('.mb_strlen($post['text']).') превышает допустимый размер ('.$options['max_text_chars'].' символов)</div>';
		}
			
		if( !$error ) # если ошибок до сих пор небыло, то можно попробовать... 
		{
			# ...авторизовать/зарегать посетителя и определить comuser_id 
			$comuser_id = 0; # id не определен
			if( !is_login_comuser()	&& !is_login() ) # не авторизован
			{
				if( !$options['anonymous'] ) # если не разрешён анонимный постинг, то обязательно надо авторизовать или зарегать и получить comuser_id 
				{
					require_once(getinfo('common_dir').'comments.php');
					$data = array();
					
					$data['allow_create_new_comuser'] = true; # явно разрешить регистрацию
					$data['die'] = false; # получаем результат в случае ошибки
					$data['redirect'] = false; # не нужно никуда редиректить
					$data['password'] = $post['password'];
					if( isset($post['comusers_nik']) )
					{
						$data['comusers_nik'] =  $post['comusers_nik'];
					}
					if( isset($post['comusers_url']) )
					{
						$data['comusers_url'] =  $post['comusers_url'];
					}
					$data['email'] = $post['email'];
					$res = mso_comuser_auth($data);
						
					# если ошибка, то выводим сообщение
					if( $res )
					{
						$error .= '<div class="message alert small">'.$res.'</div>';
					}
					else
					{
						$CI->db->select('comusers_id,comusers_nik');
						$CI->db->where('comusers_email', $post['email']);
						$qry = $CI->db->get('comusers');
						
						if( $qry->num_rows() ) # есть такой комюзер
						{
							$row = $qry->row_array(1);
							$comuser_id = $row['comusers_id'];
							$comusers_nik = $row['comusers_nik'];
							$comuser_email = $post['email'];
								
							if( isset($post['about']) && $post['about'] )
							{
								# обновляем описание комюзера
								$uptd = array(
									'comusers_description' => $post['about'],
								);
								$CI->db->where(array('comusers_id' => $comuser_id) );
								if( !$CI->db->update('comusers', $uptd) )
								{
									$error .= '<div class="message alert small">Ошибка обновления описания комюзера</div>';
								}
							}
								
							if( isset($post['comusers_url']) && $post['comusers_url'] )
							{
								# обновляем адрес сайта комюзера
								$uptd = array(
									'comusers_url' => $post['comusers_url'],
								);
								$CI->db->where(array('comusers_id' => $comuser_id) );
								if( !$CI->db->update('comusers', $uptd) )
								{
									$error .= '<div class="message alert small">Ошибка обновления адреса сайта комюзера</div>';
								}
							}
								
							if( isset($post['comusers_nik']) && $post['comusers_nik'] && $post['comusers_nik'] <> $comusers_nik )
							{
								# обновляем имя комюзера
								$uptd = array(
									'comusers_nik' => $post['comusers_nik'],
								);
								$CI->db->where(array('comusers_id' => $comuser_id) );
								if( !$CI->db->update('comusers', $uptd) )
								{
									$error .= '<div class="message alert small">Ошибка обновления имени комюзера</div>';
								}
								else
								{
									$comusers_nik = $post['comusers_nik'];
								}
							}
						}
						else
						{
							$error .= '<div class="message alert small">Ошибка регистрации комюзера</div>';
						}
					}
				} # иначе comuser_id останется равным нулю
				else # разрешен анонимный постинг
				{
					# нужно проверить наличие имени и задать его, если нет
					if( !isset($post['comusers_nik']) || $post['comusers_nik'] == ''  ) # если имя не задано
					{
						$CI->db->select_max('page_id');
						$qry = $CI->db->get('page');
						
						if( $qry->num_rows() ) # есть такой комюзер
						{
							$row = $qry->row_array(1);
							$post['comusers_nik'] = 'Публикатор №'.($row['page_id']+1);
						}
						else
						{
							$post['comusers_nik'] = 'Безымянный автор';
						}
					}
				}
			}
			elseif( is_login_comuser() && isset($_POST['comusers_id']) && $_POST['comusers_id'] == getinfo('comusers_id') )
			{
				$comuser_id = getinfo('comusers_id');
				$comusers_nik = getinfo('comusers_nik');
					
				# узнаём email комюзера
				$CI->db->select('comusers_email');
				$CI->db->where('comusers_id', $comuser_id);
				$qry = $CI->db->get('comusers');
				
				if( $qry->num_rows() ) # есть такой комюзер
				{
					$row = $qry->row_array(1);
					$comuser_email = $row['comusers_email'];
				}
			}
			elseif( is_login() && !is_login_comuser() )
			{
				$comuser_id = 0;
				$post['comusers_nik'] = getinfo('users_nik');
				$post['godmode'] = true;
			}
			else
			{
				$comuser_id = getinfo('comusers_id');
				$comusers_nik = getinfo('comusers_nik');
					
				# узнаём email комюзера
				$CI->db->select('comusers_email');
				$CI->db->where('comusers_id', $comuser_id);
				$qry = $CI->db->get('comusers');
				
				if( $qry->num_rows() ) # есть такой комюзер
				{
					$row = $qry->row_array(1);
					$comuser_email = $row['comusers_email'];
				}
			}
				
			if( !$error ) # теперь снова можно попробовать сохранить материал, если нет ошибок
			{
				# Определяем юзера, от имени которого будет публикация
				if( is_login() && $comuser_id == 0 && !$edit ) #(!isset($post['comusers_nik']) || $post['comusers_nik'] == '')
				{
					$CI->db->select('users_login,users_password');
					$CI->db->where('users_id', getinfo('users_id'));
					$qry = $CI->db->get('users');
					
					if( $qry->num_rows() ) # Проверяем наличие такого юзера, которым должны подписать материал
					{
						$user = $qry->row_array(1);
					}
				}
				elseif( $edit && ( ( is_login_comuser() && isset($pg['meta']['comusers_id']) && $pg['meta']['comusers_id'] == getinfo('comusers_id') ) || $admin ) )
				{
					$CI->db->select('users_login,users_password');
					$CI->db->where('users_id', $pg['page_id_autor']);
					$qry = $CI->db->get('users');
					
					if( $qry->num_rows() ) # Проверяем наличие такого юзера, которым должны подписать материал
					{
						$user = $qry->row_array(1);
					}
				}
				else
				{
					$CI->db->select('users_login,users_password');
					$CI->db->where('users_id', $options['byuser']);
					$qry = $CI->db->get('users');
					
					if( $qry->num_rows() ) # Проверяем наличие такого юзера, которым должны подписать материал
					{
						$user = $qry->row_array(1);
					}
					else
					{
						$error .= '<div class="message alert small">Ошибка настройки плагина</div>'; # юзер с таким id недоступен, следовательно плагин настроен неправильно и надо проверить настройки
							
						# отправляем уведомление об ошибке админу
						$toadmin = mso_get_option('admin_email', 'general', false);
						if( mso_valid_email($toadmin) )
						{
							$notify_text  = "Пройдите на страницу ".getinfo('siteurl')."/admin/plugin_options/submit_article".NR;
							$notify_text .= "Для опции «Каким юзером подписывать материал?» (byuser) указана настройка (id=".$options['byuser']."), которая приводит к ошибке (юзера с таким id нет в базе данных).".NR;
								
							mso_mail($toadmin, 'Ошибка настройки! [SUBMIT_ARTICLE]', $notify_text);
						}
					}
				}
					
				# проверка превышения разрешённого объёма для загрузки файлов
				if( $options['can_upload'] == 1 && isset($options['upload_allowed_size']) && $options['upload_allowed_size'] > 0 )
				{
					$tmpfolder = preg_replace('/[\/\\\]*$/msi', '', $options['temp_folder']); # убираем слеш в конце строки
						
					$uploaded = glob(getinfo('uploads_dir').$tmpfolder.'/*.'.$MSO->data['session']['session_id']);
					$uplsize = 0;
					$uplcount = 0;
					foreach( $uploaded as $filename )
					{
						$filename = preg_replace('/\.'.$MSO->data['session']['session_id'].'/msi', '', $filename);
						if( is_file($filename) )
						{
							$uplsize += filesize($filename);
							$uplcount++;
						}
					}
					if( $uplsize > $options['upload_allowed_size'] )
					{
						$error .= '<div class="message alert small">Ошибка сохранения! Лимит объёма ('.$options['upload_allowed_size'].' байт) для загрузки файлов превышен, ибо вы загрузили '.$uplcount.' файла(-ов) на '.$uplsize.' байт.</div>';
					}
				}
					
				# проверяем доступ к редактированию именно этого поста
				if( $edit && !$admin && ( !( $options['comuser_can_edit_published'] && $pg['page_status'] == 'publish' ) && !( $options['comuser_can_edit_draft'] && $pg['page_status'] == 'draft')  && !isset($pg['meta']['editable']) ) )
				{
					$error .= '<div class="message alert small">У вас нет доступа к обновлению этой страницы!</div>'; # комюзеру нет разрешения править данный документ
					$cant_edit = true;
				}
					
				if( !$error ) # если ошибок всё ещё нет, то можно сохранить статью
				{
					$msg = ''; # переменная для хранения текста сообщения о возможной ошибке
						
					# готовим контент - обрабатываем переносы строк
					$f_content = $post['text'];
					if( mso_hook_present('content_replace_chr10_br') )
					{
						// если нужно задать свое начально форматирование, задайте хук content_replace_chr10_br
						$f_content = mso_hook('content_replace_chr10_br', $f_content);
					}
					else
					{
						$f_content = trim($f_content);
						$f_content = str_replace(chr(10), "<br>", $f_content);
						$f_content = str_replace(chr(13), "", $f_content);
					}
						
					// глюк FireFox исправлем замену абсолютного пути src на абсолютный
					$f_content = str_replace('src="../../', 'src="'.$MSO->config['site_url'], $f_content);
					$f_content = str_replace('src="../', 'src="'.$MSO->config['site_url'], $f_content);
					
					// замены из-за мусора FireFox
					$f_content = str_replace('-moz-background-clip: -moz-initial;', '', $f_content);
					$f_content = str_replace('-moz-background-origin: -moz-initial;', '', $f_content);
					$f_content = str_replace('-moz-background-inline-policy: -moz-initial;', '', $f_content);
						
					$post['text'] = $f_content;

					require_once( getinfo('common_dir').'functions-edit.php' ); # функции редактирования
						
					if( !$edit )
					{
						# если публикуем анонимно, то мета будет содержать только имя посетителя
						if( $comuser_id == 0 ) # && !is_login()
						{
							$meta = '##METAFIELD##'.'anonymous'.'##VALUE##'.$post['comusers_nik'];
						}
						elseif( $comuser_id <> 0 ) # иначе мы должны в мете сохранить comuser_id
						{
							$meta = '##METAFIELD##'.'comusers_id'.'##VALUE##'.$comuser_id;
						}
							
						$meta .= '##METAFIELD##'.'author_ip'.'##VALUE##'.$_SERVER['REMOTE_ADDR'];
							
						# если показывалось поле сообщения для редактора
						if( $options['show_field_message_to_editor'] )
						{
							$meta .= '##METAFIELD##'.'editormsg'.'##VALUE##'.trim($post['editormsg']);
						}
							
						# если показывалось поле DESCRIPTION
						if( !$options['show_field_description'] || !isset($post['desc']) || $post['desc'] == '' )
						{
							$post['desc'] = '';
						}
						$meta .= '##METAFIELD##'.'description'.'##VALUE##'.trim($post['desc']);
							
						if( isset($post['godmode']) && $post['godmode'] ) # не нужно выводить блок автора, ибо постит админ/юзер
						{
							$meta .= '##METAFIELD##'.'godmode'.'##VALUE##'.$post['godmode'];
						}
							
						# автор пометил материал как черновик - будет ещё работать, если позволим
						if( isset($post['draft']) && $post['draft'] )
						{
							$meta .= '##METAFIELD##'.'draft'.'##VALUE##'.$post['draft'];
						}
							
						# если посетителю можно будет редактировать
						if( ($options['comuser_can_edit_published'] || $options['comuser_can_edit_draft']) && $comuser_id <> 0 )
						{
							$meta .= '##METAFIELD##'.'editable'.'##VALUE##1';
						}
							
						# подготавливаем данные
						$article = array
						(
							'user_login' => $user['users_login'],
							'password' => $user['users_password'],
							'page_title' => mso_text_to_html($post['title']),
							'page_content' => $post['text'],
							'page_type_id' => (isset($options['new_page_type']) ? $options['new_page_type'] : 0),
							'page_id_cat' => ($options['show_categories'] && isset($post['category']) ) ? $post['category'] : $options['default_category'],
							'page_id_parent' => 0,
							'page_id_autor' => (isset($options['byuser']) ? $options['byuser'] : 1),
							'page_slug' => mso_slug($post['title']),
							'page_password' => '',
							'page_comment_allow' => 1,
							'page_ping_allow' => 1,
							'page_feed_allow' => 1,
							'page_tags' => '',
							'page_meta_options' => 'title'.'##VALUE##'.trim($post['title']).$meta.'##METAFIELD##'.'submit_article'.'##VALUE##1',
							'page_menu_order' => '',
							'page_date_publish' => date('Y-m-d H:i:s'),
						);
							
						# если рубрику выбирали чекбоксами, то надо соединить в строку все выбранные рубрики
						if( isset($post['category']) && is_array($post['category']) )
						{
							$article['page_id_cat'] = implode(",", $post['category']);
						}
							
						# определяем скорость публикации материала
						if( $options['new_page_rapidity'] == 'draft' || isset($post['draft']) )
						{
							$article['page_status'] = 'draft';
						}
						else
						{
							$article['page_status'] = 'publish';
						}
							
						# наконец-то сохраняем
						$res = mso_new_page( $article );
					}
					else
					{
						$metas = $pg['meta'];
							
						# сохраняем мета title
						$meta = 'title'.'##VALUE##'.trim($post['title']);
						unset($metas['title']);
							
						# если публикуем анонимно, то мета будет содержать только имя посетителя
						if( isset($pg['meta']['anonymous']) )
						{
							$meta .= '##METAFIELD##'.'anonymous'.'##VALUE##'.$pg['meta']['anonymous'];
							unset($metas['anonymous']);
						}
						elseif( isset($pg['meta']['comusers_id']) ) # иначе мы должны в мете сохранить comuser_id
						{
							$meta = '##METAFIELD##'.'comusers_id'.'##VALUE##'.$pg['meta']['comusers_id'];
							unset($metas['comusers_id']);
						}
							
						if( isset($pg['meta']['author_ip']) && $pg['meta']['author_ip'] ) # сохраняем ip автора
						{
							$meta .= '##METAFIELD##'.'author_ip'.'##VALUE##'.$pg['meta']['author_ip'];
							unset($metas['author_ip']);
						}
							
						# если показывалось поле сообщения для редактора
						if( $options['show_field_message_to_editor'] && (isset($post['editormsg']) || isset($pg['meta']['editormsg'])) )
						{
							$edmsg = isset($post['editormsg']) ? trim($post['editormsg']) : $pg['meta']['editormsg'];
							$meta .= '##METAFIELD##'.'editormsg'.'##VALUE##'.$edmsg;
							unset($metas['editormsg']);
						}
							
						# если показывалось поле краткое описание
						if( $options['show_field_description'] && (isset($post['desc']) || isset($pg['meta']['desc'])) )
						{
							$desc = isset($post['desc']) ? trim($post['desc']) : $pg['meta']['description'];
							$meta .= '##METAFIELD##'.'description'.'##VALUE##'.$desc;
							unset($metas['description']);
						}
							
						# автор пометил материал как черновик - будет ещё работать, если позволим
						unset($metas['draft']);
						if( isset($post['draft']) && $post['draft'] )
						{
							$meta .= '##METAFIELD##'.'draft'.'##VALUE##'.$post['draft'];
						}
							
						if( isset($pg['meta']['godmode']) && $pg['meta']['godmode'] ) # не нужно выводить блок автора, ибо постит админ/юзер
						{
							$meta .= '##METAFIELD##'.'godmode'.'##VALUE##'.$pg['meta']['godmode'];
							unset($metas['godmode']);
						}
							
						$pg['category'] = isset($pg['category']) ? $pg['category'] : array(); # сохраняем категории
						# надо сохранить тэги
						if( isset($pg['meta']['tags']) && $pg['meta']['tags'] ) # есть тэги
						{
							if( isset($pg['meta']['tags']) && is_array($pg['meta']['tags']) )
							{
								$pg['meta']['tags'] = implode(",", $pg['meta']['tags']);
							}
								
							$meta .= '##METAFIELD##'.'tags'.'##VALUE##'.$pg['meta']['tags'];
							unset($metas['tags']);
						}
							
						# сохраняем остальные мета-тэги
						if( count($metas) > 0 )
						{
							foreach( $metas as $k => $v )
							{
								if( is_array($v) )
								{
									$tmp_v = implode(",", $v);
								}
									
								$meta .= '##METAFIELD##'.$k.'##VALUE##'.( is_array($v) ? $tmp_v : $v );
							}
						}
							
						# подготавливаем данные
						$article = array
						(
							'page_id' => $pid,
							'user_login' => $user['users_login'],
							'password' => $user['users_password'],
							'page_title' => mso_text_to_html($post['title']),
							'page_content' => $post['text'],
							'page_type_id' => ( isset($pg['page_type_id'] ) ? $pg['page_type_id'] : 0),
							'page_id_cat' => ( isset($options['show_categories']) && $options['show_categories'] && isset($post['category']) ) ? $post['category'] : $pg['category'],
							'page_id_parent' => $pg['page_id_parent'],
							'page_id_autor' => $pg['page_id_autor'],
							'page_slug' => $pg['page_slug'],
							'page_password' => $pg['page_password'],
							'page_comment_allow' => $pg['page_comment_allow'],
							'page_ping_allow' => $pg['page_ping_allow'],
							'page_feed_allow' => $pg['page_feed_allow'],
							'page_meta_options' => $meta,
							'page_menu_order' => $pg['page_menu_order'],
						);
							
						# если рубрику выбирали чекбоксами, то надо соединить в строку все выбранные рубрики
						if( isset($article['page_id_cat']) && is_array($article['page_id_cat']) )
						{
							$article['page_id_cat'] = implode(",", $article['page_id_cat']);
						}
							
						# определяем скорость публикации материала
						if( isset($post['draft']) && ( ( is_login_comuser() && $options['comuser_can_set_draft_published'] ) || $admin ) )
						{
							$article['page_status'] = 'draft';
						}
						else
						{
							if( !isset($post['draft']) && $pg['page_status'] == 'draft' )
							{
								$article['page_status'] = 'publish';
							}
							else
							{
								$article['page_status'] = $pg['page_status'];
							}
						}
							
						# наконец-то сохраняем
						if( ( is_login_comuser() && isset($pg['meta']['comusers_id']) && $pg['meta']['comusers_id'] == getinfo('comusers_id') && isset($pg['meta']['editable']) ) || $admin )
						{
							# сперва удалим старые meta
							$CI->db->where( array('meta_id_obj' => $pid, 'meta_table' => 'page') );
							$CI->db->delete('meta');
								
							$res = mso_edit_page( $article );
						}
						else
						{
							$msg = ' У вас нет доступа к обновлению этой страницы!';
						}
					}
						
					# обработка прикреплённых файлов
					if( isset($res['result']) && $res['result'] && $options['can_upload'] == 1 ) # && isset($post['ins_files'][0]) && $post['ins_files'][0] != ''
					{
						$page_id = $res['result'][0]; # id добавленного материала
						$current_dir = '_pages/'.$page_id;
						$path = getinfo('uploads_dir').$current_dir;
							
						# Проверка существования 
						if( !is_dir($path) ) // нет каталога
						{
							if( !is_dir(getinfo('uploads_dir').'_pages') ) // нет _pages
							{
								@mkdir(getinfo('uploads_dir').'_pages', 0777); // пробуем создать
							}
						
							// нет каталога, пробуем создать
							@mkdir($path, 0777); 
							@mkdir($path.'/_mso_i', 0777); 
							@mkdir($path.'/mini', 0777);
						}
						
						if( !is_dir($path) ) // каталог не удалось создать
						{
							$msg = ' Не удалось создать каталог для файлов страницы.';
						}
						else # работаем с файлами
						{
							$tmpfolder = preg_replace('/[\/\\\]*$/msi', '', $options['temp_folder']); # убираем слеш в конце строки
								
							if( isset($post['ins_files']) )
							{
								foreach( $post['ins_files'] as $k => $v )
								{
									$tmpfile = getinfo('uploads_dir').$tmpfolder.'/'.$v;
									if( file_exists($tmpfile) && preg_match('/'.$v.'/', $post['text']) )
									{
										# выносим функции сохранения вставленных файлов в отдельный файл для реализации Pro/Lite версии
										require(getinfo('plugins_dir').basename(dirname(__FILE__)).'/save-inserted.php');
									}
								}
							}
								
							if( $msg == '' )
							{
								$CI->db->where( array('page_id' => $page_id) );
								$uptd = array(
									'page_content' => $post['text'],
								);
								if( !$CI->db->update('page', $uptd) )
								{
									$msg .= ' Не удалось заменить временные адреса прицепленных файлов на адреса постоянного хранения.'.NR;
								}
								else # всё хорошо и можно удалить мусор или сохранить закачанные файлы тоже
								{
									# поиск файлов с таким же sess_id
									$sess_id = $MSO->data['session']['session_id'];
									$files_list = glob(getinfo('uploads_dir').$tmpfolder.'/*.'.$sess_id);
										
									if( $files_list )
									{
										if( isset($options['save_notinserted_uploads']) && $options['save_notinserted_uploads'] )
										{
											foreach( $files_list as $fl )
											{
												preg_match('/\/([^\/]*?)\.'.$sess_id.'$/msi', $fl, $flm);
													
												$tmpfile = getinfo('uploads_dir').$tmpfolder.'/'.$flm[1];
													
												# выносим функции сохранения приаттаченных файлов в отдельный файл для реализации Pro/Lite версии
												require(getinfo('plugins_dir').basename(dirname(__FILE__)).'/save-attached.php');
											}
										}
										else # удаляем мусор
										{
											foreach( $files_list as $fl )
											{
												preg_match('/\/([^\/]*?)\.'.$sess_id.'$/msi', $fl, $flm);
													
												$file_orig = getinfo('uploads_dir').$tmpfolder.'/'.$flm[1];
												$file_icon = getinfo('uploads_dir').$tmpfolder.'/_mso_i/'.$flm[1];
												$file_mini = getinfo('uploads_dir').$tmpfolder.'/mini/'.$flm[1];
												$file_sess = getinfo('uploads_dir').$tmpfolder.'/'.$flm[1].'.'.$sess_id;
													
												if( file_exists($file_orig) )
												{
													unlink($file_orig);
												}
												if( file_exists($file_icon) )
												{
													unlink($file_icon);
												}
												if( file_exists($file_mini) )
												{
													unlink($file_mini);
												}
												if( file_exists($file_sess) )
												{
													unlink($file_sess);
												}
											}
										}
									}
								}
							}
						}
					}
						
					# проверяем результат сохранения
					if( isset($res['result']) && $res['result'] && $msg == '' ) # если всё нормально, то показываем сообщение, что всё сохранилось
					{
						# сохраним в сессии время отправления материала чтобы потом проверить, на частоту посылки POST запросов
						$CI->session->set_userdata('last_activity_submit_article', time());
						
						$page_id = $res['result'][0]; # id добавленного материала
							
						# формируем сообщение об успешности сохранения присланного материала
						$out .= '<div class="submit_article_form">'.NR;
								
							# формируем сообщение, что материал будет проходить модерацию
							if ( ($options['new_page_rapidity'] == 'draft' || isset($post['draft'])) && !$edit )
							{
								$moder = ' Он будет опубликован после одобрения редактором сайта.';
							}
							else
							{
								$moder = '';
							}
							$out .= '<div class="message ok small">Все данные успешно получены и материал сохранён!'.$moder.'</div>'.NR;
						$out .= '</div>'.NR;
							
						# отправим уведомление о новом материале редактору сайта
						if( !$edit && $options['notify_email'] && $options['new_article_submited'] )
						{
							# в $notify_text формируем текст письма с уведомлением
							$notify_text = 'Прислан новый материал'.NR;
							$notify_text .= getinfo('siteurl').'admin/page_edit/'.$page_id.NR;
							$notify_text .= 'Статус : ' .trim($article['page_status']).NR.str_repeat("-", 72).NR;
							$notify_text .= $article['page_title'].NR.'----'.NR; # название материала
							$notify_text .= trim($post['desc']).NR.str_repeat("-", 20).NR; # краткое описание
								
							# если публикуем анонимно, то уведомление будет содержать только имя посетителя
							if( $comuser_id == 0 )
							{
								$notify_text .= $post['comusers_nik'].NR; # имя автора
							}
							else # иначе мы должны в мете сохранить comuser_id
							{
								$notify_text .= $comusers_nik.' (Id №'.$comuser_id.')'.NR; # имя автора
								$notify_text .= $comuser_email.NR; # email автора
								$notify_text .= getinfo('siteurl').'admin/comusers/edit/'.$comuser_id.NR; # страницу редактирования автора
									
								if( isset($post['about']) && $post['about'] ) # добавляем информацию об авторе, если присылали
								{
									$notify_text .= '----'.NR;
									$notify_text .= trim($post['about']).NR ;
								}
								
							}
							if( isset($post['editormsg']) && $post['editormsg'] ) # добавляем сообщение редактору, если присылали
							{
								$notify_text .= str_repeat("-", 20).NR;
								$notify_text .= trim($post['editormsg']).NR ;
							}
							$notify_text .= '----'.NR;
							$notify_text .= 'IP адрес отправителя : '.$_SERVER['REMOTE_ADDR'].NR.str_repeat("-", 72).NR; # укажем ip адрес отправителя материала
								
							# рассылаем уведомление всем заинтересованным
							$email_list = array_map('trim', explode(',', trim($options['notify_email'])));
							foreach( $email_list as $toemail )
							{
								if( mso_valid_email($toemail) )
								{
									mso_mail($toemail, 'Прислан новый материал! [SUBMIT_ARTICLE]', $notify_text);
								}
							}
						}
							
						# отправим уведомление редактору сайта о том, что комюзером был отредактирован ранее опубликованный материал
						if( $edit && ($options['comuser_can_edit_published'] || $options['comuser_can_edit_draft']) && $options['article_edited_by_comuser'] && is_login_comuser() ) #&& isset($pg['meta']['comusers_id']) && $pg['meta']['comusers_id'] == getinfo('comusers_id')
						{
							# в $notify_text формируем текст письма с уведомлением
							$notify_text = 'Комюзер отредактировал материал'.NR;
							$notify_text .= getinfo('siteurl').'admin/page_edit/'.$page_id.NR;
							$notify_text .= 'Статус : ' .trim($article['page_status']).NR.str_repeat("-", 72).NR;
							$notify_text .= $article['page_title'].NR.'----'.NR; # название материала
							if( isset($post['desc']) ) $notify_text .= trim($post['desc']).NR.str_repeat("-", 20).NR; # краткое описание
							$notify_text .= $comusers_nik.' (Id №'.$comuser_id.')'.NR; # имя автора
							$notify_text .= $comuser_email.NR; # email автора
							$notify_text .= getinfo('siteurl').'admin/comusers/edit/'.$comuser_id.NR; # страницу редактирования автора
							$notify_text .= '----'.NR;
							$notify_text .= 'IP адрес отправителя : '.$_SERVER['REMOTE_ADDR'].NR.str_repeat("-", 72).NR; # укажем ip адрес отправителя материала
								
							# рассылаем уведомление всем заинтересованным
							$email_list = array_map('trim', explode(',', trim($options['notify_email'])));
							foreach( $email_list as $toemail )
							{
								if( mso_valid_email($toemail) )
								{
									mso_mail($toemail, 'Комюзер отредактировал материал! [SUBMIT_ARTICLE]', $notify_text);
								}
							}
						}						
					}
					else # иначе показываем сообщение об ошибке
					{
						if( isset($res['description']) && $res['description'] == 'Existing page' ) 
							$error .= '<div class="message alert small">Такая страница уже существует</div>';
						elseif( $edit && $msg <> '' )
							$error .= '<div class="message alert small">Ошибка обновления страницы.'.$msg.'</div>';
						else
							$error .= '<div class="message alert small">Ошибка создания страницы.'.$msg.''.(isset($res['description'])? ' '.$res['description'] : '').'</div>';
        				}
				}
			}
		}
			
		if( $error ) # если были ошибки, то нужно снова показать форму и при этом сохранить ранее введённые данные, чтобы заново не вводить
		{
			if( isset($options['hide_auth_block']) && $options['hide_auth_block'] && !is_login_comuser() && !is_login() )
			{
				$out .= $error.NR;
			}
			elseif( isset($cant_edit) && $cant_edit ) # если выяснилось, что не может редактировать данный материал
			{
				$out .= $error.NR;
			}
			else
			{
				require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/frontend-form.php' ); // подключили файл для вывода внешней части сайта - он умеет показывать ранее введённые данные
			}
		}
	}
	else # если в запросе прислали не все нужные данные, то показываем соответствующее сообщение об ошибке
	{	
		if( !$good_activity )
		{
			$out .= '<div class="submit_article_form">'.NR.'<div class="message error small">Слишком частые постинги материала. Попробуйте позже.</div>'.NR.'</div>'.NR;
		}
		else
		{
			$out .= '<div class="submit_article_form">'.NR.'<div class="message error small">На сервер переданы не все обязательные поля формы!</div>'.NR.'</div>'.NR;
		}
	}
?>