<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */
# ключ, тип, ключи массива
$settings = array(
	# Общие
	'group_1' => array(
		'type' => 'info',
		'title' => 'Общие',
		'text' => '', 
	),
	'stealth_mode' => array(
		'type' => 'select',
		'name' => 'Режим «Невидимости»',
		'description' => 'Выберите сообщение, которое будет показываться посетителям страницы формы. Если выбран пункт «Выключен», то форма будет отображаться в нормальном режиме. Авторизованный администратор будет иметь доступ к форме в любом случае.',
		'values' => 'off||Выключен#on404||Показывать сообщение «Ошибка 404»#onMM||Показывать сообщение «Техническое обслуживание»',
		'default' => 'onMM'
	),
	'stealth_mode_MM_msg' => array(
		'type' => 'textarea', 
		'name' => 'Текст сообщения посетителям о режиме обслуживания при включенном режиме «Невидимости».',
		'description' => 'Укажите текст, который будет выводиться посетителям в качестве сообщения о работе режима обслуживания. Можно использовать HTML', 
		'default' => 'На странице формы «Прислать статью» сейчас проводятся технические работы. Пожалуйста, зайдите позже!'
	),
	'slug' => array(
		'type' => 'text', 
		'name' => 'Главный slug', 
		'description' => 'Slug, на котором будут размещаться внешние страницы плагина', 
		'default' => 'submit_article'
	),
	'admin_row_limit' => array(
		'type' => 'text', 
		'name' => 'Количество записей в админ-панели', 
		'description' => 'Укажите количество записей, которые будут выводиться в панели управления', 
		'default' => '20'
	),
	'widget_mode' => array(
		'type' => 'select',
		'name' => 'Встроенный виджет',
		'description' => 'Выберите состояние виджета. Если выбран пункт «Включить», то виджет станет доступен для использования в сайдбаре(-ах).',
		'values' => '0||Выключить#1||Включить',
		'default' => '0'
	),
	'widget_hide' => array(
		'type' => 'checkbox', 
		'name' => 'Скрыть виджет на странице с формой', 
		'description' => 'Если поставить галочку, то виджет не будет выводиться на странице с основной формой.',
		'default' => 1
	),
		
	# Параметры нового материала
	'group_2' => array(
		'type' => 'info',
		'title' => 'Параметры нового материала',
		'text' => '', 
	),
	'new_page_type' => array(
		'type' => 'select',
		'name' => 'Тип нового материала',
		'description' => 'Добавляемому материалу будет автоматически приписан указанный тип записи',
		'values' => submit_article_get_types(),
		'default' => '0'
	),
	'byuser' => array(
		'type' => 'select',
		'name' => 'Каким юзером подписывать материал?',
		'description' => 'За материалом ОБЯЗАТЕЛЬНО должен быть закреплён юзер, который будет иметь права в админке модерировать и выводить в паблик присланные статьи.',
		'values' => submit_article_get_users(),
		'default' => '0'
	),
	'new_page_rapidity' => array(
		'type' => 'select',
		'name' => 'Скорость публикации нового материала',
		'description' => 'Добавляемому материалу будет автоматически приписан указанный тип записи. Если автор пометит материал как «черновик» (см. следующую опцию), то он не будет опубликован на сайте при любом значении поля.',
		'values' => 'draft||Пометить как «Черновик» #publish||Опубликовать немедленно',
		'default' => 'draft'
	),
	'draft' => array(
		'type' => 'checkbox', 
		'name' => 'Разрешать ли отмечать присылаемый материал как «черновик»?', 
		'description' => 'Если поставить галочку, то автору будет показываться чекбокс «Черновик», с помощью которого он сможет отменить немедленную публикацию нового присланного материала (при заданной скорости «Опубликовать немедленно»), а также позволит ему давать сигнал редактору о том, что работа над материалом не закончена (возобновлена) и материал пока нельзя публиковать на сайте.',
		'default' => 1
	),
	'hide_auth_block' => array(
		'type' => 'checkbox', 
		'name' => 'Скрыть блок авторизации и показать сообщение', 
		'description' => 'Если поставить галочку, то все поля блока авторизации будут скрыты и неавторизованному посетителю будет показано сообщение, которое задано в поле «Сообщение при скрытом блоке авторизации». Применяется в ситуациях, когда на сайте есть специальный стандартный блок (например, виджет) авторизации и нужно избежать дублирования способов.',
		'default' => 0
	),
	'hide_auth_block_msg' => array(
		'type' => 'text', 
		'name' => 'Сообщение при скрытом блоке авторизации',
		'description' => 'Можно указать свой текст или оставить стандартный. Другой стиль оформления сообщения можно задать благодаря использованию своей html-верстки и <b>custom.css</b>.',
		'default' => '<div class="message small alert">Для использования формы необходимо <a href="/registration">зарегистрироваться</a>/<a href="/login">войти</a>!</div>'
	),
	'show_auth_services' => array(
		'type' => 'checkbox', 
		'name' => 'Использовать плагины авторизации', 
		'description' => 'Если поставить галочку, то при любом включенном плагине авторизации (например, <b>loginza_auth</b>) будет выведено приглашение «Войти с помощью...»',
		'default' => 0
	),
	'anonymous' => array(
		'type' => 'checkbox', 
		'name' => 'Публиковать материалы анонимно?',
		'description' => 'Если поставить галочку, то у посетителей будет спрашиваться только имя. По-умолчанию (галки нет), для публикации будет обязателен ввод данных комюзера (в начале формы добавления материала будут показаны поля для авторизации/регистрации комюзера)',
		'default' => 0
	),
	'show_comuser' => array(
		'type' => 'checkbox', 
		'name' => 'Публиковать информацию о залогиненом комюзере',
		'description' => 'Если поставить галочку, то для авторизованного комюзера будет выведено имя и его аватарка',
		'default' => 0
	),
	'avatar_size' => array(
		'type' => 'text', 
		'name' => 'Размер аватарки',
		'description' => 'Оставьте поле пустым, если хотите использовать стандартные размеры аватарок. Укажите 0 (ноль), если отображать аватарку не нужно. Укажите размер (в пикселях), если нужен кастомный размер аватарки',
		'default' => ''
	),
	'show_categories' => array(
		'type' => 'checkbox', 
		'name' => 'Давать ли возможность выбрать рубрику?', 
		'description' => 'Если поставить галочку, то посетитель сможет выбрать одну из существующих на сайте рубрик для публикации своего материала',
		'default' => 1
	),
	'default_category' => array(
		'type' => 'select',
		'name' => 'Рубрика «по-умолчанию»', 
		'description' => 'Выберите рубрику, которая будет подставляться в ситуации, когда посетителю не даётся возможность самому выбирать рубрику.', 
		'values' => submit_article_get_categories(),
		'default' => '1'
	),
	'allow_categories' => array(
		'type' => 'text', 
		'name' => 'Разрешённые для публикации рубрики', 
		'description' => 'Перечисление ID рубрик, которые будут доступны для выбора при публикации материала посетителем. 0 - доступны все существующие рубрики', 
		'default' => '0'
	),
	'cat_field_type' => array(
		'type' => 'select',
		'name' => 'Тип поля выбора рубрики',
		'description' => 'Укажите используемый тип поля для выбора рубрики',
		'values' => '0||список множественного выбора#1||чекбоксы',
		'default' => '0'
	),
		
	# Параметры формы ввода
	'group_3' => array(
		'type' => 'info',
		'title' => 'Параметры формы ввода',
		'text' => '', 
	),
	'title' => array(
		'type' => 'text', 
		'name' => 'Заголовок на странице формы', 
		'description' => 'Содержимое тега H1, который выводится на странице с формой добавления материала', 
		'default' => 'Прислать статью'
	),
	'editor' => array(
		'type' => 'select',
		'name' => 'Редактор текста',
		'description' => 'Укажите используемый редактор текста',
		'values' => '0||Нет#1||markItUp#2||markItUp_extended#3||editor_jw#4||Простые bb-кнопки',
		'default' => '0'
	),
	'max_text_chars' => array(
		'type' => 'text', 
		'name' => 'Лимит символов в основном поле ввода', 
		'description' => 'Введите ограничение на число символов присылаемого материала. 0 или «пустое поле» - без ограничения (подразумевается, что ограничение будет обусловлено настройками ПО веб-сервера)', 
		'default' => '2000'
	),
	'max_text_chars_counter' => array(
		'type' => 'checkbox', 
		'name' => 'Счётчик оставшихся символов', 
		'description' => 'Если поставить галочку, то будет отображаться счётчик символов, оставшихся для ввода. Если лимит символов не задан, то счётчик отображаться не будет',
		'default' => 0
	),
	'captcha' => array(
		'type' => 'select',
		'name' => 'Капча',
		'description' => 'Выберите капчу, которая будет показываться незалогиненому посетителю',
		'values' => '0||Не показывать #1||Стандартная #2||«Математическая»',
		'default' => '1'
	),
	'show_field_site' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать поле «Сайт» для неавторизованного посетителя', 
		'description' => 'Если поставить галочку, то при регистраци нового комюзера кроме емайла и пароля будет запрошен адрес сайта',
		'default' => '0'
	),
	'show_field_author_info' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать поле «Расскажите немного о себе» для неавторизованного посетителя',
		'description' => 'Если поставить галочку, то при регистраци нового комюзера кроме емайла и пароля будет запрошена дополнительная информация о посетителе',
		'default' => '0'
	),
	'show_field_description' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать поле «Краткое описание текста (о чём он?)»', 
		'description' => 'Если поставить галочку, то автору будет показано поле, где он сможет задать значение мета поля DESCRIPTION.',
		'default' => '1'
	),
	'show_field_message_to_editor' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать поле «Сообщение редактору»', 
		'description' => 'Если поставить галочку, то у автора будет возможность оставить комментарий для редактора. Например, с просьбой пока не публиковать материал, ибо ещё не доконца оформлено заключение',
		'default' => '0'
	),
	'show_rules' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать чекбокс «Я принимаю правила сайта»', 
		'description' => 'Если поставлена галочка, то анонимному посетителю показывается чекбокс о принятии правил сайта. Ссылка на правила сайта может быть задана в <a href="/admin/options#a-kommentirovanie">общих настройках сайта</a> или через поле «Заголовки и обязательность полей формы». Авторизованным комюзерам чекбокс показываться не будет',
		'default' => '0'
	),
	'text_before' => array(
		'type' => 'textarea', 
		'name' => 'Текст перед формой добавления материала', 
		'description' => 'Укажите текст, который будет выводиться перед формой. Здесь можно указать ссылку на правила сайта или привести текст требования к публикациям. Можно использовать BBCODE/HTML.', 
		'default' => ''
	),
	'text_after' => array(
		'type' => 'textarea', 
		'name' => 'Текст после формы добавления материала',
		'description' => 'Укажите текст, который будет выводиться после формы. Можно использовать BBCODE/HTML.', 
		'default' => ''
	),
	'fields_prefs' => array(
		'type' => 'textarea', 
		'name' => 'Заголовки и обязательность полей формы',
		'description' => 'В этом поле можно задать свои названия полей формы (чтобы кастомизировать форму под специфику сайта) и указать обязательные для ввода поля (браузер будет требовать заполнение поля на основе специального html-атрибута у поля формы). Формат настройки одного поля: "id поля|Заголовок поля|required" или просто "id поля" (если поле необязательное). Настройка каждого поля размещается в отдельной строке. Доступные id полей: <b>email</b>, <b>password</b>, <b>comusers_nik</b>, <b>comusers_url</b>, <b>about</b>, <b>title</b>, <b>text</b>, <b>attach</b>, <b>desc</b>, <b>category</b>, <b>draft</b>, <b>rules</b>, <b>editormsg</b>. При этом, для поля <b>attach</b> атрибут required не действует (т.е. доступно только задание кастомного заголовка).'.
			' Общий пример:<br><pre>'.
			'<b>login-plugin</b> | Войти с помощью'.NR.
			'<b>email</b> | Ваш E-mail | required'.NR.
			'<b>password</b> | Пароль | required'.NR.
			'<b>comusers_nik</b> | Ваше имя | required'.NR.
			'<b>comusers_url</b> | Сайт | required'.NR.
			'<b>about</b> | Расскажите немного о себе | required'.NR.
			'<b>title</b> | Заголовок | required'.NR.
			'<b>text</b> | Текст | required'.NR.
			'<b>attach</b> | Загрузить иллюстрацию'.NR.
			'<b>desc</b> | Краткое описание текста (о чём он?) | required'.NR.
			'<b>category</b> | Рубрика | required'.NR.
			'<b>draft</b> | Черновик'.NR.
			'<b>editormsg</b> | Сообщение редактору | required'.NR.
			'<b>rules</b> | Я принимаю &lt;a href="/rules" target="_blank"&gt;правила сайта&lt;/a&gt;'.NR.
			'<b>captcha</b> | Защита от спама: введите нижние символы | required'.NR.
			'</pre>',
		'default' => 
			'login-plugin | Войти с помощью'.NR.
			'email | Ваш E-mail | required'.NR.
			'password | Пароль | required'.NR.
			'comusers_nik | Ваше имя | required'.NR.
			'comusers_url | Сайт | required'.NR.
			'about | Расскажите немного о себе | required'.NR.
			'title | Заголовок | required'.NR.
			'text | Текст | required'.NR.
			'desc | Краткое описание текста (о чём он?) | required'.NR.
			'category | Рубрика | required'.NR.
			'draft | Черновик'.NR.
			'editormsg | Сообщение редактору | required'.NR.
			'rules | Я принимаю <a href="/rules" target="_blank">правила сайта</a>'.NR.
			'captcha | Защита от спама: введите нижние символы | required'.NR
	),
	'submit_button_text' => array(
		'type' => 'text', 
		'name' => 'Надпись кнопке отправки формы на сервер',
		'description' => 'Укажите текст, который будет отображаться на кнопке. Например, можно задать текст «Отправить на проверку» или «Опубликовать»',
		'default' => 'Отправить'
	),
	'show_reset_button' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать кнопку «Очистить форму»', 
		'description' => 'При установленной галочке рядом с кнопкой «Отправить» будет отображена кнопка «Очистить форму».',
		'default' => '0'
	),
	'show_preview_button' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать кнопку «Предпросмотр»', 
		'description' => 'При установленной галочке рядом с кнопкой «Отправить» будет отображена кнопка «Предпросмотр».',
		'default' => '1'
	),
	'delimiter' => array(
		'type' => 'text', 
		'name' => 'Код разделителя блоков',
		'description' => 'Укажите html-код, который будет выводится для визуального разделения групп полей в форме добавления материала',
		'default' => '<hr>'
	),

	# Блок загрузки иллюстраций
	'group_4' => array(
		'type' => 'info',
		'title' => 'Загрузка иллюстраций/файлов <span class="x">*</span>',
		'text' => '',
	),
	'can_upload' => array(
		'type' => 'checkbox', 
		'name' => 'Разрешать загружать иллюстрации/файлы', 
		'description' => 'Если поставлена галочка, то у формы будет выводится блок «Загрузить иллюстрацию»',
		'default' => '0'
	),
	'who_can_upload' => array(
		'type' => 'checkbox', 
		'name' => 'Разрешать загружать иллюстрации только авторизованным посетителям',
		'description' => 'Если поставлена галочка, то вместо содержимого блока «Загрузить иллюстрацию» будет показано сообщение, что «для загрузки требуется авторизоваться».',
		'default' => '1'
	),
	'can_insert_upload' => array(
		'type' => 'checkbox', 
		'name' => 'Разрешать вставлять ссылки на загруженные иллюстрации/файлы в текст', 
		'description' => 'Если поставлена галочка, то у загруженного изображения/файла появится кнопка «Вставить» (для вставки кода ссылки в тело материала). Иначе изображения/файлы можно будет только прицеплять к материалу.',
		'default' => '0'
	),
	'save_notinserted_uploads' => array(
		'type' => 'checkbox', 
		'name' => 'Сохранять все загруженные файлы', 
		'description' => 'Если поставлена галочка, то при сохранении материала будут сохранены все загруженные изображения/файлы даже если на них нет ссылки в тексте (ссылки появляются при нажатии кнопки «Вставить»).',
		'default' => '1'
	),
	'can_edit_saved' => array(
		'type' => 'checkbox', 
		'name' => 'Разрешать редактировать сохранённые иллюстрации/файлы',
		'description' => 'Если поставлена галочка, то загруженные изображения/файлы будут доступны администраторам и комюзеру-автору при редактировании материала. Иначе все аттаченные файлы будут доступны только через админ-панель.',
		'default' => '0'
	),
	'upload_allowed_types' => array(
		'type' => 'text',
		'name' => 'Разрешённые типы файлов',
		'description' => 'Перечислите через знак «|» расширения файлов, которые будут разрешены для загрузки в качестве иллюстраций к материалу.',
		'default' => 'gif|jpg|jpeg|png'
	),
	'upload_resize' => array(
		'type' => 'checkbox', 
		'name' => 'Изменять ли размер загружаемых изображений?',
		'description' => 'Если поставлена галочка, то загружаемые изображения будут приведены к размеру (максимальной стороны), указанному в поле «<b>Размер для изображений</b>».',
		'default' => '0'
	),
	'upload_resize_images' => array(
		'type' => 'text', 
		'name' => 'Размер для изображений',
		'description' => 'Укажите дефолтный размер изображений при загрузке (по максимальной стороне). Если поле оставить пустым, то будет использовано значение по-умолчанию для раздела «Загрузки».',
		'default' => '600'
	),
	'upload_image_mini' => array(
		'type' => 'checkbox', 
		'name' => 'Создавать миниатюры для загружаемых изображений?',
		'description' => 'Если поставлена галочка, то для загружаемых изображений будут созданы миниатюры с размеру (максимальной стороны), указанному в поле «<b>Размер миниатюры для изображений</b>».',
		'default' => '0'
	),
	'upload_size_image_mini' => array(
		'type' => 'text', 
		'name' => 'Размер миниатюры для изображений',
		'description' => 'Укажите размер миниатюры по-умолчанию. Если поле оставить пустым, то будет использовано значение по-умолчанию для раздела «Загрузки».',
		'default' => '150'
	),
	'upload_image_mini_type' => array(
		'type' => 'select',
		'name' => 'Способ миниатюры',
		'description' => 'Способ создания миниатюры по умолчанию',
		'values' => '1||Пропорциональное уменьшение#2||Обрезки (crop) по центру#3||Обрезки (crop) с левого верхнего края#4||Обрезки (crop) с левого нижнего края#5||Обрезки (crop) с правого верхнего края#6||Обрезки (crop) с правого нижнего края#7||Уменьшения и обрезки (crop) в квадрат',
		'default' => '1'
	),
	'upload_use_watermark' => array(
		'type' => 'checkbox', 
		'name' => 'Ставить ватермарку',
		'description' => 'Примечание: водяной знак должен быть файлом <strong>watermark.png</strong>. Сперва ищется в подпапке <b>images</b> папки плагина (пример: <a target="_blank" href="'.getinfo('plugins_url').'submit_article/images/_watermark.png">watermark.png</a>), затем в каталоге <b>uploads</b> (попытка взять ватермарку всего сайта).',
		'default' => '0'
	),
	'upload_watermark_type' => array(
		'type' => 'select',
		'name' => 'Способ ватермарки',
		'description' => 'Способ размещения водяного знака на изображениях.',
		'values' => '1||По центру # 2||В левом верхнем углу # 3||В правом верхнем углу # 4||В левом нижнем углу # 5||В правом нижнем углу',
		'default' => '1'
	),
	'upload_preview_width' => array(
		'type' => 'text',
		'name' => 'Ширина превью-картинки',
		'description' => 'Укажите максимальную ширину превью-картинки. Если указать «<b>0</b>», то превьюшка отображаться <b>не будет</b>.',
		'default' => '100'
	),
	'upload_allowed_size' => array(
		'type' => 'text', 
		'name' => 'Разрешённый суммарный объём файлов',
		'description' => 'Укажите объём байт, которые можно будет загрузить пользователю для одного материала. 0 - нет явных ограничений.',
		'default' => '0'
	),
	'allowed_size_counter_title' => array(
		'type' => 'text', 
		'name' => 'Текст перед счётчиком',
		'description' => 'Задайте текст информера объёма, доступного для закачивания. Например, можно указать текст «Доступно для закачивания (байт): ». Если поле оставить пустым, то информер выводиться не будет.',
		'default' => 'Доступно для закачивания (байт): '
	),
	'temp_folder' => array(
		'type' => 'text', 
		'name' => 'Папка для временного хранения загруженных файлов',
		'description' => 'Укажите название папки относительно uploads-папки сайта (т.е. путь «/uploads/» указывать не нужно, он подставится автоматически)',
		'default' => 'tempfiles'
	),
	'upload_res_path_type' => array(
		'type' => 'select',
		'name' => 'Тип пути загруженной иллюстрации',
		'description' => 'Укажите тип пути, который будет указывать на загруженное изображение.',
		'values' => '0||относительный#1||абсолютный',
		'default' => '0'
	),
	'upload_sess_dietime' => array(
		'type' => 'text', 
		'name' => 'Через сколько минут удалять невостребованные файлы?',
		'description' => 'Укажите количество минут, после истечения которых будет считаться, что принадлежащие неактивной сессии файлы (во временной папке) можно удалять как «мусор». Чистка будет происходить при каждом открытии страницы с формой (при этом будут удаляться бесхозные файлы, которые «старее» указанного в поле периода) или же «по крону» с периодом, который зададите сами для команды CRON. Крон должен обращаться к специальному URL примерно так:<span class="cite">«GET http://сайт/submit_article/clean».<br>Для ISPManager указывайте так: «/usr/local/bin/wget -O /dev/null http://сайт/submit_article/clean».</span>Если операция чистки мусора по крону прошла успешно, то будет получено сообщение «cleaning complete!»',
		'default' => '15'
	),
		
	# Блок информации об авторе
	'group_5' => array(
		'type' => 'info',
		'title' => 'Блок информации об авторе <span class="x">*</span>',
		'text' => '',
	),
	'show_author_info' => array(
		'type' => 'checkbox', 
		'name' => 'Показывать блок информации об авторе', 
		'description' => 'Если поставить галочку, то при выводе присланных статей будет выводится блок с информацией о приславшем материал авторе. Такой блок может стать хорошим мотиватором присылать материалы на сайт (особенно, если в блоке будет выводится индексируемая гиперссылка на сайт автора)',
		'default' => '0'
	),
	'show_author_info_hook' => array(
		'type' => 'text', 
		'name' => 'Название хука, когда должна выводится информация об авторе материала', 
		'description' => 'Укажите название хука, когда нужно будет осуществлять вывод блока с информацией об авторе материала. Оставьте поле пустым, если ничего выводить не нужно', 
		'default' => 'content_end'
	),
	'author_info_block_type' => array(
		'type' => 'select',
		'name' => 'Тип содержимого блока',
		'description' => 'Укажите тип. При выборе типа «PHP» не будет производится обработка BBCODE (можно реализовать самостоятельно) и псевдокодов плагина.',
		'values' => '0||HTML/BBCODE#1||PHP',
		'default' => '0'
	),
	'author_info_block_code' => array(
		'type' => 'textarea', 
		'name' => 'Код блока с информацией об авторе материала',
		'description' => 'Укажите код, который будет выводится при срабатывании соответствующего хука (задаётся выше). Если тип PHP, то код должен выполняться без ошибок! Вместо PHP при работе с комюзерами можно установить тип поля в значение «HTML/BBCODE» и использовать смесь HTML и специальных ББ-кодов:[NAME],[SITE],[EMAIL],[ABOUT],[PROFILE],[AVATAR],[GRAVATAR]. Доступно к использованию подмножество условных, парных бб-кодов «с плюсом или минусом»: [+NAME]...[/+NAME],[-SITE]...[/-SITE] и т.д. - содержимое будет выведено, если доступно(если «+») или недоступно(если «-») для вывода значение NAME, SITE и т.д.',
		'default' => '<div class="author"><p>Автор: <b><a href="[PROFILE]">[NAME]</a></b></p><p>[ABOUT]</p><p>[+SITE]<a href="[SITE]" rel=nofollow>Сайт</a>[/+SITE][+EMAIL][+SITE] /[/+SITE]<a href="mailto:[EMAIL]" rel=nofollow>Емайл</a>[/+EMAIL]</p></div>'
	),
	'show_user_author_info' => array(
		'type' => 'checkbox', 
		'name' => 'Использовать информацию юзера, если комюзер-автор недоступен', 
		'description' => 'Если при выводе авторского блока информация о комюзер-авторе не будет найден в базе данных, то в блоке будет выведена информация юзер-редактора, от имени которого плагин осуществляет публикации.',
		'default' => '0'
	),
	'show_block_in_godmode' => array(
		'type' => 'checkbox', 
		'name' => 'Публиковать блок с информацией юзер-автора',
		'description' => 'Если материал публиковался от имени юзера (а не комюзера или анонима), то будет выведена информация о нём. Если галочки нет, то блок будет скрыт.',
		'default' => '0'
	),
		
	# Уведомления
	'group_6' => array(
		'type' => 'info',
		'title' => 'Уведомления',
		'text' => '', 
	),
	'notify_email' => array(
		'type' => 'text',
		'name' => 'Email для уведомлений',
		'description' => 'Укажите email, на который будут высылаться уведомления о добавлении нового или редактировании старого материала. Можно указать несколько email адресов через запятую. Если поле оставить пустым, то уведомления отсылаться не будут',
		'default' => ''
	),			
	'new_article_submited' => array(
		'type' => 'checkbox',
		'name' => 'Присылать уведомления, когда прислан новый материал',
		'description' => 'Если поставить галочку, то на указанный емайл будут приходить уведомления о новых присланных материалах.',
		'default' => 0
	),
	'article_edited_by_comuser' => array(
		'type' => 'checkbox',
		'name' => 'Присылать уведомления, когда комюзер-автор отредактировал свой материал',
		'description' => 'Если поставить галочку, то на указанный емайл будут приходить уведомления о редактировании комюзером ранее сохранённого (черновика или опубликованного) материала.',
		'default' => 0
	),
	'new_comment_subscription' => array(
		'type' => 'checkbox',
		'name' => 'Автоматически подписать автора материала на новые комментарии к нему',
		'description' => 'Если поставить галочку, то комюзер будет получать уведомления о новых комментариях к опубликованным им материалам',
		'default' => 0
	),
	'comuser_can_unsubscribe' => array(
		'type' => 'checkbox',
		'name' => 'Возможность отписаться от уведомлений о новых комментариях',
		'description' => 'Если поставить галочку, то комюзер-автор сможет на странице своего профиля убрать «галочку» подписки, чтобы не получать уведомления о новых комментариях к опубликованным им материалам.',
		'default' => 1
	),
	'off_alerts_comuser_notfound' => array(
		'type' => 'checkbox',
		'name' => 'Не присылать уведомления про не найденного комюзера-автора',
		'description' => 'Если поставить галочку, то администратор сайта не будет получать уведомления если комюзер-автор материала не будет найден при попытке послать ему сообщение о комментарии.',
		'default' => 0
	),
	'reauthor_comuser_notfound' => array(
		'type' => 'checkbox',
		'name' => 'Убрать привязку материала к комюзер-автору, если комюзер-автор не найден в базе данных',
		'description' => 'Если поставить галочку, то вместо комюзера-автора материалу будет назначен анонимный автор с именем «Комментатор ID» (а в панели управления присланными материала такой комюзер будет помечен желтым цветом и именем «Удалённый ID»).',
		'default' => 0
	),
		
	# Страница комюзера
	'group_7' => array(
		'type' => 'info',
		'title' => 'Возможности комюзера',
		'text' => '',
	),
	'comuser_work_list' => array(
		'type' => 'checkbox',
		'name' => 'Отображение списка опубликованных присланных материалов',
		'description' => 'Если поставить галочку, то на странице профиля комюзера-автора будет виден список всех опубликованных им материалов.',
		'default' => 1
	),
	'comuser_draft_list' => array(
		'type' => 'checkbox',
		'name' => 'Отображение списка «черновиков»',
		'description' => 'Если поставить галочку, комюзер-автор будет видеть список материалов, которые имеют статус «черновик».',
		'default' => 1
	),
	'comuser_can_edit_published' => array(
		'type' => 'checkbox',
		'name' => 'Возможность редактировать опубликованные материалы',
		'description' => 'Если поставить галочку, то комюзер-автор сможет редактировать опубликованные на сайте материалы. Можно настроить получение уведомлений о фактах редактирования комюзером (см. раздел «Уведомления»).',
		'default' => 0
	),
	'comuser_can_edit_draft' => array(
		'type' => 'checkbox',
		'name' => 'Возможность редактировать черновики',
		'description' => 'Если поставить галочку, то комюзер-автор сможет редактировать свои материалы-черновики. Можно настроить получение уведомлений о фактах редактирования комюзером (см. раздел «Уведомления»).',
		'default' => 1
	),
	'comuser_can_set_draft_published' => array(
		'type' => 'checkbox',
		'name' => 'Возможность переводить опубликованный на сайте материал в статус «Черновик»',
		'description' => 'Если поставить галочку, то комюзер-автор сможет с помощью своей галочки «Черновик» (см. опцию «Разрешать ли отмечать присылаемый материал как «черновик»?» ) снимать с публикации опубликованные на сайте материалы.',
		'default' => 0
	),
	'comuser_page_title' => array(
		'type' => 'text',
		'name' => 'Заголовок списка присланных материалов',
		'description' => 'Укажите текст, который будет отображаться в качестве заголовка на странице профайла комюзера перед списком материалов. Если оставить поле пустым, то будет использована надпись «Присланные статьи».',
		'default' => 'Присланные статьи'
	),
		
	# Стили
	'group_8' => array(
		'type' => 'info',
		'title' => 'Стили',
		'text' => '',
	),
	'css' => array(
		'type' => 'textarea',
		'name' => 'CSS стили',
		'description' => 'Вы можете указать произвольные css-стили, которые могут пригодится при оформлении формы ввода присылаемого материала или блока информации об авторе. Также доступен альтернативный вариант: создайте в папке плагина файл <b>custom.css</b> и разместите в нём все необходимые стили. Файл будет подключен автоматически.',
		'default' => ''
	),
	'css_slug' => array(
		'type' => 'text',
		'name' => 'Slug-и для подключения CSS стилей',
		'description' => 'Специфические slug-и, на страницах которых дополнительно будут подключаться вышеуказанные CSS стили и файл «<b>custom.css</b>». Slug плагина указывать не нужно - стили подключаются по-умолчанию. Перечислять через запятую',
		'default' => 'page, users'
	),
		
	# SEO параметры страницы с формой ввода
	'group_9' => array(
		'type' => 'info',
		'title' => 'SEO параметры страницы с формой ввода',
		'text' => '',
	),
	'head_title' => array(
		'type' => 'text',
		'name' => 'TITLE',
		'description' => 'Содержимое тэга TITLE для страницы формы. Можно использовать бб-коды: <b>[SITENAME]</b> (для подстановки глобального названия сайта), <b>[HEADER]</b> (для подстановки значения поля «Заголовок на странице формы», см. выше). Если поле оставить пустым, то тэг <b>&lt;title&gt;</b> останется незаполненным.',
		'default' => '[HEADER] - [SITENAME]'
	),
	'head_description' => array(
		'type' => 'text',
		'name' => 'DESCRIPTION',
		'description' => 'Значение мета-тэга DESCRIPTION.',
		'default' => 'Страница с формой добавления материала на сайт.'
	),
	'head_keywords' => array(
		'type' => 'text',
		'name' => 'KEYWORDS',
		'description' => 'Значение мета-тэга KEYWORDS.',
		'default' => 'submit,article,прислать,статья'
	),
	'redirect_submit_article_uri' => array(
		'type' => 'checkbox',
		'name' => 'Делать редирект с URI «submit_aricle» на новый slug',
		'description' => 'Если поставить галочку, то будет производится 301 редирект со стандартного URI формы («submit_article») на slug, который указан в опции «Главный slug» (если отличается от стандартного). Это помогает избежать битых ссылок на форму.',
		'default' => 1
	),
);

?>