<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */

# функция, которая берет настройки из опций виджетов
function submit_article_widget($num = 1)
{
	$widget = basename(dirname(__FILE__)).'_widget_'.$num; # имя для опций = виджет + номер
	$options = mso_get_option($widget, 'plugins', array() ); # получаем опции
		
	# получаем опции плагина
	$options_pl = submit_article_get_options();
		
	# заменим заголовок, чтобы был в  h2 class="box"
	if( isset($options['header']) && $options['header'] ) 
		$options['header'] = mso_get_val('widget_header_start', '<h2 class="box"><span>').$options['header'].mso_get_val('widget_header_end', '</span></h2>');
	else 
		$options['header'] = '';
		
	if( isset($options_pl['widget_mode']) && $options_pl['widget_mode'] && ( !$options_pl['widget_hide'] || ( $options_pl['widget_hide'] && mso_segment(1) <> $options_pl['slug'] ) ) ) # подключение виджета при необходимости
	{
		return submit_article_widget_custom($options, $num);
	}
	else
		return false;
}

# форма настройки виджета 
# имя функции = виджет_form
function submit_article_widget_form($num = 1)
{
	$widget = basename(dirname(__FILE__)).'_widget_'.$num; # имя для формы и опций = виджет + номер
	
	# получаем опции 
	$options = mso_get_option($widget, 'plugins', array());
	
	if(!isset($options['header'])) $options['header'] = '';
	if(!isset($options['text_before'])) $options['text_before'] = '';
	if(!isset($options['caption'])) $options['caption'] = '';
	if(!isset($options['font_size'])) $options['font_size'] = '16pt';
	if(!isset($options['text_after'])) $options['text_after'] = '';
	
	# вывод самой формы
	$CI = & get_instance();
	$CI->load->helper('form');
		
	$form = mso_widget_create_form(t('Заголовок'), form_input( array( 'name' => $widget.'header', 'value' => $options['header'])), 'Заголовок виджета');

	$form .= mso_widget_create_form(t('Текст перед кнопкой'), form_textarea( array( 'name' => $widget.'text_before', 'value' => $options['text_before'] ) ), 'Любой пояснительный текст перед кнопкой. Можно использовать HTML-тэги.');

	$form .= mso_widget_create_form(t('Надпись на кнопке'), form_input( array( 'name' => $widget.'caption', 'value' => $options['caption'])), '');

	$form .= mso_widget_create_form(t('Размер шрифта кнопки'), form_input( array( 'name' => $widget.'font_size', 'value' => $options['font_size'])), 'Укажите число и единицу измерений. Например, «<b>16pt</b>» или «<b>14px</b>». Точку с запятой («;») ставить <b>не нужно!</b>');
		
	$form .= mso_widget_create_form(t('Текст после кнопки'), form_textarea( array( 'name' => $widget.'text_after', 'value' => $options['text_after'] ) ), 'Любой пояснительный текст после кнопки. Можно использовать HTML-тэги.');
	
	return $form;
}

# сохранение настроек виджета
function submit_article_widget_update($num = 1)
{
	$widget = basename(dirname(__FILE__)).'_widget_'.$num; # имя для формы и опций = виджет + номер
		
	# получаем опции
	$options = $newoptions = mso_get_option($widget, 'plugins', array());
		
	# обрабатываем POST
	$newoptions['header'] = mso_widget_get_post($widget.'header');
	$newoptions['text_before'] = mso_widget_get_post($widget.'text_before');
	$newoptions['caption'] = mso_widget_get_post($widget.'caption');
	$newoptions['font_size'] = mso_widget_get_post($widget.'font_size');
	$newoptions['text_after'] = mso_widget_get_post($widget.'text_after');
		
	if( $options != $newoptions )
		mso_add_option($widget, $newoptions, 'plugins');
}

# функции виджета
function submit_article_widget_custom($options = array(), $num = 1)
{
	# кэш 
	$cache_key = basename(dirname(__FILE__)).'_widget_custom'.serialize($options).$num;
	$k = mso_get_cache($cache_key);
	if( $k ) return $k; # да есть в кэше
		
	# получаем опции плагина
	$options_pl = submit_article_get_options();
		
	$out = $options['header'].'<div class="text_before">'.$options['text_before'].'</div><div class="button"><a style="font-size: '.$options['font_size'].';" href="/'.$options_pl['slug'].'" rel="nofollow">'.$options['caption'].'</a></div><div class="text_after">'.$options['text_after'].'</div>';
		
	mso_add_cache($cache_key, $out); # сразу в кэш добавим
		
	return $out;	
}