<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * For MaxSite CMS
 * Highlight
 * Author: (c) Bugo
 * Plugin URL: http://dragomano.ru/page/maxsite-cms-plugins
 */

function highlight_autoload($args = array())
{
	mso_hook_add('head', 'highlight_head');
	mso_hook_add('content', 'highlight_content');
}

function highlight_uninstall($args = array())
{	
	mso_delete_option('plugin_highlight', 'plugins');
	return $args;
}

function highlight_scan_files($cat = 'css')
{
	$CI = &get_instance();
	$CI -> load -> helper('directory'); 

	$path = getinfo('plugins_dir') . '/highlight/' . $cat;
	$files = directory_map($path, true);
	
	if (!$files) return '';
	
	$all_files = array();
	
	foreach ($files as $file)
	{
		if (@is_dir($path . $file)) continue;
		$file = str_replace('.css', '', $file);
		$all_files[] = $file;
	}
	
	sort($all_files);
	
	return implode($all_files, '#');
}

function highlight_mso_options()
{
	$all_css = highlight_scan_files();

	mso_admin_plugin_options('plugin_highlight', 'plugins', 
		array(
			'style' => array(
				'type' => 'select', 
				'name' => t('Стиль оформления', __FILE__), 
				'description' => t('Выберите схему подсветки кода.', __FILE__), 
				'values' => $all_css,
				'default' => 'default'
			)
		),
		t('Настройки плагина Highlight', __FILE__),
		t('Укажите необходимые опции.', 'plugins')
	);

}

function highlight_head($arg = array()) 
{
	$options = mso_get_option('plugin_highlight', 'plugins', array());
	if (!isset($options['style']) or !$options['style']) $options['style'] = 'default';
	
	echo '
	<link rel="stylesheet" href="' . getinfo('plugins_url') . 'highlight/css/' . $options['style'] . '.css" type="text/css" media="screen">
	<style type="text/css">pre {padding: 0; white-space: normal}</style>
	<script src="' . getinfo('plugins_url') . 'highlight/highlight.pack.js" type="text/javascript"></script>
	<script type="text/javascript">hljs.initHighlightingOnLoad();</script>' . NR;
	
	return $arg;

}

function highlight_content($text = '')
{
	$options = mso_get_option('plugin_highlight', 'plugins', array());
	if (!isset($options['style']) or !$options['style']) 
	{
		return $text;
	}
	else
	{
		$text = str_ireplace('<code', '<pre><code ', $text);
		$text = str_ireplace('</code>', '</code></pre>', $text);

		return $text;
	}
}

# end file