<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 *
 * Alexander Schilling
 * (c) http://alexanderschilling.net
 */
 
 
# функция автоподключения плагина
function dignity_biblequote_autoload($args = array())
{
	# регистрируем виджет
	mso_register_widget('dignity_biblequote_widget', t('Цитаты из Библии', 'plugins')); 
}

function dignity_biblequote_uninstall($args = array())
{	
	mso_delete_option_mask('dignity_biblequote_widget_', 'plugins'); // удалим созданные опции
	return $args;
}

# функция виджета
function dignity_biblequote_widget($num = 1)
{
	$widget = 'dignity_biblequote_widget_' . $num; // имя для опций = виджет + номер
	$options = mso_get_option($widget, 'plugins', array() ); // получаем опции
	
	// заменим заголовок, чтобы был в  h2 class="box"
	if ( isset($options['header']) and $options['header'] ) 
		$options['header'] = mso_get_val('widget_header_start', '<h2 class="box"><span>') . $options['header'] . mso_get_val('widget_header_end', '</span></h2>');
	else $options['header'] = '';
	
	return dignity_biblequote_widget_custom($options, $num);
}

# функция вывода формы настройки виджета
function dignity_biblequote_widget_form($num = 1)
{
	$widget = 'dignity_biblequote_widget_' . $num; // имя для формы и опций = виджет + номер
	
	// получаем опции 
	$options = mso_get_option($widget, 'plugins', array());
	
	if ( !isset($options['header']) ) $options['header'] = '';
	if ( !isset($options['once_daily']) ) $options['once_daily'] = 'random';
	
	// вывод самой формы
	$CI = & get_instance();
	$CI->load->helper('form');
	
	$form = '<p><div class="t150">' . t('Заголовок:', 'plugins') . '</div> '. 
			form_input( array( 'name'=>$widget . 'header', 'value'=>$options['header'] ) ) ;
	
	$form .= '<p><div class="t150">' . t('Способ вывода:', 'plugins') . '</div> '. form_dropdown( $widget . 'once_daily', array( 'random'=>t('Случайным образом', 'plugins'), 'day'=>t('Раз в сутки', 'plugins')), $options['once_daily']);
	
	$form .= '<br><div class="t150">&nbsp</div> ' . 
			t('При выборе «Раз в сутки» выводится строчка, номер которой совпадает с сегодняшним числом.', 'plugins');
	
	return $form;
}


# сюда приходят POST из формы настройки виджета
# имя функции = виджет_update
function dignity_biblequote_widget_update($num = 1) 
{
	$widget = 'dignity_biblequote_widget_' . $num; // имя для опций = виджет + номер
	
	// получаем опции
	$options = $newoptions = mso_get_option($widget, 'plugins', array());
	
	# обрабатываем POST
	$newoptions['header'] = mso_widget_get_post($widget . 'header');
	$newoptions['once_daily'] = mso_widget_get_post($widget . 'once_daily');
	
	if ( $options != $newoptions ) 
		mso_add_option($widget, $newoptions, 'plugins');
}


# основная функция
function dignity_biblequote_widget_custom($arg = array(), $num = 1)
{
	if ( !isset($arg['header'])) $arg['header'] = mso_get_val('widget_header_start', '<h2 class="box"><span>') . t('Цитата из Библии', 'plugins') . mso_get_val('widget_header_end', '</span></h2>') ;
	if ( !isset($arg['block_start']) ) $arg['block_start'] = '<div class="random-text">';
	if ( !isset($arg['block_end']) ) $arg['block_end'] = '</div>';
	if ( !isset($arg['once_daily']) ) $arg['once_daily'] = 'random';
	
	$text = '';
	
	# если есть ушка dignity_biblequote, то берем текст из неё
	if (function_exists('ushka')) 
	{
		$text = ushka('dignity_biblequote', "\n");
	}
	
	if (!$text)
	{
		$text =
		'А теперь пребывают сии три: вера, надежда, любовь (1Кор.13:13)
А устроивший все есть Бог (Евр.3:4)
А чего я не знаю. Ты научи меня (Иов (34:32)
Благ Господь к надеющимся на Него (Плач.3:25)
Благо будет боящимся Бога (Еккл.8:12)
Благодарение Богу за неизреченный дар Его! (2Кор.9:15)
Благодарение Богу, даровавшему нам победу (1Кор.15:57)
Благопоспеши рабу Твоему теперь (Неем.1:11)
Благословен Господь всякий день (Пс.67:20)
Благословлю тебя... и будешь ты в благословение (Быт.12:2)
Благословляет боящихся Господа (Пс.113:21)
Блажен человек, который переносит искушение (Иак.1:12)
Блажен... чьи грехи покрыты! (Пс.31:1)
Блаженны плачущие ныне, ибо воссмеетесь (Лук.6:21)
Близко к тебе слово, в устах твоих и в сердце твоем (Рим.10:8)
Близок всему конец (1Пет.4:7)
Бог во Христе примирил с Собою мир (2Кор.5:19)
Бог даровал нам жизнь вечную (1Иоан.5:11)
Бог есть любовь (1Иоан.4:8)
Бог есть свет, и нет в Нем никакой тьмы (1Иоан.1:5)
Бог же силен обогатить вас всякою благодатью (2Кор.9:8)
Бог мой да восполнит всякую нужду вашу (Фил.4:19)
Бог нам прибежище (Пс.61:9)
Бог наш, Которому мы служим, силен спасти нас (Дан.3:17)
Бог производит в вас и хотение и действие... (Фил.2:13)
Бог твой, научающий тебя полезному (Ис.48:17)
Бог, творец Мой, Который дает песни в ночи (Иов 35:10)
Бог... терпения и утешения (Рим.15:5)
Бодрствуйте и молитесь (Мат.26:41)
Бодрствуйте, стойте в вере (1Кор.16:13)
Больше всего хранимого храни сердце твое (Прит.4:23)
Буду вспоминать о чудесах Твоих древних (Пс.76:12)
Буду радоваться о них, благотворя им (Иер.32:41)
Будут дожди благословения (Иез.34:26)
Будь верен до смерти, и дам венец жизни (Отк.2:10)
Будьте братолюбивы друг к другу с нежностью (Рим.12:10)
Будьте единомысленны, мирны (2Кор.13:11)
Будьте же исполнители слова (Иак.1:22)
Будьте святы во всех поступках (1Пет.1:15)
Будьте святы, потому что Я свят (1Пет.1:16)
Быть готовыми на всякое доброе дело (Тит.3:1)
В кротости примите насаждаемое слово (Иак.1:21)
В Нем вы обогатились всем (1Кор.1:5)
В тени крыл Твоих укрой меня (Пс.16:8)
Велик мир любящих закон Твой (Пс.118:165)
Великие и драгоценные обетования (2Пет.1:4)
Вера без дел мертва (Иак.2:26)
Вера от слышания, а слышание от слова Божия (Рим.10:17)
Веруете ли, что Я могу это сделать? (Мат.9:28)
Верующий в Него не постыдится (1Пет.2:6)
Веселие вечное будет у них (Ис.61:7)
Веселись пред Господом, Богом твоим (Втор.12:18)
Взыщите Меня - и будете живы (Ам.5:4)
Видимое временно, а невидимое вечно (2Кор.4:18)
Влеки меня, мы побежим за тобою ((Песн.П.1:4)
Во всякой скорби их Он не оставлял их (Ис.63:9)
Воздвигните руки ваши... и благословите Господа (Пс.134:2)
Воззови ко Мне - и Я отвечу тебе (Иер.33:3)
Воззову к Богу... благодетельствующему мне (Пс.56:3)
Возложи на Господа заботы твои (Пс.54:23)
Возлюбленные! мы теперь дети Божии (1Иоан.3:2)
Возрастайте в благодати (2Пет.3:18)
Возродивший нас... к наследству нетленному, чистому... (1Пет.1:3,4)
Возьми крест... и следуй за Мною (Лук.9:23)
Войду в размышление о силах, Господа Бога (Пс.70:16)
Воля Божия благая, угодная и совершенная (Рим.12:2)
Восхотев, родил Он нас словом истины (Иак.1:18)
Вот, теперь день спасения (2Кор.6:2)
Все вы одно во Христе Иисусе (Гал.3:28)
Все делайте в славу Божию (1Кор.10:31)
Все заботы ваши возложите на Него (1Пет.5:7)
Все Мое Твое, и Твое Мое (Иоан.17:10)
Все сие преодолеваем силою Возлюбившего нас (Рим.8:37)
Все у вас да будет с любовью (1Кор.16:14)
Все хорошо делает (Мар.7:37)
Все, водимые Духом Божиим, суть сыны Божии (Рим.8:14)
Все, что делает Бог, пребывает вовек (Еккл.3:14)
Встав весьма рано... молился (Мар.1:35)
Всякий, кто призовет имя Господне, спасется (Рим.10:13)
Всякое даяние доброе... нисходит свыше (Иак.1:17)
Вы - письмо Христово (2Кор.3:3)
Вы вкусили, что благ Господь (1Пет.2:3)
Вы же - Христовы, а Христос - Божий (1Кор.3:23)
Вы куплены дорогою ценою (1Кор.6:20)
Вы получите неувядающий венец славы (1Пет.5:4)
Вы приняли не духа мира сего, а Духа от Бога (1Кор.2:12)
Вы.. стали близки Кровию Христовою (Еф.2:13)
Вывел народ Свой в радости (Пс.104:43)
Где Дух Господень, там свобода (2Кор.3:17)
Где Я, там и слуга Мой будет (Иоан.12:26)
Говорили слово Божие с дерзновением (Деян.4:31)
Говорит ли кто, говори как слова Божии (1Пет.4:11)
Господа Бога святите в сердцах ваших (1Пет.3:15)
Господи! пред Тобою все желания мои (Пс.37:10)
Господи! соверши дело Твое среди лет (Авв.3:2)
Господу Богу твоему поклоняйся (Мат.4:10)
Господь - сила моя, и пение мое - Господь (Ис.12:2)
Господь благословит народ Свой миром (Пс.28:11)
Господь Бог есть солнце и щит (Пс.83:12)
Господь Бог есть твердыня вечная (Пс.26:4)
Господь будет для тебя вечным светом (Ис.60:20)
Господь будет защитою для народа Своего (Иоил.3:16)
Господь весьма милосерд и сострадателен (Иак.5:11)
Господь возложил на Него грехи всех нас (Ис.53:6)
Господь дает благодать и славу (Пс.83:12)
Господь знает надеющихся на Него (Наум 1:7)
Господь совершит за меня (Пс.137:8)
Господь, Бог человеколюбивый и милосердный (Исх.34:6)
Грехов их уже не воспомяну более (Иер.31:34)
Грядет Бог наш, и не в безмолвии (Пс.49:3)
Да будет воля Господня! (Деян.21:14)
Да будет же милость Твоя утешением моим (Пс.118:76)
Да будет рука Твоя в помощь мне (Пс.118:173)
Да живу я вечно в жилище Твоем (Пс.60:5)
Да приносим плод Богу (Рим.7:4)
Да просит с верою, ни мало не сомневаясь (Иак.1:6)
Да просит у Бога, дающего всем просто и без упреков (Иак.1:5)
Дабы нам получить усыновление (Гал.4:5)
Дар Божий - жизнь вечная (Рим.6:23)
Даром получили, даром давайте (Мат.10:8)
Дары и призвание Божие непреложны (Рим.11:29)
Делами вера достигла совершенства (Иак.2:22)
Делом правды будет мир (Ис.32:17)
Дерзай.. прощаются тебе грехи твои (Мат.9:2)
Долготерпение Господа нашего почитайте спасением (2Пет.3:15)
Долготерпите и вы, укрепите сердца ваши (Иак.5:8)
Дорога цена искупления души их (Пс.48:9)
Дорожа временем, потому что дни лукавы (Еф.5:16)
Достигайте любви, ревнуйте о дарах духовных (1Кор.14:1)
Достоин Агнец закланный (Отк.5:12)
Древнее прошло, теперь все новое (2Кор.5:17)
Дух Славы, Дух Божий почивает на вас (1Пет.4:14)
Духом пламенейте, Господу служите (Рим.12:11)
Един.. посредник между Богом и человеками (1Тим.2:5)
Если Бог за нас, кто против нас?  (Рим.8:31)
Если будешь искать Его, то найдешь Его (1Пар.28:9)
Еще немного.. и Грядущий приидет и не умедлит (Евр.10:37)
Жизнь ваша сокрыта со Христом в Боге (Кол.3:3)
Жилище благочестивых Он благословляет (Прит.3:33)
Завет вечный положил Он со мною (2Цар.23:5)
Запечатлены обетованным Святым Духом (Еф.1:13)
Знает Господь путь праведных (Пс.1:6)
Знает Отец ваш, в чем вы имеете нужду (Мат.6:8)
Знание надмевает, а любовь назидает (1Кор.8:1)
И буду вам Отцем, и вы будете Моими сынами и дщерями (2Кор.6:18)
И во всем.. оправдывается Им всякий верующий (Деян.13:39)
И воспоют пути Господни (Пс.137:5)
И говорил Я: ты будешь называть Меня отцом твоим (Иер.3:19
И дух новый дам вам (Иез.36:26)
И жизнь была свет человеков (Иоан.1:4)
И которые прикасались к Нему, исцелялись (Мар.6:56)
И мы познали любовь, которую имеет к нам Бог (1Иоан.4:16)
И на земле мир, в человеках благоволение (Лук.2:14)
И ожидать с небес Сына Его (1Фес.1:10)
И поставлю жилище Мое среди вас (Лев.26:11)
И слово мое и проповедь моя.. в явлении духа и силы (1Кор.2:4)
И так Авраам долготерпев получил обещанное (Евр.6:15)
И Царь скажет им в ответ: вы сделали Мне (Мат.25:40)
Ибо Агнец... будет пасти их (Отк.7:17)
Ибо благоволит Господь к народу Своему (Пс.149:4)
Ибо близок день Господень (Соф.1:7)
Ибо велика милость Его к нам (Пс.116:2)
Ибо вот, Я творю новое небо и новую землю (Ис.65:17)
Ибо все обетования Божий в Нем "да" (2Кор.1:20)
Ибо жизнь явилась (1Иоан.1:2)
Ибо иго Мое благо, и бремя Мое легко (Мат.11:30)
Ибо Милующий их будет вести их (Ис.49:10)
Ибо мы соработники у Бога (1Кор.3:9)
Ибо мы Христово благоухание Богу (2Кор.2:15)
Ибо Сам Отец любит вас (Иоан.16:27)
Ибо слово о кресте... - сила Божия (1Кор.1:18)
Идите и присоединитесь к Господу (Иер.50:5)
Из уст Моих исходит правда, слово неизменное (Ис.45:23)
Иисус... всегда жив, чтобы ходатайствовать  (Евр.7:22,25)
Илия был человек, подобный нам (Иак.5:17)
Имея такие обетования, очистим себя (2Кор.7:1)
Имя Господа - крепкая башня (Прит.18:10)
Исполнились все Духа Святого (Деян.2:4)
Исполняющий волю Божию пребывает вовек (1Иоан.2:17)
Истина Его в род и род (Пс.99:5)
Истина Твоя до облаков (Пс.35:6)
Итак, дети, пребывайте в Нем (1Иоан.2:28)
Ищущие меня найдут меня (Прит.8:17)
К Тебе прилепилась душа моя (Пс.62:9)
К тебе, Господи, взываю (Иоил.1:19)
Каждый получит свою награду по своему труду (1Кор.3:8)
Как величественно имя Твое по всей земле! (Пс.8:10)
Как возвышенны для меня помышления Твои (Пс.138:17)
Как непостижимы судьбы Его! (Рим.11:33)
Как пастырь Он будет пасти стадо свое (Ис.40:11)
Как прекрасны ноги благовествующих мир (Рим.10:15)
Когда я в страхе, на Тебя я уповаю (Пс.55:4)
Кого ты благословишь, тот благословен (Числ.22:6)
Который и утвердит вас до конца (1Кор.1:8)
Который отдал себя самого за грехи наши (Гал.1:4)
Кровь Иисуса Христа, Сына Его, очищает нас от всякого греха (1Иоан.1:7)
Кто во Христе, тот новая тварь (2Кор.5:17)
Кто войдет Мною, тот спасется (Иоан.10:9)
Кто жаждет, иди ко Мне и пей (Иоан.7:37)
Кто же верный и благоразумный раб? (Мат.24:45)
Кто любит Бога, тому дано знание от Него (1Кор.8:3)
Кто мне служит. Мне да последует (Иоан.12:26)
Кто обращал взор к Нему, те просвещались (Пс.33:6)
Кто последует за мною... будет иметь свет жизни (Иоан.8:12)
Кто сеет щедро, тот щедро и пожнет (2Кор.9:6)
Кто ходит непорочно, тот будет невредим (Прит.28:18)
Кто... может сделать несравненно больше...Тому слава (Еф.3:20,21)
Лучше уповать на Господа (Пс.117:8)
Любовь Божия излилась в сердца наши Духом Святым (Рим.5:5)
Любовь Божия к нам открылась (1Иоан.4:9)
Притом знаем, что любящим Бога.. все содействует ко благу (Рим.8:28)
Милосердый будет благословляем (Прит.22:9)
Милость Моя не отступит от тебя (Ис.54:10)
Милость превозносится над судом (Иак.2:13)
Милость Твоя возвеличивает меня (Пс.17:36)
Много может усиленная молитва праведного (Иак.5:16)
Может Господь дать тебе более сего (2Пар.25:9)
Молитва веры исцелит болящего (Иак.5:15)
Молитву праведников слышит (Прит.15:29)
Мрак сделаю светом пред ними (Ис.42:16)
Мы безумны Христа ради (1Кор.4:10)
Мы будем ходить во имя Господа Бога нашего (Мих.4:5)
Мы же, будучи сынами дня, да трезвимся (1Фес.5:8)
Мы имеем от Бога жилище на небесах (2Кор.5:1)
Мы проповедуем Христа распятого (1Кор.1:23)
Мы ходим верою, а не видением (2Кор.5:7)
На всю жизнь благоволение Его (Пс.29:6)
На Господа уповаю (Пс.10:1)
На Него уповало сердце мое, и Он помог мне (Пс.27:7)
На помощь Твою надеюсь, Господи (Быт.49:18)
Над народом Твоим благословение Твое (Пс.3:9)
Напишу на Нем... имя Мое новое (Отк.3:12)
Направь меня на путь вечный (Пс.138:24)
Нарекут имя Ему... Бог крепкий (Ис.9:6)
Народ мой будет жить в обители мира (Ис.32:18)
Наступает день Господень (Зах.14:1)
Наступил уже час пробудиться нам от сна (Рим.13:11)
Научи меня  Господи, пути Твоему (Пс.26:11)
Научи меня исполнять волю Твою, потому что Ты - Бог мой (Пс.142:10)
Научит Он нас своим путям (Ис.2:3)
Научитесь делать добро (Ис.1:17)
Наше общение - с Отцем и Сыном Его, Иисусом Христом (1Иоан.1:3)
Не бойся, Я помогаю тебе (Ис.41:13)
Не бойтесь; да укрепятся руки ваши! (Зах.8:13)
Не дорожу своею жизнью (Деян.20:24)
Не забывай всех благодеяний Его (Пс.102:2)
Не знавшего греха Он сделал для нас жертвою за грех (2Кор.5:21)
Не медлит Господь исполнением обетования (2Пет.3:9)
Не навсегда забыт будет нищий (Пс.9:19)
Не оскорбляйте Святого Духа Божия (Еф.4:30)
Не поможет богатство в день гнева (Прит.11:4)
Не судите да не судимы будете (Мат.7:1)
Не хлебом одним будет жить человек (Мат.4:4)
Нет, мы Господу будем служить (Иис.Н.24:21)
Неужели снова не оживишь нас? (Пс.84:7)
Но всегда ищите добра... (1Феc.5:15)
Но если и страдаете за правду, то вы блаженны (1Пет.3:14)
Но когда он... взыщет Его, Он даст им найти Себя (2Пар.15:4)
Но потому, что любит вас Господь (Втор.7:8)
Но сокровище сие мы носим в глиняных сосудах (2Кор.4:7)
Но Ты, Господи, не удаляйся от меня (Пс.21:20)
Но Христос воскрес из мертвых (1Кор.15:20)
Ной же обрел благодать пред очами Господа (Быт.6:8)
О, бездна богатства и премудрости и ведения Божия! (Рим.11:33)
Об имени Твоем радуются весь день (Пс.88:17)
Облекитесь в Господа нашего Иисуса Христа (Рим.13:14)
Облекитесь в Господа нашего Иисуса Христа (Рим.13:14)
Облекитесь во всеоружие Божие (Еф.6:10)
Облечемся в оружия света (Рим.13:12)
Обратись ко Мне, ибо Я искупил тебя (Ис.44:22)
Общник я всем боящимся Тебя (Пс.118:63)
Один Господь у всех, богатый для всех призывающих Его (Рим.10:12)
Однако страданиями навык послушанию (Евр.5:8)
Ожидание праведников - радость (Прит.10:28)
Ожидая милости от Господа нашего Иисуса Христа (Иуда 21)
Он грехи наши Сам вознес телом Своим на древо (1Пет.2:24)
Он действовал от всего сердца своего, и имел успех (2Пар.31:21)
Он есть Ходатай нового завета (Евр.9:15)
Он избавит Израиля от всех беззаконий его (Пс.129:8)
Он избавит нищего, вопиющего (Пс.71:12)
Он насытил душу жаждущую (Пс.106:9)
Он не стыдится называть их братиями (Евр.2:11)
Он... водит меня к водам тихим (Пс.22:2)
Они непорочные пред престолом Божиим (Отк.14:5)
Они погибнут, а Ты пребудешь (Пс.101:27)
Они ходят во свете лица Твоего, Господи (Пс.88:16)
Они... убелили одежды свои кровию Агнца (Отк.7:14)
Оправдавшись верою, мы имеем мир с Богом (Рим.5:1)
Оставаясь на месте и в покое, вы спаслись бы (Ис.30:15)
От тайных моих очисти меня (Пс.18:13)
Отвсюду притесняемы, но не стеснены (2Кор.4:8)
Отец послал Сына Спасителем миру (1Иоан.4:14)
Откровение слов Твоих просвещает (Пс.118:130)
Очи Господа обращены к праведным (1Пет.3:12)
Пасха наша, Христос, заклан за нас (1Кор.5:7)
Пищу его благословляя благословлю (Пс.131:15)
По милости Твоей вспомни меня Ты (Пс.24:7)
Побеждающий наследует все (Отк.21:7)
Подвигом добрым я подвизался (2Тим.4:7)
Поддержи меня, и спасусь (Пс.118:117)
Познал Господь Своих (2Тим.2:19)
Поклонитесь Господу во благолепии (Пс.95:9)
Покоритесь Богу, противостаньте диаволу (Иак.4:7)
Полна милосердия и добрых плодов (Иак.3:17)
Полнота радостей пред  лицем Твоим (Пс.15:11)
Положите сии слова Мои в сердце ваше и в душу вашу (Втор.11:18)
Помощь наша - в имени Господа (Пс.123:8)
Помяни меня, Боже мой, во благо мне (Неем.13:31)
Послушай гласа Господа (Иер.38:20)
Поступающий по правде идет к свету (Иоан.3:21)
Пошли свет твой и истину Твою (Пс.42:3)
Предай Господу путь твой (Пс.36:5)
Предоставь Господу, и Он сохранит тебя (Прит.20:22)
Преподобные Твои да насладятся благами (2Пар.6:41)
Претерпевший же до конца спасется (Мат.24:13)
Прибежище мое и защита моя (Пс.90:2)
Приблизьтесь к Богу, и приблизится к вам (Иак.4:8)
Приду опять и возьму вас к Себе (Иоан.14:3)
Приклони, Боже мой, ухо Твое и услыши (Дан.9:18)
Примиритесь с Богом (2Кор.5:20)
Приму вас, как благовонное курение (Иез.20:41)
Приходящий ко Мне не будет алкать (Иоан.6:35)
Пришествие Господне приближается (Иак.5:8)
Пробьются воды в пустыне и в степи потоки (Ис.35:6)
Прославляйте Бога и в телах ваших и в душах ваших (1Кор.6:20)
Прощены вам грехи ради имени Его (1Иоан.2:12)
Ради имени Твоего води меня и управляй мною (Пс.30:4)
Радость пред Богом - подкрепление для вас (Неем.8:10)
Радуйтесь, усовершайтесь, утешайтесь (2Кор.13:11)
Разве не знаете, что вы храм Божий (1Кор.3:16)
Разумный воздержен в словах своих (Прит.17:27)
Ранами Его вы исцелились (1Пет.2:24)
Расспросите о путях древних, где путь добрый, и идите по нему (Иер.6:16)
Рожденный от Бога, побеждает мир (1Иоан.5:4)
Сам же Господь мира да даст вам мир всегда (2Фес.3:16)
Свят, свят, свят Господь Бог Вседержитель (Отк.4:8)
Свят, свят, свят Господь Саваоф (Ис.6:3)
Се, Царь твой грядет к тебе (Мат.21:5)
Сей Иисус... приидет таким же образом (Деян.1:11)
Сей... может всегда спасать... (Евр.7:24-25)
Сила Моя совершается в немощи (2Кор.12:9)
Слово ваше да будет всегда с благодатию (Кол.4:6)
Слово Господне пребывает вовек (1Пет.1:25)
Слово Твое - светильник ноге моей (Пс.118:105)
Смиренным дает благодать (Иак.4:6)
Смиритесь пред Господом (Иак.4:10)
Смотрите, какую любовь дал нам Отец (1Иоан.3:1)
Совершая святыню в страхе Божием (2Кор.7:1)
Соединяющийся с Господом есть один дух с Господом (1Кор.6:17)
Сохраняйте себя в любви Божией (Иуда 21)
Спасшего нас и призвавшего званием святым (2Тим.1:9)
Способность наша от Бога (2Кор.3:5)
Старайтесь иметь мир со всеми и святость (Евр.12:14)
Стоите в одном духе... единодушно... (Фил.1:27)
Стопы святых Своих Он блюдет (1Цар.2:9)
Странники и пришельцы на земле (Евр.11:13)
Страх Господень - источник жизни (Прит.14:27)
Страх Господень есть истинная премудрость (Иов 28:28)
Сын мой! храни слова мои (Прит.7:1)
Тайна Господня - боящимся Его (Пс.24:14)
Так бегите, чтобы получить (1Кор.9:24)
Так да светит свет ваш пред людьми (Мат.5:16)
Так и нам ходить в обновленной жизни (Рим.6:4)
Также и Дух подкрепляет нас в немощах наших (Рим.8:26)
Тению руки Моей покрою тебя (Ис.51:16)
Только бойтесь Господа и служите Ему истинно (1Цар.12:24)
Только Господа, Бога вашего, чтите (4Цар.17:39)
Тот, Кто в вас, больше того, кто в мире (1Иоан.4:4)
Трости надломленной не переломит (Мат.12:20)
Ты будешь, как напоенный водою сад (Ис.58:11)
Ты выздоровел; не греши больше (Иоан.5:14)
Ты испытуешь сердца... праведный Боже! (Пс.7:10)
Ты, Господи, благ и милосерд и многомилостив... (Пс.85:5)
Тьма проходит и истинный свет уже светит (1Иоан.2:8)
У Господа спасение (Иона.2:10)
Увещевая пребывать в вере (Деян.14:22)
Увидят это страждущие, и возрадуются (Пс.68:33)
Умереть уже не могут... будучи сынами воскресения (Лук.20:36)
Умножается Христом... утешение наше (2Кор.1:5)
Уповаю на милость Божию во веки веков (Пс.51:10)
Устами исповедуют ко спасению (Рим.10:10)
Утверди слово Твое рабу Твоему (Пс.118:38)
Храм Божий свят, а этот храм - вы (1Кор.3:17)
Хранить себя неоскверненным от мира (Иак.1:27)
Царство Божие не в слове, а в силе (1Кор.4:20)
Что Ему угодно, то да сотворит (1Цар.3:18)
Что Он умер, то умер однажды для греха (Рим.6:10)
Что хотите, чтобы Я сделал вам? (Мар.10:36)
Чтобы вы исполнялись познанием воли Его (Кол.1:9)
Чтобы радость ваша была совершенна (1Иоан.1:4)
Чтобы ты здравствовал и преуспевал во всем (3Иоан.2)
Я буду искать лица Твоего, Господи (Пс.26:8)
Я буду... уповать на Бога спасения моего (Мих.7:7)
Я дал вам пример, чтоб и вы делали то же, что Я сделал вам (Иоан.13:15)
Я есмь Лоза, а вы ветви (Иоан.15:5)
Я же воззову к Богу (Пс.54:17)
Я желаю исполнить волю Твою, Боже мой (Пс.39:9)
Я исполнен силы Духа Господня (Мих.3:8)
Я милости хочу, а не жертвы (Ос.6:6)
Я не стыжусь благовествования Христова (Рим.1:16)
Я посреди вас, как служащий (Лук.22:27)
Я проведу пред тобою всю славу Мою (Исх.ЗЗ:19)
Я с тобою, чтобы спасать и избавлять тебя (Иер.15:20)
Я Сам изглаживаю преступления твои (Ис.43:25)
Я свет миру (Иоан.9:5)
Я твой щит; награда твоя весьма велика (Быт.15:1)
Я увидел страдание народа Моего (Исх.3:7)
Я укажу тебе, что делать тебе (1Цар.16:3)
Я, Бог Израилев, не оставлю их (Ис.41:17)
Я, Господь, проникаю сердце (Иер.17:10)
А без веры угодить Богу невозможно (Евр.11:6)
А ты пребывай в том, чему научен (2Тим.3:14)
Благодаря Бога.. избавившего нас от власти тьмы.. (Кол.1:13)
Благодатью вы спасены (Еф.2:5)
Блажен бодрствующий и хранящий одежду свою (Отк.16:15)
Блажен соблюдающий слова пророчества книги сей (Отк.22:7)
Бог определил нас не на гнев, но к получению спасения (1Феc.5:9)
Бог послал в сердца ваши Духа Сына Своего (Гал.4:6)
Будем твердо держаться исповедания нашего (Евр.4:14)
Будь верен до смерти, и дам тебе венец жизни (Отк.2:10)
Будьте дружелюбны (Кол.3:15)
Будьте постоянны в молитве (Кол.4:2)
Великая благочестия тайна: Бог явился во плоти (1Тим.3:16)
Велики и чудны дела Твои, Господи Боже Вседержитель! (Отк.15:3)
Великое приобретение - быть благочестивым и довольным (1Тим.6:6)
Вера же есть осуществление ожидаемого и уверенность в невидимом (Евр.11:1)
Вера, действующая любовью (Гал.5:6)
Верен Господь, Который утвердит вас и сохранит от лукавого (2Феc.3:3)
Вложу законы Мои в мысли их, и напишу их на сердцах их (Евр.8:10)
Вникай в себя и в учение; занимайся сим постоянно (1Тим.4:16)
Во всем показывай в себе образец добрых дел (Тит.2:7)
Все вы сыны Божии по вере во Христа Иисуса (Гал.3:26)
Все делайте во имя Господа Иисуса Христа (Кол.3:17)
Все испытывайте, хорошего держитесь (1Феc.5:21)
Все могу в укрепляющем меня Иисусе Христе (Фил.4:13)
Все почитаю за сор, чтобы приобрести Христа  (Фил.3:8)
Все почитаю тщетою ради превосходства познания Христа Иисуса (Фил.3:8)
Всегда радуйтесь (1Феc.5:16)
Вы еще не до крови сражались, подвизаясь против греха (Евр.12:4)
Господь близко (Фил.4:5)
Да владычествует в сердцах ваших мир Божий (Кол.3:15)
Да приступаем с дерзновением к престолу благодати (Евр.4:16)
Дела Его были совершены еще в начале мира (Евр.4:3)
Делая добро, да не унываем (Гал.6:9)
Держи, что имеешь, дабы кто не восхитил венца твоего (Отк.3:11)
Для меня жизнь - Христос, и смерть - приобретение (Фил.1:21)
Жаждущий пусть приходит, и желающий пусть берет воду жизни даром (Отк.22:17)
Живите достойно благовествования Христова (Фил.1:27)
За все благодарите (1Феc.5:18)
За претерпение смерти увенчан славою и честью Иисус (Евр.2:9)
Запечатлены обетованным Святым Духом (Еф.1:13)
И вы имеете полноту в Нем (Кол.2:10)
И уже не я живу, но живет во мне Христос (Гал.2:20)
Ибо воля Божия есть освящение ваше (1Феc.4:3)
Ибо все вы - сыны света и сыны дня (1Феc.5:5)
Ибо дал нам Бог духа не боязни, но силы и любви и целомудрия (2Тим.1:7)
Ибо не имеем здесь постоянного града, но ищем будущего (Евр.13:14)
Ибо призвал нас Бог не к нечистоте, но к святости (1Феc.4:7)
Ибо слово Божие живо и действенно (Евр.4:12)
Ибо так возлюбил Бог мир, что отдал Cына Своего (Ин.3:16)
Ибо я знаю, в Кого уверовал.. (2Тим.1:12)
Ибо явилась благодать Божия, спасительная для всех человеков (Тит.2:11)
Иисус Христос вчера и сегодня и во веки Тот же (Евр.13:8)
Имея пропитание и одежду, будем довольны тем (1Тим.6:8)
Исполняйтесь Духом (Еф.5:18)
Как безмерно величие могущества Его в нас (Еф.1:19)
Какое богатство славного наследия Его для святых (Еф.1:18)
Когда услышите глас Его, не ожесточите сердец ваших (Евр.3:7-8)
Кого Я люблю, тех обличаю и наказываю (Отк.3:19)
Любовью служите друг другу (Гал.5:13)
Молитесь во всякое время духом (Еф.6:18)
Мы имеем искупление Кровию Его, прощение грехов (Еф.1:7)
Мы сделались причастниками Христу (Евр.3:14)
Наставляйте друг друга каждый день (Евр.3:13)
Не будем оставлять собрания своего (Евр.10:25)
Не будем спать, как и прочие, но будем бодрствовать и трезвиться (1Феc.5:6)
Не заботьтесь ни о чем (Фил.4:6)
Не неради о пребывающем в тебе даровании (1Тим.4:14)
Непрестанно молитесь (1Феc.5:17)
О горнем помышляйте, а не о земном (Кол.3:2)
Он спас нас не по делам праведности,.. а по Своей милости (Тит.3:5)
Они победили его кровию Агнца и словом свидетельства своего (Отк.12:11)
Оставив начатки учения Христова, поспешим к совершенству (Евр.6:1)
Отдал Себя Самого за грехи наши (Гал.1:4)
Открывайте свои желания пред Богом (Фил.4:6)
Плод же духа: любовь, радость, мир.. (Гал.5:22)
Побеждающему дам вкушать от древа жизни (Отк.2:7)
Побеждающему дам сесть со Мною на престоле Моем (Отк.3:21)
Подвизайся добрым подвигом веры, держись вечной жизни (1Тим.6:12)
Подражайте Богу, как чада возлюбленные (Еф.5:1)
Познавайте, что есть воля Божия (Еф.5:17)
Помыслите о Претерпевшем такое над Собою поругание от грешников (Евр.12:3)
Поступайте по духу (Гал.5:16)
Поступайте, как чада света (Еф.5:8)
Праведный верою жив будет (Рим.1:17)
Преуспевай в правде, благочестии, вере, любви, терпении, кротости (1Тим.6:11)
Проповедуй слово, настой во время и не во время (2Тим.4:2)
Радуйтесь всегда в Господе; и еще говорю: радуйтесь (Фил.4:4)
С терпением будем проходить предлежащее нам поприще (Евр.12:1)
Святый да освящается еще (Отк.22:11)
Се, гряду скоро (Отк.3:11)
Слово ваше да будет всегда с благодатию, приправлено солью (Кол.4:6)
Слово Христово да вселяется в вас обильно (Кол.3:16)
Стойте в свободе, которую даровал нам Христос (Гал.5:1)
Те, которые Христовы, распяли плоть (Гал.5:24)
Терпение нужно вам, чтобы, исполнив волю Божию, получить обещанное (Евр.10:36)
Укрепите опустившиеся руки и ослабевшие колени (Евр.12:12)
Укрепляйся, сын мой, в благодати Христом Иисусом (2Тим.2:1)
Укрепляйтесь Господом и могуществом силы Его (Еф.6:10)
Уповаем на Бога живoго, Который есть Спаситель всех человеков (1Тим.4:10)
Храни добрый залог Духом Святым, живущим в нас (2Тим.1:14)
Христос в вас, упование славы (Кол.1:27)
Христос возлюбил нас и предал Себя за нас (Еф.5:2)
Христос Иисус пришел в мир спасти грешников (1Тим.1:15)
Я есмь Альфа и Омега, начало и конец, говорит Господь (Отк.1:8)
Я отворил перед тобою дверь, и никто не может затворить ее (Отк.3:8)';
	}
	
	
	$text = str_replace("\r", "", $text);
	$text = str_replace("\n\n", "\n", $text);
	
	$text = explode("\n", $text); // массив строк
	
	if ($arg['once_daily'] == 'day') // вывод раз в сутки
	{
		$d = date('d') + 1; // текущее число + 1
		if ($d <= sizeof($text)) $out = $text[$d];
			else $out = $text[sizeof($text)-1];
	}
	else // случайным образом
	{
		$out = trim($text[ mt_rand(0, count($text) - 1) ] );
	}
	
	return $arg['header'] . $arg['block_start'] . $out . $arg['block_end'];
}


# end file
