<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * RGaysin
 * (c) http://rgblog.ru/
 */

function seogen_autoload() 
{
	mso_hook_add('edit_page', 'seogen_page');
	mso_hook_add('new_page', 'seogen_page');
}

# функция выполняется при деинсталяции плагина
function seogen_uninstall($args = array())
{
	// константа
	$options_key = 'plugin_seogen';
	mso_delete_option($options_key,'plugins');
	return $args;
}

# функция отрабатывающая миниопции плагина (function плагин_mso_options)
function seogen_mso_options() 
{
	global $blackList_def;
	# ключ, тип, ключи массива
	mso_admin_plugin_options('plugin_seogen', 'plugins', 
		array(
			'top1' => array(
							'type' => 'info', 
							'title' => 'Заголовок', 
						),
			'titletype' => array(
							'type' => 'select', 
							'name' => 'Тип заголовка', 
							'description' => 'Выберите тип построения мета заголовка',
							'values' => '0||Заголовок+Название # 1||Название+заголовок # 2||Только заголовок',
							'default' => '0'
								
						),
			'nsite' => array(
							'type' => 'text', 
							'name' => 'Добавочный заголовок', 
							'description' => 'Добавляемый заголовок в meta title, вместо названия сайта', 
							'default' => getinfo('name_site')
						),	
			'sep' => array(
							'type' => 'text', 
							'name' => 'Разделитель', 
							'description' => 'Разделитель между заголовком и добавочный заголовком', 
							'default' => '|'
						),	
			'top2' => array(
							'type' => 'info', 
							'title' => 'Описание', 
						),
			'thelength' => array(
							'type' => 'text', 
							'name' => 'Длина описания', 
							'description' => 'Длина обрезки текста для мета-тега description', 
							'default' => '300'
						),
			'top3' => array(
							'type' => 'info', 
							'title' => 'Ключевые слова', 
						),
			'count' => array(
							'type' => 'text', 
							'name' => 'Количество ключевых слов', 
							'description' => 'Укажите максимальное количество ключевых слов', 
							'default' => '20'
						),
			'minlength' => array(
							'type' => 'text', 
							'name' => 'Длина слова', 
							'description' => 'Минимальная длина ключевого слова', 
							'default' => '4'
						),
			'usetitle' => array(
							'type' => 'select', 
							'name' => 'Использовать заголовок', 
							'description' => 'Использовать заголовок при создании ключевых слов',
							'values' => '0||Нет # 1||Да',
							'default' => '1'
								
						),
			'staticwords' => array(
							'type' => 'textarea', 
							'name' => 'Постоянные слова', 
							'description' => 'Список постоянных ключевых слов', 
							'rows' => 2,
							'default' => ''
						),
			'blacklist' => array(
							'type' => 'textarea', 
							'name' => 'Black List', 
							'description' => 'Список запрещенных слов', 
							'default' => blacklist(),
							'rows' => 6
						),
		),
		'Настройка плагина "СЕО Генератор"', // титул
		'Укажите необходимые опции.'   // инфо
	);
}

function cleanText( $str ) {
	$str = preg_replace( "'<script[^>]*>.*?</script>'si", '', $str );
	$str = preg_replace( '/<!--.+?-->/', '', $str );
	$str = preg_replace( '/{.+?}/', '', $str );
	$str = preg_replace( '/\[image.+?\]http.+?\[\/image\]/', '', $str );
	$str = preg_replace( '/\[.+?\]/', '', $str );
	$str = preg_replace('/<[^>]*>/', ' ', $str);	

	// convert html entities to chars (with conditional for PHP4 users
	if(( version_compare( phpversion(), '5.0' ) < 0 )) {
		require_once(JPATH_SITE.DS.'libraries'.DS.'tcpdf'.DS.'html_entity_decode_php4.php');
		$str = html_entity_decode_php4($str,ENT_QUOTES,'UTF-8');
	}else{
		$str = html_entity_decode($str,ENT_QUOTES,'UTF-8');
	}
		$str = strip_tags( $str );

       $str = str_replace('"', '\'', $str);
       $str = str_replace(array("\r\n", "\r", "\n", "\t"), " ", $str);
	while (strchr($str,"  ")) {
		$str = str_replace("  ", " ",$str);
	}
	for ($cnt = 1; $cnt < strlen($str)-1; $cnt++) {
		if ( ($str{$cnt} == '.') || (($str{$cnt} == ',') && !(is_numeric($str{$cnt+1})))) {
			if ($str{$cnt+1} != ' ') {
				$str = substr_replace($str, ' ', $cnt + 1, 0);
			}
		}
	}
	return $str;
}

function seogenkey($keys, $blackList, $count, $minLength) {
	$keywords ='';

	$keys = preg_replace('/[\.;:!?|\'|\"|\`|\,|\(|\)|\-]/', ' ', $keys);	
	$keysArray = explode(" ", $keys);
	$keysArray = array_count_values(array_map('mb_strtolower', $keysArray));
  
	$blackArray = explode(",", $blackList);
	
	foreach($blackArray as $blackWord)
	{
		if(isset($keysArray[trim($blackWord)]))
		unset($keysArray[trim($blackWord)]);
	}

	arsort($keysArray);
	
	$i = 1;
	
	foreach($keysArray as $word=>$instances)
	{
		if($i > $count)	break;
		if(mb_strlen(trim($word)) >= $minLength ) {
			$keywords .= $word . ", ";
			$i++;
		}
	}
	
	$keywords = rtrim($keywords, ", ");
	return($keywords);
}	

function blacklist()
{
	return 'благодарю, благодаря, близко, более, более-менее, большая, больше, большие, больших, большое, большой, большой, большую, будем, будет, будешь, буду, будут, будучи, будь, будьте, была, были, было, быстро, быть, важно, вами, ваше, вашего, вашей, вашем, вашему, ваши, вашим, вашими, ваших, ваших, вашу, вблизи, ведь, везде, великолепно, весь, весьма, вида, виде, виду, вместе, вместо, внутри, внутрь, возле, вокруг, вообще, восемь, восмерых, восмью, восьмеро, восьмерым, восьмерыми, восьми, восьмого, восьмой, восьмом, восьмому, восьмым, восьмых, вперед, вполне, временами, временем, времени, время, всевозможным, всегда, всего, всей, всем, всеми, всему, всё-таки, всех, всею, вследствие, всяк, всякая, всякие, всякий, всяким, всякими, всяких, всякого, всякое, всякой, всяком, всякому, всякую, второго, второй, втором, второму, вторым, выглядит, выглядят, высшие, вышла, горазд, гораздо, гран, давал, давали, даже, далее, далеко, данном, даются, двоих, двум, двумя, двух, девятеро, девяти, девятом, девятому, девятый, девятым, девятыми, девятых, девять, девятью, действительно, день, десятеро, десятерых, десяти, десятом, десятый, десятым, десятых, десять, дней, днем, дням, днями, днях, должно, должны, дома, доме, домом, дому, другими, других, если, есть, жабе, зависящей, зависящие, затем, затем-то, захотел, захотела, захотели, захочу, зачем, зачем-то, здесь, знает, знаешь, знал, знала, знали, знало, знать, значит, значительно, знаю, из-под, именно, имхо, иначе, иногда, искал, искала, искали, искало, искать, итак, каждые, каждый, какая, какие, каким, каких, какого, какое, какой, каком, какому, какую, когда, когда-нибудь, кого, кому, которая, которого, которое, которой, котором, которому, которою, которую, которые, который, которым, которыми, которых, кроме, кстати, кто-то, куда, легко, либо, личной, лучшая, лучше, лучшее, лучшие, лучший, любая, любого, любое, любой, любом, любому, любую, любые, любым, любыми, любых, маленькая, маленький, маленьким, маленького, маленькое, маленькой, маленьком, маленькому, маленькую, малых, между, мелко, менее, меньше, меня, минимум, многие, многими, много, многократные, мной, мною, моги, могите, могла, могли, могло, могу, могут, моего, моей, моем, моему, моею, можем, может, можете, можешь, можно, моим, моими, моих, мочь, надо, назад, наиболее, наименее, наконец, нами, напишет, напишу, напишут, например, наша, наше, нашего, нашей, нашем, нашему, нашею, наши, нашим, нашими, наших, нашу, невозможность, него, недавно, нежели, некоторые, нельзя, немного, нему, необыкновенно, непосредственно, несколько, неужели, никогда, никто, ними, ничего, ничто, новая, нового, новое, новой, новом, новому, новостей, новости, новость, новостями, новую, новый, новым, новых, нужен, нужно, нужны, образом, обратно, один, одинаково, одинаковый, одна, однако, одни, одним, одними, одних, одно, одного, одной, одному, одною, одну, около, окуда, основной, основным, особенно, особливо, ответ, ответил, ответила, ответили, ответило, отдельных, отнюдь, отчего, очевидно, очень, первое, первом, перед, петеро, писал, писала, писали, писало, пишет, пишу, пишут, плохо, поблизости, пожалуйста, пока, получала, получали, получало, получать, получил, получила, получили, получило, получить, полчаса, пора, порам, порами, поре, порой, пору, поры, посему, после, после, постепенно, потом, потому, почему, почти, пошли, поэтому, правда, правой, пред, прежде, примерно, просто, против, прошел, прошла, прошли, прошло, пускай, пусть, пятером, пятерых, пятом, пятому, пятый, пятым, пятыми, пятых, пять, равным, раза, разве, разных, реже, сама, сами, самим, самими, самих, само, самого, самое, самой, самом, самому, самоя, саму, самую, самые, самый, самым, самыми, самых, сверх, свое, своего, своей, своем, своему, своею, свои, своим, своими, своих, свой, свою, своя, сделайте, сделал, сделала, сделали, сделало, себе, себя, сегодня, седьмому, седьмым, седьмыми, седьмых, сейчас, семеро, семерых, семи, семь, сильнее, сильно, сильного, сильное, сильной, сквозь, сколько, скорее, скоро, скруп, случае, случаем, случай, случайно, случаю, случая, смотря, снаружи, снова, собой, собою, совсем, спасибо, старая, старого, старое, старой, старом, старому, старую, старый, старым, старых, стороне, сторону, такая, также, такие, таким, такими, таких, такого, такое, такой, таком, такому, такою, твое, твоего, твои, твой, твою, твоя, тебе, тебя, теми, теперь, тобой, тобою, тогда, того, тоже, только, тому, трем, тремя, третий, третьим, третьими, третьих, трех, троим, троими, троих, трудно, туда, ужасно, узнает, узнают, ушел, ушла, ушли, ушло, ходил, ходила, ходили, ходило, ходит, ходить, ходят, хорошо, хотел, хотела, хотели, хотело, хоть, хотя, хочу, часа, часов, частей, части, часто, частью, чаще, чего, чего, чем-то, чему, червертых, через, четвертом, четвертому, четвертый, четвертым, четвертыми, четверть, четыре, чисто, чрезвычайно, чтоб, чтобы, чьей, чьему, чьим, чьими, чьих, шестеро, шестеры, шестого, шестой, шестому, шестым, шестыми, шесть, шестью, этим, этим, этими, этих, этого, этой, этом, этому, этот, является, являются';
}

function seogen_page($args)
{
	global $blackList_def;
	$options = mso_get_option('plugin_seogen', 'plugins', array() ); // получаем опции
	if (!isset($options['count'])) { $count = 20; } else { $count = $options['count']; }
	if (!isset($options['minlength'])) { $minLength = 4; } else { $minLength = $options['minlength']; }
	if (!isset($options['thelength'])) { $thelength = 300; } else { $thelength = $options['thelength']; }
	if (!isset($options['sep'])) { $sep = '|'; } else { $sep = $options['sep']; }
	if (!isset($options['titletype'])) { $title_type = 0; } else { $title_type = $options['titletype']; }
	if (!isset($options['usetitle'])) { $use_title = 1; } else { $use_title = $options['usetitle']; }
	if (!isset($options['nsite'])) { $nsite = getinfo('name_site'); } else { $nsite = $options['nsite']; }
	if (!isset($options['statickeywords'])) { $statickeywords = ''; } else { $statickeywords = $options['statickeywords']; }
	if (!isset($options['blackList'])) { $blackList = blacklist(); } else { $blackList = $options['blackList']; }
	$id = $args[0];
	$CI = & get_instance();
	//Получаем заголовок и контент страницы
	$CI->db->select('page_title, page_content');
	$CI->db->where(array('page_id'=>$id));
	$query = $CI->db->get('page');
	if ($query->num_rows()>0)
	{
		$rows = $query->result_array();
		$row = $rows[0];
		$ptitle = $row['page_title'];
		$pcontent = $row['page_content'];
	}
	//Получаем мета-теги страницы
	$CI->db->select('meta_key, meta_value');
	$CI->db->where(array('meta_id_obj'=>$id));
	$query = $CI->db->get('meta');
	if ($query->num_rows()>0)
	{
		$rows = $query->result_array();
		foreach ($rows as $row)
			$meta[$row['meta_key']] = $row['meta_value'];
	}
	
	$pcontent = CleanText($pcontent);

	if ((!isset($meta['description']))or(trim($meta['description'])==''))
	{
		$desc = $pcontent . ' ';
		$desc = substr($desc,0,$thelength);
		$desc = substr($desc,0,strrpos($desc,' '));
		mso_add_meta('description',$id,'page',$desc);
	}

	if ((!isset($meta['title']))or(trim($meta['title'])==''))
	{
		if ($title_type == 0):
			$newtitle = $ptitle . ' ' . $sep . ' ' . $nsite;
		elseif ($title_type == 1):
			$newtitle = $nsite . ' ' . $sep . ' ' . $ptitle;
		elseif ($title_type == 2):
			$newtitle = $ptitle;
		endif;
		mso_add_meta('title',$id,'page',$newtitle);
	}

	if ((!isset($meta['keywords']))or(trim($meta['keywords'])==''))
	{	
		CleanText($ptitle);
		if ($use_title == 0) { $keys = $pcontent; }
		else { $keys = $ptitle . ' ' . $pcontent; }
		$keywords = seogenkey($keys, $blackList, $count, $minLength);
		if ($statickeywords <> '') { $keywords = $statickeywords . ', '. $keywords; }
		mso_add_meta('keywords',$id,'page',$keywords);
	}
	return $args;
}


?>
