;(function($){
	var timer, exit_shown = false;
	$(document).ready(function(){
		if(check_cookie()){
			return false;
		}
		$(document).find('body').prepend(masterpopup.output);
		if(masterpopup.impression_count > 0){
			if(check_impressions()){
				return false;
			}
		}
		switch(masterpopup.show_opt){
			case 'mouseleave':
				$('body',document).mouseleave(show_lightbox);
				break;
			case 'unload':
				enable_unload();
				break;
			default:
				if(masterpopup.delay && masterpopup.delay > 0){
					timer = setTimeout(show_lightbox,(masterpopup.delay*1000));
				} else {
					show_lightbox();
				}
				break;
		}
			
		$('#closepopup').click(function(){
			close_box();
			return false;
		});
		
		$('#wrappopup form').submit(function(){
			var checked = true;
			$('#wrapmaster :text').each(function(){
				var $this = $(this), val = $this.val();
				if($this.data('default_value') && val == $this.data('default_value')){
					if(checked)
						$this.val('').focus();
					checked = false;
				}
				if(val == ''){
					checked = false;
				}
			});
			if(checked){
				close_box();
				return true;
			}
			return false;
		});
	});
	function enable_unload(){
		var oldunload = window.onbeforeunload, oldunload2 = window.onunload;
		if(typeof oldunload != 'function'){
			oldunload = null;
		}
		if(typeof oldunload2 != 'function'){
			oldunload2 = null;
		}
		window.onbeforeunload = function(e){ 
			if(exit_shown === false){
				e = e || window.event;
				exit_shown = true;
				$(document).focus(function(){ timer = setTimeout(show_lightbox,1000)});
				window.onunload = function(){
					close_box(false);
					if(oldunload2 !== null){
						window.onunload = oldunload2;
						return oldunload2();
					}
				}
				window.onbeforeunload = oldunload;
				if(e)
					e.returnValue = masterpopup.unload_msg;
				return masterpopup.unload_msg; 
			}
		};
	};
	
	function show_lightbox(){
		$(document).unbind('focus',show_lightbox);
		$('body',document).unbind('mouseleave',show_lightbox);
		if(!check_cookie()){
			max_zindex();
			$('#wrappopup').fadeIn('fast');
			center_it();
			$(window).resize(center_it);
		}
	};
	
	function center_it(){
		var styles = {
			position: 'absolute',
			left: ($(window).width() - $('#popupmaster').outerWidth())/2,
			top: ($(window).height() - $('#popupmaster').outerHeight())/2,
		};
		styles.left = styles.left < 0 ? 0 : styles.left;
		styles.top = styles.top < 0 ? 0 : styles.top;
		$('#popupmaster').css(styles);
	};
	
	function max_zindex(){
		var maxz = 0;
		$('body *').each(function(){
			var cur = parseInt($(this).css('z-index'));
			maxz = cur > maxz ? cur : maxz;
		});
		$('#wrappopup').css('z-index',maxz+10);
	};
	
	function close_box(fade){
		fade = fade === false ? false : true;
		var elem = $('#wrappopup');
		clearTimeout(timer);
		if(fade){
			elem.fadeOut('fast');
			if(masterpopup.cookie_time && masterpopup.cookie_time > 0){
				var date = new Date();
				date.setTime(date.getTime() + (masterpopup.cookie_time*86400*1000));
				set_cookie('masterpopup_hide_lightbox','Y',date);
			}
		} else {
			elem.hide();
		}
	};
	
	function set_cookie(name,value,date){
		window.document.cookie = [name+'='+escape(value),'expires='+date.toUTCString(),'path='+masterpopup.cookie_path].join('; ');
	};
	
	function check_cookie(){
		if(get_cookie('masterpopup_hide_lightbox') == 'Y')
			return true;
		return false;
	};
	
	function check_impressions(){
		var ic = 1, date = new Date();
		if(ic = get_cookie('masterpopup_icount')){
			ic = parseInt(ic);
			ic++;
			if(ic == masterpopup.impression_count){
				date.setTime(date.getTime());
				set_cookie('masterpopup_icount',masterpopup.impression_count,date);
				return false;
			}
		} else {
			ic = 1;
		}
		date.setTime(date.getTime() + (7200*1000));
		set_cookie('masterpopup_icount',ic,date);
		return true;
	};
	
	function get_cookie(cname){
		var cookie = window.document.cookie;
		if(cookie.length > 0){
			var c_start = cookie.indexOf(cname+'=');
			if(c_start !== -1){
				c_start = c_start + cname.length+1;
				var c_end = cookie.indexOf(';',c_start);
				if(c_end === -1)
					c_end = cookie.length;
				return unescape(cookie.substring(c_start,c_end));
			}
		}
		return false;
	};
})(jQuery);