<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 
 
$p = new Page_out; // подготавливаем объект для вывода записей

// $p->div('Последние записи', 'home-title-col');

if ($pages = mso_get_pages(array( 
			'limit' => 6, 
			'cut' => '...',
			'custom_type' => 'home',
			'get_page_categories' => false,
			'get_page_count_comments' => true,
			), $pagination))
{
	// формат записи
	$p->format('title', '<h4>', '</h4>');
	$p->format('date', 'd.m.Y', '<img src="' 
				. getinfo('template_url') 
				. 'images/date.png" width="16" height="16" title="' 
				. tf('Дата публикации') . '"> ', '');
	$p->format('comments', 'обсудить', 'комментариев', ' <img src="' 
				. getinfo('template_url') 
				. 'images/comments.png" width="16" height="16" title="' 
				. tf('коментарии') . '"> ', ''); 
	$p->format('read', '»»»');
	
	// вывод в виде сетки
	$p->box_grid(2); // 2 ячейки
	
	foreach ($pages as $page)
	{
		$p->load($page); // загружаем данные записи
		
		$p->box_grid_cell('home-cell'); // начало ячейки
			
			// адрес картинки записи в мета img_page_home
			// генерируем thumb
			if (
				$img = thumb_generate(
				$p->meta_val('img_page_home'), // адрес
				310, //ширина
				100, //высота
				getinfo('template_url') . 'images/placehold/310x100.png', // если нет
				'resize_full_crop_center', 
				mso_get_val('refresh_thumb')
				))
			{
				$img = '<img src="' . $img . '" alt="" title="' . htmlspecialchars($p->val('page_title')). '">';
				
				$p->html($img);
			}

			$p->line('[title]'); // заголовок
		
			$p->line('[date],  [comments]', '<p class="info">' , '</p>'); // дата
				
				/*	$p->line('', '<p class="comm"> ' , '</p>');*/

			$p->content_chars(250, $p->line('[read]', '... ', '', false));  // текст обрезанный
		
		$p->box_grid_next(); // конец ячейки
	}
	
	$p->box_grid_end(); // стоп вывода ячеек
	
	mso_hook('pagination', $pagination);
}
