<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

mso_cur_dir_lang('templates');

mso_head_meta('title', t('Все метки').' » ' . getinfo('name_site')); // meta title страницы
mso_head_meta('description', t('Все использованные на этом сайте метки')); // meta description страницы

# начальная часть шаблона
require(getinfo('template_dir') . 'main-start.php');

echo '<h1 class="category">'.t('Все метки').'</h1>';
echo '<p>'.t('Все используемые на сайте метки.').'</p>';
echo '<div>';

// возьмем настройки из первого виджета, если он был настроен
$options = mso_get_option('tagclouds_widget_0', 'plugins', array());
if ( !isset($options['min_size']) ) $options['min_size'] = 100;
	else $options['min_size'] = (int) $options['min_size'];
if ( !isset($options['max_size']) ) $options['max_size'] = 210;
	else $options['max_size'] = (int) $options['max_size'];

$options['format'] = '<a style="font-size: %SIZE%%" title="%COUNT% шт." href="%URL%">%TAG%</a>, ';

require_once( getinfo('common_dir') . 'meta.php' ); // функции мета
$tagcloud = mso_get_all_tags_page();
asort($tagcloud);
$min = reset($tagcloud);
$max = end($tagcloud);
if ($max == $min) $max++;

// сортировка перед выводом
arsort($tagcloud); // по количеству обратно
$url = getinfo('siteurl') . 'tag/';
$out = '';
foreach ($tagcloud as $tag => $count) 
{
	$font_size = round( (($count - $min)/($max - $min)) * ($options['max_size'] - $options['min_size']) + $options['min_size'] );
	$af = str_replace(array('%SIZE%', '%URL%', '%TAG%', '%COUNT%'), 
						array($font_size, $url . urlencode($tag), $tag, $count), $options['format']);
	$out .= $af;
}
if ($out) {
	echo '<p class="all-tags">';
	echo $out;
	echo '</p>';
}
echo '</div>';

# конечная часть шаблона
require(getinfo('template_dir') . 'main-end.php');
	
?>