<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

// упрощенная сборка меню шаблона, игнорирующая группировку
function mso_menu_build_mod($menu = '')
{
	# добавить ссылку на admin
	$menu = str_replace("[", "", $menu);
	$menu = str_replace("]", "", $menu);
	$menu = str_replace("_NR_", "\n", $menu);
	$menu = str_replace("\n\n\n\n", "\n", $menu);
	$menu = str_replace("\n\n\n", "\n", $menu);
	$menu = str_replace("\n\n", "\n", $menu);

	$menu = explode("\n", trim($menu));

	$http = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on") ? "https://" : "http://";
	$out = '';

	foreach ($menu as $elem) {
		$elem = explode('|', $elem);
		if (count($elem) > 1) {
			$url = trim($elem[0]);
			$name = trim($elem[1]);
			if (isset($elem[2])) $title = ' title="' . htmlspecialchars(trim($elem[2])) . '"';
			else $title = '';
			if (($url != '#') and strpos($url, $http) === false) {
				if ($url == '/') $url = getinfo('siteurl');
				else $url = getinfo('siteurl') . $url;
			}
			$out .= '<li><a href="' . $url . '"' . $title . '>' . $name . '</a></li>' . NR;
		}
	}
	
	return $out;
}

// получение последнего сообщения из твиттера
function twitter_last_msg($url = false)
{	
	if (!$url) return false; // вообще-то, этого не можт быть, но чем черт не шутит...
	
 	$cache_key = 'twitter_last_msg';
	$k = mso_get_cache($cache_key, true);
	if ($k) return $k;
	
	if (!defined('MAGPIE_CACHE_AGE')) define('MAGPIE_CACHE_AGE', 600); // время кэширования
	require_once(getinfo('common_dir') . 'magpierss/rss_fetch.inc');
	$rss = fetch_rss($url);
	$rss = array_slice($rss->items, 0, 1);
	$out = '';
	foreach ($rss as $item) { 
		$out .= '<span class="tt">%TITLE%<br><a class="ltp" href="%LINK%">%DATE%</a></span>';
		$item['title'] = preg_replace('|(\S+): |si', '\\2', $item['title']);
		$item['title'] = preg_replace('|(http:\/\/)(\S+)|si', '<a href="http://\\2" target="_blank">\\2</a>', $item['title']);
		$out = str_replace('%TITLE%', $item['title'], $out);
		$out = str_replace('%DATE%', date('d.m.Y (H:i)', (int) $item['date_timestamp']), $out);
		$out = str_replace('%LINK%', $item['link'], $out);
	}
	
	mso_add_cache($cache_key, $out, 600, true);

	return $out;
}

?>