<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

mso_cur_dir_lang('templates');

mso_head_meta('title', t('Все рубрики').' » ' . getinfo('name_site'));
mso_head_meta('description', 'Список рубрик сайта.');

# начальная часть шаблона
require(getinfo('template_dir') . 'main-start.php');

echo '<h1 class="category">'.t('Все рубрики').'</h1>';
echo '<p>'.t('Список рубрик этого сайта.').'</p>';
echo '<div class="type type_category_list">';

// получаем опции виджета, чтоб не было разногласий
$options = mso_get_option('category_widget_0', 'plugins', array() ); 
if ( !isset($options['include']) ) $options['include'] = array();
if ( !isset($options['exclude']) ) $options['exclude'] = array();
if ( !isset($options['format']) ) $options['format'] = '[LINK][TITLE]<sup>[COUNT]</sup>[/LINK]<br>[DESCR]';
if ( !isset($options['format_current']) ) $options['format_current'] = '<span>[TITLE]<sup>[COUNT]</sup></span><br/>[DESCR]';
if ( !isset($options['hide_empty']) ) $options['hide_empty'] = 0;
if ( !isset($options['order']) ) $options['order'] = 'category_name';
if ( !isset($options['order_asc']) ) $options['order_asc'] = 'ASC';
$options['include_child'] = 1;

// есть в кеше?
$cache_key = 'category_widget' . serialize($options) . '0';
$k = mso_get_cache($cache_key);
if ($k) $all = $k;
else {
	$all = mso_cat_array('page', 0, $options['order'], $options['order_asc'], $options['order'], $options['order_asc'], $options['include'], $options['exclude'], $options['include_child'], $options['hide_empty'], true);
	mso_add_cache($cache_key, $all);
}
//pr($all);
echo mso_create_list($all, array('childs'=>'childs', 'format'=>$options['format'], 'format_current'=>$options['format_current'], 'class_ul'=>'is_link', 'title'=>'category_name', 'link'=>'category_slug', 'current_id'=>false, 'prefix'=>'category/', 'count'=>'pages_count', 'slug'=>'category_slug', 'id'=>'category_id', 'menu_order'=>'category_menu_order', 'id_parent'=>'category_id_parent' ) );

echo '</div>';

# конечная часть шаблона
require(getinfo('template_dir') . 'main-end.php');

?>