<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

	$p = new Page_out; // подготавливаем объект для вывода записей
	
	if ($pages = mso_get_pages(array( 
				'limit' => 6, 
				'cut' => '...',
				'custom_type' => 'home',
				'get_page_categories' => false,
				'get_page_count_comments' => true,
				), $pagination))
	{

		// формат записи
		$p->format('title', '<h4>', '</h4>');
		$p->format('date', 'd/m/Y H:i');
		$p->format('read', 'Читать полностью »', '');
		$p->format('comments', tf('Обсудить'), tf('Читать все >>>'), '',  '');
		
		//echo '<div class="home-title-col">Последние записи</div>';		
		// вывод в виде сетки
		$p->box_grid(2); // 2 ячейки
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи

			$p->box_grid_cell('left'); // начало ячейки
			
			// адрес картинки записи в мета img_page_home
			// генерируем thumb
			if (
				$img = thumb_generate(
				$p->meta_val('image_for_page'), // адрес
				300, //ширина
				150, //высота
				getinfo('template_url') . 'images/placehold/300x150.png'
				))
			{
				$img = $p->page_url(true) . '<div class="shadow-inset"><img src="' . $img . '"class="home" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></div></a>';
				
				$p->html($img);
			}
			
		
			$p->line('[title]'); // заголовок
			$p->content_chars(190, '...');  // текст обрезанный
			//$p->content_words(27, ' ...');  // текст обрезанный
			
			$p->line('[read]','<p class="read">', '</p>');
			$p->line('[comments]','<p class="commenty">', '</p>');
			$p->box_grid_next(); // конец ячейки 
		}
		
	$p->box_grid_end(); // стоп вывода ячеек
	
	mso_hook('pagination', $pagination);
	}