<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

// одна колонка из заданных рубрик
// слева картинка, справа текст

function out_1col_cats_left($cats_id = '', $limit = 3)
{
	$p = new Page_out; // подготавливаем объект для вывода записей
	
	if ( $pages = mso_get_pages(array( 
				'limit' => $limit, 
				'cut' => '...',
				'custom_type' => 'home',
				'pagination' => false,
				'exclude_page_id' => mso_get_val('exclude_page_id'),
				'cat_id' => $cats_id,
				), $temp) )
	{
	
		$p->reset_counter(count($pages)); // сбросить счетчик
		
		$p->format('date', 'd-m-Y');
		$p->format('read', '»»»', ' ');
		$p->format('cat', ', ', ' | <span class="cat">', '</span>');
		
		$exclude_page_id = mso_get_val('exclude_page_id');
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи
			
			// иммитируем таблицу на основе box
			$p->box_start();
			
				// генерируем thumb
				if (
					$img = thumb_generate(
					$p->meta_val('image_for_page'), // адрес
					150, //ширина
					150, //высота
					getinfo('template_url') . 'images/placehold/150x150.png'
					))
				{
					$img = $p->page_url(true) . '<img src="' . $img . '" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></a>';
					$p->cell($img, 'cell-img');
				}
			
				$p->cell_start('cell-content');
					$p->line('[date] [cat]', '<p class="info">', '</p>'); // дата
					$p->title('<h4>', '</h3>');
					
					$p->div_start('page_content home_others_page_content');
						$p->content_chars(200, '... ', '', '');
						$p->line('[read]');
						$p->clearfix();
					$p->div_end('page_content home_others_page_content');
				$p->cell_end();
				
			
			$p->box_end();
			
			$p->div('', 'sep'); // пустой разделитель между записями
			
			
			$exclude_page_id[] = $p->val('page_id');
		}
		
		mso_set_val('exclude_page_id', $exclude_page_id);
		
	}
}

// формируем вывод


echo '<div class="home-1col-cats-left">';
	echo '<div class="home-title-col">Прочее</div>';
	
	out_1col_cats_left(mso_get_option('home_cats_id_other', 'templates', '4'), mso_get_option('home_cats_other_limit', 'templates', 3));
	
echo '</div>';


# end file