<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

// 2 ряда по 2 колонки
// в каждой колонке по одной рубрике _cat_last_pages

// название рубрики-ссылка
// картинка
// последняя запись рубрики
// список последних записей рубрики

// имя функции как out_файл
function out_2col_1cat($home_cats_id = '1', $limit = 6)
{
	$p = new Page_out;
	
	// по slug рубрики ищем изображение и формируем ссылку
	$cat_slug = mso_get_cat_from_id(mso_explode($home_cats_id), 'category_slug');
	
	
	$cat_name = $p->link(getinfo('site_url') . 'category/' . $cat_slug, mso_get_cat_from_id(mso_explode($home_cats_id), 'category_name'));
	
	if (mso_fe('images/category/' . $cat_slug . '.png'))
	{
		$cat_img = getinfo('template_url') . 'images/category/' . $cat_slug . '.png';
	}
	else
	{
		$cat_img = getinfo('template_url') . 'images/category/' . 'default.png';
	}
	
	$cat_name = $p->img($cat_img) . $cat_name;
	
	
	$p->div($cat_name, 'home-title-col');
	
	
	// получение и вывод записей
	
	if ($pages = mso_get_pages(array( 
				'limit' => $limit, 
				'cut' => '...',
				'custom_type' => 'home',
				'pagination' => false,
				'exclude_page_id' => mso_get_val('exclude_page_id'),
				'cat_id' => $home_cats_id,
				), $temp) )
	{
		$p->reset_counter(count($pages)); // сбросить счетчик
		
		$p->format('read', 'Читать полностью »', '');
		$p->format('date', 'd-m-Y');
		
		$exclude_page_id = mso_get_val('exclude_page_id');
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи

			if ($p->num == 1)
			{
			
				// адрес картинки записи в мета img_page_home
				// генерируем thumb
				if (
					$img = thumb_generate(
					$p->meta_val('image_for_page'), // адрес
					310, //ширина
					170, //высота
					getinfo('template_url') . 'images/placehold/310x170.png'
					))
				{
					$img = $p->page_url(true) . '<img src="' . $img . '" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></a>';
					
					$p->html($img);
				}
			
				$p->line('[date] | [comments]', '<p class="info">', '</p>');
				$p->title('<h4>', '</h4>');
				$p->content_chars(220, '...');
				$p->line('[read]', '<span class="cut">', '</span>');
			}
			else
			{
				if ($p->num == 2) 
				{
					$p->html('<hr>');
					$p->html('<p><b>Последние записи рубрики:</b></p>');
					$p->html('<ul>');
				}
				
				$p->title(NR . '<li>', '</li>');
				
				if ($p->last) $p->html('</ul>');
			}
			
			$exclude_page_id[] = $p->val('page_id');
		}
		
		mso_set_val('exclude_page_id', $exclude_page_id);
	}
	
} // out_2col_1cat()

// теперь сам вывод

echo '<div class="onerow home-2col-1cat">';
	echo '<div class="col w1-2">';
		out_2col_1cat(mso_get_option('home_cats_id_1', 'templates', '1'));
	echo '</div>';
		
	echo '<div class="col w1-2">';
		out_2col_1cat(mso_get_option('home_cats_id_2', 'templates', '2'));
	echo '</div>';
	
	echo '<div class="clearfix"></div>';
	
echo '</div>';


# end file