<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

// функция вывода последние записи сайта
// $limit - кол-во записей в одной колонке
function out_4col_last_pages($limit = 1)
{
	$p = new Page_out; // подготавливаем объект для вывода записей
	
	if ($pages = mso_get_pages(array( 
				'limit' => $limit, 
				'cut' => '...',
				'custom_type' => 'home',
				'pagination' => false,
				'get_page_categories' => false,
				'get_page_count_comments' => false,
				'exclude_page_id' => mso_get_val('exclude_page_id'),
				), $temp))
	{

		// формат записи
		$p->format('title', '<h4>', '</h4>');
		$p->format('date', 'd/m/Y H:i');
		$p->format('read', 'Читать полностью »', '');
		
		$exclude_page_id = mso_get_val('exclude_page_id');
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи
			
			// адрес картинки записи в мета img_page_home
			// генерируем thumb
			if (
				$img = thumb_generate(
				$p->meta_val('image_for_page'), // адрес
				198, //ширина
				100, //высота
				getinfo('template_url') . 'images/placehold/198x100.png'
				))
			{
				$img = $p->page_url(true) . '<img src="' . $img . '" class="width100" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></a>';
				
				$p->html($img);
			}
			
			$p->line('[title]'); // заголовок
			$p->line('[date]', '<p class="info">', '</p>'); // дата
			$p->content_chars(200, ' ...');  // текст обрезанный
			// $p->content_words(20, ' ...');  // текст обрезанный
			
			$p->line('[read]');
			
			// сохраняем id записей, чтобы их позже исключить из вывода
			$exclude_page_id[] = $p->val('page_id'); 
		}
		
		mso_set_val('exclude_page_id', $exclude_page_id);
	}
}


// формируем вывод

echo '<div class="home-title-col">Последние записи</div>';

$my_columns = new Columns;

$my_columns->new_col('left w25 home-col1'); // старт колонки
out_4col_last_pages(1);
$my_columns->end_col(); // конец колонки

$my_columns->new_col('left w25 home-col2'); // старт колонки
out_4col_last_pages(1);
$my_columns->end_col(); // конец колонки

$my_columns->new_col('left w25 home-col3'); // старт колонки
out_4col_last_pages(1);
$my_columns->end_col(); // конец колонки

$my_columns->new_col('left w25 home-col4'); // старт колонки
out_4col_last_pages(1);
$my_columns->end_col(); // конец колонки

$my_columns->close();

# end file