<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
Слайдер
Опции задаются в slides в custom/my_options.ini

[slide]
header = заголовок
text = текст с html без переносов
link = ссылка
img = адрес картинки
[/slide]

*/

if (!is_type('home')) return;

// опции слайдера
$slides0 = mso_get_option('slides', 'templates', 
'
[slide]
header = заголовок1
text = текст с html без переносов
link = http://maxsite.org/
img = TEMPLATE_URL/stock/slides/images/slide1.jpg
[/slide]

[slide]
header = заголовок2
text = текст с html без переносов
link = http://wbloger.com/
img = TEMPLATE_URL/stock/slides/images/slide2.jpg
[/slide]

[slide]
header = заголовок3
text = текст с html без переносов
link = http://max-3000.com/
img = TEMPLATE_URL/stock/slides/images/slide3.jpg
[/slide]
');


if (!$slides0) return; // слайды не определены - выходим

$slides0 = str_replace('TEMPLATE_URL', getinfo('template_url'), $slides0);

// ищем вхождение [slide] ... [slide]
// указываем дефолтные атрибуты полей слайдера
$slides = mso_section_to_array($slides0, '!\[slide\](.*?)\[\/slide\]!is', array('header'=>'', 'text'=>'', 'link'=>'', 'img'=>''));

if (!$slides) return; // нет секций - выходим

//pr($slides);


// http://slidesjs.com/
echo mso_load_jquery('slides.min.jquery.js');

echo '
	<script>
		$(document).ready(function(){
			$("div.slides").slides({
				preload: true,
				currentClass: "slides_current",
				play: 4000,
				pause: 1500,
				hoverPause: true,

				animationStart: function(current){
					$("div.slide div.r2").animate({
						bottom: -85
					},100);
				},

				animationComplete: function(current){
					$("div.slide div.r2").animate({
						bottom:0
					},200);
				},

				slidesLoaded: function() {
					$("div.slide div.r2").animate({
						bottom:0
					},200);
				}
			});
		});
	</script>
';


// формируем html-код слайдера
// первый цикл выводит изображения
// второй навигацию
?>


<div class="slides">
	<div class="slides_container">
	<?php foreach ($slides as $slide) { ?>
			<div class="slide"><div class="slide-wrap">
				<div class="r1">
				<?= '<a href="' . $slide['link'] . '"><img src="' . $slide['img'] . '" alt=""></a>' ?>	
				</div>
				
				<?php if ($slide['header'] and $slide['text']) { ?>
				<div class="r2">
					<h3><a href="<?= $slide['link'] ?>"><?= $slide['header'] ?></a></h3>
					<p><?= $slide['text'] ?></p>
				</div>
				<?php } ?>
				
			</div></div>
	<?php } ?>
	</div>
	
	<a href="#" class="prev"></a>
	<a href="#" class="next"></a>
				
</div>
