﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

# начальная часть шаблона
require(getinfo('template_dir') . 'main-start.php');

# все блоки закэшировать
$cache_key = 'home-all'; // ключ кэша
$cache_time = 900; // время кэша

$use_cache = true; // использовать кэш (true) или нет (false)

if ($use_cache and $k = mso_get_cache($cache_key)) echo $k;
else
{
	ob_start();
	
	// если указан текст перед всеми записями, то выводим и его
	if ($home_text_do = mso_get_option('home_text_do', 'templates', '')) echo $home_text_do;
	
	
	// библиотека для вывода колонок
	require_once(getinfo('template_dir') . 'stock/class-columns/class-columns.php');

	// библиотека для вывода записей в цикле
	require_once(getinfo('template_dir') . 'stock/page-out/page-out.php');
	
	// библиотека для работы с изображениями
	require_once(getinfo('template_dir') . 'stock/thumb/thumb.php');
	
	$exclude_page_id = array(); // исключаем вывод записей из нижних блоков
	
	$p = new Page_out; // подготавливаем объект для вывода записей
	
	
	// первый блок - последние 3 записи сайта
	echo '<div class="home-title-col">Последние записи</div>';

	if ($pages = mso_get_pages(array( 
				'limit' => 3, 
				'cut' => '...',
				'pagination' => false,
				'get_page_categories' => false,
				'get_page_count_comments' => false,
				'exclude_page_id' => $exclude_page_id,
				), $temp))
	{
		
		// колонки
		$my_columns = new Columns(3, count($pages));
		
		// формат записи
		$p->format('title', '<h1 class="home-last-pages">', '</h1>');
		$p->format('date', 'd/m/Y H:i', '<div class="home-last-pages-date">', '</div>');
		$p->format('edit', 'edit', '<p>', '</p>');
		
		foreach ($pages as $page)
		{
			$my_columns->out('left w33'); // колонка
			
			$p->load($page); // загружаем данные записи
			
			// адрес картинки записи
			$img_meta = $p->meta_val('img_page_home');
			
			// генерируем thumb
			$img = thumb_generate($img_meta, 205, 145, getinfo('template_url') . 'images/current/image-pending-205-145.jpg'); 
			
			if ($img) 
			{
				$img = $p->page_url(true) . '<img src="' . $img . '" class="width100" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></a>';
				
				$p->html($img);
			}

			$p->line('[title]'); // заголовок
			$p->line('[date]'); // дата
			$p->content_chars(100, ' ...');  // текст обрезанный

			$exclude_page_id[] = $p->val('page_id'); // сохраняем id записей, чтобы их позже исключить из вывода
			
			$my_columns->next(); // следующая итерация колонки
		}
		
		
		$my_columns->close(); // завершение вывода колонок
		unset($my_columns); // удалим переменную
	}
	
	
	
	// второй блок - две колонки
	// в каждой колонке по одной рубрике 
	
	$my_columns = new Columns;
	$my_columns->new_col('left w50'); // старт колонки

	echo '<div class="home-title-col">' . mso_get_cat_from_id(mso_explode(mso_get_option('home_cats_id_1', 'templates', '1')), 'category_name') . '</div>';
	
	if ( $pages = mso_get_pages(array( 
				'limit' => 6, 
				'cut' => '...',
				'pagination' => false,
				'exclude_page_id' => $exclude_page_id,
				'cat_id' => mso_get_option('home_cats_id_1', 'templates', '1'),
				), $temp) )
	{
		
		$p->reset_counter(count($pages)); // сбросить счетчик
		
		$p->format('read', 'Читать полностью »', '');
		$p->format('date', 'd/m/Y H:i', '<span class="date">', '</span>');
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи

			if ($p->num == 1)
			{
				$p->line('[title]');
				$p->line('[date] | [comments]', '<p>', '</p>');
				$p->content_chars(200, '...');
				$p->line('[read]');
			}
			else
			{
				if ($p->num == 2) 
				{
					$p->html('<hr>');
					$p->html('<p><b>Последние записи по теме:</b></p>');
					$p->html('<ul>');
				}
				
				$p->title(NR . '<li>', '</li>');
				
				if ($p->last) $p->html('</ul>');
			}
			
			$exclude_page_id[] = $p->val('page_id');
		}
	}
	
	$my_columns->end_col(); // конец колонки
	
	// вторая колонка
	$my_columns->new_col('left w50'); // старт колонки
	
	echo '<div class="home-title-col">' . mso_get_cat_from_id(mso_explode(mso_get_option('home_cats_id_2', 'templates', '2')), 'category_name') . '</div>';
	
	if ( $pages = mso_get_pages(array( 
				'limit' => 6, 
				'cut' => '...',
				'pagination' => false,
				'exclude_page_id' => $exclude_page_id,
				'cat_id' => mso_get_option('home_cats_id_2', 'templates', '2'),
				), $temp) )
	{
		
		$p->reset_counter(count($pages)); // сбросить счетчик

		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи

			if ($p->num == 1)
			{
				$p->line('[title]');
				$p->line('[date] | [comments]', '<p>', '</p>');
				$p->content_chars(200, '...');
				$p->line('[read]');
				
			}
			else
			{
				if ($p->num == 2) 
				{
					$p->html('<hr>');
					$p->html('<p><b>Последние записи по теме:</b></p>');
					$p->html('<ul>');
				}
				
				$p->title(NR . '<li>', '</li>');
				
				if ($p->last) $p->html('</ul>');
			}
			
			$exclude_page_id[] = $p->val('page_id');
		}
	}
	
	$my_columns->end_col(); // конец колонки

	$my_columns->close();
	unset($my_columns); // удалим переменную
	
	
	
	// последний блок - одной колонкой заданные рубрики
	
	echo '<div class="home-title-col">Прочее</div>';
	
	if ( $pages = mso_get_pages(array( 
				'limit' => 5, 
				'cut' => '...',
				'pagination' => false,
				'exclude_page_id' => $exclude_page_id,
				'cat_id' => mso_get_option('home_cats_id_other', 'templates', ''),
				), $temp) )
	{
		
		$p->reset_counter(count($pages)); // сбросить счетчик
		
		$p->format('date', 'd/m/Y H:i', '<div class="home-last-pages-date">', '</div>');
		$p->format('title', '<h1 class="home-others">', '</h1>');
		$p->format('read', '»»»', ' ');
		$p->format('cat', ', ', '<p>', '</p>');
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи

			// адрес картинки записи
			$img_meta = $p->meta_val('img_page_home');
			
			// генерируем thumb
			$img = thumb_generate($img_meta, 205, 145, getinfo('template_url') . 'images/current/image-pending-205-145.jpg'); 
			
			if ($img) 
			{
				$img = $p->page_url(true) . '<img src="' . $img . '" class="right" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></a>';
				
				$p->html($img);
			}
			
			$p->line('[cat]');
			$p->line('[title]');
			$p->line('[date]'); // дата
			
			$p->html('<div class="page_content home_others_page_content">');
			
			$p->content_chars(400, '... ', '', '');
			
			$p->line('[read]');
			
			$p->html('<div class="clearfix"></div></div>');

			
			$exclude_page_id[] = $p->val('page_id');
		}
	}
	

	mso_add_cache($cache_key, ob_get_flush(), $cache_time);
	
} // if $k


if ($f = mso_page_foreach('home-posle')) require($f);

# конечная часть шаблона
require(getinfo('template_dir') . 'main-end.php');


# end file