<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Highlight for MaxSite CMS
 * Authors: Leonis
 * Plugin URL: http://tv-games.ru/pages/Projects/Soft.html
 */

# функция автоподключения плагина
function highlight_autoload($args = array())
{
	mso_hook_add('head', 'highlight_head');
	mso_hook_add('content', 'highlight_content');
}

# функция выполняется при деинсталяции плагина
function highlight_uninstall($args = array())
{	
	mso_delete_option('plugin_highlight', 'plugins'); // удалим созданные опции
	return $args;
}

# вспомогательная функция, возвращает имена файлов в виде #-списка для select
function highlight_scan_files($cat = 'styles')
{
	$CI = &get_instance();
	$CI -> load -> helper('directory'); 

	$path = getinfo('plugins_dir') . '/highlight/' . $cat;
	$files = directory_map($path, true);
	
	if (!$files) return '';
	
	$all_files = array();
	
	// функция directory_map возвращает не только файлы, но и подкаталоги
	// нам нужно оставить только файлы. Делаем это в цикле
	foreach ($files as $file)
	{
		if (@is_dir($path . $file)) continue; // это каталог
		$file = str_replace('.css', '', $file);
		$all_files[] = $file;
	}
	
	// отсортируем список для красоты
	sort($all_files);
	
	// преобразуем массив в строчку с разделителем #
	return implode($all_files, '#');
}

# функция отрабатывающая мини-опции плагина (function плагин_mso_options)
# если не нужна, удалите целиком
function highlight_mso_options()
{
	$all_css = highlight_scan_files();

	# ключ, тип, ключи массива
	mso_admin_plugin_options('plugin_highlight', 'plugins', 
		array(
			'style' => array(
				'type' => 'select', 
				'name' => t('Стиль оформления для сайта:', __FILE__), 
				'description' => t('Необходимо выбрать схему подсветки кода. <a href="https://highlightjs.org/static/demo/" target="_blank">Онлайн демонстрация стилей</a>', __FILE__), 
				'values' => $all_css,
				'default' => 'default'
			)
		),
		t('Настройки плагина Highlight', __FILE__),
		t('<p>Плагин Highlight предоставляет владельцам MaxSite CMS всё богатство функционала подсветки текста от <a href="https://highlightjs.org" target="_blank">highlight.js</a>.</p><p>Характеристики:</p><ul><li><b><i>Версия highlight.js:</i></b> 9.10.0</li><li><b><i>Включённые языки:</i></b> HTML, CSS, Java, JavaScript, PHP (из 172 доступных)</li><li><b><i>Включённые стили оформления:</i></b> 80 (все)</li></ul>', 'plugins')
	);


	echo'<p>Плагин <b><i>highlight.js</i></b> подсвечивает исходный код, делая его более привлекательным и наглядным. Примеры использования: </p>
<pre>
&lt;pre class="php"&gt; тут PHP-код &lt;/pre&gt;
&lt;pre class="html"&gt; тут HTML-код &lt;/pre&gt;
&lt;pre class="javascript"&gt; тут JavaScript-код &lt;/pre&gt;
&lt;pre class="js"&gt; тут тоже код JavaScript &lt;/pre&gt;
</pre>
<p class="info">Если параллельно задействован плагин <strong>BBCode</strong>, то можно использовать следующий синтаксис:</p>
<pre>
[pre class="html"] тут HTML-код [/pre]
[pre class="javascript"] тут JavaScript-код [/pre]
</pre>
<p class="info">Результаты работы встроенного редактора так же допустимы:</p>
<pre>
[pre lang=html] тут HTML-код [/pre]
[pre lang=scala] тут Scala-код [/pre]
</pre>
<p class="info">Highlight умеет подбирать язык по умолчанию, в большинстве случаев можно вообще не указывать class:</p>
<pre>
&lt;pre&gt; тут код &lt;/pre&gt;
[pre] тут код [/pre]
</pre>';

	echo '<p class="info">Темы оформления, любые языки, и самый свежий исходный код highlight.pack.js можно найти на странице <a href="https://highlightjs.org/download/" target="_blank">highlight.js</a>. Все нужные файлы без всяких изменений следует записать в аналогичные каталоги плагина MaxSite CMS (<strong>application/maxsite/plugins/highlight</strong>).</p>';

	echo '<p class="info">Любые рекомендации приветствуются. e-mail: tv-games собака mail.ru</p>';
}

# подключение плагина в head
function highlight_head($arg = array()) 
{
	$options = mso_get_option('plugin_highlight', 'plugins', array());
	if (!isset($options['style']) or !$options['style']) $options['style'] = 'default';
	
	echo '
	<link rel="stylesheet" href="' . getinfo('plugins_url') . 'highlight/styles/' . $options['style'] . '.css" type="text/css" media="screen">
	<style type="text/css">pre {padding: 0; white-space: normal}</style>
	<script src="' . getinfo('plugins_url') . 'highlight/highlight.pack.js" type="text/javascript"></script>
	<script type="text/javascript">hljs.initHighlightingOnLoad();</script>' . NR;
	
	return $arg;
}

# замены pre в тексте
function highlight_content($text = '')
{
	$options = mso_get_option('plugin_highlight', 'plugins', array());
	if (!isset($options['style']) or !$options['style']) 
	{
		return $text;
	}
	else
	{
		$text = str_ireplace('<pre>', '<pre><code>', $text);
		$text = preg_replace('~([<\[])pre (lang|class)="?([a-z1-9-]*)"?([>\]])~', '$1pre class="$3"$4$1code$4', $text);
		$text = preg_replace('~([<\[])\/pre([>\]])~', '</code></pre>', $text);

		return $text;
	}
}

# end file
