<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

	mso_cur_dir_lang('admin');

?>

<h1><?= t('Загрузки. Файлы. Галереи') ?></h1>
<p class="info"><?= t('Здесь вы можете выполнить необходимые операции с файлами.') ?></p>

<?php

	$CI = & get_instance();
	$CI->load->helper('file'); // хелпер для работы с файлами
	
	$CI->load->helper('directory');
	$CI->load->helper('form');

	// разрешенные типы файлов
	$allowed_types = 'mp3|gif|jpg|jpeg|png|zip|txt|rar|doc|rtf|pdf|html|htm|css|xml|odt|avi|wmv|flv|swf|wav|xls|7z|gz';


	// по сегменту определяем текущий каталог в uploads
	// если каталога нет, скидываем на дефолтный ''

	$current_dir = $current_dir_h2 = mso_segment(3);
	if ($current_dir) $current_dir .= '/';

	$path = getinfo('uploads_dir') . $current_dir;
	if ( ! is_dir($path) ) // нет каталога
	{
		$path = getinfo('uploads_dir');
		$current_dir = $current_dir_h2 = '';
	}
	else
	{
		if ($current_dir_h2) $current_dir_h2 = '/' . $current_dir_h2;
	}

	echo '<h2>' . t('Текущий каталог:', 'admin') . ' uploads' . $current_dir_h2 . '</h2>';


	# новый каталог - создаем до того, как отобразить навигацию
	if ( $post = mso_check_post(array('f_session3_id', 'f_cat_name', 'f_newcat_submit')) )
	{
		mso_checkreferer();

		$f_cat_name = mso_slug($post['f_cat_name']);

		if (!$f_cat_name)
			echo '<div class="error">' . t('Нужно ввести имя каталога', 'admin') . '</div>';
		else
		{
			$new_dir = getinfo('uploads_dir') . $f_cat_name;

			if ( is_dir($new_dir) ) // уже есть
			{
				echo '<div class="error">' . t('Такой каталог уже есть!', 'admin') . '</div>';
			}
			else
			{
				@mkdir($new_dir, 0777); // нет каталога, пробуем создать
				@mkdir($new_dir . '/_mso_i', 0777); // нет каталога, пробуем создать
				@mkdir($new_dir . '/mini', 0777); // нет каталога, пробуем создать
				echo '<div class="update">' . sprintf(t('Каталог <strong>%s</strong> создан!'), $f_cat_name)
					. '</div>';
			}
		}
	}


	// нужно вывести навигацию по каталогам в uploads
	$all_dirs = directory_map(getinfo('uploads_dir'), true); // только в uploads
	asort($all_dirs);
	$out = '';
	foreach ($all_dirs as $d)
	{
		// это каталог
		if (is_dir( getinfo('uploads_dir') . $d) and $d != '_mso_float' and $d != 'mini' and $d != '_mso_i' and $d != 'smiles')
		{
			if (mso_segment(3) == $d)
				$out .= '<a href="'. $MSO->config['site_admin_url'] . 'files/' . $d . '"><strong>' . $d . '</strong></a> ';
			else
				$out .= '<a href="'. $MSO->config['site_admin_url'] . 'files/' . $d . '">' . $d . '</a> ';
		}
	}
	if ($out)
	{
		if (!mso_segment(3))
			$out = '<a href="' . $MSO->config['site_admin_url'] . 'files"><strong>uploads</strong></a> ' . $out;
		else
			$out = '<a href="' . $MSO->config['site_admin_url'] . 'files">uploads</a> ' . $out;

		$out = '<div class="admin_files_nav"><span>' . t('Навигация:', 'admin') . '</span>' . $out . '</div>';
		echo $out;
	}


	// нужно создать в этом каталоге _mso_i и mini если нет
	if ( ! is_dir($path . '_mso_i') ) @mkdir($path . '_mso_i', 0777); // нет каталога, пробуем создать
	if ( ! is_dir($path . 'mini') ) @mkdir($path . 'mini', 0777); // нет каталога, пробуем создать



	// описания файлов хранятся в виде серилизованного массива в
	// uploads/_mso_i/_mso_descritions.dat
	$fn_mso_descritions = $path . '_mso_i/_mso_descriptions.dat';

	if (!file_exists( $fn_mso_descritions )) // файла нет, нужно его создать
		write_file($fn_mso_descritions, serialize(array())); // записываем в него пустой массив

	if (file_exists( $fn_mso_descritions )) // файла нет, нужно его создать
	{
		// массив данных: fn => описание )
		$mso_descritions = unserialize( read_file($fn_mso_descritions) ); // получим из файла все описания
	}
	else $mso_descritions = array();

	# Добавление Рамира -  редактирование описания
	if ( $post = mso_check_post(array('f_session_id', 'f_file_name', 'f_file_description', 'f_edit_submit')) )
	{
		mso_checkreferer();

			// удалим описание из _mso_i/_mso_descriptions.dat
			unset($mso_descritions[$post['f_file_name']]);
			$mso_descritions[$post['f_file_name']]=$post['f_file_description'];
			write_file($fn_mso_descritions, serialize($mso_descritions) ); // сохраняем файл

		echo '<div class="update">' . t('Описание обновлено!', 'admin') . '</div>';
	}
	# Конец Добавление Рамира

	# удаление выделенных файлов
	if ( $post = mso_check_post(array('f_session_id', 'f_check_files', 'f_delete_submit')) )
	{
		mso_checkreferer();

		foreach ($post['f_check_files'] as $file)
		{
			@unlink(getinfo('uploads_dir') . $current_dir . $file);
			@unlink(getinfo('uploads_dir') . $current_dir . '_mso_i/' . $file);
			@unlink(getinfo('uploads_dir') . $current_dir . 'mini/' . $file);

			// удалим описание из _mso_i/_mso_descriptions.dat
			unset($mso_descritions[$file]);
			write_file($fn_mso_descritions, serialize($mso_descritions) ); // сохраняем файл
		}
		echo '<div class="update">' . t('Выполнено', 'admin') . '</div>';
	}


	# загрузка нового файла
	if ( $post = mso_check_post(array('f_session2_id', 'f_upload_submit')) )
	{
		mso_checkreferer();
		
		require_once( getinfo('common_dir') . 'uploads.php' ); // функции загрузки 
		
		// параметры для mso_upload
		$mso_upload_ar1 = array( // конфиг CI-библиотеки upload
				'upload_path' => getinfo('uploads_dir') . $current_dir,
				'allowed_types' => $allowed_types,
			);
			
		$mso_upload_ar2 = array( // массив прочих опций
				'userfile_title' => $post['f_userfile_title'], // описание файла
				'fn_mso_descritions' => $fn_mso_descritions, // файл для описаний
				'userfile_resize' => isset($post['f_userfile_resize']), // нужно ли менять размер
				'userfile_resize_size' => $post['f_userfile_resize_size'], // размер
				'userfile_water' => isset($post['f_userfile_water']), // нужен ли водяной знак
				'userfile_water_file' => getinfo('uploads_dir') . 'watermark.png', // файл водяного знака
				'water_type' => $post['f_water_type'], // тип водяного знака
				'userfile_mini' => isset($post['f_userfile_mini']), // делать миниатюру?
				'userfile_mini_size' => $post['f_userfile_mini_size'], // размер миниатюры
				'mini_type' => $post['f_mini_type'], // тип миниатюры
				'prev_size' => 100, // размер превьюхи
				'message1' => '', // не выводить сообщение о загрузке каждого файла
				// 'message2' => '',
				
			);
		
		// подготовим массив $_FILES - у нас множественная загрузка
		$new_files = mso_prepare_files('f_userfile');
		
		$res = false; // результат загрузки
		// формируем поэлементно с загрузкой файлов
		foreach ($new_files as $key => $val)
		{
			$_FILES[$key] = $val; // формируем $_FILES для одиночного файла
			$res = mso_upload($mso_upload_ar1, $key, $mso_upload_ar2);
			unset($_FILES[$key]);
		}
		
		if ($res) echo '<div class="update">' . t('Загрузка выполнена', 'admin') . '</div>';
			else echo '<div class="error">' . t('Возникли ошибки при загрузке', 'admin') . '</div>';
		
		
		// после загрузки сразу обновим массив описаний - он ниже используется
		if (file_exists( $fn_mso_descritions )) // файла нет, нужно создать массив
		{
			// массив данных: fn => описание )
			$mso_descritions = unserialize( read_file($fn_mso_descritions) ); // получим из файла все описания
		}
		else $mso_descritions = array();
		
	}

	// форма нового каталога
	echo '
		<div class="new_cat_upload"><h2>'. t('Новый каталог', 'admin'). '</h2>
		<form action="" method="post">' . mso_form_session('f_session3_id') .
		'<p>'. t('Имя каталога', 'admin'). ': <input type="text" name="f_cat_name" value="">
		<input type="submit" name="f_newcat_submit" value="'. t('Создать', 'admin'). '" onClick="if(confirm(\'' . t('Создать каталог в uploads?', 'admin') . '\')) {return true;} else {return false;}" ></p>
		</form></div>';


	$resize_images = (int) mso_get_option('resize_images', 'general', 600);
	if ($resize_images < 1) $resize_images = 600;
	
	$size_image_mini = (int) mso_get_option('size_image_mini', 'general', 150);
	if ($size_image_mini < 1) $size_image_mini = 150;

	$watermark_type = mso_get_option('watermark_type', 'general', 1);
	
	// форма загрузки
	echo '
		<div class="upload_file">
		<h2>' . t('Загрузка файлов', 'admin') . '</h2>
		<p>' . t('Для загрузки файла нажмите кнопку «Обзор», выберите файл на своем компьютере. После этого нажмите кнопку «Загрузить». Размер файла не должен превышать', 'admin') . ' ' . ini_get ('post_max_size') . '.</p>
		<form action="" method="post" enctype="multipart/form-data">' . mso_form_session('f_session2_id') .
		'<p>
		<input type="file" name="f_userfile[]" size="80"><br>
		<input type="file" name="f_userfile[]" size="80"><br>
		<input type="file" name="f_userfile[]" size="80"><br>
		<input type="file" name="f_userfile[]" size="80"><br>
		<input type="file" name="f_userfile[]" size="80">
		
		&nbsp;<input type="submit" name="f_upload_submit" value="' . t('Загрузить', 'admin') . '"></p>
		<p>' . t('Описание файла:', 'admin') . ' <input type="text" name="f_userfile_title" class="description_file" value=""></p>

		<p><label><input type="checkbox" name="f_userfile_resize" checked="checked" value=""> ' . t('Для изображений изменить размер до', 'admin') . '</label>
			<input type="text" name="f_userfile_resize_size" style="width: 50px" maxlength="4" value="' . $resize_images . '"> ' . t('px (по максимальной стороне).', 'admin') . '</p>

		<p><label><input type="checkbox" name="f_userfile_mini" checked="checked" value=""> ' . t('Для изображений сделать миниатюру размером', 'admin') . '</label>
			<input type="text" name="f_userfile_mini_size" style="width: 50px" maxlength="4" value="' . $size_image_mini . '"> ' . t('px (по максимальной стороне).', 'admin') . ' <br><em>' . t('Примечание: миниатюра будет создана в каталоге', 'admin') . ' <strong>uploads/' . $current_dir . 'mini</strong></em></p>

		<p>' . t('Миниатюру делать путем:', 'admin') . ' <select name="f_mini_type">
		<option value="1">' . t('Пропорционального уменьшения', 'admin') . '</option>
		<option value="2">' . t('Обрезки (crop) по центру', 'admin') . '</option>
		<option value="3">' . t('Обрезки (crop) с левого верхнего края', 'admin') . '</option>
		<option value="4">' . t('Обрезки (crop) с левого нижнего края', 'admin') . '</option>
		<option value="5">' . t('Обрезки (crop) с правого верхнего края', 'admin') . '</option>
		<option value="6">' . t('Обрезки (crop) с правого нижнего края', 'admin') . '</option>
		</select></p>

		<p><label><input type="checkbox" name="f_userfile_water" value="" '.
			((file_exists(getinfo('uploads_dir') . 'watermark.png')) ? '' : ' disabled="disabled"') . 
			((mso_get_option('use_watermark', 'general', 0)) ? (' checked="checked"') : ('')) .
			'> ' . t('Для изображений установить водяной знак', 'admin') . '</label>
			<br><em>' . t('Примечание: водяной знак должен быть файлом <strong>watermark.png</strong> и находиться в каталоге', 'admin') . ' <strong>uploads</strong></em></p>

		<p>' . t('Водяной знак устанавливается:', 'admin') . ' <select name="f_water_type">
		<option value="1"'.(($watermark_type == 1)?(' selected="selected"'):('')).'>' . t('По центру', 'admin') . '</option>
		<option value="2"'.(($watermark_type == 2)?(' selected="selected"'):('')).'>' . t('В левом верхнем углу', 'admin') . '</option>
		<option value="3"'.(($watermark_type == 3)?(' selected="selected"'):('')).'>' . t('В правом верхнем углу', 'admin') . '</option>
		<option value="4"'.(($watermark_type == 4)?(' selected="selected"'):('')).'>' . t('В левом нижнем углу', 'admin') . '</option>
		<option value="5"'.(($watermark_type == 5)?(' selected="selected"'):('')).'>' . t('В правом нижнем углу', 'admin') . '</option>
		</select></p>

		</form>
		</div>
		';

	// как выводим файлы
	$admin_view_files = mso_get_option('admin_view_files', 'general', 'mini');
	
	
	if ($admin_view_files == 'table')
	{
		$CI->load->library('table');
		$tmpl = array (
					'table_open'		  => '<table class="page" border="0" width="100%"><colgroup width="110">',
					'row_alt_start'		  => '<tr class="alt">',
					'cell_alt_start'	  => '<td class="alt">',
			  );

		$CI->table->set_template($tmpl); // шаблон таблицы
		// заголовки
		$CI->table->set_heading('&bull;', t('Коды для вставки', 'admin'));
	}

	// проходимся по каталогу аплоада и выводим их списком

	$uploads_dir = getinfo('uploads_dir') . $current_dir;
	$uploads_url = getinfo('uploads_url') . $current_dir;

	// все файлы в массиве $dirs
	$dirs = directory_map($uploads_dir, true); // только в текущем каталоге

	if (!$dirs) $dirs = array();

	sort($dirs);

	$allowed_ext = explode('|', $allowed_types);

	$out_all = ''; // весь вывод

	foreach ($dirs as $file)
	{
		if (@is_dir($uploads_dir . $file)) continue; // это каталог

		$ext = strtolower(str_replace('.', '', strrchr($file, '.'))); // расширение файла
		if ( !in_array($ext, $allowed_ext) ) continue; // запрещенный тип файла

		$cod = '<p>';
		$title = '';
		$title_f = '';
		
		if (isset($mso_descritions[$file]))
		{
			$title = $mso_descritions[$file];
			if ($title) $title_f = '<br><em>' . $title . '</em>';
		}

		$sel = form_checkbox('f_check_files[]', $file, false,
			'title="' . $title . '" id="' . mso_strip($file) . '" class="f_check_files"')
			. '<label for="' . mso_strip($file)
			. '"> '
			. $file . $title_f . '</label>';

		$cod1 = stripslashes(htmlspecialchars( $uploads_url . $file ) );

		# if ($title) $cod .= '<input type="text" style="width: 300px;" value="' . $title . '">';


		# $cod .= '<p><input type="text" style="width: 99%;" value="' . $cod1 . '">';

		$cod .= '<a href="#"
			onClick = "jAlert(\'<textarea cols=60 rows=4>' . $cod1 . '</textarea>\', \'Адрес файла\'); return false;">Адрес</a>';

		# $cod .= '<p><textarea style="width: 99%;">' . $cod1 . '</textarea>';



		//Если картинка - делаем ссылку превьюшкой, иначе титлом или именем файла.
		if ( $ext == 'jpg' or $ext == 'jpeg' or $ext == 'gif' or $ext == 'png'  ) {
			$cod2 = stripslashes(htmlspecialchars( '<a href="' . $uploads_url . $file . '"><img src="' . $uploads_url . 'mini/' . $file . '"></a>') );
		} else {
			if ($title) $cod2 = stripslashes(htmlspecialchars( '<a href="' . $uploads_url . $file . '">' . $title . '</a>') );
				else $cod2 = stripslashes(htmlspecialchars( '<a href="' . $uploads_url . $file . '">' . $file . '</a>') );
		}

		# $cod .= '<p><input type="text" style="width: 99%;" value="' . $cod2 . '">';
		$cod .= ' | <a href="#"
			onClick = "jAlert(\'<textarea cols=60 rows=5>' . $cod2 . '</textarea>\', \'HTML-ссылка файла\'); return false;">HTML-ссылка</a>';


		if ( $ext == 'jpg' or $ext == 'jpeg' or $ext == 'gif' or $ext == 'png'  )
		{
			if (file_exists( $uploads_dir . '_mso_i/' . $file  )) $_f = '_mso_i/' . $file;
			else $_f = $file;

			if (file_exists( $uploads_dir . 'mini/' . $file  ))
				$file_mini = '=' . $uploads_url . 'mini/' . $file;
			else $file_mini = '=' . $uploads_url . $file;


			// $cod3 = stripslashes(htmlspecialchars( '<a href="' . $uploads_url . $file . '"><img src="' . $uploads_url . $file . '"></a>') );
			//$cod .= '<p><input type="text" style="width: 99%;" value="' . $cod3 . '">';

			if ($title)
				$cod3 = stripslashes(htmlspecialchars( '[image' . $file_mini . ' ' . $title . ']' . $uploads_url . $file . '[/image]') );
			else
				$cod3 = stripslashes(htmlspecialchars( '[image' . $file_mini . ']' . $uploads_url . $file . '[/image]') );

			# $cod .= '<p><input type="text" style="width: 99%;" value="' . $cod3 . '">';
			$cod .= ' | <a href="#"
			onClick = "jAlert(\'<textarea cols=60 rows=6>' . $cod3 . '</textarea>\', \'Код [image] файла\'); return false;">Код [image]</a>';

			$predpr = '<a class="lightbox" href="' . $uploads_url . $file . '" target="_blank" title="' . $title . ' ('. $file . ')' . '"><img class="file_img" alt="" src="' . $uploads_url . $_f . '"></a>';

		}
		else
		{
			if ( $ext == 'mp3')
			{
				$predpr = '<a href="' . $uploads_url . $file . '" target="_blank" title="' . $title . ' ('. $file . ')' . '"><img class="file_img" alt="" src="' . getinfo('admin_url') . 'plugins/admin_files/mp3.png"></a>';

				$cod .= ' | <a href="#"
			onClick = "jAlert(\'<textarea cols=60 rows=6>' . stripslashes(htmlspecialchars( '[audio=' . $uploads_url . $file . ']') ) . '</textarea>\', \'Код [audio] файла\'); return false;">Код [audio]</a>';

			}
			else
			{
				$predpr = '<a href="' . $uploads_url . $file . '" target="_blank" title="' . $title . ' ('. $file . ')' . '"><img class="file_img" alt="" src="' . getinfo('admin_url') . 'plugins/admin_files/document_plain.png"></a>';
			}


		}

		// nicothin добавил:
		$cod .= '<br><a href="#" class="edit_descr_link" onClick="return false;">' . t('Изменить описание', 'admin') . '</a>';
		// конец добавления

		$out_all .= '<div class="cornerz"><div class="wrap">' . $sel . $predpr . $cod . '</div></div>';

		if ($admin_view_files == 'table') $CI->table->add_row($predpr, $sel . $cod);
	}

	// добавляем форму, а также текущую сессию
	if ($out_all != '') 
	{
		echo '<form action="" method="post">' . mso_form_session('f_session_id');
		if ($admin_view_files == 'table') 
			echo $CI->table->generate(); // вывод подготовленной таблицы
		else
		{
			echo '<div class="float-parent" style="width:100%">';
			echo $out_all;
			echo '<div style="clear:both"></div></div>';
		}

		echo '<p class="br"><input type="submit" name="f_delete_submit" value="' . t('Удалить', 'admin') . '" onClick="if(confirm(\'' . t('Выделенные файы будут безвозвратно удалены! Удалять?', 'admin') . '\')) {return true;} else {return false;}" ></p>
			<p class="br"><input type="button" id="check-all" value="' . t('Инвертировать выделение', 'admin') . '"></p>
			</form>';

		$n = '\n';
		$up = $uploads_url;

		$mess = t('Предварительно нужно выделить файлы для галереи', 'admin');
		$session = mso_form_session('f_session_id');
		$save_button = t('Сохранить', 'admin');

		echo <<<EOF
<script type="text/javascript">
function toggleAll() {
	var allCheckboxes = $("input.f_check_files:enabled");
	var notChecked = allCheckboxes.not(':checked');
	allCheckboxes.removeAttr('checked');
	notChecked.attr('checked', 'checked');
}

$(function()
{
	$("#check-all").click(function(){
		toggleAll()
	});

	//nicothin добавления
	if ($('script[src$="jquery/cornerz.js"]').size()) 
	{ 
		$('div.cornerz').cornerz({radius:10, background: "#FFFFFF"}); 
	}
	$('.edit_descr_link').toggle(function () 
	{
		if (!$(this).parent().parent().children('.edit_descr').size())
		{
			var file_name = $(this).parent().parent().children(':checkbox').attr('id');
			var old_descr = $(this).parent().parent().children('label').children('em').text();
			var form_code = '<div class="edit_descr" style="width: 100%;" style="display:none"><form action="" method="post">{$session}<input type="hidden" name="f_file_name" value="' + file_name + '"><textarea name="f_file_description" >' + old_descr + '</textarea><br><input type="submit" name="f_edit_submit" value="{$save_button}"></form></div>';
			$(this).parent().parent().append(form_code);
		}
		$(this).parent().parent().find('.edit_descr').slideDown('fast');
	},
	function () {
		$(this).parent().parent().find('.edit_descr').slideUp('fast');
	});
	// nicothin конец добавления
	
	$('#gallerycodeclick').click(function()
	{
		$('#gallerycode').html('');

		codegal = '';
		$("input[name='f_check_files[]']").each( function(i)
		{
			if (this.checked)
			{
				t = this.title;
				if (!t) { t = this.value; }
				codegal = codegal + '[gal={$up}mini/' + this.value + ' ' + t + ']{$up}'+ this.value +'[\/gal]{$n}';
			}
		});

		if ( codegal )
		{
			n = $('#gallerycodename').val();
			if (n) { n = '[galname]' + n + '[/galname]';}
			else { n = ''; }

			codegal = '[gallery]' + n + '{$n}'+ codegal + '[/gallery]';
			$('#gallerycode').html(codegal);
			$('#gallerycode').css({ background: '#F0F0F0', width: '100%', height: '150px',
									border: '1px solid gray', margin: '20px 0',
									'font-family': 'Courier New',
									'font-size': '9pt'});
			$('#gallerycode').fadeIn('slow');
			$('#gallerycode').select();
		}
		else
		{
			$('#gallerycode').hide();
			alert('{$mess}');
		}
	});
});
</script>
<hr class="br">
EOF;
		echo '<h2 class="br">' . t('Создание галереи', 'admin') . '</h2>
		<p>' . t('Выделите нужные файлы. (У вас должен быть активирован плагин <strong>LightBox</strong>)', 'admin') . '</p>
		<p>' . t('Название:', 'admin') . ' <input type="text" id="gallerycodename" value=""> ' . t('(если нужно)', 'admin') . '<br><input class="br" type="button" id="gallerycodeclick" value="' . t('Генерировать код галереи', 'admin') . '">
		</p>
		<p><textarea id="gallerycode" style="display: none"></textarea>
		';
	}
	else
	{
		echo '<p>' . t('Нет загруженных файлов', 'admin') . '</p>';
	}

?>