<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

# основной файл html-структуры

# секция HEAD
if ($fn = mso_fe('custom/head-section.php')) require($fn); // подключение HEAD из файла
	else mso_default_head_section(); // подключение через функцию

?>
<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
<script type="text/javascript">
 
	$(document).ready(function() {
 
		// Хранение переменных
 
		var accordion_head = $('.accordion > li > a'),
			accordion_body = $('.accordion li > .sub-menu');
 
		// Открытие первой вкладки при загрузке
 
accordion_head.first().addClass('active').next().slideDown('normal');
 
		// Выбор функции
 
		accordion_head.on('click', function(event) {
 
			// Отключить заголовок ссылки
 
			event.preventDefault();
 
			// Отображение и скрытие вкладок при клике
 
			if ($(this).attr('class') != 'active'){
				accordion_body.slideUp('normal');
				$(this).next().stop(true,true).slideToggle('normal');
				accordion_head.removeClass('active');
				$(this).addClass('active');
			}
 
		});
 
	});
 
</script>


<body<?= (mso_get_val('body_class')) ? ' class="' . mso_get_val('body_class') . '"' : ''; ?>>
<!-- end header -->
<?php 
	mso_hook('body_start');
	if (function_exists('ushka')) echo ushka('body_start');
	if ($fn = mso_fe('custom/body-start.php')) require($fn);
?>
<?
/*
	Файл: logo-ns-descr-banner.php

	Название: «Лого, название, описание и баннер в шапке»
	
	Для баннера используется ушка logo-banner.
		
	Расположение: header
	
	Схематичный вид: 
		(лого) Название сайта				(баннер)
		       Описание		

	CSS-стили: 
			>	@import url('components/logo-ns-descr-banner.less');
		
	PHP-связи: 
			>	if ($fn = mso_fe('components/logo-ns-descr-banner/logo-ns-descr-banner.php')) require($fn);
			
			
*/

$pt = new Page_out; // подготавливаем объект для вывода

// если в опции явно указан адрес лого, то берем его
$logo = trim(mso_get_option('default_header_logo_custom', 'templates', false));

if (!$logo)
{	
	$logo = getinfo('stylesheet_url') . 'images/logos/' . mso_get_option('default_header_logo', 'templates', 'logo01.png');
}

$logo = '<img src="' . $logo . '" alt="' . getinfo('name_site') . '" title="' . getinfo('name_site') . '">';

if (!is_type('home')) $logo = $pt->link(getinfo('siteurl'), $logo);

// вывод
$pt->div_start('logo-ns-descr-banner', 'wrap');

	$pt->div_start('r1');
		$pt->html($logo);
	$pt->div_end('r1');
	
	$pt->div_start('r2');
		$pt->div($pt->name_site(), 'name_site');
		$pt->div(getinfo('description_site'), 'description_site');
	$pt->div_end('r2');
	
	
	$pt->clearfix();

$pt->div_end('logo-ns-descr-banner', 'wrap');

?>

		<div class="header"><div class="header-wrap">
			<?php 
				if (function_exists('ushka')) echo ushka('header-start');
				if ($fn = mso_fe('custom/header-start.php')) require($fn);
				
				if ($fn = mso_fe('custom/header_components.php')) require($fn);
				else
				{
					if ($fn = get_component_fn('header_component1', 'menu-only')) require($fn);
					if ($fn = get_component_fn('header_component2')) require($fn);
					if ($fn = get_component_fn('header_component3')) require($fn);
					if ($fn = get_component_fn('header_component4')) require($fn);
					if ($fn = get_component_fn('header_component5')) require($fn);
				}

				if (function_exists('ushka')) echo ushka('header-end');
				if ($fn = mso_fe('custom/header-end.php')) require($fn);

			?>
		</div></div><!-- /div.header-wrap /div.header -->
			</div><!-- /div.header-main -->
		
<div class="all"><div class="all-wrap">
	<div class="header-main">

		<?php 
			if (function_exists('ushka')) echo ushka('header-pre'); 
			if ($fn = mso_fe('custom/header-pre.php')) require($fn);
		?>



		<?php if (function_exists('ushka')) echo ushka('header-out'); ?>

		<div class="main"><div class="main-wrap">
			<?php 
				if (function_exists('ushka')) echo ushka('main-start');
				if ($fn = mso_fe('custom/main-start.php')) require($fn);
			?>

			<div class="content"><div class="content-wrap">
				<?php 
			
					if (function_exists('ushka')) echo ushka('content-start');
					if ($fn = mso_fe('custom/content-start.php')) require($fn);
					
					if ($fn = mso_fe('custom/content-out.php')) require($fn);
					else
					{ 
						global $CONTENT_OUT; 
						echo $CONTENT_OUT; 
					}
					
					if (function_exists('ushka')) echo ushka('content-end');
					if ($fn = mso_fe('custom/content-end.php')) require($fn);
				?>
			</div></div><!-- /div.content-wrap /div.content -->

			<?php
				if ($fn = mso_fe('custom/sidebars.php')) require($fn);
				else
				{
				?>
				
				
				
				
				
<div id="wrapper-250">
<ul class="accordion">
    <li id="one">
        <a href="#">Меню</a>
        <ul class="sub-menu">
		
		<?php
			if ($menu = mso_get_option('menu2', 'templates', '/ | Главная_NR_about | О сайте')) 
				echo mso_menu_build($menu, 'selected', false);
		?>
            </ul>
    </li>
</ul>
</div><!-- div class="MainMenu2" -->
	
	
	
	
	
	
<?
					echo NR . '<div class="sidebar sidebar1"><div class="sidebar1-wrap">';
					mso_show_sidebar('1');
					echo NR . '</div></div><!-- /div.sidebar1-wrap /div.sidebar sidebar1 -->';
				}

				
				if (function_exists('ushka')) echo ushka('main-end');
				if ($fn = mso_fe('custom/main-end.php')) require($fn);
			?>

			<div class="clearfix"></div>
		</div></div><!-- /div.main-wrap /div.main -->
</div></div><!-- /div.all-wrap /div.all -->


<div class="footer-do-separation"></div>
	<?php if (function_exists('ushka')) echo ushka('footer-pre'); ?>

	<div class="footer"><div class="footer-wrap">
		<?php 
			if (function_exists('ushka')) echo ushka('footer-start');
			if ($fn = mso_fe('custom/footer-start.php')) require($fn);
			
			if ($fn = mso_fe('custom/footer_components.php')) require($fn);
			else
			{
				if ($fn = get_component_fn('footer_component1', 'footer-copy-stat')) require($fn);
				if ($fn = get_component_fn('footer_component2')) require($fn);
				if ($fn = get_component_fn('footer_component3')) require($fn);
				if ($fn = get_component_fn('footer_component4')) require($fn);
				if ($fn = get_component_fn('footer_component5')) require($fn); 
			}
			
			if (function_exists('ushka')) echo ushka('footer-end');
			if ($fn = mso_fe('custom/footer-end.php')) require($fn);
		?>
		
		
	</div></div><!-- /div.footer-wrap /div.footer -->
<?php 
	if ($fn = mso_fe('custom/body-end.php')) require($fn); 

	if (function_exists('ushka')) 
	{
		echo ushka('google_analytics'); 
		echo ushka('body_end');
	} 
	
	mso_hook('body_end'); 
?>
</body></html>