/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel.treeview;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTable;

public class MyTreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected int visibleRow;
    private MyTreeTable treeTable;

    public MyTreeTableCellRenderer(MyTreeTable treeTable, TreeModel model) {
        super(model);
        this.treeTable = treeTable;
        this.setRowHeight(this.getRowHeight());
        this.setRootVisible(false);
        this.setScrollsOnExpand(true);
        this.setShowsRootHandles(true);
    }

    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this.treeTable != null && this.treeTable.getRowHeight() != rowHeight) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.treeTable.getHeight());
    }

    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.visibleRow = row;
        return this;
    }
}

