/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.helper.ImageHelper;
import wjhk.jupload2.filedata.helper.ImageReaderWriterHelper;
import wjhk.jupload2.policies.PictureUploadPolicy;
import wjhk.jupload2.policies.UploadPolicy;

public class PictureFileData
extends DefaultFileData {
    boolean isPicture = false;
    Image offscreenImage = null;
    int quarterRotation = 0;
    int originalWidth = -1;
    int originalHeight = -1;
    File transformedPictureFile = null;
    long uploadLength = -1L;
    File workingCopyTempFile = null;
    String targetPictureFormat;

    public PictureFileData(File file, PictureUploadPolicy uploadPolicy) throws JUploadIOException {
        super(file, uploadPolicy);
        String fileExtension = this.getFileExtension();
        uploadPolicy.displayDebug("Looking for iterator of extension '" + file + "'", 80);
        this.isPicture = PictureFileData.isFileAPicture(file);
        uploadPolicy.displayDebug("isPicture=" + this.isPicture + " (" + file.getName() + "), extension=" + fileExtension, 50);
        if (this.isPicture) {
            this.setMimeTypeByExtension(fileExtension);
        }
    }

    public static void freeMemory(String caller, UploadPolicy uploadPolicy) {
        Runtime rt = Runtime.getRuntime();
        rt.runFinalization();
        rt.gc();
        if (uploadPolicy.getDebugLevel() >= 50) {
            uploadPolicy.displayDebug("freeMemory (after " + caller + ") : " + rt.freeMemory() + " (maxMemory: " + rt.maxMemory() + ", totalMemory: " + rt.totalMemory() + ")", 50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeUpload(String uploadFileRoot) throws JUploadException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.beforeUpload()", 95);
        if (!this.preparedForUpload && this.uploadLength < 0L) {
            try {
                PictureFileData.freeMemory("Picture manabeforeUpload(): before initTransformedPictureFile", this.uploadPolicy);
                this.initTransformedPictureFile();
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): after call to initTransformedPictureFile()", 100);
            }
            catch (OutOfMemoryError e) {
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): OutOfMemoryError", 30);
                this.deleteTransformedPictureFile();
                this.deleteWorkingCopyPictureFile();
                PictureFileData.freeMemory("beforeUpload(): in OutOfMemoryError", this.uploadPolicy);
                this.tooBigPicture();
            }
            PictureFileData pictureFileData = this;
            synchronized (pictureFileData) {
                if (this.transformedPictureFile != null) {
                    this.uploadLength = this.transformedPictureFile.length();
                    this.setMimeTypeByExtension(this.targetPictureFormat);
                } else {
                    this.uploadLength = this.getFile().length();
                }
            }
        }
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): before call to super.beforeUpload()", 100);
        super.beforeUpload(uploadFileRoot);
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): after call to super.beforeUpload()", 100);
    }

    public long getUploadLength() {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        return this.uploadLength;
    }

    public synchronized InputStream getInputStream() throws JUploadException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.getInputStream()", 95);
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        if (this.transformedPictureFile != null) {
            try {
                return new FileInputStream(this.transformedPictureFile);
            }
            catch (FileNotFoundException e) {
                throw new JUploadIOException(e);
            }
        }
        return super.getInputStream();
    }

    public void afterUpload() {
        this.deleteTransformedPictureFile();
        this.deleteWorkingCopyPictureFile();
        this.uploadLength = -1L;
        super.afterUpload();
    }

    public Image getImage(Canvas canvas, boolean shadow) throws JUploadException {
        BufferedImage localImage = null;
        if (canvas == null) {
            throw new JUploadException("canvas null in PictureFileData.getImage");
        }
        if (shadow && this.offscreenImage != null) {
            return this.offscreenImage;
        }
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            this.uploadPolicy.displayDebug("canvas width and/or height null in PictureFileData.getImage()", 1);
            return null;
        }
        if (!this.isPicture) {
            this.uploadPolicy.displayWarn("canvas width and/or height null in PictureFileData.getImage(). PictureFileData.getImage will return null");
            return null;
        }
        try {
            ImageReaderWriterHelper irwh = new ImageReaderWriterHelper((PictureUploadPolicy)this.uploadPolicy, this);
            BufferedImage sourceImage = irwh.readImage(0);
            irwh.dispose();
            irwh = null;
            ImageHelper ih = new ImageHelper((PictureUploadPolicy)this.uploadPolicy, this, canvasWidth, canvasHeight, this.quarterRotation);
            localImage = ih.getBufferedImage(((PictureUploadPolicy)this.uploadPolicy).getHighQualityPreview(), sourceImage);
            sourceImage.flush();
            sourceImage = null;
        }
        catch (OutOfMemoryError e) {
            localImage = null;
            this.tooBigPicture();
        }
        if (shadow) {
            this.offscreenImage = localImage;
        }
        PictureFileData.freeMemory("end of " + this.getClass().getName() + ".getImage()", this.uploadPolicy);
        this.uploadPolicy.getContext().getUploadPanel().getPreparationProgressBar().setValue(0);
        return localImage;
    }

    public void addRotation(int quarter) {
        this.quarterRotation += quarter;
        this.deleteWorkingCopyPictureFile();
        this.deleteTransformedPictureFile();
        this.uploadLength = -1L;
        while (this.quarterRotation < 0) {
            this.quarterRotation += 4;
        }
        while (this.quarterRotation >= 4) {
            this.quarterRotation -= 4;
        }
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
    }

    public boolean isPicture() {
        return this.isPicture;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public synchronized void deleteTransformedPictureFile() {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.deleteTransformedPictureFile()", 95);
        if (null != this.transformedPictureFile && this.uploadPolicy.getDebugLevel() <= 100) {
            if (!this.transformedPictureFile.delete()) {
                this.uploadPolicy.displayWarn("Unable to delete " + this.transformedPictureFile.getName());
            }
            this.transformedPictureFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initTransformedPictureFile() throws JUploadException {
        int targetMaxHeight;
        int targetMaxWidth;
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.initTransformedPictureFile()", 95);
        if (this.quarterRotation == 0) {
            targetMaxWidth = ((PictureUploadPolicy)this.uploadPolicy).getMaxWidth();
            targetMaxHeight = ((PictureUploadPolicy)this.uploadPolicy).getMaxHeight();
        } else {
            targetMaxWidth = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxWidth();
            targetMaxHeight = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxHeight();
        }
        ImageHelper imageHelper = new ImageHelper((PictureUploadPolicy)this.uploadPolicy, this, targetMaxWidth, targetMaxHeight, this.quarterRotation);
        PictureFileData pictureFileData = this;
        synchronized (pictureFileData) {
            if (imageHelper.hasToTransformPicture() && this.transformedPictureFile == null) {
                try {
                    this.createTranformedPictureFile(imageHelper);
                }
                catch (JUploadException e) {
                    this.deleteTransformedPictureFile();
                    throw e;
                }
            }
        }
    }

    synchronized void createTranformedPictureFile(ImageHelper imageHelper) throws JUploadException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.createTransformedPictureFile()", 95);
        IIOMetadata metadata = null;
        IIOImage iioImage = null;
        BufferedImage originalImage = null;
        BufferedImage transformedImage = null;
        ImageReaderWriterHelper imageWriterHelper = new ImageReaderWriterHelper((PictureUploadPolicy)this.uploadPolicy, this);
        boolean transmitMetadata = ((PictureUploadPolicy)this.uploadPolicy).getPictureTransmitMetadata();
        this.createTransformedTempFile();
        this.targetPictureFormat = imageWriterHelper.getTargetPictureFormat();
        imageWriterHelper.setOutput(this.transformedPictureFile);
        int nbPictures = 1;
        if (PictureFileData.getExtension(this.getFileName()).equalsIgnoreCase("gif")) {
            nbPictures = Integer.MAX_VALUE;
        }
        this.uploadPolicy.displayDebug("Reading image with imageWriterHelper.readImage(i)", 50);
        try {
            for (int i = 0; i < nbPictures; ++i) {
                originalImage = imageWriterHelper.readImage(i);
                transformedImage = imageHelper.getBufferedImage(true, originalImage);
                if (transmitMetadata) {
                    metadata = imageWriterHelper.getImageMetadata(i);
                }
                iioImage = new IIOImage(transformedImage, null, metadata);
                imageWriterHelper.write(iioImage);
                if (originalImage == null) continue;
                originalImage.flush();
                originalImage = null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.uploadPolicy.displayDebug("IndexOutOfBoundsException catched: end of reading for file " + this.getFileName(), 10);
        }
        if (originalImage != null) {
            originalImage.flush();
            originalImage = null;
        }
        imageWriterHelper.dispose();
    }

    void tooBigPicture() {
        String msg = this.uploadPolicy.getLocalizedString("tooBigPicture", this.getFileName());
        this.uploadPolicy.displayWarn(msg);
        JOptionPane.showMessageDialog(null, msg, "Warning", 2);
    }

    void setMimeTypeByExtension(String fileExtension) {
        String ext = fileExtension.toLowerCase();
        if (ext.equals("jpg")) {
            ext = "jpeg";
        }
        this.mimeType = "image/" + ext;
    }

    synchronized void createTransformedTempFile() throws JUploadIOException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.createTransformedTempFile()", 95);
        if (this.transformedPictureFile == null) {
            try {
                this.transformedPictureFile = File.createTempFile("jupload_", ".tmp");
            }
            catch (IOException e) {
                throw new JUploadIOException("PictureFileData.createTransformedTempFile()", e);
            }
            this.uploadPolicy.getContext().registerUnload(this, "deleteTransformedPictureFile");
            this.uploadPolicy.displayDebug("Using transformed temp file " + this.transformedPictureFile.getAbsolutePath() + " for " + this.getFileName(), 30);
        }
    }

    void initWidthAndHeight() throws JUploadIOException {
        Iterator<ImageReader> iter;
        if (this.isPicture && (this.originalHeight < 0 || this.originalWidth < 0) && (iter = ImageIO.getImageReadersByFormatName(this.getFileExtension().toLowerCase())).hasNext()) {
            try {
                FileImageInputStream fiis = new FileImageInputStream(this.getFile());
                ImageReader ir = iter.next();
                ir.setInput(fiis);
                this.originalHeight = ir.getHeight(0);
                this.originalWidth = ir.getWidth(0);
                ir.dispose();
                fiis.close();
            }
            catch (IOException e) {
                throw new JUploadIOException("PictureFileData()", e);
            }
        }
    }

    synchronized void createWorkingCopyTempFile() throws IOException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.createWorkingCopyTempFile()", 95);
        if (this.workingCopyTempFile == null) {
            this.workingCopyTempFile = File.createTempFile("jupload_", ".tmp." + DefaultFileData.getExtension(this.getFileName()));
            this.uploadPolicy.getContext().registerUnload(this, "deleteWorkingCopyPictureFile");
            this.uploadPolicy.displayDebug("Using working copy temp file " + this.workingCopyTempFile.getAbsolutePath() + " for " + this.getFileName(), 30);
        }
    }

    public synchronized void deleteWorkingCopyPictureFile() {
        if (null != this.workingCopyTempFile && this.uploadPolicy.getDebugLevel() <= 100) {
            if (!this.workingCopyTempFile.delete()) {
                this.uploadPolicy.displayWarn("Unable to delete " + this.workingCopyTempFile.getName());
            }
            this.workingCopyTempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public synchronized File getWorkingSourceFile() throws JUploadIOException {
        block24: {
            if (this.workingCopyTempFile == null) {
                IOException e22;
                FileOutputStream os;
                FileInputStream is;
                block21: {
                    int l;
                    this.uploadPolicy.displayDebug("[getWorkingSourceFile] Creating a copy of " + this.getFileName() + " as a source working target.", 30);
                    is = null;
                    os = null;
                    this.createWorkingCopyTempFile();
                    is = new FileInputStream(this.getFile());
                    os = new FileOutputStream(this.workingCopyTempFile);
                    byte[] b = new byte[1024];
                    while ((l = is.read(b)) > 0) {
                        os.write(b, 0, l);
                    }
                    Object var6_6 = null;
                    if (is == null) break block21;
                    try {
                        try {
                            is.close();
                        }
                        catch (IOException e22) {
                            this.uploadPolicy.displayWarn(e22.getClass().getName() + " while trying to close FileInputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                            Object var9_9 = null;
                            is = null;
                            break block21;
                        }
                        Object var9_8 = null;
                        is = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        is = null;
                        throw throwable;
                    }
                }
                if (os != null) {
                    try {
                        try {
                            os.close();
                        }
                        catch (IOException e22) {
                            this.uploadPolicy.displayWarn(e22.getClass().getName() + " while trying to close FileOutputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                            Object var11_19 = null;
                            os = null;
                        }
                        Object var11_18 = null;
                        os = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_20 = null;
                        os = null;
                        throw throwable;
                    }
                }
                break block24;
                {
                    catch (IOException e3) {
                        throw new JUploadIOException("ImageReaderWriterHelper.getWorkingSourceFile()", e3);
                    }
                }
                catch (Throwable throwable) {
                    IOException e22;
                    Object var6_7 = null;
                    if (is != null) {
                        try {
                            try {
                                is.close();
                            }
                            catch (IOException e22) {
                                this.uploadPolicy.displayWarn(e22.getClass().getName() + " while trying to close FileInputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                                Object var9_12 = null;
                                is = null;
                            }
                            Object var9_11 = null;
                            is = null;
                        }
                        catch (Throwable throwable2) {
                            Object var9_13 = null;
                            is = null;
                            throw throwable2;
                        }
                    }
                    if (os != null) {
                        try {
                            try {
                                os.close();
                            }
                            catch (IOException e22) {
                                this.uploadPolicy.displayWarn(e22.getClass().getName() + " while trying to close FileOutputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                                Object var11_22 = null;
                                os = null;
                            }
                            Object var11_21 = null;
                            os = null;
                        }
                        catch (Throwable throwable3) {
                            Object var11_23 = null;
                            os = null;
                            throw throwable3;
                        }
                    }
                    throw throwable;
                }
            }
        }
        return this.workingCopyTempFile;
    }

    public int getOriginalWidth() throws JUploadIOException {
        this.initWidthAndHeight();
        return this.originalWidth;
    }

    public int getOriginalHeight() throws JUploadIOException {
        this.initWidthAndHeight();
        return this.originalHeight;
    }

    public static ImageIcon getImageIcon(File pictureFile, int maxWidth, int maxHeight, UploadPolicy uploadPolicy) throws JUploadException {
        ImageIcon imageIcon = null;
        if (pictureFile != null) {
            BufferedImage tmpImage = null;
            try {
                if (pictureFile.canRead() && pictureFile.isFile() && ImageIO.getImageReaders(new FileImageInputStream(pictureFile)).hasNext()) {
                    tmpImage = ImageIO.read(pictureFile);
                }
            }
            catch (IOException e) {
                throw new JUploadIOException("An error occured while loading the image for " + pictureFile.getAbsolutePath(), e);
            }
            if (tmpImage != null) {
                double scaleHeight;
                double scaleWidth = (double)maxWidth / (double)tmpImage.getWidth();
                double scale = Math.min(scaleWidth, scaleHeight = (double)maxHeight / (double)tmpImage.getHeight());
                if (scale < 1.0) {
                    int width = (int)(scale * (double)tmpImage.getWidth());
                    int height = (int)(scale * (double)tmpImage.getHeight());
                    Image rescaledImage = tmpImage.getScaledInstance(width, height, 2);
                    BufferedImage tempBufferedImage = new BufferedImage(width, height, 4);
                    tempBufferedImage.getGraphics().drawImage(rescaledImage, 0, 0, null);
                    imageIcon = new ImageIcon(tempBufferedImage);
                    uploadPolicy.displayDebug("Icon generated (witdh=" + imageIcon.getIconWidth() + ", imageheight=" + imageIcon.getIconHeight() + ")", 80);
                }
                tmpImage.flush();
                tmpImage = null;
                PictureFileData.freeMemory("PictureFileData.getImageIcon()", uploadPolicy);
            }
        }
        return imageIcon;
    }

    public static boolean isFileAPicture(File file) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(DefaultFileData.getExtension(file.getName()).toLowerCase());
        return iter.hasNext();
    }
}

