/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel.treeview;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.filepanel.FilePanelFlatDataModel2;
import wjhk.jupload2.gui.filepanel.treeview.FileDataNode;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeNode;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTableModel;
import wjhk.jupload2.gui.filepanel.treeview.TreeFileDataNode;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderNode
implements TreeFileDataNode {
    MyTreeTableModel<TreeFileDataNode> treeModel = null;
    FilePanelFlatDataModel2 flatModel = null;
    File file = null;
    TreeFileDataNode parent = null;
    List<TreeFileDataNode> children = null;
    Date fileModified;
    boolean uploadFlag = true;
    UploadPolicy uploadPolicy = null;

    public static String getFilename(File file) {
        String filename = file.getName();
        try {
            filename = filename.equals("") ? file.getCanonicalPath() : filename;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage() + " exception, when trying to resolve the canonical path for " + file.getAbsolutePath(), e);
        }
        return filename;
    }

    public static String getAbsolutePath(TreeFileDataNode node) {
        StringBuffer sb = new StringBuffer();
        int depth = 0;
        for (Object o : node.getTreePath().getPath()) {
            String oName = o.toString();
            sb.append(oName);
            if (depth == 1 && oName.substring(1, 2).equals(":")) {
                sb.setLength(0);
                sb.append(oName);
            } else if (o != node) {
                sb.append(File.separator);
            }
            ++depth;
        }
        return sb.toString();
    }

    public static int[] getIntArray(int ... indexOf) {
        int[] ints = new int[indexOf.length];
        for (int i = 0; i < indexOf.length; ++i) {
            ints[i] = indexOf[i];
        }
        return ints;
    }

    public static TreeFileDataNode[] getItemArray(TreeFileDataNode ... child) {
        TreeFileDataNode[] treeNodes = (TreeFileDataNode[])Array.newInstance(TreeFileDataNode.class, child.length);
        for (int i = 0; i < child.length; ++i) {
            treeNodes[i] = child[i];
        }
        return treeNodes;
    }

    protected FolderNode(UploadPolicy uploadPolicy, MyTreeTableModel<TreeFileDataNode> model, FilePanelFlatDataModel2 flatModel) {
        this.uploadPolicy = uploadPolicy;
        this.treeModel = model;
        this.flatModel = flatModel;
        this.children = new ArrayList<TreeFileDataNode>();
    }

    public FolderNode(File file, UploadPolicy uploadPolicy, MyTreeTableModel<TreeFileDataNode> model, FilePanelFlatDataModel2 flatModel) {
        this(uploadPolicy, model, flatModel);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Internal error: " + file.getAbsolutePath() + " should be a folder");
        }
        this.file = file;
    }

    @Override
    public int getTotalChildCount() {
        int total = 0;
        for (TreeFileDataNode child : this.children) {
            total += 1 + child.getTotalChildCount();
        }
        return total;
    }

    @Override
    public List<MyTreeNode> getChildren() {
        return this.children;
    }

    @Override
    public void appendFileProperties(ByteArrayEncoder bae, int index) throws JUploadIOException {
        throw new IllegalAccessError("Internal error: appendFileProperties should not be called from " + this.getClass().getName());
    }

    @Override
    public void beforeUpload(String uploadPathRoot) throws JUploadException {
        throw new IllegalAccessError("Internal error: beforeUpload should not be called from " + this.getClass().getName());
    }

    @Override
    public long getUploadLength() {
        throw new IllegalAccessError("Internal error: getUploadLength should not be called from " + this.getClass().getName());
    }

    @Override
    public void afterUpload() {
        throw new IllegalAccessError("Internal error: afterUpload should not be called from " + this.getClass().getName());
    }

    @Override
    public InputStream getInputStream() throws JUploadException {
        throw new IllegalAccessError("Internal error: getInputStream should not be called from " + this.getClass().getName());
    }

    @Override
    public String getFileName() {
        return FolderNode.getFilename(this.file);
    }

    @Override
    public String getFileExtension() {
        throw new IllegalAccessError("Internal error: getFileExtension should not be called from " + this.getClass().getName());
    }

    @Override
    public long getFileLength() {
        return -1L;
    }

    @Override
    public Date getLastModified() {
        if (this.fileModified == null) {
            this.fileModified = new Date(this.file.lastModified());
        }
        return this.fileModified;
    }

    @Override
    public boolean getUploadFlag() {
        return this.uploadFlag;
    }

    @Override
    public void setUploadFlag(boolean uploadFlag) {
        if (this.uploadFlag != uploadFlag) {
            this.uploadFlag = uploadFlag;
            for (TreeFileDataNode tfdn : this.children) {
                tfdn.setUploadFlag(uploadFlag);
            }
            if (this.getParent() == null) {
                this.treeModel.fireTreeNodesChanged(this, null, null, null);
            } else {
                this.treeModel.fireTreeNodesChanged(this, this.treeModel.getTreePath((TreeFileDataNode)this.getParent()), FolderNode.getIntArray(this.getParent().getChildren().indexOf(this)), FolderNode.getItemArray(this));
            }
        }
    }

    @Override
    public String getDirectory() {
        return this.file.getAbsoluteFile().getParent();
    }

    @Override
    public String getMD5() throws JUploadException {
        throw new IllegalAccessError("Internal error: getMD5 should not be called from " + this.getClass().getName());
    }

    @Override
    public String getMimeType() {
        throw new IllegalAccessError("Internal error: getMimeType should not be called from " + this.getClass().getName());
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    protected File getFile() {
        throw new IllegalAccessError("Internal error: getFile is deprecated and should not be called from " + this.getClass().getName());
    }

    @Override
    public String getRelativeDir() {
        throw new IllegalAccessError("Internal error: getRelativeDir should not be called from " + this.getClass().getName());
    }

    @Override
    public String getAbsolutePath() {
        return FolderNode.getAbsolutePath(this);
    }

    @Override
    public boolean isPreparedForUpload() {
        throw new IllegalAccessError("Internal error: isPreparedForUpload should not be called from " + this.getClass().getName());
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public TreeFileDataNode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    @Override
    public TreeFileDataNode getChild(String name) {
        for (TreeFileDataNode node : this.children) {
            if (!node.getFileName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public TreeFileDataNode getChild(File file) {
        return this.getChild(FolderNode.getFilename(file));
    }

    @Override
    public MyTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MyTreeNode parent) {
        this.parent = (TreeFileDataNode)parent;
    }

    @Override
    public void setTreeModel(TreeModel model) {
        this.treeModel = (MyTreeTableModel)model;
    }

    @Override
    public void setFlatModel(FilePanelFlatDataModel2 flatModel) {
        this.flatModel = flatModel;
    }

    @Override
    public void removeChild(MyTreeNode child) {
        if (!this.children.remove(child)) {
            throw new IllegalArgumentException(child.toString() + " is not a child of " + this.getFileName());
        }
        child.setParent(null);
        child.setTreeModel(null);
        child.setFlatModel(null);
        while (child.getChildCount() > 0) {
            ((FolderNode)child).removeChild(child.getChild(0));
        }
    }

    public TreeFileDataNode addChild(FileData fileData) {
        return this.addChild(new FileDataNode(fileData));
    }

    public TreeFileDataNode addChild(TreeFileDataNode child) {
        TreeFileDataNode alreadyExistingChild = this.getChild(child.getFileName());
        if (alreadyExistingChild == null) {
            this.children.add(child);
            child.setTreeModel(this.treeModel);
            child.setParent(this);
            this.treeModel.fireTreeNodesInserted(this, this.treeModel.getTreePath(this), FolderNode.getIntArray(this.children.indexOf(child)), FolderNode.getItemArray(child));
            return child;
        }
        this.uploadPolicy.displayWarn("The FileData for " + child.getAbsolutePath() + " already exists for the folder " + this.getFileName());
        return alreadyExistingChild;
    }

    public FolderNode getSubfolderOrCreateIt(File file) throws JUploadExceptionStopAddingFiles {
        if (!file.isDirectory()) {
            throw new JUploadExceptionStopAddingFiles(file.getAbsolutePath() + " must be a directory");
        }
        TreeFileDataNode child = this.addChild(new FolderNode(file, this.uploadPolicy, this.treeModel, this.flatModel));
        if (!(child instanceof FolderNode)) {
            throw new JUploadExceptionStopAddingFiles("A child with the same name (" + file.getName() + ") already exists, but is not a folder");
        }
        return (FolderNode)child;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return this.getFileName();
    }

    @Override
    public TreeFileDataNode getTreeFileDataNode() {
        return this;
    }

    @Override
    public void setTreeFileDataNode(TreeFileDataNode node) {
        throw new IllegalStateException("setTreeFileDataNode may not be called againts a FolderNode");
    }

    @Override
    public TreePath getTreePath() {
        if (this.parent == null) {
            return new TreePath(this);
        }
        return this.parent.getTreePath().pathByAddingChild(this);
    }

    public TreeFileDataNode addChild(File f) throws JUploadExceptionStopAddingFiles {
        if (this.getChild(f) != null) {
            throw new JUploadExceptionStopAddingFiles("Internal error: " + f.getAbsolutePath() + " is already a child of the node for " + this.file.getAbsolutePath());
        }
        if (f.isDirectory()) {
            return this.addChild(new FolderNode(f, this.uploadPolicy, this.treeModel, this.flatModel));
        }
        FileData fd = this.flatModel.addFile(f);
        return this.addChild(new FileDataNode(fd));
    }

    public int addChildAndDescendants(File f) throws JUploadExceptionStopAddingFiles {
        int nbFiles = 0;
        TreeFileDataNode child = this.getChild(f);
        if (child == null) {
            if (f.isDirectory()) {
                child = this.addChild(f);
            } else {
                FileData fd = this.flatModel.addFile(f);
                if (fd != null) {
                    child = this.addChild(new FileDataNode(fd));
                    fd.setTreeFileDataNode(child);
                    ++nbFiles;
                }
            }
        }
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                nbFiles += ((FolderNode)child).addChildAndDescendants(file);
            }
        }
        return nbFiles;
    }

    public List<FileData> getTotalFileDataChildren() {
        ArrayList<FileData> files = new ArrayList<FileData>();
        for (MyTreeNode tfdn : this.getChildren()) {
            if (tfdn instanceof FileDataNode) {
                files.add(((FileDataNode)tfdn).getFileData());
                continue;
            }
            files.addAll(((FolderNode)tfdn).getTotalFileDataChildren());
        }
        return files;
    }
}

