/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel.treeview;

import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import wjhk.jupload2.gui.filepanel.treeview.FolderNode;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeNode;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTableCellRenderer;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTableModel;
import wjhk.jupload2.policies.UploadPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyAbstractTreeTableModel<T extends MyTreeNode>
implements MyTreeTableModel<T> {
    UploadPolicy uploadPolicy = null;
    MyTreeTableCellRenderer tree = null;
    protected T absoluteRoot = null;
    protected T visibleRoot;
    protected EventListenerList listenerList = new EventListenerList();
    private static final int CHANGED = 0;
    private static final int INSERTED = 1;
    private static final int REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;

    public MyAbstractTreeTableModel(UploadPolicy uploadPolicy, T root) {
        this.uploadPolicy = uploadPolicy;
        this.absoluteRoot = root;
        this.visibleRoot = root;
        this.absoluteRoot.setTreeModel(this);
        this.visibleRoot.setTreeModel(this);
    }

    public MyTreeTableCellRenderer getTree() {
        return this.tree;
    }

    @Override
    public void setTree(MyTreeTableCellRenderer tree) {
        this.tree = tree;
    }

    public T getAbsoluteRoot() {
        return this.absoluteRoot;
    }

    @Override
    public T getRoot() {
        return this.visibleRoot;
    }

    @Override
    public synchronized void setRoot(T root) {
        this.uploadPolicy.displayInfo("Setting visible Root to file " + root.toString());
        this.visibleRoot = root;
        this.reload();
    }

    @Override
    public synchronized void remove(T item) {
        this.remove(item, true);
    }

    @Override
    public synchronized void removeAndClean(T item) {
        this.removeAndClean(item, true);
    }

    synchronized void remove(T item, boolean callReloadAfterRemoval) {
        FolderNode parent;
        if (item == this.absoluteRoot) {
            throw new IllegalArgumentException("The absoluteRoot may not be removed");
        }
        if (item == this.visibleRoot) {
            this.setRoot(this.visibleRoot.getParent());
        }
        if ((parent = (FolderNode)item.getParent()) != null) {
            parent.removeChild((MyTreeNode)item);
            if (callReloadAfterRemoval) {
                this.reload();
            }
        }
    }

    synchronized void removeAndClean(T item, boolean callReloadAfterRemoval) {
        if (item == this.absoluteRoot) {
            throw new IllegalArgumentException("The absoluteRoot may not be removed");
        }
        if (item == this.visibleRoot) {
            this.setRoot(this.visibleRoot.getParent());
        }
        MyTreeNode parentNode = item.getParent();
        this.remove(item, false);
        if (parentNode.getChildCount() == 0) {
            this.removeAndClean(parentNode, false);
        } else if (callReloadAfterRemoval) {
            this.reload();
        }
    }

    @Override
    public TreePath getTreePath(T item) {
        if (item == null) {
            return null;
        }
        if (item == this.absoluteRoot) {
            return new TreePath(this.absoluteRoot);
        }
        if (item.getParent() == null) {
            throw new IllegalArgumentException("Root not found for node " + item);
        }
        return this.getTreePath(item.getParent()).pathByAddingChild(item);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireTreeNode(int changeType, Object source, TreePath path, int[] childIndices, T[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, (Object[])children);
        block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            switch (changeType) {
                case 0: {
                    ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
                    continue block6;
                }
                case 1: {
                    ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
                    continue block6;
                }
                case 2: {
                    ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
                    continue block6;
                }
                case 3: {
                    ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
                    continue block6;
                }
            }
        }
    }

    @Override
    public synchronized boolean cleanHierarchy() {
        return this.cleanHierarchy(this.absoluteRoot, true);
    }

    public synchronized boolean cleanHierarchy(T node) {
        return this.cleanHierarchy(node, true);
    }

    private synchronized boolean cleanHierarchy(T node, boolean callReloadAfterRemoval) {
        boolean ret = false;
        if (node != null && node.getChildren().size() > 0) {
            ArrayList<MyTreeNode> children = new ArrayList<MyTreeNode>();
            for (MyTreeNode child : node.getChildren()) {
                children.add(child);
            }
            for (MyTreeNode child : children) {
                if (this.cleanHierarchy(child, false)) {
                    ret = true;
                }
                if (child.isLeaf() || child.getChildCount() != 0) continue;
                node.removeChild(child);
                ret = true;
            }
        }
        if (ret && callReloadAfterRemoval) {
            this.reload();
        }
        return ret;
    }

    @Override
    public synchronized void reload() {
        this.reload(this.visibleRoot);
    }

    @Override
    public synchronized void reload(T node) {
        int n = this.getChildCount(node);
        int[] childIdx = new int[n];
        MyTreeNode[] children = (MyTreeNode[])Array.newInstance(MyTreeNode.class, n);
        for (int i = 0; i < n; ++i) {
            childIdx[i] = i;
            children[i] = this.getChild(node, i);
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot((MyTreeNode)node), childIdx, children);
    }

    private TreePath getPathToRoot(MyTreeNode node) {
        if (node == this.visibleRoot) {
            return new TreePath(this.visibleRoot);
        }
        if (node == this.absoluteRoot) {
            throw new IllegalArgumentException("The visibleRoot is not an ancestror of the given node");
        }
        MyTreeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return this.getPathToRoot(parent).pathByAddingChild(node);
    }

    @Override
    public void fireTreeNodesChanged(Object source, TreePath path, int[] childIndices, T[] children) {
        this.fireTreeNode(0, source, path, childIndices, (MyTreeNode[])children);
    }

    @Override
    public void fireTreeNodesInserted(Object source, TreePath path, int[] childIndices, T[] children) {
        this.fireTreeNode(1, source, path, childIndices, (MyTreeNode[])children);
    }

    @Override
    public void fireTreeNodesRemoved(Object source, TreePath path, int[] childIndices, T[] children) {
        this.fireTreeNode(2, source, path, childIndices, (MyTreeNode[])children);
    }

    @Override
    public void fireTreeStructureChanged(Object source, TreePath path, int[] childIndices, T[] children) {
        this.fireTreeNode(3, source, path, childIndices, (MyTreeNode[])children);
    }

    public final T getChild(Object parent, int index) {
        return (T)((MyTreeNode)parent).getChild(index);
    }

    @Override
    public final int getChildCount(Object child) {
        return ((MyTreeNode)child).getChildCount();
    }

    @Override
    public final boolean isLeaf(Object node) {
        return ((MyTreeNode)node).isLeaf();
    }

    @Override
    public final void valueForPathChanged(TreePath path, Object newValue) {
        this.uploadPolicy.displayErr("The method MyAbstractTreeTableModel.valueForPathChanged should not be called");
    }

    @Override
    public final int getIndexOfChild(Object parent, Object child) {
        return ((MyTreeNode)parent).getChildren().indexOf((MyTreeNode)child);
    }

    @Override
    public abstract Object getValueAt(T var1, int var2);
}

