/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.OutputStream;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.exception.JUploadInterrupted;
import wjhk.jupload2.gui.DialogUploadRetry;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultFileUploadThread
extends Thread
implements FileUploadThread {
    BlockingQueue<UploadFilePacket> packetQueue = null;
    FileUploadManagerThread fileUploadManagerThread = null;
    protected UploadPolicy uploadPolicy = null;
    long maxChunkSize;
    static boolean sendResumableError = false;
    int nbRetry = 0;
    protected String responseMsg = "";
    protected String responseBody = "";

    public DefaultFileUploadThread(String threadName, BlockingQueue<UploadFilePacket> packetQueue, UploadPolicy uploadPolicy, FileUploadManagerThread fileUploadManagerThread) {
        super(threadName);
        this.packetQueue = packetQueue;
        this.uploadPolicy = uploadPolicy;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        this.uploadPolicy.displayDebug("DefaultFileUploadThread created", 30);
    }

    abstract long getAdditionnalBytesForUpload(UploadFileData var1) throws JUploadIOException;

    abstract void beforeRequest(UploadFilePacket var1) throws JUploadException;

    abstract void startRequest(long var1, boolean var3, int var4, boolean var5) throws JUploadException;

    abstract int finishRequest() throws JUploadException;

    abstract void interruptionReceived();

    abstract void beforeFile(UploadFilePacket var1, UploadFileData var2) throws JUploadException;

    abstract void afterFile(UploadFileData var1) throws JUploadException;

    abstract void cleanRequest() throws JUploadException;

    abstract void cleanAll() throws JUploadException;

    abstract OutputStream getOutputStream() throws JUploadException;

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String getResponseMsg() {
        return this.responseMsg;
    }

    @Override
    public BlockingQueue<UploadFilePacket> getPacketQueue() {
        return this.packetQueue;
    }

    void setResponseBody(String body) {
        this.responseBody = this.normalizeCRLF(body);
    }

    void setResponseMsg(String msg) {
        this.responseMsg = this.normalizeCRLF(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        this.uploadPolicy.displayDebug("Start of the FileUploadThread", 5);
        nbSentFiles = 0;
        while (!this.fileUploadManagerThread.isUploadFinished()) {
            block25: {
                packet = null;
                try {
                    block26: {
                        packet = this.packetQueue.take();
                        if (!packet.isPoisonned()) break block26;
                        var5_8 = null;
                        ** GOTO lbl84
                    }
                    this.nbRetry = 0;
                    while (true) {
                        try {
                            this.doUpload(packet);
                        }
                        catch (JUploadException jue) {
                            this.manageRetry(jue);
                            ++this.nbRetry;
                            this.beforeRetry(packet);
                            continue;
                        }
                        break;
                    }
                    this.uploadPolicy.displayDebug("After do upload", 50);
                    ** GOTO lbl94
                }
                catch (InterruptedException e) {
                    this.uploadPolicy.displayWarn(this.getClass().getName() + ".run(): received in " + e.getClass().getName() + ", exiting...");
                    var5_8 = null;
                    for (UploadFileData uploadFileData : packet) {
                        if (!uploadFileData.isPreparedForUpload()) continue;
                        uploadFileData.afterUpload();
                    }
                    try {
                        this.cleanAll();
                    }
                    catch (Exception e) {
                        this.uploadPolicy.displayWarn("[run(), After cleanAll] Ignoring " + e.getClass().getName() + " because upload is finished");
                    }
                    break;
                }
                catch (JUploadException e) {
                    if (this.fileUploadManagerThread.isUploadFinished()) {
                        this.uploadPolicy.displayWarn("Ignoring " + e.getClass().getName() + " because upload is finished");
                    } else {
                        this.fileUploadManagerThread.setUploadException(e);
                    }
                    var5_8 = null;
                    for (UploadFileData uploadFileData : packet) {
                        if (!uploadFileData.isPreparedForUpload()) continue;
                        uploadFileData.afterUpload();
                    }
                    ** try [egrp 3[TRYBLOCK] [13 : 324->331)] { 
lbl51:
                    // 1 sources

                    this.cleanAll();
lbl53:
                    // 1 sources

                    catch (Exception e) {
                        this.uploadPolicy.displayWarn("[run(), After cleanAll] Ignoring " + e.getClass().getName() + " because upload is finished");
                    }
                    break block25;
                }
                catch (JUploadInterrupted e) {
                    this.uploadPolicy.displayInfo("Upload stopped by the user");
                    this.uploadPolicy.displayDebug(e.getMessage(), 30);
                    var5_8 = null;
                    for (UploadFileData uploadFileData : packet) {
                        if (!uploadFileData.isPreparedForUpload()) continue;
                        uploadFileData.afterUpload();
                    }
                    ** try [egrp 3[TRYBLOCK] [13 : 324->331)] { 
lbl66:
                    // 1 sources

                    this.cleanAll();
lbl68:
                    // 1 sources

                    catch (Exception e) {
                        this.uploadPolicy.displayWarn("[run(), After cleanAll] Ignoring " + e.getClass().getName() + " because upload is finished");
                    }
                    break block25;
                }
                {
                    catch (Throwable var4_11) {
                        var5_8 = null;
                        for (UploadFileData uploadFileData : packet) {
                            if (!uploadFileData.isPreparedForUpload()) continue;
                            uploadFileData.afterUpload();
                        }
                        ** try [egrp 3[TRYBLOCK] [13 : 324->331)] { 
lbl79:
                        // 1 sources

                        this.cleanAll();
                        throw var4_11;
lbl81:
                        // 1 sources

                        catch (Exception e) {
                            this.uploadPolicy.displayWarn("[run(), After cleanAll] Ignoring " + e.getClass().getName() + " because upload is finished");
                        }
                        throw var4_11;
                    }
lbl84:
                    // 3 sources

                    for (UploadFileData uploadFileData : packet) {
                        if (!uploadFileData.isPreparedForUpload()) continue;
                        uploadFileData.afterUpload();
                    }
                    ** try [egrp 3[TRYBLOCK] [13 : 324->331)] { 
lbl89:
                    // 1 sources

                    this.cleanAll();
lbl91:
                    // 1 sources

                    catch (Exception e) {
                        this.uploadPolicy.displayWarn("[run(), After cleanAll] Ignoring " + e.getClass().getName() + " because upload is finished");
                    }
                    break;
lbl94:
                    // 1 sources

                    var5_8 = null;
                    for (UploadFileData uploadFileData : packet) {
                        if (!uploadFileData.isPreparedForUpload()) continue;
                        uploadFileData.afterUpload();
                    }
                    ** try [egrp 3[TRYBLOCK] [13 : 324->331)] { 
lbl100:
                    // 1 sources

                    this.cleanAll();
lbl102:
                    // 1 sources

                    catch (Exception e) {}
                    this.uploadPolicy.displayWarn("[run(), After cleanAll] Ignoring " + e.getClass().getName() + " because upload is finished");
                }
            }
            nbSentFiles += packet.size();
        }
        this.uploadPolicy.displayDebug("End of the FileUploadThread (" + nbSentFiles + " have been sent)", 5);
    }

    private void manageRetry(JUploadException jue) throws JUploadException {
        String exceptionCauseClass = jue.getCause() == null ? "no exception cause" : jue.getCause().getClass().getName();
        String errMsg = jue.getClass().getName() + " (" + jue.getMessage() + "), caused by: " + exceptionCauseClass;
        if (this.fileUploadManagerThread.isUploadFinished()) {
            this.uploadPolicy.displayWarn("The following error occurs, but the upload is stopped, ignoring it ]" + errMsg + "]");
            throw jue;
        }
        if (jue.getCause() instanceof SocketException) {
            this.uploadPolicy.displayWarn("A 'resumable' error occurred: " + errMsg);
            if (this.nbRetry >= this.uploadPolicy.getRetryMaxNumberOf()) {
                this.uploadPolicy.displayWarn("Too much retries (" + this.nbRetry + "), exiting...");
                throw jue;
            }
            DialogUploadRetry dialogUploadRetry = new DialogUploadRetry(this.uploadPolicy.getContext().getFrame(), jue, this.nbRetry, this.uploadPolicy);
            if (!dialogUploadRetry.isRetryValidated()) {
                this.uploadPolicy.displayDebug("The user refuses to retry the upload, exiting...", 30);
                throw jue;
            }
        } else {
            this.uploadPolicy.displayWarn("Non resumable error occured, exiting...");
            throw jue;
        }
        this.uploadPolicy.displayDebug("The user (or the timer) choosed to retry the upload", 30);
    }

    void doUpload(UploadFilePacket packet) throws JUploadException, JUploadInterrupted {
        boolean bChunkEnabled = false;
        long totalContentLength = 0L;
        long totalFileLength = 0L;
        this.fileUploadManagerThread.setUploadStatus(packet, (UploadFileData)packet.get(0), 2);
        this.beforeRequest(packet);
        for (UploadFileData uploadFileData : packet) {
            if (this.fileUploadManagerThread.isUploadFinished()) {
                return;
            }
            totalContentLength += uploadFileData.getUploadLength();
            totalContentLength += this.getAdditionnalBytesForUpload(uploadFileData);
            totalFileLength += uploadFileData.getUploadLength();
            this.uploadPolicy.displayDebug("file " + uploadFileData.getFileName() + ": content=" + uploadFileData.getUploadLength() + " bytes, getAdditionnalBytesForUpload=" + this.getAdditionnalBytesForUpload(uploadFileData) + " bytes", 50);
        }
        if (totalFileLength >= this.maxChunkSize) {
            if (packet.size() > 1) {
                this.fileUploadManagerThread.setUploadException(new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should be 1 (doUpload)"));
            }
            bChunkEnabled = true;
        }
        if (bChunkEnabled) {
            if (packet.size() > 1) {
                throw new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should not be more than 1 (doUpload)");
            }
            this.doChunkedUpload(packet);
        } else {
            this.doNonChunkedUpload(packet, totalContentLength, totalFileLength);
        }
        if (this.fileUploadManagerThread.getUploadException() == null && !this.fileUploadManagerThread.isUploadStopped()) {
            this.fileUploadManagerThread.currentRequestIsFinished(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doChunkedUpload(UploadFilePacket packet) throws JUploadException, JUploadInterrupted {
        boolean bLastChunk = false;
        int chunkPart = 0;
        long contentLength = 0L;
        long thisChunkSize = 0L;
        if (packet.size() > 1) {
            throw new JUploadException("doChunkedUpload called with a packet of more than 1 file (" + packet.size() + " files)");
        }
        UploadFileData uploadFileData = (UploadFileData)packet.get(0);
        while (!bLastChunk && !this.fileUploadManagerThread.isUploadFinished()) {
            Object var11_8;
            bLastChunk = uploadFileData.getRemainingLength() <= this.maxChunkSize;
            thisChunkSize = bLastChunk ? uploadFileData.getRemainingLength() : this.maxChunkSize;
            contentLength = thisChunkSize + this.getAdditionnalBytesForUpload(uploadFileData);
            this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 2);
            this.startRequest(contentLength, true, ++chunkPart, bLastChunk);
            try {
                this.beforeFile(packet, uploadFileData);
                uploadFileData.uploadFile(this.getOutputStream(), thisChunkSize);
                if (chunkPart == 2 && sendResumableError) {
                    sendResumableError = false;
                    throw new JUploadException(new SocketException("This is a debug error. Should not happen in production."));
                }
                if (bLastChunk && uploadFileData.getRemainingLength() > 0L) {
                    throw new JUploadExceptionUploadFailed("Files has not be entirely uploaded. The remaining size is " + uploadFileData.getRemainingLength() + " bytes. File size was: " + uploadFileData.getUploadLength() + " bytes.");
                }
                this.afterFile(uploadFileData);
                int status = this.finishRequest();
                if (bLastChunk) {
                    this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 4);
                } else {
                    this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 3);
                }
                this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
                var11_8 = null;
            }
            catch (Throwable throwable) {
                var11_8 = null;
                this.cleanRequest();
                throw throwable;
            }
            this.cleanRequest();
            {
            }
        }
        this.fileUploadManagerThread.anotherFileHasBeenSent(packet, uploadFileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doNonChunkedUpload(UploadFilePacket packet, long totalContentLength, long totalFileLength) throws JUploadException, JUploadInterrupted {
        this.startRequest(totalContentLength, false, 0, true);
        try {
            for (UploadFileData uploadFileData : packet) {
                if (this.fileUploadManagerThread.isUploadFinished()) break;
                this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 2);
                this.beforeFile(packet, uploadFileData);
                if (!this.fileUploadManagerThread.isUploadFinished()) {
                    uploadFileData.uploadFile(this.getOutputStream(), uploadFileData.getUploadLength());
                }
                if (this.fileUploadManagerThread.isUploadFinished()) continue;
                this.afterFile(uploadFileData);
                this.fileUploadManagerThread.anotherFileHasBeenSent(packet, uploadFileData);
            }
            if (!this.fileUploadManagerThread.isUploadFinished()) {
                this.fileUploadManagerThread.setUploadStatus(packet, (UploadFileData)packet.get(packet.size() - 1), 4);
                int status = this.finishRequest();
                this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.cleanRequest();
            throw throwable;
        }
        this.cleanRequest();
    }

    private void beforeRetry(UploadFilePacket packet) throws JUploadException {
        if (packet != null) {
            for (UploadFileData uploadFileData : packet) {
                if (!uploadFileData.isPreparedForUpload()) continue;
                uploadFileData.beforeRetry();
            }
        }
    }

    @Override
    public void close() {
        try {
            this.cleanAll();
        }
        catch (JUploadException e) {
            this.uploadPolicy.displayErr(e);
        }
    }

    public final String normalizeCRLF(String s) {
        Pattern p = Pattern.compile("\\r\\n|\\r|\\n", 8);
        String[] lines = p.split(s);
        StringBuffer sb = new StringBuffer(s.length() * 2);
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]).append("\r\n");
        }
        return sb.toString();
    }

    public final String quoteCRLF(String s) {
        return s.replaceAll("\r\n", "\\\\r\\\\n\n");
    }

    @Override
    public void setFileUploadThreadManager(FileUploadManagerThread fileUploadManagerThread) throws JUploadException {
        if (this.fileUploadManagerThread != null) {
            throw new JUploadException("Can not override fileUploadManagerThread (in DefaultFileUpload.setFileUploadThreadManager()");
        }
        this.fileUploadManagerThread = fileUploadManagerThread;
    }
}

