/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.swing.JProgressBar;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFileDataPoisonned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePreparationThread
extends Thread {
    List<FileData> fileDataArray = null;
    int nbPreparedFiles = 0;
    int nbFilesToPrepare = -1;
    int nbFilesToSend = 0;
    long nbTotalNumberOfPreparedBytes = 0L;
    JProgressBar preparationProgressBar = null;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;
    FileUploadManagerThread fileUploadManagerThread = null;
    FilePanel filePanel = null;
    BlockingQueue<UploadFileData> preparedFileQueue = null;

    public FilePreparationThread(BlockingQueue<UploadFileData> preparedFileQueue, FileUploadManagerThread fileUploadManagerThread, UploadPolicy uploadPolicy) {
        super("FilePreparationThread");
        this.preparedFileQueue = preparedFileQueue;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPolicy.getContext().getUploadPanel();
        this.filePanel = this.uploadPanel.getFilePanel();
        this.preparationProgressBar = this.uploadPanel.getPreparationProgressBar();
        this.filePanel.removeFileNotToUpload();
        this.fileDataArray = new ArrayList<FileData>(this.filePanel.getFiles().size());
        for (FileData fd : this.filePanel.getFiles()) {
            if (!fd.getUploadFlag()) continue;
            this.fileDataArray.add(fd);
        }
        this.nbFilesToSend = this.fileDataArray.size();
        this.uploadPolicy.displayDebug("Nb files to send: " + this.nbFilesToSend, 20);
        this.preparationProgressBar.setMaximum(100 * this.nbFilesToSend);
    }

    @Override
    public final void run() {
        String uploadFileRoot;
        File fileRoot = DefaultFileData.getRoot(this.fileDataArray);
        String string = uploadFileRoot = fileRoot == null ? "" : fileRoot.getAbsolutePath();
        if (this.fileDataArray.size() != this.nbFilesToSend) {
            this.uploadPolicy.displayWarn(this.fileDataArray.size() + " files to prepare, but there are " + this.nbFilesToSend + " files to send!");
        }
        int numFileInCurrentUpload = 0;
        for (int i = 0; i < this.fileDataArray.size() && !this.fileUploadManagerThread.isUploadFinished(); ++i) {
            try {
                this.uploadPolicy.displayDebug("============== Start of file preparation (" + this.fileDataArray.get(i).getFileName() + ")", 30);
                UploadFileData uploadFileData = new UploadFileData(this.fileDataArray.get(i), numFileInCurrentUpload, this.fileUploadManagerThread, this.uploadPolicy);
                this.preparationProgressBar.setString(this.uploadPolicy.getLocalizedString("preparingFile", i + 1, this.fileDataArray.size()));
                this.preparationProgressBar.repaint(0L);
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".prepareFiles(): before call to beforeUpload()", 100);
                try {
                    uploadFileData.beforeUpload(uploadFileRoot);
                    ++numFileInCurrentUpload;
                    this.uploadPolicy.displayDebug("============== End of file preparation (" + uploadFileData.getFileName() + ")", 30);
                    try {
                        this.anotherFileIsPrepared(uploadFileData);
                    }
                    catch (InterruptedException e) {
                        --i;
                    }
                }
                catch (JUploadException e) {
                    --this.nbFilesToPrepare;
                    this.uploadPolicy.displayErr(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    --this.nbFilesToPrepare;
                    String msg = "An exception " + e.getClass().getName() + " occured during file preparation for file " + this.fileDataArray.get(i).getAbsolutePath() + ". This file will not be uploaded.";
                    this.uploadPolicy.displayErr(msg);
                    throw new JUploadException(msg, e);
                }
                this.preparationProgressBar.setValue(this.nbPreparedFiles * 100);
                this.preparationProgressBar.repaint();
                continue;
            }
            catch (JUploadException e) {
                this.fileUploadManagerThread.setUploadException(e);
            }
        }
        try {
            this.preparedFileQueue.put(new UploadFileDataPoisonned());
        }
        catch (InterruptedException e) {
            this.uploadPolicy.displayWarn("Got interrupted, while posting the poisoned UploadFileData on the preparedQueue!");
        }
        this.preparationProgressBar.setString("");
        this.uploadPolicy.displayDebug(this.nbPreparedFiles + " files has been prepared (for " + this.nbFilesToSend + " files to send)", 10);
    }

    private void anotherFileIsPrepared(UploadFileData newlyPreparedFileData) throws JUploadException, InterruptedException {
        ++this.nbPreparedFiles;
        this.nbTotalNumberOfPreparedBytes += newlyPreparedFileData.getUploadLength();
        this.preparedFileQueue.put(newlyPreparedFileData);
    }

    public double getTotalFileBytesToSend() {
        double totalFileBytesToSend = this.nbPreparedFiles == this.nbFilesToSend ? (double)this.nbTotalNumberOfPreparedBytes : (this.nbPreparedFiles == 0 ? 0.0 : (double)(this.nbTotalNumberOfPreparedBytes + (long)(this.fileDataArray.size() - this.nbPreparedFiles) * this.nbTotalNumberOfPreparedBytes / (long)this.nbPreparedFiles));
        return totalFileBytesToSend;
    }

    public int getNbPreparedFiles() {
        return this.nbPreparedFiles;
    }

    public int getNbFilesToSend() {
        return this.nbFilesToSend;
    }

    public long getNbTotalNumberOfPreparedBytes() {
        return this.nbTotalNumberOfPreparedBytes;
    }
}

