/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreePath;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionTooBigFile;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.filepanel.treeview.TreeFileDataNode;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileData
implements FileData {
    UploadPolicy uploadPolicy;
    boolean preparedForUpload = false;
    private static final int BUFLEN = 4096;
    protected String mimeType = "application/octet-stream";
    TreeFileDataNode treeFileDataNode = null;
    protected File file;
    protected long fileSize;
    protected String fileDir;
    protected String fileRoot = null;
    protected Date fileModified;
    protected boolean uploadFlag = true;
    protected String md5sum = null;
    protected Boolean canRead = null;

    public DefaultFileData(File file, UploadPolicy uploadPolicyParam) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Internal Error: DefaultFileData can't be created from a Directory. It needs a file");
        }
        uploadPolicyParam.displayDebug("Creation of the DefaultFileData for " + file.getAbsolutePath(), 10);
        this.file = file;
        this.uploadPolicy = uploadPolicyParam;
        this.fileSize = this.file.length();
        this.fileDir = this.file.getAbsoluteFile().getParent();
        this.fileModified = new Date(this.file.lastModified());
        this.mimeType = this.uploadPolicy.getContext().getMimeType(this.getFileExtension());
    }

    @Override
    public void appendFileProperties(ByteArrayEncoder bae, int index) throws JUploadIOException {
        bae.appendTextProperty("mimetype", this.getMimeType(), index);
        bae.appendTextProperty("pathinfo", this.getDirectory(), index);
        bae.appendTextProperty("relpathinfo", this.getRelativeDir(), index);
        SimpleDateFormat dateformat = new SimpleDateFormat(this.uploadPolicy.getDateFormat());
        String uploadFileModificationDate = dateformat.format(this.getLastModified());
        bae.appendTextProperty("filemodificationdate", uploadFileModificationDate, index);
    }

    @Override
    public synchronized void beforeUpload(String uploadFileRoot) throws JUploadException {
        if (this.preparedForUpload) {
            this.uploadPolicy.displayWarn("The file " + this.getFileName() + " is already prepared for upload");
        } else {
            this.preparedForUpload = true;
            this.fileRoot = uploadFileRoot;
            if (this.uploadPolicy.getSendMD5Sum()) {
                this.calculateMD5Sum();
            }
            if (this.getUploadLength() > this.uploadPolicy.getMaxFileSize()) {
                throw new JUploadExceptionTooBigFile(this.getFileName(), this.getUploadLength(), this.uploadPolicy);
            }
        }
    }

    @Override
    public long getUploadLength() {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        return this.fileSize;
    }

    @Override
    public synchronized void afterUpload() {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        this.md5sum = null;
        this.preparedForUpload = false;
    }

    @Override
    public synchronized InputStream getInputStream() throws JUploadException {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new JUploadIOException(e);
        }
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public String getFileExtension() {
        return DefaultFileData.getExtension(this.getFileName());
    }

    @Override
    public long getFileLength() {
        return this.fileSize;
    }

    @Override
    public Date getLastModified() {
        return this.fileModified;
    }

    @Override
    public String getDirectory() {
        return this.fileDir;
    }

    @Override
    public boolean getUploadFlag() {
        return this.uploadFlag;
    }

    @Override
    public void setUploadFlag(boolean uploadFlag) {
        this.uploadFlag = uploadFlag;
    }

    @Override
    public String getMD5() throws JUploadException {
        if (this.md5sum == null) {
            throw new JUploadException("The MD5Sum has not been calculated!");
        }
        return this.md5sum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void calculateMD5Sum() throws JUploadException {
        StringBuffer ret = new StringBuffer();
        MessageDigest digest = null;
        byte[] md5Buffer = new byte[4096];
        InputStream md5InputStream = this.getInputStream();
        try {
            try {
                int nbBytes;
                digest = MessageDigest.getInstance("MD5");
                while ((nbBytes = md5InputStream.read(md5Buffer, 0, 4096)) > 0) {
                    digest.update(md5Buffer, 0, nbBytes);
                }
                Object var8_6 = null;
            }
            catch (IOException e) {
                throw new JUploadIOException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new JUploadException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                md5InputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JUploadIOException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        md5InputStream.close();
        byte[] md5sum = new byte[32];
        if (digest != null) {
            md5sum = digest.digest();
        }
        int i = 0;
        while (true) {
            if (i >= md5sum.length) {
                this.md5sum = ret.toString();
                return;
            }
            ret.append(Integer.toHexString(md5sum[i] >> 4 & 0xF));
            ret.append(Integer.toHexString(md5sum[i] & 0xF));
            ++i;
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public boolean canRead() {
        if (this.canRead == null) {
            try {
                FileInputStream is = new FileInputStream(this.file);
                ((InputStream)is).close();
                this.canRead = true;
            }
            catch (IOException e) {
                this.canRead = false;
            }
        }
        return this.canRead;
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public String getRelativeDir() {
        String ret = "";
        switch (this.uploadPolicy.getFileListViewMode()) {
            case FLAT: 
            case TREE_VIEW: {
                if (null == this.fileRoot || this.fileRoot.equals("")) {
                    ret = this.fileDir;
                    break;
                }
                if (this.fileDir.startsWith(this.fileRoot)) {
                    int skip = this.fileRoot.length();
                    if (this.fileRoot.endsWith(File.separator)) {
                        ++skip;
                    }
                    if (skip < 0 || skip >= this.fileDir.length()) break;
                    ret = this.fileDir.substring(skip);
                    break;
                }
                throw new IllegalStateException("Root (" + this.fileRoot + ") is not part of current path (" + this.fileDir + ")");
            }
            case INDEPENDENT_TREE_VIEW: {
                TreePath treePath = this.treeFileDataNode.getTreePath();
                for (int i = 0; i < treePath.getPathCount() - 1; ++i) {
                    String nodeName = ((TreeFileDataNode)treePath.getPathComponent(i)).toString();
                    if (nodeName.equals("")) continue;
                    ret = ret + (ret.equals("") ? "" : "/") + nodeName;
                }
                break;
            }
        }
        return ret;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public static String getExtension(String filename) {
        return filename.substring(filename.lastIndexOf(46) + 1);
    }

    public static File getRoot(List<? extends FileData> rows) {
        File root = ((DefaultFileData)rows.get((int)0)).file;
        if (root.isDirectory()) {
            root = root.getParentFile();
        }
        while (root != null && !root.isDirectory()) {
            root = root.getParentFile();
        }
        if (root != null) {
            String pathRoot = root.getAbsolutePath() + File.separator;
            for (int i = 1; i < rows.size() && root != null; ++i) {
                if (!rows.get(i).getUploadFlag()) continue;
                File pathCurrentFileParent = ((DefaultFileData)rows.get((int)i)).file;
                String pathCurrentFileParentPath = pathCurrentFileParent.getAbsolutePath() + File.separator;
                do {
                    String string = pathCurrentFileParentPath = (pathCurrentFileParent = pathCurrentFileParent.getParentFile()) == null ? "" : pathCurrentFileParent.getAbsolutePath() + File.separator;
                } while (pathCurrentFileParent != null && !pathRoot.startsWith(pathCurrentFileParentPath));
                root = pathCurrentFileParent;
                pathRoot = pathCurrentFileParentPath;
            }
            root = pathRoot.equals("") ? null : new File(pathRoot);
        }
        return root;
    }

    @Override
    public boolean isPreparedForUpload() {
        return this.preparedForUpload;
    }

    @Override
    public TreeFileDataNode getTreeFileDataNode() {
        return this.treeFileDataNode;
    }

    @Override
    public void setTreeFileDataNode(TreeFileDataNode treeFileDataNode) {
        this.treeFileDataNode = treeFileDataNode;
    }
}

