/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.filepanel.ColumnComparator;
import wjhk.jupload2.policies.UploadPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePanelFlatDataModel2
extends AbstractTableModel {
    private static final long serialVersionUID = 1473262424494858913L;
    public static final int COLINDEX_NAME = 0;
    public static final int COLINDEX_SIZE = 1;
    public static final int COLINDEX_DIRECTORY = 2;
    public static final int COLINDEX_MODIFIED = 3;
    private UploadPolicy uploadPolicy = null;
    private String COL_NAME = null;
    private String COL_SIZE = null;
    private String COL_DIRECTORY = null;
    private String COL_MODIFIED = null;
    private String COL_CHECKED = "";
    protected String[] columnNames = null;
    protected int[] columnSizePercentage = null;
    protected boolean[] columnEditable = null;
    protected Class<?>[] columnClasses = null;
    private List<FileData> rows = new ArrayList<FileData>();

    public FilePanelFlatDataModel2(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
        this.COL_NAME = uploadPolicy.getLocalizedString("colName", new Object[0]);
        this.COL_SIZE = uploadPolicy.getLocalizedString("colSize", new Object[0]);
        this.COL_DIRECTORY = uploadPolicy.getLocalizedString("colDirectory", new Object[0]);
        this.COL_MODIFIED = uploadPolicy.getLocalizedString("colModified", new Object[0]);
        this.columnNames = new String[]{this.COL_NAME, this.COL_SIZE, this.COL_DIRECTORY, this.COL_MODIFIED, this.COL_CHECKED};
        this.columnSizePercentage = new int[]{29, 11, 35, 20, 5};
        this.columnEditable = new boolean[]{false, false, false, false, true};
        int total = 0;
        for (int i = 0; i < this.columnSizePercentage.length; ++i) {
            total += this.columnSizePercentage[i];
        }
        if (total != 100) {
            throw new AssertionError((Object)("Total sum of '" + this.getClass().getName() + ".columnSizePercentage' should be 100% (but was " + total + ")"));
        }
        this.columnClasses = new Class[]{String.class, Long.class, String.class, Date.class, Boolean.class, Boolean.class};
    }

    public FileData contains(String absolutePath) {
        FileData foundFileData = null;
        for (FileData fd : this.rows) {
            if (!absolutePath.equals(fd.getAbsolutePath())) continue;
            foundFileData = fd;
            break;
        }
        return foundFileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileData addFile(File file) throws JUploadExceptionStopAddingFiles {
        List<FileData> list = this.rows;
        synchronized (list) {
            FileData foundFileData = this.contains(file.getAbsolutePath());
            if (foundFileData != null) {
                this.uploadPolicy.displayWarn("File " + file.getName() + " already exists");
                return foundFileData;
            }
            FileData fd = this.uploadPolicy.createFileData(file);
            if (fd != null) {
                this.rows.add(fd);
            }
            return fd;
        }
    }

    public FileData getFileDataAt(int row) {
        if (row >= 0) {
            try {
                return this.rows.get(row);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + " in FilePanelDataModel2.getFileDataAt(" + row + ")");
            }
        }
        return null;
    }

    public void removeRow(int row) {
        this.rows.remove(row);
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow(FileData fileData) {
        List<FileData> list = this.rows;
        synchronized (list) {
            for (int i = 0; i < this.rows.size(); ++i) {
                if (!this.rows.get(i).getAbsolutePath().equals(fileData.getAbsolutePath())) continue;
                return i;
            }
            return -1;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return this.columnEditable[arg1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortColumn(int col, boolean ascending) {
        List<FileData> list = this.rows;
        synchronized (list) {
            Collections.sort(this.rows, new ColumnComparator(col, ascending));
        }
        this.fireTableDataChanged();
    }

    public boolean isSortable(int col) {
        return Boolean.class != this.getColumnClass(col);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return this.columnClasses[arg0];
    }

    @Override
    public Object getValueAt(int row, int col) {
        FileData fileData = this.getFileDataAt(row);
        if (fileData != null) {
            String colName = this.getColumnName(col);
            if (colName.equals(this.COL_NAME)) {
                return fileData.getFileName();
            }
            if (colName.equals(this.COL_SIZE)) {
                return fileData.getFileLength();
            }
            if (colName.equals(this.COL_DIRECTORY)) {
                return fileData.getDirectory();
            }
            if (colName.equals(this.COL_MODIFIED)) {
                return fileData.getLastModified();
            }
            if (colName.equals(this.COL_CHECKED)) {
                return fileData.getUploadFlag();
            }
            this.uploadPolicy.displayErr("Unknown column in " + this.getClass().getName() + ": " + colName);
            return null;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        if (!this.columnEditable[col]) {
            this.uploadPolicy.displayWarn(this.getClass().getName() + ".setValueAt: no action");
        } else {
            FileData fd = this.getFileDataAt(row);
            if (!(aValue instanceof Boolean)) {
                this.uploadPolicy.displayErr("Internal error in " + this.getClass().getName() + ": o should be a Boolean but is a " + aValue.getClass().getName());
            } else {
                fd.setUploadFlag((Boolean)aValue);
                this.uploadPolicy.displayDebug("uploadFlag set to " + (Boolean)aValue + " for file " + fd.getAbsolutePath(), 10);
            }
        }
    }

    @Override
    public String getColumnName(int arg0) {
        return this.columnNames[arg0];
    }

    public int getColumnSizePercentage(int col) {
        return this.columnSizePercentage[col];
    }

    public File getFileRoot() {
        return DefaultFileData.getRoot(this.rows);
    }

    public List<FileData> getFiles() {
        return this.rows;
    }
}

