/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel.treeview;

import java.io.File;
import java.util.Date;
import javax.swing.tree.TreePath;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.FilePanelFlatDataModel2;
import wjhk.jupload2.gui.filepanel.treeview.FolderNode;
import wjhk.jupload2.gui.filepanel.treeview.MyAbstractTreeTableModel;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTableModel;
import wjhk.jupload2.gui.filepanel.treeview.RootNode;
import wjhk.jupload2.gui.filepanel.treeview.TreeFileDataNode;
import wjhk.jupload2.policies.UploadPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDataTreeViewModel
extends MyAbstractTreeTableModel<TreeFileDataNode> {
    UploadPolicy uploadPolicy = null;
    static final String COL_NAME = "colName";
    static final String COL_SIZE = "colSize";
    static final String COL_DIRECTORY = "colDirectory";
    static final String COL_MODIFIED = "colModified";
    String colName = null;
    String colSize = null;
    String colDirectory = null;
    String colModified = null;
    String[] columnNames = null;
    int[] columnSizePercentage = null;
    boolean[] columnEditable = null;
    Class<?>[] columnClasses = null;

    public FileDataTreeViewModel(UploadPolicy uploadPolicy, FilePanelFlatDataModel2 flatModel) {
        super(uploadPolicy, new RootNode(uploadPolicy, null, flatModel));
        this.uploadPolicy = uploadPolicy;
        this.colName = this.uploadPolicy.getLocalizedString(COL_NAME, new Object[0]);
        this.colSize = this.uploadPolicy.getLocalizedString(COL_SIZE, new Object[0]);
        this.colDirectory = this.uploadPolicy.getLocalizedString(COL_DIRECTORY, new Object[0]);
        this.colModified = this.uploadPolicy.getLocalizedString(COL_MODIFIED, new Object[0]);
        this.columnNames = new String[]{this.colName, this.colSize, this.colDirectory, this.colModified, ""};
        this.columnSizePercentage = new int[]{50, 17, 15, 15, 3};
        this.columnClasses = new Class[]{MyTreeTableModel.class, Long.class, String.class, Date.class, Boolean.class};
        this.columnEditable = new boolean[]{true, false, false, false, true};
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnSizePercentage(int col) {
        return this.columnSizePercentage[col];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnClasses[column];
    }

    @Override
    public Object getValueAt(TreeFileDataNode node, int column) {
        if (node != null) {
            String columnName = this.getColumnName(column);
            if (columnName.equals(this.colName)) {
                return node.getFileName();
            }
            if (columnName.equals(this.colSize)) {
                return node.getFileLength();
            }
            if (columnName.equals(this.colDirectory)) {
                return node.getDirectory();
            }
            if (columnName.equals(this.colModified)) {
                return node.getLastModified();
            }
            if (columnName.equals("")) {
                return node.getUploadFlag();
            }
            this.uploadPolicy.displayErr("Unknown column in " + this.getClass().getName() + ": " + columnName);
            return null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(TreeFileDataNode node, int column) {
        return this.columnEditable[column];
    }

    @Override
    public void setValueAt(Object aValue, TreeFileDataNode node, int col) {
        if (!this.columnEditable[col]) {
            this.uploadPolicy.displayWarn(this.getClass().getName() + ".setValueAt: no action");
        } else if (!(aValue instanceof Boolean)) {
            this.uploadPolicy.displayErr("Internal error in " + this.getClass().getName() + ": aValue should be a Boolean but is a " + aValue.getClass().getName());
        } else {
            node.setUploadFlag((Boolean)aValue);
            this.uploadPolicy.displayDebug("uploadFlag set to " + (Boolean)aValue + " for file " + node.getAbsolutePath(), 10);
        }
    }

    public TreePath getTreePathFromFile(File file, boolean createIntermediateNode) throws JUploadExceptionStopAddingFiles {
        if (this.uploadPolicy.getFileListViewMode() != FilePanel.FileListViewMode.FLAT && this.uploadPolicy.getFileListViewMode() != FilePanel.FileListViewMode.TREE_VIEW) {
            throw new IllegalStateException(this.getClass().getName() + ".getTreePathFromFile(File) may not be called when the ListViewMode is in " + (Object)((Object)this.uploadPolicy.getFileListViewMode()) + " mode");
        }
        if (file == null) {
            return new TreePath(this.absoluteRoot);
        }
        TreePath parentTreePath = this.getTreePathFromFile(file.getParentFile(), createIntermediateNode);
        if (parentTreePath == null) {
            return null;
        }
        FolderNode parentNode = (FolderNode)parentTreePath.getLastPathComponent();
        TreeFileDataNode node = parentNode.getChild(file);
        if (node == null && createIntermediateNode) {
            node = parentNode.addChild(file);
        }
        if (node == null) {
            return null;
        }
        return parentTreePath.pathByAddingChild(node);
    }

    @Override
    public int attachObject(Object o) throws NullPointerException, IllegalArgumentException, JUploadExceptionStopAddingFiles {
        if (o == null) {
            throw new NullPointerException(this.getClass().getName() + " has been called with a null parameter");
        }
        if (!(o instanceof File)) {
            throw new IllegalArgumentException(this.getClass().getName() + " has been called with a " + o.getClass().getName() + ". It must be a File");
        }
        File file = (File)o;
        FolderNode parentNode = null;
        switch (this.uploadPolicy.getFileListViewMode()) {
            case FLAT: 
            case TREE_VIEW: {
                if (file.getParentFile() != null) {
                    parentNode = (FolderNode)this.getTreePathFromFile(file.getParentFile(), true).getLastPathComponent();
                    break;
                }
                parentNode = (FolderNode)this.absoluteRoot;
                break;
            }
            case INDEPENDENT_TREE_VIEW: {
                parentNode = (FolderNode)this.absoluteRoot;
            }
        }
        if (parentNode == null) {
            throw new IllegalArgumentException("Root not found for file " + file.getAbsolutePath());
        }
        return parentNode.addChildAndDescendants(file);
    }

    @Override
    public TreePath getTreePathForObject(Object o, boolean createIntermediateNode) {
        if (o != null && !(o instanceof File)) {
            throw new IllegalArgumentException(this.getClass().getName() + " has been called with a " + o.getClass().getName() + ". It must be a File");
        }
        try {
            return this.getTreePathFromFile((File)o, createIntermediateNode);
        }
        catch (JUploadExceptionStopAddingFiles e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

