/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.SizeRenderer;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FilePreparationThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;

public class ProgressBarManager
implements ActionListener {
    public static final int DELAY_FOR_UPDATE_OF_PROGRESS_BAR = 100;
    long currentRequestStartTime = 0L;
    UploadFileData currentUploadFileData = null;
    UploadFilePacket currentUploadFilePacket = null;
    FilePreparationThread filePreparationThread = null;
    long globalStartTime = 0L;
    long nbBytesUploadedForCurrentFile = 0L;
    int nbSentFiles = 0;
    long nbUploadedBytes = 0L;
    JProgressBar preparationProgressBar = null;
    Timer timer;
    long totalUploadDuration = 0L;
    UploadPolicy uploadPolicy;
    JProgressBar uploadProgressBar = null;
    int uploadStatus = 1;

    public ProgressBarManager(UploadPolicy uploadPolicy, FilePreparationThread filePreparationThread) {
        this.uploadPolicy = uploadPolicy;
        this.filePreparationThread = filePreparationThread;
        this.timer = new Timer(100, this);
        JUploadPanel uploadPanel = uploadPolicy.getContext().getUploadPanel();
        this.uploadProgressBar = uploadPanel.getUploadProgressBar();
        this.preparationProgressBar = uploadPanel.getPreparationProgressBar();
        this.updateUploadProgressBarText(null);
    }

    public void actionPerformed(ActionEvent arg0) {
        this.updateUploadProgressBarValue();
        this.updateUploadStatusBar();
    }

    public synchronized void anotherFileHasBeenSent(UploadFilePacket uploadFilePacket, UploadFileData uploadFileData) throws JUploadException {
        if (uploadFilePacket != this.currentUploadFilePacket) {
            throw new AssertionError((Object)("Wrong file packet in " + this.getClass().getName() + ".anotherFileHasBeenSent()"));
        }
        if (uploadFileData != this.currentUploadFileData) {
            throw new AssertionError((Object)("Wrong file packet in " + this.getClass().getName() + ".anotherFileHasBeenSent()"));
        }
        ++this.nbSentFiles;
        this.nbBytesUploadedForCurrentFile = 0L;
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".anotherFileHasBeenSent(): before call to newlyUploadedFileData.getUploadLength()", 100);
        this.uploadStatus = 5;
        this.updateUploadProgressBarText(uploadFilePacket);
    }

    public void clearBarContent() {
        this.timer.stop();
        this.preparationProgressBar.setValue(0);
        this.preparationProgressBar.setString("");
        this.uploadProgressBar.setValue(0);
        this.uploadProgressBar.setString("");
    }

    public long getGlobalStartTime() {
        return this.globalStartTime;
    }

    public long getNbUploadedBytes() {
        return this.nbUploadedBytes;
    }

    public long getUploadDuration() {
        long currentRequestDuration = 0L;
        if (this.currentRequestStartTime != 0L) {
            currentRequestDuration = System.currentTimeMillis() - this.currentRequestStartTime;
        }
        return this.totalUploadDuration + currentRequestDuration;
    }

    private void initProgressBar() throws JUploadException {
        this.preparationProgressBar.setMaximum(100 * this.filePreparationThread.getNbFilesToSend());
        this.preparationProgressBar.setString("");
        this.uploadProgressBar.setMaximum(100 * this.filePreparationThread.getNbFilesToSend());
        this.uploadProgressBar.setString("");
    }

    public synchronized void nbBytesUploaded(long nbBytes, UploadFileData uploadFileData) throws JUploadException {
        this.nbUploadedBytes += nbBytes;
        this.nbBytesUploadedForCurrentFile += nbBytes;
    }

    public void setErrorMessage(String errorTexte) {
        this.preparationProgressBar.setString(errorTexte);
    }

    public synchronized void setUploadStatus(UploadFilePacket uploadFilePacket, UploadFileData uploadFileData, int uploadStatus) throws JUploadException {
        this.currentUploadFileData = uploadFileData;
        this.currentUploadFilePacket = uploadFilePacket;
        switch (uploadStatus) {
            case 3: 
            case 4: {
                this.totalUploadDuration += System.currentTimeMillis() - this.currentRequestStartTime;
                this.currentRequestStartTime = 0L;
                break;
            }
            case 2: {
                if (this.currentRequestStartTime != 0L) break;
                this.currentRequestStartTime = System.currentTimeMillis();
                break;
            }
            case 5: {
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown value for uploadStatus: " + uploadStatus);
            }
        }
        this.uploadStatus = uploadStatus;
        this.updateUploadProgressBarText(uploadFilePacket);
    }

    private void updateUploadProgressBarText(UploadFilePacket uploadFilePacket) {
        this.updateUploadProgressBarValue();
        String msg = null;
        switch (this.uploadStatus) {
            case 1: {
                msg = "";
                break;
            }
            case 2: 
            case 3: {
                msg = this.uploadPolicy.getLocalizedString("infoUploading", this.nbSentFiles + 1);
                break;
            }
            case 4: {
                int firstFileInPacket = this.nbSentFiles - uploadFilePacket.size() + 1;
                int currentFile = this.nbSentFiles;
                msg = this.currentUploadFilePacket.size() == 1 ? currentFile + "/" + this.filePreparationThread.getNbFilesToSend() : firstFileInPacket + "-" + currentFile + "/" + this.filePreparationThread.getNbFilesToSend();
                msg = this.uploadPolicy.getLocalizedString("infoUploaded", msg);
                break;
            }
            case 5: {
                msg = this.uploadPolicy.getLocalizedString("nbUploadedFiles", this.nbSentFiles);
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown upload status in FileUploadManagerThreadImpl.updateProgressBar(): " + this.uploadStatus);
            }
        }
        this.uploadProgressBar.setString(msg);
        this.uploadProgressBar.repaint(0L);
    }

    private void updateUploadProgressBarValue() {
        int percent = 0;
        if (this.nbBytesUploadedForCurrentFile == 0L || this.nbSentFiles == this.filePreparationThread.getNbFilesToSend()) {
            percent = 0;
        } else if (this.currentUploadFileData == null) {
            percent = 0;
        } else {
            percent = this.currentUploadFileData.isPreparedForUpload() ? (int)(this.nbBytesUploadedForCurrentFile * 100L / this.currentUploadFileData.getUploadLength()) : 0;
            if (percent > 100) {
                this.uploadPolicy.displayWarn("percent is more than 100 (" + percent + ") in FileUploadManagerThreadImpl.update.UploadProgressBar");
                percent = 100;
            }
        }
        this.uploadProgressBar.setValue(100 * this.nbSentFiles + percent);
    }

    private void updateUploadStatusBar() {
        if (null != this.uploadPolicy.getContext().getUploadPanel().getStatusLabel() && this.nbUploadedBytes > 0L) {
            String eta;
            double globalCPS;
            double percent;
            try {
                percent = 100.0 * (double)this.nbUploadedBytes / this.filePreparationThread.getTotalFileBytesToSend();
            }
            catch (ArithmeticException e1) {
                percent = 100.0;
            }
            double uploadSpeed = (double)this.nbUploadedBytes / ((double)this.getUploadDuration() / 1000.0);
            if (uploadSpeed == Double.POSITIVE_INFINITY) {
                this.uploadPolicy.displayDebug("uploadSpeed is Infinity, for nbUploadedBytes=" + this.nbUploadedBytes + " and actualUploadDuration(ms)=" + this.getUploadDuration(), 80);
            }
            try {
                globalCPS = (double)this.nbUploadedBytes / (double)(System.currentTimeMillis() - this.globalStartTime) * 1000.0;
            }
            catch (ArithmeticException e1) {
                globalCPS = this.nbUploadedBytes;
            }
            try {
                long remaining = (long)((this.filePreparationThread.getTotalFileBytesToSend() - (double)this.nbUploadedBytes) / globalCPS);
                eta = remaining > 3600L ? this.uploadPolicy.getLocalizedString("timefmt_hms", remaining / 3600L, remaining / 60L % 60L, remaining % 60L) : (remaining > 60L ? this.uploadPolicy.getLocalizedString("timefmt_ms", remaining / 60L, remaining % 60L) : this.uploadPolicy.getLocalizedString("timefmt_s", remaining));
            }
            catch (ArithmeticException e1) {
                eta = this.uploadPolicy.getLocalizedString("timefmt_unknown", new Object[0]);
            }
            String status = this.uploadPolicy.getLocalizedString("status_msg", (int)percent, SizeRenderer.formatFileUploadSpeed(uploadSpeed, this.uploadPolicy), eta);
            this.uploadPolicy.getContext().getUploadPanel().getStatusLabel().setText(status);
            this.uploadPolicy.getContext().showStatus(status);
        }
    }

    public void uploadIsFinished() {
        this.timer.stop();
        this.updateUploadProgressBarText(null);
        this.updateUploadStatusBar();
    }

    public void uploadIsStarted() throws JUploadException {
        this.globalStartTime = System.currentTimeMillis();
        this.initProgressBar();
        this.timer.start();
    }
}

