/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.FilePanelFlatDataModel2;
import wjhk.jupload2.gui.filepanel.FilePanelJFlatTable;
import wjhk.jupload2.gui.filepanel.treeview.FileDataNode;
import wjhk.jupload2.gui.filepanel.treeview.FileDataTreeViewModel;
import wjhk.jupload2.gui.filepanel.treeview.FolderNode;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTable;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTableModel;
import wjhk.jupload2.gui.filepanel.treeview.MyTreeTableModelAdapter;
import wjhk.jupload2.gui.filepanel.treeview.TreeFileDataNode;
import wjhk.jupload2.policies.UploadPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePanelTableImp
extends JPanel
implements FilePanel,
ComponentListener {
    static final long serialVersionUID = -8273990467324350526L;
    JUploadPanel juploadPanel = null;
    FilePanelJFlatTable flatTable;
    FilePanelFlatDataModel2 flatModel;
    MyTreeTable treeTable;
    MyTreeTableModel<TreeFileDataNode> treeModel;
    JScrollPane flatScrollPane = null;
    JScrollPane treeScrollPane = null;
    FilePanel.FileListViewMode fileListViewMode = FilePanel.FileListViewMode.FLAT;
    UploadPolicy uploadPolicy = null;

    public FilePanelTableImp(JUploadPanel juploadPanel, UploadPolicy uploadPolicy) {
        this.juploadPanel = juploadPanel;
        this.uploadPolicy = uploadPolicy;
        this.setLayout(new BorderLayout());
        this.addMouseListener(juploadPanel.getMouseListener());
        this.setTransferHandler(juploadPanel.getTransferHandler());
        this.flatTable = new FilePanelJFlatTable(juploadPanel, uploadPolicy);
        this.flatModel = new FilePanelFlatDataModel2(uploadPolicy);
        this.flatTable.setModel(this.flatModel);
        this.flatScrollPane = new JScrollPane(this.flatTable);
        this.flatScrollPane.addMouseListener(juploadPanel.getMouseListener());
        this.flatScrollPane.getViewport().addComponentListener(this);
        this.treeModel = new FileDataTreeViewModel(uploadPolicy, this.flatModel);
        this.treeTable = new MyTreeTable(this.treeModel);
        this.treeModel.setTree(this.treeTable.getTree());
        this.treeScrollPane = new JScrollPane(this.treeTable);
        this.treeScrollPane.addMouseListener(juploadPanel.getMouseListener());
        this.treeScrollPane.getViewport().addComponentListener(this);
        this.fileListViewMode = this.uploadPolicy.getFileListViewMode();
        switch (this.fileListViewMode) {
            case FLAT: {
                this.add((Component)this.flatScrollPane, "Center");
                break;
            }
            case TREE_VIEW: 
            case INDEPENDENT_TREE_VIEW: {
                this.add((Component)this.treeScrollPane, "Center");
            }
        }
    }

    @Override
    public FilePanel.FileListViewMode getFileListMode() {
        return this.fileListViewMode;
    }

    @Override
    public void setFileListViewMode(FilePanel.FileListViewMode fileListViewMode) {
        if (this.fileListViewMode != fileListViewMode) {
            switch (fileListViewMode) {
                case FLAT: {
                    this.remove(this.treeScrollPane);
                    this.add((Component)this.flatScrollPane, "Center");
                    break;
                }
                case TREE_VIEW: {
                    this.remove(this.flatScrollPane);
                    this.add((Component)this.treeScrollPane, "Center");
                    break;
                }
                default: {
                    IllegalArgumentException e = new IllegalArgumentException("Unknown value for fileListMode:" + fileListViewMode.toString());
                    this.uploadPolicy.displayErr(e);
                    throw e;
                }
            }
            this.fileListViewMode = fileListViewMode;
            this.uploadPolicy.setFileListViewMode(fileListViewMode);
        }
    }

    @Override
    public final void addFiles(File[] filesToAdd) {
        long startTime = System.currentTimeMillis();
        int nbFiles = 0;
        if (null == filesToAdd) {
            String msg = "FilePanelTableImpl: filesToUpload may not be null)";
            this.uploadPolicy.displayErr(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            for (int i = 0; i < filesToAdd.length; ++i) {
                nbFiles += this.treeModel.attachObject(filesToAdd[i]);
            }
        }
        catch (JUploadExceptionStopAddingFiles e) {
            this.uploadPolicy.displayWarn(this.getClass().getName() + ".addFiles() [" + e.getClass().getName() + "]: " + e.getMessage());
        }
        catch (Exception e) {
            this.uploadPolicy.displayErr("Unexpected error during file adding: " + this.getClass().getName() + ".addFiles() [" + e.getClass().getName() + "]: " + e.getMessage());
        }
        this.juploadPanel.updateButtonState();
        this.flatModel.fireTableDataChanged();
        if (this.uploadPolicy.getFileListViewMode().equals((Object)FilePanel.FileListViewMode.FLAT) || this.uploadPolicy.getFileListViewMode().equals((Object)FilePanel.FileListViewMode.TREE_VIEW)) {
            TreePath treePath = this.treeModel.getTreePathForObject(this.flatModel.getFileRoot(), true);
            if (treePath == null) {
                this.uploadPolicy.displayErr("[Internal Error] treePath not found for folder " + this.flatModel.getFileRoot().getAbsolutePath());
            } else {
                FolderNode visibleRoot = (FolderNode)treePath.getLastPathComponent();
                if (visibleRoot == null) {
                    this.uploadPolicy.displayErr("[Internal Error] Folder Node not found for folder " + this.flatModel.getFileRoot().getAbsolutePath());
                } else {
                    this.treeModel.setRoot(visibleRoot);
                }
            }
        } else {
            this.reload();
        }
        long finishTime = System.currentTimeMillis();
        this.uploadPolicy.displayInfo("Added " + nbFiles + " files in " + (finishTime - startTime) / 1000L + " seconds");
    }

    @Override
    public final List<FileData> getFiles() {
        return this.flatModel.getFiles();
    }

    @Override
    public final int getFilesLength() {
        return this.flatTable.getRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeSelected() {
        List<FileData> list = this.flatModel.getFiles();
        synchronized (list) {
            if (this.fileListViewMode.equals((Object)FilePanel.FileListViewMode.FLAT)) {
                int[] rows = this.flatTable.getSelectedRows();
                for (int i = rows.length - 1; 0 <= i; --i) {
                    this.removeRowFromFlatView(rows[i], null);
                }
            } else {
                int[] rows = this.treeTable.getSelectedRows();
                for (int i = rows.length - 1; 0 <= i; --i) {
                    this.removeRowFromTreeView(rows[i]);
                }
            }
        }
        this.treeModel.cleanHierarchy();
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAll() {
        List<FileData> list = this.flatModel.getFiles();
        synchronized (list) {
            for (int i = this.getFilesLength() - 1; 0 <= i; --i) {
                this.removeRowFromFlatView(i, null);
            }
        }
        this.treeModel.cleanHierarchy();
        this.reload();
    }

    @Override
    public void remove(List<FileData> files) {
        for (FileData fd : files) {
            this.removeRowFromFlatView(null, fd);
        }
        this.treeModel.cleanHierarchy();
        this.reload();
    }

    @Override
    public void removeFileNotToUpload() {
        int i = 0;
        List<FileData> files = this.flatModel.getFiles();
        while (i < files.size()) {
            FileData fd = files.get(i);
            if (fd.getUploadFlag()) {
                ++i;
                continue;
            }
            this.removeRowFromFlatView(i, fd);
        }
    }

    @Override
    public final void remove(FileData fileData) {
        this.removeRowFromFlatView(null, fileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeRowFromFlatView(Integer rowNumberParam, FileData fileDataParam) {
        List<FileData> list = this.flatModel.getFiles();
        synchronized (list) {
            if (rowNumberParam == null && fileDataParam == null) {
                this.uploadPolicy.displayErr("rowNumberParam and fileDataParam may not be both null (in FilePanelTableImpl.removeRow(Integer,FileData)");
            }
            Integer rowNumber = rowNumberParam;
            FileData fileData = fileDataParam;
            if (rowNumber == null) {
                rowNumber = this.flatModel.getRow(fileDataParam);
            } else if (fileData == null) {
                fileData = this.flatModel.getFileDataAt(rowNumber);
            }
            if (rowNumber == null || rowNumber < 0) {
                this.uploadPolicy.displayWarn("The row " + rowNumber + " doesn't exist (in FilePanelTableImpl.removeRow(Integer,FileData)");
            } else {
                this.flatModel.removeRow(rowNumber);
            }
            if (fileData == null) {
                this.uploadPolicy.displayWarn("The fileData for " + rowNumber + " doesn't exist (in FilePanelTableImpl.removeRow(Integer,FileData)");
            } else {
                this.uploadPolicy.displayDebug("removing file " + fileData.getAbsolutePath(), 10);
                try {
                    this.treeModel.remove(fileData.getTreeFileDataNode());
                }
                catch (Exception e) {
                    this.uploadPolicy.displayErr(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeRowFromTreeView(Integer rowNumber) {
        List<FileData> list = this.flatModel.getFiles();
        synchronized (list) {
            MyTreeTableModelAdapter treeTableModelAdapter = (MyTreeTableModelAdapter)this.treeTable.getModel();
            TreeFileDataNode treeFileDataNode = (TreeFileDataNode)treeTableModelAdapter.nodeForRow(rowNumber);
            if (treeFileDataNode instanceof FileDataNode) {
                this.removeRowFromFlatView(null, ((FileDataNode)treeFileDataNode).getFileData());
            } else {
                this.remove(((FolderNode)treeFileDataNode).getTotalFileDataChildren());
            }
        }
    }

    @Override
    public final void clearSelection() {
        this.flatTable.clearSelection();
    }

    @Override
    public final void focusTable() {
        if (0 < this.flatTable.getRowCount()) {
            this.flatTable.requestFocus();
        }
    }

    @Override
    public FileData getFileDataAt(Point point) {
        int row = this.flatTable.rowAtPoint(point);
        return this.flatModel.getFileDataAt(row);
    }

    @Override
    public Component getDropComponent() {
        return this;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        if (this.getWidth() > 0) {
            TableColumnModel flatColumnModel = this.flatTable.getColumnModel();
            for (int i = 0; i < this.flatModel.getColumnCount(); ++i) {
                flatColumnModel.getColumn(i).setPreferredWidth(this.flatModel.getColumnSizePercentage(i) * this.flatScrollPane.getViewport().getWidth() / 100);
            }
            TableColumnModel treeviewColumnModel = this.treeTable.getColumnModel();
            for (int i = 0; i < this.treeModel.getColumnCount(); ++i) {
                treeviewColumnModel.getColumn(i).setPreferredWidth(this.treeModel.getColumnSizePercentage(i) * this.treeScrollPane.getViewport().getWidth() / 100);
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void setGridBorderColor(Color color) {
        this.flatTable.setGridColor(color);
    }

    @Override
    public void setTableHeaderBackColor(Color color) {
        this.flatTable.getTableHeader().setBackground(color);
    }

    @Override
    public void setTableHeaderFont(Font font) {
        this.flatTable.getTableHeader().setFont(font);
    }

    @Override
    public void setTableHeaderTextColor(Color color) {
        this.flatTable.getTableHeader().setForeground(color);
    }

    @Override
    public void reload() {
        this.treeModel.reload();
    }

    @Override
    public void cleanHierarchy() {
        this.treeModel.cleanHierarchy();
        this.reload();
    }
}

