/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import wjhk.jupload2.gui.filepanel.FilePanelJFlatTable;
import wjhk.jupload2.gui.filepanel.SortArrowIcon;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4104776293873798189L;
    private static final Icon NONSORTED = new SortArrowIcon(0);
    private static final Icon ASCENDING = new SortArrowIcon(2);
    private static final Icon DESCENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JTableHeader header;
        int index = -1;
        boolean ascending = true;
        if (table instanceof FilePanelJFlatTable) {
            FilePanelJFlatTable sortTable = (FilePanelJFlatTable)table;
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
        }
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        Icon icon = ascending ? ASCENDING : DESCENDING;
        this.setIcon(col == index ? icon : NONSORTED);
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

