<?php
/*

преобразование po-файла в lang.php MaxSite CMS

*/



# массив всех файлов для обработки
# результат сохраняется в файле с именем + .lang.php
$all_file_to_parse = array(
	//'install.po',
	//'common.po',
	//'plugins.po',
	//'templates.po',
	//'admin.po',
	'frontend.po',
	'backend.po',
	'frontend-no-plugins.po',
);


define('PATH', dirname(realpath(__FILE__)) . '/'); // текущий каталог

foreach($all_file_to_parse as $file) 
{
	if (file_exists(PATH . $file)) 
	{
		$fc_all = file(PATH . $file);
	
		if ($fc_all)
		{
			$out = parse($fc_all);
			
			$fp = fopen(PATH . $file . '.lang.php', "w");
			fwrite($fp,  $out);
			fclose($fp);
		}
	}
	
	echo '<p>' . $file . ' - ок</p>';
}


# сам парсинг po-файла
# входящий текст в виде массива строк
function parse($line)
{
	$out = '';
	
	$i = -1; // номер строки
	
	/*
	Для первода используется пара:
	
	msgid ""
	msgstr ""
	
	*/
	
	$msgid = $msgstr = false;
	
	
	while($i < sizeof($line)-1)
	{
		$i++;
		$str = $line[$i]; // текущая строка
		
		if (strpos($str, 'msgid') === 0) // есть вхождение msgid
		{
			$msgid = true;
			$str_msgid = $str; // сохраним строчку
		}
		
		if ($msgid and strpos($str, 'msgstr') === 0) // есть вхождение msgstr
		{
			$out .= p_str($str_msgid, $str);
			$msgid = false;
		}
	}
	
	//	echo $out;
	
	// $out = str_replace('$lang[\'\'] = \'\';' , '', $out);
	
	
	$out = '<?php  if (!defined(\'BASEPATH\')) exit(\'No direct script access allowed\');

/**
 * Language for MaxSite CMS (c) http://max-3000.com/
 */

' . $out;
	
	return $out;
}

# обработка строки
# на выходе
# $lang['text1'] = 'text2';
function p_str($text1, $text2)
{	
	$text1 = trim($text1);
	
	$text1 = str_replace('msgid', '', $text1);
	$text1 = str_replace('\"', '_QQQ_', $text1);
	$text1 = str_replace('"', '', $text1);
	$text1 = str_replace('_QQQ_', '"', $text1);
	
	$text1 = str_replace('\'', '_Q1Q', $text1);
	$text1 = str_replace('_Q1Q', '\\' . '\'', $text1);
	
	
	$text1 = trim($text1);
	
	if ($text1 == '') return; // пустая фраза
	
	// фразе не требующие перевода
	if ($text1 == '%%%') return; 
	if ($text1 == 'Плагин %%%') return; 
	
	$text = '$lang[\'' . $text1 . '\']=';
	
	
	$text2 = trim($text2);
	$text2 = str_replace('msgstr', '', $text2);
	$text2 = str_replace('\"', '_QQQ_', $text2);
	$text2 = str_replace('"', '', $text2);
	$text2 = str_replace('_QQQ_', '"', $text2);
	
	$text2 = str_replace('\'', '_Q1Q', $text2);
	$text2 = str_replace('_Q1Q', '\\' . '\'', $text2);
	
	$text2 = trim($text2);
	
	$text .= '\'' . $text2 . '\';' . "\n";
	
	return $text;
}

