<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
Слайдер


[slide]
header = заголовок
text = текст с html без переносов
link = ссылка
img = адрес картинки
[/slide]

*/

// где выводить записи
$responsiveslides_output = mso_get_option('responsiveslides_output', 'templates', array());

if (!$responsiveslides_output)  return; // ничего не отмечено - нигде не показывать

if (!in_array(getinfo('type'), $responsiveslides_output)) return;
	elseif (mso_current_paged() > 1) return; // на страницах пагинации не показывать (или показывать?..)


// опции слайдера
$responsiveslides_def = '
[slide]
header = Слайд1
text = описание
link = http://di-modern.ru/
img = TEMPLATE_URL/images/slider/1.png
[/slide]

[slide]
header = Слайд2
text = описание
link = http://di-modern.ru/
img = TEMPLATE_URL/images/slider/2.png
[/slide]
';

$slides0 = mso_get_option('responsiveslides', 'templates', $responsiveslides_def);

if (!$slides0) return; // слайды не определены - выходим

$slides0 = str_replace('TEMPLATE_URL/', getinfo('template_url'), $slides0);

// ищем вхождение [slide] ... [slide]
// указываем дефолтные атрибуты полей слайдера
$slides = mso_section_to_array($slides0, '!\[slide\](.*?)\[\/slide\]!is', array('header'=>'', 'text'=>'', 'link'=>'', 'img'=>''));

if (!$slides) return; // нет секций - выходим
// формируем html-код слайдера
?>
<div class="callbacks_container">
 <ul class="rslides" id="slider4">
<?php foreach ($slides as $slide) { ?>
	<li><?= '<a href="' . trim($slide['link']) . '"><img src="' . trim($slide['img']) . '" alt="' . trim($slide['header']). '"></a>' ?>
	<div class="caption"><a href="<?= $slide['link'] ?>"><b><?= trim($slide['header']) ?></b></a>
	<p><?= trim($slide['text']) ?></p></div>
	</li>

<?php } ?>
</ul>
</div>
<div class="break"></div>
<?php
echo mso_load_script(getinfo('template_url') . 'components/responsiveslides/responsiveslides.min.js');
?>
<script>
$(function () {
      $("#slider4").responsiveSlides({
        nav: true,
        auto: true,
        pager: false,
        speed: 100,
        namespace: "callbacks",
        before: function () {
          $('.events').append("<li>before event fired.</li>");
        },
        after: function () {
          $('.events').append("<li>after event fired.</li>");
        }
      });

    });
</script>