<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

mso_cur_dir_lang('templates');

# подготовка данных

$full_posts = mso_get_option('category_full_text', 'templates', '1'); // полные или короткие записи
	
// параметры для получения страниц
$par = array( 'limit' => mso_get_option('limit_post', 'templates', '15'), 
			'cut' => mso_get_option('more', 'templates', 'Читать полностью »'),
			'cat_order'=>'category_id_parent', 'cat_order_asc'=>'asc', 'type'=> false, 'content'=> $full_posts ); 

// подключаем кастомный вывод, где можно изменить массив параметров $par для своих задач
if ($f = mso_page_foreach('category-mso-get-pages')) require($f); 

$pages = mso_get_pages($par, $pagination); // получим все - второй параметр нужен для сформированной пагинации

$title_page = mso_head_meta('title', $pages, '%category_name%'); // заголовок для записи на основе титла

if ($f = mso_page_foreach('category-head-meta')) require($f);
else
{ 
	mso_head_meta('title', $pages, '%category_name%'); //  meta title страницы
	mso_head_meta('description', $pages, '%category_desc%'); // meta description страницы
	mso_head_meta('keywords', $pages, '%category_name%'); // meta keywords страницы
}

if (!$pages and mso_get_option('page_404_http_not_found', 'templates', 1) ) header('HTTP/1.0 404 Not Found'); 

# начальная часть шаблона
require(getinfo('template_dir') . 'main-start.php');

echo NR . '<div class="type type_category">' . NR;

if ($f = mso_page_foreach('category-do')) require($f); // подключаем кастомный вывод
	else 
	{
		# выводим только если есть найденные страницы
		if ($pages) 
		{
			echo '<h1 class="category">' . $title_page . '</h1>';
		}
	}

if ($pages) // есть страницы
{ 	
	
	if ( mso_get_option('category_show_rss_text', 'templates', 1) )
	{
		if ($f = mso_page_foreach('category-show-rss-text')) 
			require($f); // подключаем кастомный вывод
		else
			echo mso_get_val('show_rss_text_start', '<h3 class="category">') . '<a href="' . getinfo('siteurl') . mso_segment(1) . '/' . mso_segment(2) . '/feed">'. t('Подписаться на эту рубрику по RSS'). '</a>' .  mso_get_val('show_rss_text_end', '</h3>');
			
	}
	
	if ($f = mso_page_foreach('category-show-desc')) 
			require($f); // подключаем кастомный вывод
	else
	{
		if (isset($pages[0]['page_categories_detail']))
		{
			// описание рубрики
			foreach ($pages[0]['page_categories_detail'] as $_cat)
			{
				if ($_cat['category_slug'] == mso_segment(2))
				{
					if ($_cat['category_desc']) echo '<div class="category_desc">' . $_cat['category_desc'] . '</div>';
					break;
				}
			}
		}
	}
	
	
	if (!$full_posts) echo '<ul class="category">';
	
	foreach ($pages as $page) : // выводим в цикле
		
		if ($f = mso_page_foreach('category')) 
		{
			require($f); // подключаем кастомный вывод
			continue; // следующая итерация
		}

		
		extract($page);
	
		if (!$full_posts)
		{
			echo '<li>';
			
			if ($f = mso_page_foreach('category-list')) 
			{
				require($f); // подключаем кастомный вывод
			}
			else
			{
				mso_page_title($page_slug, $page_title, '', '', true);
				mso_page_date($page_date_publish, 'd/m/Y', ' - ', '');
			}
			
			echo '</li>';
		}
		else
		{
			echo NR . '<div class="page_only">' . NR;
				if ($f = mso_page_foreach('info-top')) 
				{
					require($f); // подключаем кастомный вывод
				}
				else
				{
					echo '<div class="info info-top">';
						mso_page_title($page_slug, $page_title, '<h1>', '</h1>');
						/*
						mso_page_date($page_date_publish, 
										array(	'format' => 'D, j F Y г.', // 'd/m/Y H:i:s'
												'days' => t('Понедельник Вторник Среда Четверг Пятница Суббота Воскресенье'),
												'month' => t('января февраля марта апреля мая июня июля августа сентября октября ноября декабря')), 
										'<span>', '</span>');
						mso_page_cat_link($page_categories, ' -&gt; ', '<br><span>' . t('Рубрика') . ':</span> ', '');
						mso_page_tag_link($page_tags, ' | ', '<br><span>' . t('Метки') . ':</span> ', '');
						mso_page_view_count($page_view_count, '<br><span>' . t('Просмотров') . ':</span> ', '');
						mso_page_meta('nastr', $page_meta, '<br><span>' . t('Настроение') . ':</span> ', '');
						mso_page_meta('music', $page_meta, '<br><span>' . t('В колонках звучит') . ':</span> ', '');
						if ($page_comment_allow) mso_page_feed($page_slug, t('комментарии по RSS'), '<br><span>' . t('Подписаться на').'</span> ', '', true);
						mso_page_edit_link($page_id, 'Edit page', '<br>[', ']'); */
					echo '</div>';
				}
				
				if ($f = mso_page_foreach('page-content')) 
				{
					require($f); // подключаем кастомный вывод
				}
				else
				{
					echo '<div class="page_content">';
						mso_page_content($page_content);
						if ($f = mso_page_foreach('info-bottom')) require($f); // подключаем кастомный вывод
						mso_page_content_end();
						echo '<div class="break"></div>';
						
						
					echo '</div>';
				}
			
			echo NR . '</div><!--div class="page_only"-->' . NR;
		}
		
		if ($f = mso_page_foreach('category-page-only-end')) require($f);
		
	endforeach;
	
	if (!$full_posts) echo '</ul>';
	
	if ($f = mso_page_foreach('category-posle-pages')) require($f); // подключаем кастомный вывод
	
	mso_hook('pagination', $pagination);

}
else 
{
	if ($f = mso_page_foreach('pages-not-found')) 
	{
		require($f); // подключаем кастомный вывод
	}
	else // стандартный вывод
	{
		echo '<div class="info-top"><div class="block-icon nopage"><div class="tetris t1"></div></div><h2>страница не найдена</h2><span class="login_header_min">404 ошибка</span></div><br>';
		echo '<p>' . tf('Извините по вашему запросу ничего не найдено!') . '</p><br>';
		echo '<p>' . tf('К сожалению, запрошенная страница не найдена на сервере'). '</p><br>';

		echo 'Попробуйте сделать следующее: <br><ul class="is_link_link">

			<li>Проверьте правильность адреса страницы указанного в адресной строке браузера.</li>
			<li>Нажмите кнопку «Обновить» на панели управления браузера.</li>
			<li>Нажмите кнопку «Назад», чтобы вернуться на предыдущую страницу сайта.</li>
			<li>Нажмите кнопку «Главная», чтобы вернуться на главную страницу сайта.</li>
			<li>Воспользуйтесь навигационным меню, чтобы перейти в другой раздел сайта.</li></ul><br><br><br>
 

		Если вы считаете, что запрошенная вами страница должна находиться по этому адресу или вы перешли на нее по ссылке с одной из страниц этого же сайта, пожалуйста, сообщите нам об этом.';
	}
} // endif $pages

if ($f = mso_page_foreach('category-posle')) require($f); // подключаем кастомный вывод
	
echo NR . '</div><!-- class="type type_category" -->' . NR;

# конечная часть шаблона
require(getinfo('template_dir') . 'main-end.php');
	
?>