<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

// функция вывода последние записи сайта
// $limit - кол-во записей
function out_last_page($limit = 1)
{
	$p = new Page_out; // подготавливаем объект для вывода записей
	
	if ($pages = mso_get_pages(array( 
				'limit' => $limit, 
				'cut' => '...',
				'custom_type' => 'home',
				'pagination' => false,
				'get_page_categories' => false,
				'get_page_count_comments' => false,
				'exclude_page_id' => mso_get_val('exclude_page_id'),
				), $temp))
	{

		// формат записи
		$p->format('title', '<h3 class="home-last-page">', '</h3>');
		$p->format('date', 'D, j F Y г. в H:i');
		// $p->format('read', 'Читать полностью »', '');
		
		$exclude_page_id = mso_get_val('exclude_page_id');
		
		foreach ($pages as $page)
		{
			$p->load($page); // загружаем данные записи
			
			// адрес картинки записи в мета img_page_home
			// генерируем thumb
			
			$width = mso_get_option('home_last_page_img_width', 'templates', 640);
			$height = mso_get_option('home_last_page_img_height', 'templates', 300);
			
			if (
				$img = thumb_generate(
				$p->meta_val('image_for_page'), // адрес
				$width, //ширина
				$height, //высота
				getinfo('template_url') . 'images/placehold/640x300.png'
				))
			{
				$img = $p->page_url(true) . '<img src="' . $img . '" class="width100" alt="" title="' . htmlspecialchars($p->val('page_title')). '"></a>';
				
				$p->html($img);
			}
			
			$p->line('[date]', '<p class="home-last-page-info">', '</p>'); // дата
			$p->line('[title]'); // заголовок
			$p->content();
			
			//$p->content_chars(200, ' ...');  // текст обрезанный
			// $p->content_words(40, ' ...');  // текст обрезанный
			
			// $p->line('[read]');
			
			// сохраняем id записей, чтобы их позже исключить из вывода
			$exclude_page_id[] = $p->val('page_id'); 
		}
		
		mso_set_val('exclude_page_id', $exclude_page_id);
	}
}


// формируем вывод
echo '<div class="home-last-page">';
out_last_page(1);
echo '</div>';


# end file