<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 */

# основной файл html-структуры

# секция HEAD
if ($fn = mso_fe('custom/head-section.php')) require($fn); // подключение HEAD из файла
	else mso_default_head_section(); // подключение через функцию

?>
<body>
<div id="pagewrap">
		<header id="header">
            <div class="header-wrap">
			<?php
				if (function_exists('ushka')) echo ushka('header-start');
				if ($fn = mso_fe('custom/header-start.php')) require($fn);

				if ($fn = mso_fe('custom/header_components.php')) require($fn);
				else
				{
					if ($fn = get_component_fn('header_component1', 'menu-only')) require($fn);
					if ($fn = get_component_fn('header_component2')) require($fn);
					if ($fn = get_component_fn('header_component3')) require($fn);
					if ($fn = get_component_fn('header_component4')) require($fn);
					if ($fn = get_component_fn('header_component5')) require($fn);
				}

				if (function_exists('ushka')) echo ushka('header-end');
				if ($fn = mso_fe('custom/header-end.php')) require($fn);

			?>
		</div>

		<nav>
			<ul id="main-nav" class="clearfix">
             <?php
			if ($menu = mso_get_option('top_menu', 'templates', '/ | Главная_NR_about | О сайте'))
				echo mso_menu_build($menu, 'selected', false);
		     ?>
			</ul>
			<!-- /#main-nav -->
		</nav>

		<form id="searchform" name="f_search" method="get" onsubmit="location.href='<?= getinfo('siteurl') ?>search/' + encodeURIComponent(this.s.value).replace(/%20/g, '+'); return false;">
			<input type="search" id="s" placeholder="Поиск">
		</form>
	</header>
	<!-- /#header -->

	<section id="content">
            <div class="content-wrap">
				<?php

					if (function_exists('ushka')) echo ushka('content-start');
					if ($fn = mso_fe('custom/content-start.php')) require($fn);

					if ($fn = mso_fe('custom/content-out.php')) require($fn);
					else
					{
						global $CONTENT_OUT;
						echo $CONTENT_OUT;
					}

					if (function_exists('ushka')) echo ushka('content-end');
					if ($fn = mso_fe('custom/content-end.php')) require($fn);
				?>
			</div>

		<!-- /.post -->

	</section>
	<!-- /#content -->


	<aside id="sidebar">
              <?php

					echo NR . '<div class="sidebar-wrap">';
					mso_show_sidebar('1');
					echo NR . '</div><!-- /div.sidebar1-wrap -->';
			 ?>
	</aside>
	<!-- /#sidebar -->

	<footer id="footer">
        <div class="footer-wrap">
		<?php
			if (function_exists('ushka')) echo ushka('footer-start');
			if ($fn = mso_fe('custom/footer-start.php')) require($fn);

			if ($fn = mso_fe('custom/footer_components.php')) require($fn);
			else
			{
				if ($fn = get_component_fn('footer_component1', 'footer-copy-stat')) require($fn);
				if ($fn = get_component_fn('footer_component2')) require($fn);
				if ($fn = get_component_fn('footer_component3')) require($fn);
				if ($fn = get_component_fn('footer_component4')) require($fn);
				if ($fn = get_component_fn('footer_component5')) require($fn);
			}

			if (function_exists('ushka')) echo ushka('footer-end');
			if ($fn = mso_fe('custom/footer-end.php')) require($fn);
		?>
		</div>
	<!-- /div.footer-wrap  -->
	</footer>
	<!-- /#footer -->
</div>
<!-- /#pagewrap -->
</body>
</html>