<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

	# файл functions.php подключается при инициализации сайта
	# в этом файле нельзя выводить данные в браузер!
	
	# регистрируем сайдбары - имя, заголовок.
	# если имя совпадает, то берется последний заголовок
	mso_register_sidebar('1', t('Первый сайдбар', 'templates'));

if (!function_exists('my_image_header'))
{
	function my_image_header()
	{
		// подключение CodeIgniter
		$CI = & get_instance();
		
		// хелпер для работы с каталогами
		$CI->load->helper('directory'); 

		// результирующий массив с нашими файлами
		$all_files = array();

		// все файлы из images/headers шаблона
		$files = directory_map(getinfo('template_dir') . 'images/headers/', true);
		
		// функция directory_map возвращает не только файлы, но и подкаталоги
		// нам нужно оставить только файлы. Делаем это в цикле
		
		// вначале по images/headers шаблона
		$path = getinfo('template_dir') . 'images/headers/';
		foreach ($files as $file)
		{
			if (@is_dir($path . $file)) continue; // это каталог
			// добавим файл в массив сразу с полным адресом
			$all_files[] = getinfo('template_url') . 'images/headers/' . $file;
		}
		
		
		// аналогично для uploads/headers
		$files = directory_map(getinfo('uploads_dir') . 'headers/', true);
		
		$path = getinfo('uploads_dir') . 'headers/';
		foreach ($files as $file)
		{
			if (@is_dir($path . $file)) continue; // это каталог
			
			// добавим файл в массив сразу с полным адресом
			$all_files[] = getinfo('uploads_url') . 'headers/' . $file;
		}
		
		// если файлов нет, то возвращаем пустую строчку
		if (!$all_files) return '';
		
		// преобразуем массив в строчку с разделителем #
		return implode($all_files, '#');
	}
}