<?php 

/**
 * MaxSite CMS
 * (c) http://max-3000.com/
 * 
 * Компиляция var_style.less в var_style.css
 * 
 * 10/04/2012
 * 19/03/2012
 * 31/01/2012
 * 23/01/2012
 * 
 */
 
/* 
	
 
	Разместить в каталоге /css/ своего шаблона
		var_style.php - этот файл
		lessc.inc.php - компилятор LESS
		var_style.less - стили шаблона
	
	Теперь при каждом обновлении страниц сайта автоматически будет генерироваться var_style.css
	и подключаться в HEAD шаблона.
	
	После загрузки на рабочий сайт, удалить или переименовать файл var_style.php (этот файл). 
	Компиляция прекратится и будет подключен только var_style.css.
	
	К файлу можно обращаться напрямую из браузера для быстрой компиляции стилей: 
		http://сайт/application/maxsite/templates/шаблон/css/var_style.php
	
*/


# использовать сжатие css-кода?
$use_mini = true; 

# если включено сжатие, то удалять переносы строк?
# при false - лучше читабельность кода
$use_mini_n = false; 

# разрешить использование кэша LESS
# сравнивается время var_style.less м var_style.css 
# если первый новее, то происходит компиляция
# при отладке кэш лучше отключить
# на работчем сайте, можно включить
$use_cache = true;


/* ----------------------------------------------------------------------------
 *  дальше можно не трогать
 * ---------------------------------------------------------------------------- */

define('CSSPATH', dirname(realpath(__FILE__)) . '/'); // каталог

# массив всех файлов для парсинга - все файлы объединяются в один
$all_less_file_to_parse = array(
	CSSPATH . 'var_style.less',
);

# выходной файл
$out_css_file = 'var_style.css';


if ($use_cache) // проверка кэша
{
	$in_css_file = $all_less_file_to_parse[0]; // только первый файл
	
	if (function_exists('mso_add_file') and file_exists($in_css_file) and file_exists(CSSPATH . $out_css_file))
	{
		$lastModified1 = filemtime($in_css_file);
		$lastModified2 = filemtime(CSSPATH . $out_css_file);
		
		if ($lastModified1 < $lastModified2)
		{
			mso_add_file('css/' . $out_css_file);
		}
	}
}

$fc_all = '';

foreach($all_less_file_to_parse as $file) if (file_exists($file)) $fc_all .= file_get_contents($file);

if ($fc_all)
{
	require CSSPATH . 'lessc.inc.php';
	$compiler = new lessc();
	$compiler->importDir = CSSPATH;
	$compiler->indentChar = "\t";
	
	try 
	{
		$out = $compiler->parse($fc_all);
	} 
	catch (Exception $ex) 
	{
		die("<pre>lessphp fatal error: " . $ex->getMessage() . '</pre>');
	}
	
	
	// сжатие кода
	if ($use_mini)
	{
		if ($use_mini_n)
		{
			$out = str_replace(array("\r\n", "\r", "\n", '  ', '    '), '', $out);
		}
		
		$out = str_replace("\n\t", '', $out);
		$out = str_replace("\n}", '}', $out);
		$out = str_replace('; ', ';', $out);
		$out = str_replace(';}', '}', $out);
		$out = str_replace(': ', ':', $out);
		$out = str_replace('{ ', '{', $out);
		$out = str_replace(' }', '}', $out);
		$out = str_replace(' {', '{', $out);
		$out = str_replace(', ', ',', $out);
		$out = str_replace(' > ', '>', $out);		
		$out = str_replace('} ', '}', $out);
		$out = str_replace('  ', ' ', $out);
	}
	
	$fp = fopen(CSSPATH . $out_css_file, "w");
	fwrite($fp,  $out);
	fclose($fp);
	
	// если это в рамках MaxSite CMS, то подключаем в виде mso_add_file
	// иначе выводим в браузер
	if (function_exists('mso_add_file')) mso_add_file('css/' . $out_css_file );
		else echo '<pre>' . $out . '</pre>'; 
}


# end file