<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');?>

// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2008 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------

myBbcodeSettings = {
	nameSpace:	"bbcode", // Useful to prevent multi-instances CSS conflict
	
	previewParserPath: "<?= getinfo('ajax') . base64_encode('plugins/editor_markitup/preview-ajax.php') ?>",
	// previewInWindow: 'width=960, height=800, resizable=yes, scrollbars=yes',
	
	<?= $editor_config['preview'] ?>
	<?= $editor_config['previewautorefresh'] ?>
	<?= $editor_config['previewPosition'] ?>
	
	markupSet:	[

		{name:'Шрифт', openWith:'[b]', closeWith:'[/b]', className:"fonts", multiline:false, dropMenu: [
			{name:'Полужирный (важный)', openWith:'[b]', closeWith:'[/b]', className:"bold", key:"B" },
			{name:'Курсив (важный)', openWith:'[i]', closeWith:'[/i]', className:"italic", key:"I" },
			{separator:'---------------' },
			{name:'Полужирный (простой)', openWith:'[bold]', closeWith:'[/bold]', className:"bold" },
			{name:'Курсив (простой)', openWith:'[italic]', closeWith:'[/italic]', className:"italic" },
			{separator:'---------------' },
			{name:'Подчеркнутый', openWith:'[u]', closeWith:'[/u]', className:"underline" },
			{name:'Зачеркнутый', openWith:'[s]', closeWith:'[/s]', className:"stroke" },
			{separator:'---------------' },
			{name:'Верхний индекс', openWith:'[sup]', closeWith:'[/sup]', className:"sup" },
			{name:'Нижний индекс', openWith:'[sub]', closeWith:'[/sub]', className:"sub" },
			{separator:'---------------' },
			{name:'Уменьшенный шрифт', openWith:'[small]', closeWith:'[/small]', className:"small" },
			{separator:'---------------' },
			{name:'Размер текста', openWith:'[size=[![Размер текста]!]%]', closeWith:'[/size]', className:"text-smallcaps"},
		]},
		
		{name:'Ссылка', key:'L', openBlockWith:'[url=[![Адрес с http://]!]]', closeBlockWith:'[/url]', className:"link", dropMenu: [
			{name:'Ссылка (адрес и текст)', openBlockWith:'[url=[![Адрес с http://]!]][![Текст ссылки]!][/url]', closeBlockWith:'', className:"link"}, 
		]},
		      
 		{name:'Цитата', openBlockWith:'[quote]\n', closeBlockWith:'\n[/quote]', className:"quote", dropMenu: [
			{name:'Цитата (блок)', openBlockWith:'\n[quote]\n', closeBlockWith:'\n[/quote]', className:"quote"}, 
			{name:'Цитирование в строке', openBlockWith:'[q]', closeBlockWith:'[/q]', className:"quote"}, 
			{name:'Абревиатура', openBlockWith:'[abbr [![Определение]!]]', closeBlockWith:'[/abbr]', className:"abbr"}, 
			{name:'Сноска', openBlockWith:'[cite]', closeBlockWith:'[/cite]', className:"cite"}, 
			{name:'Адрес', openBlockWith:'[address]', closeBlockWith:'[/address]', className:"address"}, 
			{name:'Новый термин', openBlockWith:'[dfn]', closeBlockWith:'[/dfn]', className:"dfn"}, 
		]},
	
		{name:'Изображение', openBlockWith:'[img [![Описание]!]][![Адрес]!][/img]', className:"picture", dropMenu: [
			{name:'Изображение', replaceWith:'[img][![Адрес]!][/img]', className:"picture"}, 
			{separator:'---------------' },
			{name:'[img]', openBlockWith:'[img [![Описание]!]][![Адрес]!][/img]', className:"image_add"},
			{name:'[img(left)]', openBlockWith:'[img(left) [![Описание]!]][![Адрес]!][/img]', className:"image_add"},
			{name:'[img(right)]', openBlockWith:'[img(right) [![Описание]!]][![Адрес]!][/img]', className:"image_add"},
			{name:'[img(center)]', openBlockWith:'[img(center) [![Описание]!]][![Адрес]!][/img]', className:"image_add"},
		]},
	
		{name:'Цвет', openWith:'[color=[![Color]!]]', closeWith:'[/color]', className:"colors", dropMenu: [
			{name:'Желтый', openWith:'[color=yellow]', closeWith:'[/color]', className:"col-yellow" },
			{name:'Оранжевый', openWith:'[color=orange]', closeWith:'[/color]', className:"col-orange" },
			{name:'Красный', openWith:'[color=red]', closeWith:'[/color]', className:"col-red" },
			{name:'Синий', openWith:'[color=blue]', closeWith:'[/color]', className:"col-blue" },
			{name:'Фиолетовый', openWith:'[color=purple]', closeWith:'[/color]', className:"col-purple" },
			{name:'Зеленый', openWith:'[color=green]', closeWith:'[/color]', className:"col-green" },
			{name:'Белый', openWith:'[color=white]', closeWith:'[/color]', className:"col-white" },
			{name:'Серый', openWith:'[color=gray]', closeWith:'[/color]', className:"col-gray" },
			{name:'Черный', openWith:'[color=black]', closeWith:'[/color]', className:"col-black" },
			{name:'Ярко-голубой', openWith:'[color=cyan]', closeWith:'[/color]', className:"col-cyan" },
			{name:'Ярко-зеленый', openWith:'[color=lime]', closeWith:'[/color]', className:"col-lime" },
			
			{name:'Таблица цветов', className:'help', beforeInsert:function(){miu.select_colors();}, className:"col-select"},
			
		]},
		
		<?php if ($smiles) echo $smiles ?>
		
		
		{separator:'---------------' },
		
		{name:'Выравнивание', openWith:'[pleft]', closeWith:'[/pleft]', className:"left", dropMenu :[  
			{name:'Абзац влево', openWith:'[pleft]', closeWith:'[/pleft]', className:"left" },
			{name:'Абзац по центру', openWith:'[pcenter]', closeWith:'[/pcenter]', className:"center" },
			{name:'Абзац вправо', openWith:'[pright]', closeWith:'[/pright]', className:"right" },
			{name:'Абзац по формату', openWith:'[pjustify]', closeWith:'[/pjustify]', className:"justify" },
			
			{separator:'---------------' },
			
			{name:'Блок влево', openWith:'[left]', closeWith:'[/left]', className:"text-padding-left"}, 
			{name:'Блок по центру', openWith:'[center]', closeWith:'[/center]', className:"text-padding-center"},       
			{name:'Блок вправо', openWith:'[right]', closeWith:'[/right]', className:"text-padding-right"}, 
			{name:'Блок по формату', openWith:'[justify]', closeWith:'[/justify]', className:"text-padding-justify"}, 
			
			{separator:'---------------' },
			
			{name:'p - абзац', openWith:'[p]', closeWith:'[/p]', className:"add"}, 
			
			{separator:'---------------' },
			
			{name:'div.class', openBlockWith:'[div([![Css class]!])]', closeBlockWith:'[/div]', className:"add"}, 
			{name:'span.class', openBlockWith:'[span([![Css class]!])]', closeBlockWith:'[/span]', className:"add"}, 
			{name:'&lt;div свойства&gt;', openBlockWith:'[div [![Свойства]!]]', closeBlockWith:'[/div]', className:"add"}, 
			{name:'&lt;span свойства&gt;', openBlockWith:'[span [![Свойства]!]]', closeBlockWith:'[/span]', className:"add"}, 
		]},

		{name:'Заголовок', openWith:'[h1]', closeWith:'[/h1]', className:"h1", dropMenu: [
			{name:'Заголовок 1', openWith:'[h1]', closeWith:'[/h1]', className:"h1"}, 
			{name:'Заголовок 2', openWith:'[h2]', closeWith:'[/h2]', className:"h2"}, 
			{name:'Заголовок 3', openWith:'[h3]', closeWith:'[/h3]', className:"h3"}, 
			{name:'Заголовок 4', openWith:'[h4]', closeWith:'[/h4]', className:"h4"}, 
			{name:'Заголовок 5', openWith:'[h5]', closeWith:'[/h5]', className:"h5"}, 
			{name:'Заголовок 6', openWith:'[h6]', closeWith:'[/h6]', className:"h6"}, 
		]},
		
		{name: 'Список', className:"list-bullet", openBlockWith:'[list]\n', openWith:'[*]', closeWith:'', closeBlockWith:'\n[/list]', multiline:true, dropMenu: [ 
			{name:'Номера', className:'list-numeric', openBlockWith:'[ol]\n', openWith:'[*]', closeWith:'', closeBlockWith:'\n[/ol]', multiline:true}, 
			{name:'Элемент списка', openWith:'[*]', className:"list-item"},
		
			{separator:'---------------' },
			
			{name:'Список определений', openBlockWith:'\n[dl]\n', closeBlockWith:'\n[/dl]', className:"dl"}, 
			{name:'Определение', openBlockWith:'[dt]', closeBlockWith:'[/dt]', className:"dl"}, 
			{name:'Описание', openBlockWith:'[dd]', closeBlockWith:'[/dd]', className:"dl"}, 
			{name:'Заготовка', openBlockWith:'\n[dl]\n[dt]Определение[/dt]\n[dd]Описание[/dd]\n\n[dt]Определение[/dt]\n[dd]Описание[/dd]\n[/dl]', closeBlockWith:'', className:"dl"}, 
		]},
		
		{name:'Таблица', openBlockWith:'\n[table]\n', closeBlockWith:'\n[/table]', className:"table", dropMenu: [
			{name:'Таблица', openBlockWith:'\n[table]\n', closeBlockWith:'\n[/table]\n', className:"table-add"}, 
			
			{name:'Строка', openBlockWith:'[tr]\n', closeBlockWith:'\n[/tr]',  className:"table-row-insert"}, 
			
			{name:'Строка ячеек', openBlockWith:'[tr]\n', closeBlockWith:'\n[/tr]', openWith:'[td]', closeWith:'[/td]', className:"table-row-insert"},
			
			{name:'Ячейки', openWith:'[td]', closeWith:'[/td]', className:"table-select"}, 
			
			{name:'Заготовка1', openBlockWith:'[table]\n[tr]\n[td] [/td]\n[td] [/td]\n[td] [/td]\n[/tr]\n[/table]', className:"table-go"}, 
			{name:'Заготовка2', openBlockWith:'\n[tr]\n[td] [/td]\n[td] [/td]\n[td] [/td]\n[/tr]', className:"table-go"}, 
		]},

		{separator:'---------------'},

		{name:'Преформатированный текст с подсветкой синтаксиса', openBlockWith:'[pre]', closeBlockWith:'[/pre]', className:"code", dropMenu: [
			{name:'Обычный текст', openBlockWith:'[pre]', closeBlockWith:'[/pre]', className:"text" },
			{name:'PHP-код', openBlockWith:'[pre lang=php]', closeBlockWith:'[/pre]', className:"php" },
			{name:'HTML-код', openBlockWith:'[pre lang=html]', closeBlockWith:'[/pre]', className:"html-pre" },
			{name:'CSS-код', openBlockWith:'[pre lang=css]', closeBlockWith:'[/pre]', className:"css" },
			{name:'JavaScript-код', openBlockWith:'[pre lang=js]', closeBlockWith:'[/pre]', className:"js" },
			{name:'Delphi/Pascal-код', openBlockWith:'[pre lang=delphi]', closeBlockWith:'[/pre]', className:"delphi" },
			{name:'SQL-код', openBlockWith:'[pre lang=sql]', closeBlockWith:'[/pre]', className:"sql" },
			{name:'C#-код', openBlockWith:'[pre lang=csharp]', closeBlockWith:'[/pre]', className:"csharp" },
			{name:'XML-код', openBlockWith:'[pre lang=xml]', closeBlockWith:'[/pre]', className:"xml" }
		]},

		{name:'Очистить текст от BB-кодов', className:"clean", replaceWith:function(h) { return h.selection.replace(/\[(.*?)\]/g, "") }, className:"clean", dropMenu: [
	
			{name:'Очистить текст от BB-кодов', className:"clean", replaceWith:function(h) { return h.selection.replace(/\[(.*?)\]/g, "") }, className:"clean"},
			
			{name:'Очистить текст от HTML', className:"clean", replaceWith:function(h) { return h.selection.replace(/\<(.*?)\>/g, "") }, className:"clean"},

			{name:'Замена в тексте', className:'qrepl', beforeInsert:function(markItUp) { miu.repl(markItUp) }},

			{separator:'---------------' },

			{name:'Принудительный перенос', replaceWith:'[br]\n', className:"page-red"},
			{name:'Линия', openBlockWith:'\n[hr]\n', className:"hr"}, 

			{separator:'---------------' },

			<?php if (function_exists('run_php_custom')) { ?>
			{name:'Выполнить PHP-код', openBlockWith:'[php]', closeBlockWith:'[/php]', className:"php"},
			<?php } ?>

			{name:'Выполнить HTML-код', openBlockWith:'[html]', closeBlockWith:'[/html]', className:"html-code"}, 

			<?php if (function_exists('ushka')) { ?>
			{separator:'---------------' },
			{name:'Ушка', openBlockWith:'[ushka=[![Имя ушки]!]]', closeBlockWith:'', className:"add"}, 
			<?php } ?>
			
			
			<?php if (function_exists('down_count_content')) { ?>
			{separator:'---------------' },
			{name:'Счетчик перехода', openBlockWith:'[dc]', closeBlockWith:'[/dc]', className:"add"}, 
			<?php } ?>

			<?php if (function_exists('audioplayer_content')) { ?>
			{separator:'---------------' },
			{name:'Аудиоплеер MP3', replaceWith:'[audio=[![Адрес]!]]', className:"audio"}, 
			<?php } ?>

			<?php if (function_exists('faq_custom')) { ?>
			{separator:'---------------' },
			{name:'FAQ (заготовка)', openBlockWith:'[faqs]\n[faq=вопрос]ответ[/faq]\n[faq=вопрос2]ответ2[/faq]\n[/faqs]', closeBlockWith:'', className:"add"}, 
			<?php } ?>


			<?php if (function_exists('spoiler_custom')) { ?>
			{separator:'---------------' },
			{name:'Показать/спрятать (spoiler)', openBlockWith:'[spoiler=[![Заголовок блока]!]]', closeBlockWith:'[/spoiler]', className:"add"}, 
			<?php } ?>

			<?php if (function_exists('auth_content_parse')) { ?>
			{separator:'---------------' },
			{name:'Спрятать от незалогиненных', openBlockWith:'[auth]', closeBlockWith:'[/auth]', className:"add"}, 
			<?php } ?>

			<?php if (function_exists('forms_content')) { ?>
			{separator:'---------------' },
			{name:'Форма (заготовка)', openBlockWith:'[form] \n[email=mylo@sait.com] \n[redirect=http://site.com/] \n[subject=Моя форма] \n \n[field] \nrequire = 1   \ntype = select \ndescription = Выберите специалиста \nvalues = Иванов # Петров # Сидоров\ndefault = Иванов\ntip = Подсказка к полю \n[/field] \n \n[field] \nrequire = 0   \ntype = text \ndescription = Ваш город\ntip = Указывайте вместе со страной\n[/field] \n \n[field] \nrequire = 1 \ntype = textarea \ndescription = Ваш вопрос \n[/field] \n \n[/form]', closeBlockWith:'', className:"add"}, 
			<?php } ?>


		]},

		{separator:'---------------' },

		{name:'Отрезать для анонса', replaceWith:'[cut]\n', className:"separator"}, 

		{separator:'---------------' },

		{name:'Быстрое сохранение текста', className:'qsave', key:"S", beforeInsert:function(markItUp) { miu.save(markItUp) }},
		{name:'Предпросмотр (с ALT скрыть)', className:'preview', call:'preview', key:"E"},
		{name:'Полноэкранный режим редактора (F2)', className:'fullscreen', beforeInsert:function(){shsh();} },

		{separator:'---------------' },

		{name:'Помощь по BB-кодам', className:'help', beforeInsert:function(){miu.help_bb();} },

		<?php mso_hook('editor_markitup_bbcode') ?>

	]
}

miu = {
	save: function(markItUp) 
	{
		data = markItUp.textarea.value;
		$.post(autosaveurl, {"text": data, "id": autosaveid}, 
			function(response) 
			{
				var dd = new Date();
				$('span.autosave-editor').html('<a target="_blank" href="' + response + '">Сохранено в ' + dd.toLocaleTimeString() + '</a>');
				alert("Сохранено!");
				
			});
	},

	repl: function(markItUp) 
	{
		str = markItUp.textarea.value;
		
		var s_search = prompt('Что ищем?');
		var s_replace = prompt('На что меняем?');
		
		markItUp.textarea.value = str.replace(new RegExp(s_search,'g'), s_replace)
		
		alert("Выполнено!");
	},	
	
	help_bb: function()
	{
		window.open('<?= getinfo('siteurl') ?>application/maxsite/plugins/bbcode/bbcode-help.html');
	},

	select_colors: function()
	{
		window.open('<?= getinfo('siteurl') ?>application/maxsite/plugins/editor_markitup/color-table.html');
	},
	
}

