<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * RGaysin
 * (c) http://rgblog.ru/
 */

function seogen_autoload() 
{
	mso_hook_add('edit_page', 'seogen_page');
	mso_hook_add('new_page', 'seogen_page');
}

# функция выполняется при деинсталяции плагина
function seogen_uninstall($args = array())
{
	// константа
	$options_key = 'plugin_seogen';
	mso_delete_option($options_key,'plugins');
	return $args;
}

# функция отрабатывающая миниопции плагина (function плагин_mso_options)
function seogen_mso_options() 
{
	//global $blackList_def;
	# ключ, тип, ключи массива
	mso_admin_plugin_options('plugin_seogen', 'plugins', 
		array(
			'top1' => array(
							'type' => 'info', 
							'title' => 'Заголовок', 
						),
			'titletype' => array(
							'type' => 'select', 
							'name' => 'Тип заголовка', 
							'description' => 'Выберите тип построения мета заголовка',
							'values' => '0||Заголовок+Название # 1||Название+заголовок # 2||Только заголовок',
							'default' => '0'
								
						),
			'nsite' => array(
							'type' => 'text', 
							'name' => 'Добавочный заголовок', 
							'description' => 'Добавляемый заголовок в meta title, вместо названия сайта', 
							'default' => getinfo('name_site')
						),	
			'sep' => array(
							'type' => 'text', 
							'name' => 'Разделитель', 
							'description' => 'Разделитель между заголовком и добавочный заголовком', 
							'default' => '|'
						),	
			'top2' => array(
							'type' => 'info', 
							'title' => 'Описание', 
						),
			'thelength' => array(
							'type' => 'text', 
							'name' => 'Длина описания', 
							'description' => 'Длина обрезки текста для мета-тега description', 
							'default' => '300'
						),
			'top3' => array(
							'type' => 'info', 
							'title' => 'Ключевые слова', 
						),
			'count' => array(
							'type' => 'text', 
							'name' => 'Количество ключевых слов', 
							'description' => 'Укажите максимальное количество ключевых слов', 
							'default' => '20'
						),
			'minlength' => array(
							'type' => 'text', 
							'name' => 'Длина слова', 
							'description' => 'Минимальная длина ключевого слова', 
							'default' => '4'
						),
			'usetitle' => array(
							'type' => 'select', 
							'name' => 'Использовать заголовок', 
							'description' => 'Использовать заголовок при создании ключевых слов',
							'values' => '0||Нет # 1||Да',
							'default' => '1'
								
						),
			'staticwords' => array(
							'type' => 'textarea', 
							'name' => 'Постоянные слова', 
							'description' => 'Список постоянных ключевых слов', 
							'rows' => 2,
							'default' => ''
						),
			'blacklist' => array(
							'type' => 'textarea', 
							'name' => 'Black List', 
							'description' => 'Список запрещенных слов', 
							'default' => blacklist(),
							'rows' => 6
						),
		),
		'Настройка плагина "СЕО Генератор"', // титул
		'Укажите необходимые опции.'   // инфо
	);
}

function cleanText( $str ) {
	// Основные
	$str = preg_replace( "'<script[^>]*>.*?</script>'si", '', $str );
	$str = preg_replace( '/<!--.+?-->/', '', $str );
	$str = preg_replace( '/{.+?}/', '', $str );
	// Картинки
	$str = preg_replace( '/\[image.+?\]http.+?\[\/image\]/', '', $str ); 
	$str = preg_replace( '/\[img.+?\]http.+?\[\/img\]/', '', $str );
	// Галерея
	$str = preg_replace( '/\[gal.+?\]http.+?\[\/gal\]/', '', $str );	
	// Удаление BB кодов
	$str = preg_replace( '/\[.+?\]/', '', $str );                

	// convert html entities to chars (with conditional for PHP4 users
	if(( version_compare( phpversion(), '5.0' ) < 0 )) {
		require_once(JPATH_SITE.DS.'libraries'.DS.'tcpdf'.DS.'html_entity_decode_php4.php');
		$str = html_entity_decode_php4($str,ENT_QUOTES,'UTF-8');
	}else{
		$str = html_entity_decode($str,ENT_QUOTES,'UTF-8');
	}

	$str = strip_tags( $str );
    $str = str_replace('"', '\'', $str);
    $str = str_replace(array("\r\n", "\r", "\n", "\t"), " ", $str);

	while (strchr($str,"  ")) {
		$str = str_replace("  ", " ",$str);
	}
	for ($cnt = 1; $cnt < strlen($str)-1; $cnt++) {
		if ( ($str{$cnt} == '.') || (($str{$cnt} == ',') && !(is_numeric($str{$cnt+1})))) {
			if ($str{$cnt+1} != ' ') {
				$str = substr_replace($str, ' ', $cnt + 1, 0);
			}
		}
	}
	return $str;
}

function seogenkey($keys, $blackList, $count, $minLength) {
	$keywords ='';

	//Удаление HTML тегов
    $keys = preg_replace('/<[^>]*>/', ' ', $keys);	
    $keys = preg_replace('/[\.;:!?|\'|\"|\`|\,|\(|\)|\-]/', ' ', $keys);	

	$keysArray = explode(" ", $keys);
	$keysArray = array_count_values(array_map('mb_strtolower', $keysArray));
 
	$blackArray = explode(",", $blackList);
	
	foreach($blackArray as $blackWord)
	{
		if(isset($keysArray[trim($blackWord)]))
		unset($keysArray[trim($blackWord)]);
	}

	arsort($keysArray);
	
	$i = 1;
	
	foreach($keysArray as $word=>$instances)
	{
		if($i > $count)	break;
		if(mb_strlen(trim($word)) >= $minLength ) {
			$keywords .= $word . ", ";
			$i++;
		}
	}
	
	$keywords = rtrim($keywords, ", ");
	return($keywords);
}	

function blacklist()
{
	return 'а, акт, ах, б, бежал, без, безусловно, белый, бери, благодарственное, благодарю, благодаря, близко, более, более-менее, большая, больше, большие, больших, большое, большой, большую, боюсь, будем, будет, будете, будешь, буду, будут, будучи, будь, будьте, бы, бывших, был, была, были, было, быстро, бытие, быть, в, в течение, важно, вам, вами, вас, ваш, ваше, вашего, вашей, вашем, вашему, ваши, вашим, вашими, ваших, вашу, вблизи, вверх, вдали, вдоль, ведь, везде, великий, великолепно, верить, вероятно, весь, весьма, вещи, вещь, взял, взять, вида, виде, видел, видеть, видимому, виду, видя, визит, вкл, влево, вместе, вместо, вне, внезапно, вниз, внизу, внутренний, внутри, внутрь, во, возле, возможно, возраст, вокруг, воля, вообще, восемь, восемьдесят, восмерых, восмью, восьмеро, восьмерым, восьмерыми, восьми, восьмого, восьмой, восьмом, восьмому, восьмым, восьмых, вот, вперед, вполне, временами, временем, времени, время, вряд, все, всевозможным, всегда, всего, всей, всем, всеми, всему, всех, всею, вслед, вследствие, встретились, встроенные, всяк, всякая, всякие, всякий, всяким, всякими, всяких, всякого, всякое, всякой, всяком, всякому, всякую, всё-таки, второго, второй, втором, второму, вторым, вторых, вы, выбрать, выглядит, выглядят, вызов, выкл, выключено, выполнить, вырезать, вырос, высокая, высокий, высшие, выше, вышла, г, где, главным, глагол, глубокий, гнев, го, говорит, говорить, горазд, гораздо, горе, горячий, готово, гран, д, да, давай, давал, давали, давать, дает, даже, дал, далее, далеко, дальше, данном, данную, даются, два, двигаться, двоих, двум, двумя, двух, девяносто, девятеро, девяти, девятом, девятому, девятый, девятым, девятыми, девятых, девять, девятью, действительно, делает, делать, деле, день, держал, держать, держит, десятеро, десятерых, десяти, десятом, десятый, десятым, десятых, десять, длинный, для, дней, днем, дням, днями, днях, до, добавить, довольно, должен, должна, должно, должного, должны, дома, доме, домом, дому, достаточно, достижения, доступно, другие, другими, других, другое, другой, другом, думать, е, его, ее, ей, если, есть, еще, ещё, её, ж, жабе, жаль, же, железо, животное, з, за, забыл, зависящей, зависящие, завтра, закрыть, залив, занято, заполнить, заранее, затем, затем-то, захотел, захотела, захотели, захочу, зачем, зачем-то, здесь, зеленые, знает, знаешь, знак, знал, знала, знали, знало, знать, значит, значительно, значительный, знаю, и, игнорируются, идет, из, из-за, из-под, известной, известным, извините, или, им, имеет, именно, иметь, имхо, имя, иначе, иногда, искал, искала, искали, искало, искать, исключением, использование, использованию, использования, используемых, итак, их, ищет, к, к сведению, каждая, каждое, каждые, каждый, кажется, кажущийся, казалось, как, как-то, какая, какие, каким, каких, какого, какое, какой, каком, какому, какую, когда, когда-нибудь, кого, количество, ком, кому, конец, конечно, контрольный, копия, корреспонденты, которая, которого, которое, которой, котором, которому, которою, которую, которые, который, которым, которыми, которых, краткой, крик, кроме, кстати, кто, кто-то, куда, купить, курс, л, легко, летняя, ли, либо, личной, лишь, луна, лучшая, лучше, лучшее, лучшие, лучший, любая, любого, любое, любой, любом, любому, любую, любые, любым, любыми, любых, м, маленькая, маленький, маленьким, маленького, маленькое, маленькой, маленьком, маленькому, маленькую, мало, малых, мальчик, мая, между, мелко, менее, меньше, меня, мере, месте, мешок, милый, миля, минимум, минус, мисс, мне, многие, многими, много, многократные, множество, мной, мною, моги, могите, могла, могли, могло, могу, могут, мое, моего, моей, моем, моему, моею, можем, может, можете, можешь, можно, мои, моим, моими, моих, мой, молодые, мочь, мы, н, на, навсегда, над, надеемся, надо, назад, наиболее, наименее, найдены, найти, наконец, нам, нами, напишет, напишу, напишут, например, нас, насладиться, настоящее, настоящему, научили, начал, начала, начать, наш, наша, наше, нашего, нашей, нашем, нашему, нашею, наши, нашим, нашими, наших, нашу, не, невозможность, него, недавно, нежели, независимо, некоторые, некто, нельзя, нем, немедленный, немногие, немного, нему, необходимое, необходимости, необходимым, необыкновенно, непосредственно, несколько, несмотря, нет, неужели, неё, ни, нибудь, нигде, ниже, нижней, низкой, никогда, никто, ними, них, ничего, ничто, но, новая, нового, новое, новой, новом, новому, новостей, новости, новость, новостями, новую, новые, новый, новым, новых, ноги, ноль, номер, нормально, ноу, ну, нужен, нужно, нужны, нуль, о, об, обеспечивает, образова, образом, обратно, общее, объяснить, обычно, обычный, один, одинаково, одинаковый, одинокий, одна, однако, одни, одним, одними, одних, одно, одного, одной, одному, одною, одну, одолжить, ожидать, ой, окно, около, окончание, окружении, окуда, он, она, они, оно, оружие, основной, основном, основным, особенно, особливо, от, ответ, ответил, ответила, ответили, ответило, ответить, отдельных, откуда, отличие, отнюдь, оттуда, отчего, офф, очевидно, очень, п, падение, палка, партия, первое, первом, первых, перед, перерыв, петеро, пила, писал, писала, писали, писало, пишет, пишу, пишут, плохо, плюс, по, поблизости, повесить, поворот, погубило, под, подготовка, поднять, подпись, подходит, пожалуйста, пожеланиями, позволить, позволяет, поздней, поздно, позже, пока, покупать, полезного, полностью, половина, половиной, получает, получала, получали, получало, получать, получил, получила, получили, получило, получить, полчаса, помещен, помощь, понимать, понравилось, попробовать, попробуй, попытка, пора, порам, порами, порвал, поре, порой, пору, поры, посему, поскольку, после, последнее, последний, последних, последовали, постепенно, постольку, потом, потому, потому что, потребностями, почему, почти, пошел, пошли, пошло, поэтому, появиться, правда, право, правой, пребывание, пред, предоставляемых, предполагать, прежде, прежнему, при, привели, привет, примерно, принадлежать, принес, принимая, приносить, принято, приходит, приходят, причина, пришел, пришла, про, провал, проверенных, продается, продать, продолжить, произойдет, происходит, просто, против, противном, противоположные, прошел, прошла, прошли, прошло, прошлое, пускай, пусть, пути, путь, пытается, пытался, пятером, пятерых, пяти, пятой, пятом, пятому, пятый, пятым, пятыми, пятых, пять, р, равно, равным, раз, раза, разве, различны, различным, разные, разных, разумно, ранее, рано, раньше, рассмотреть, расти, реже, решить, родился, роман, рука, рядом, с, сам, сама, сами, самим, самими, самих, само, самого, самое, самой, самом, самому, самоя, саму, самую, самые, самый, самым, самыми, самых, сверх, свое, своего, своей, своем, своему, своею, свои, своим, своими, своих, свой, свою, своя, сделайте, сделал, сделала, сделали, сделало, сделаны, сделка, себе, себя, сегодня, седьмому, седьмым, седьмыми, седьмых, сейчас, семеро, семерых, семи, семь, сердится, серый, серьезно, серьезный, сильнее, сильно, сильного, сильное, сильной, сим, скажем, сказал, сказать, сквозь, сколь, сколько, скорее, скоро, скруп, следить, следовало, следовательно, следует, следующие, следующий, слишком, случае, случаем, случай, случайно, случаю, случая, слышали, смею, смотреть, смотри, смотря, снаружи, снизу, снова, со, собака, собой, собою, собственные, совсем, согласен, содержать, содержащие, содержит, сожалению, сомнение, соответственно, состоялась, состоянии, спасибо, справочной, спросить, сравнительно, среди, средний, средняя, стал, становится, старая, старого, старое, старой, старом, старому, старую, старый, старым, старых, стать, сто, стоимость, сторона, стороне, сторону, стояли, страх, стремится, суб, схожи, считать, съесть, сюда, т, так, такая, также, такие, таким, такими, таких, такого, такое, такой, таком, такому, такою, там, твое, твоего, твои, твой, твою, твоя, те, тебе, тебя, тело, тем, теми, темный, теперь, тетя, то, тобой, тобою, тогда, того, тоже, той, только, том, тому, точно, требуются, трем, тремя, третий, третьим, третьими, третьих, трех, три, тридцать, троим, троими, троих, трудно, туда, тур, тут, тщательно, ты, тысяч, тысячи, тянуть, у, убежище, уверен, угадать, угодно, ужасно, уже, узнает, узнают, указав, указанный, указанных, указать, указывает, указывают, умереть, упал, усилие, услышать, ухо, учитывая, ушел, ушла, ушли, ушло, ф, фоне, фронт, х, хит, ходил, ходила, ходили, ходило, ходит, ходить, ходят, хорошо, хотел, хотела, хотели, хотело, хоть, хотя, хотят, хочу, ц, ч, часа, часов, частей, части, часто, частью, чаще, чего, чего-то, чей, чем, чем-то, чему, червертых, через, четвертое, четвертом, четвертому, четвертый, четвертым, четвертыми, четверть, четыре, чистая, чисто, чистый, чрезвычайно, что, чтоб, чтобы, чувственно, чувствовал, чувствовать, чудо, чуть, чьей, чьему, чьим, чьими, чьих, чья, чьё, ш, шаг, шестеро, шестеры, шестого, шестой, шестому, шестым, шестыми, шесть, шестью, шляпа, щ, ы, ь, э, экс, эта, эти, этим, этими, этих, это, этого, этой, этом, этому, этот, ю, я, яблоко, является, являются, ясно, ё';
}

function seogen_page($args)
{
	//global $blackList_def;
	$options = mso_get_option('plugin_seogen', 'plugins', array() ); // получаем опции
	if (!isset($options['count'])) { $count = 20; } else { $count = $options['count']; }
	if (!isset($options['minlength'])) { $minLength = 4; } else { $minLength = $options['minlength']; }
	if (!isset($options['thelength'])) { $thelength = 300; } else { $thelength = $options['thelength']; }
	if (!isset($options['sep'])) { $sep = '|'; } else { $sep = $options['sep']; }
	if (!isset($options['titletype'])) { $title_type = 0; } else { $title_type = $options['titletype']; }
	if (!isset($options['usetitle'])) { $use_title = 1; } else { $use_title = $options['usetitle']; }
	if (!isset($options['nsite'])) { $nsite = getinfo('name_site'); } else { $nsite = $options['nsite']; }
	if (!isset($options['statickeywords'])) { $statickeywords = ''; } else { $statickeywords = $options['statickeywords']; }
	if (!isset($options['blackList'])) { $blackList = blacklist(); } else { $blackList = $options['blackList']; }
	$id = $args[0];
	$CI = & get_instance();
	//Получаем заголовок и контент страницы
	$CI->db->select('page_title, page_content');
	$CI->db->where(array('page_id'=>$id));
	$query = $CI->db->get('page');
	if ($query->num_rows()>0)
	{
		$rows = $query->result_array();
		$row = $rows[0];
		$ptitle = $row['page_title'];
		$pcontent = $row['page_content'];
	}
	//Получаем мета-теги страницы
	$CI->db->select('meta_key, meta_value');
	$CI->db->where(array('meta_id_obj'=>$id));
	$query = $CI->db->get('meta');
	if ($query->num_rows()>0)
	{
		$rows = $query->result_array();
		foreach ($rows as $row)
			$meta[$row['meta_key']] = $row['meta_value'];
	}
	
	$pcontent = CleanText($pcontent);

	if ((!isset($meta['description']))or(trim($meta['description'])==''))
	{
		$desc = $pcontent . ' ';
		$desc = substr($desc,0,$thelength);
		$desc = substr($desc,0,strrpos($desc,' '));
		mso_add_meta('description',$id,'page',$desc);
	}

	if ((!isset($meta['title']))or(trim($meta['title'])==''))
	{
		if ($title_type == 0):
			$newtitle = $ptitle . ' ' . $sep . ' ' . $nsite;
		elseif ($title_type == 1):
			$newtitle = $nsite . ' ' . $sep . ' ' . $ptitle;
		elseif ($title_type == 2):
			$newtitle = $ptitle;
		endif;
		mso_add_meta('title',$id,'page',$newtitle);
	}

	if ((!isset($meta['keywords']))or(trim($meta['keywords'])==''))
	{	
		CleanText($ptitle);
		if ($use_title == 0) { $keys = $pcontent; }
		else { $keys = $ptitle . ' ' . $pcontent; }
		$keywords = seogenkey($keys, $blackList, $count, $minLength);
		if ($statickeywords <> '') { $keywords = $statickeywords . ', '. $keywords; }
		mso_add_meta('keywords',$id,'page',$keywords);
	}
	return $args;
}


?>
