<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */
 	$antispam1 = rand(1, 10);
	$antispam2 = rand(1, 10);
		
	if( !isset($options['fields_prefs']) )
	{
		$options['fields_prefs'] = '';
	}
		
	$options['fields_prefs'] =
		'login-plugin | Войти с помощью '.NR.
		'email | Ваш E-mail | required'.NR.
		'password | Пароль | required'.NR.
		'comusers_nik | Ваше имя | '.( $options['anonymous'] ? 'required' : '' ).NR.
		'comusers_url | Сайт'.NR.
		'about | Расскажите немного о себе'.NR.
		'title | Заголовок | required'.NR.
		'text | Текст | required'.NR.
		'attach | Загрузить иллюстрацию'.NR.
		'desc | Краткое описание текста (о чём он?) | required'.NR.
		'category | Рубрика | required'.NR.
		'draft | Черновик'.NR.
		'editormsg | Сообщение редактору | required'.NR.
		'captcha | Защита от спама: введите нижние символы | required'.NR.
		$options['fields_prefs'];
		
	$lnprefs = explode(NR, trim($options['fields_prefs']));
	$fprefs = array();
		
	foreach($lnprefs as $ln){
		$param = array_map('trim', explode('|', trim($ln)));
		if( isset($param) && $param[0] <> '' )
		{
			$fprefs[$param[0]]['title'] = isset($param[1]) ? $param[1] : '';
			$fprefs[$param[0]]['req'] = (isset($param[2]) && $param[2] == 'required') ? ' required="'.$param[2].'"' : '';
		}
	}

$out .= '
<header>
	<h1>'.$options['title'].'</h1>
</header>
<div class="submit_article_form">'.NR;
		
	if( isset($error) && $error ) # блок для повторного вывода формы с ранее введенными данными
	{
		$out .= $error.NR; # добавляем к выводу сообщения об ошибке, которые возникли при проверке присланных данных
			
		if( $post ) # если действительно был POST запрос
		{
			# Приведение строк с <br> в первозданный вид
			if( isset($post['text']) && $options['editor'] <> '3' )
			{
				$post['text'] = htmlspecialchars($post['text']);
				$post['text'] = preg_replace('"&lt;br\s?/?&gt;"i', "\n", $post['text']);
				$post['text'] = preg_replace('"&lt;br&gt;"i', "\n", $post['text']);
			}
				
			# обязательные поля
			$vals = array(
				'title' => ' value="'.$post['title'].'"',
				'text' => isset($post['text']) ? $post['text'] : '',
				'desc' => isset($post['desc']) ? $post['desc'] : '',
				'category' => isset($post['category']) ? $post['category'] : '',
				'draft' => isset($post['draft'])? ' checked':'',
				'editormsg' => isset($post['editormsg']) ? $post['editormsg'] : '',
				'rules' => isset($post['rules'])? ' checked':'',
				'comusers_nik' => isset($post['comusers_nik']) ? ' value="'.$post['comusers_nik'].'"' : '',
			);
				
			# поля, которые бывают только если не разрешён анонимный постинг или посетитель авторизован
			if( !is_login_comuser() && !$options['anonymous'] )
			{
				if( isset($post['email']) )
				{
					$vals['email'] = ' value="'.$post['email'].'"';
				}
				else
				{
					$vals['email'] = '';
				}
					
				if( $options['show_field_site'] )
				{
					$vals['comusers_url'] = ' value="'.$post['comusers_url'].'"';
				}
					
				if( $options['show_field_author_info'] )
				{
					$vals['about'] = $post['about'];
				}
			}
		}
	}
	elseif( isset($edit) && $edit )
	{
		# Приведение строк с <br> в первозданный вид
		if( isset($pg['page_content']) && $options['editor'] <> '3' )
		{
			$pg['page_content'] = htmlspecialchars($pg['page_content']);
			$pg['page_content'] = preg_replace('"&lt;br\s?/?&gt;"i', "\n", $pg['page_content']);
			$pg['page_content'] = preg_replace('"&lt;br&gt;"i', "\n", $pg['page_content']);
		}	
			
		$vals['email'] = '';
		$vals['comusers_id'] = isset($pg['meta']['comusers_id']) ? $pg['meta']['comusers_id'] : '';
		$vals['comusers_nik'] = isset($pg['meta']['anonymous']) ? $pg['meta']['anonymous'] : '';
		$vals['comusers_url'] = '';
		$vals['about'] = '';
			
		$vals['title'] = isset($pg['meta']['title']) ? $pg['meta']['title'] : $pg['page_title'];
		$vals['title'] = ' value="'.$vals['title'].'"';
		$vals['text'] = $pg['page_content'];
		$vals['desc'] = isset($pg['meta']['description']) ? $pg['meta']['description'] : '';
		$vals['category'] = $pg['category'];
		$vals['draft'] = isset($pg['meta']['draft']) ? ' checked' : '';
		$vals['editormsg'] = isset($pg['meta']['editormsg']) ? $pg['meta']['editormsg'] : '';
	}
	else # задаём пустные значения атрибута value для простого вывода формы
	{
		$vals = array(
			'email' => '',
			'comusers_nik' =>  '',
			'comusers_url' =>  '',
			'about' =>  '',
			'title' => '',
			'text' => '',
			'desc' => '',
			'category' => '',
			'draft' => '',
			'editormsg' => '',
		);
	}

	if( isset($options['text_before']) && $options['text_before'] )
	{
		$out .= '
		<div class="text_before">'.mso_hook('content', $options['text_before']).'</div>'.NR;
	}

	$out .= '
		<form method="post">'.NR;
		
	# информация о постере
	if( !is_login_comuser() && !is_login() )
	{
		if( !isset($options['hide_auth_block']) || !$options['hide_auth_block'] )
		{
			if( !$options['anonymous'] ) # Если разрешен анонимный сабмитинг
			{
				# Использование плагинов авторизации
				if( isset($options['show_auth_services']) && $options['show_auth_services'])
				{
					# Хук для плагинов аутентификации
					$auth_plugin = mso_hook_present('login_form_auth') ? mso_hook('login_form_auth') : '';
						
					if( $auth_plugin )
					{
						$auth_plugin = trim(str_replace('[end]', '', $auth_plugin));
						$out .= '<div class="login_plugin unit"><span class="ftitle">'.$fprefs['login-plugin']['title'].'</span>'.$auth_plugin.'</div>';
					}
				}
					
				$out .= '
						<div class="auth unit">
							<label for="sa_email" class="ftitle">'.$fprefs['email']['title'].'</label>
							<input type="email"'.$fprefs['email']['req'].' name="email" class="email" id="sa_email"'.$vals['email'].'>
							<button type="button" class="copy" title="Использовать email как пароль" onclick="document.getElementById(\'sa_password\').value=document.getElementById(\'sa_email\').value; ">&gt;</button>
							<label for="sa_password" class="ftitle">'.$fprefs['password']['title'].'</label>
							<input type="password"'.$fprefs['password']['req'].' name="password" class="password" id="sa_password">
							<span class="classic">(<a href="/login" rel="nofollow" class="" title="Авторизоваться">Войти</a>/<a href="/registration" rel="nofollow" class="" title="Зарегистрироваться">Регистрация</a>)</span>
						</div>'.NR;
			}
					
			$out .= '
					<div class="comuser unit">
						<label for="sa_comusers_nik" class="ftitle">'.$fprefs['comusers_nik']['title'].'</label>
						<span><input type="text"'.$fprefs['comusers_nik']['req'].' name="comusers_nik" class="comusers_nik" id="sa_comusers_nik"'.$vals['comusers_nik'].'></span>'.NR;
				
			if( $options['show_field_site'] && !$options['anonymous'] )
			{
				$out .= '
							<label for="sa_comusers_url" class="ftitle">'.$fprefs['comusers_url']['title'].'</label>
							<span><input type="url"'.$fprefs['comusers_url']['req'].' name="comusers_url" class="comusers_url" id="sa_comusers_url" size="38"'.$vals['comusers_url'].'></span>'.NR;
			}
				
			$out .= '
					</div>'.NR;
				
			if( $options['show_field_author_info'] && !$options['anonymous'])
			{
				$out .= '
				<div class="about unit">
					<label for="sa_about" class="ftitle ffirst">'.$fprefs['about']['title'].'</label>
					<span>
						<textarea id="sa_about"'.$fprefs['about']['req'].' name="about" cols="90" rows="2" maxlength="1000" class="full98">'.$vals['about'].'</textarea>
					</span>
				</div>'.NR;
			}
		}
		else
		{
			if( isset($options['hide_auth_block_msg']) ) $out .= $options['hide_auth_block_msg'].NR;
		}
		
		if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
	}
	elseif( is_login_comuser() && $options['show_comuser'] )  # Комюзер залогинен, ищем никнейм, аватарку
	{
		require_once( getinfo('common_dir').'comments.php' ); 
		$comuser = array_shift( mso_get_comuser() );
			
		if( isset($options['avatar_size']) && $options['avatar_size'] !== '0' )
		{
			if( $options['avatar_size'] == '' )
				$avatar_size = (int) mso_get_option('gravatar_size', 'templates', 80);
			else
				$avatar_size = $options['avatar_size'];
				
			if( $avatar_size < 1 || $avatar_size > 512 ) $avatar_size = 80;
				
			$avatar_url = $comuser['comusers_avatar_url'];
			if( !$avatar_url ) # аватарки нет, то попробуем получить из gravatara
			{
				if( $comuser['comusers_email'] )
					$grav_email = $comuser['comusers_email'];
				else
					$grav_email = $comments_author_name; # используем имя комментатора
				
				if( $gravatar_type = mso_get_option('gravatar_type', 'templates', '') )
					$d = '&amp;d='.urlencode($gravatar_type);
				else
					$d = '';
				
				if( !empty($_SERVER['HTTPS']) )
				{
				   $avatar_url = "https://secure.gravatar.com/avatar.php?gravatar_id="
						. md5($grav_email)
						. "&amp;size=".$avatar_size
						. $d;
				} 
				else 
				{
				   $avatar_url = "http://www.gravatar.com/avatar.php?gravatar_id="
						. md5($grav_email)
						. "&amp;size=".$avatar_size
						. $d;
				}
			}
			
			if( $avatar_url )
				$avatar_url	= '<img src="'.$avatar_url.'" width="'.$avatar_size.'" height="'.$avatar_size.'" alt="" title="" class="gravatar">';
		}
		else
		{
			$avatar_url	= '';
		}
			
		$out .= '
		<div class="comuser unit">
			'.$avatar_url.'
			<div class="nik">
				<a href="'.getinfo('siteurl').'users/'.$comuser['comusers_id'].'">'.$comuser['comusers_nik'].'</a>
			</div>
			<div class="logout">
				<a href="'.getinfo('siteurl').'logout">Выйти</a>
			</div>
		</div><div class="clearfix"></div>'.NR;
		if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
	}
	elseif( is_login() )
	{
		if( isset($edit) && $edit )
		{
			if( isset($vals['comusers_id']) && $vals['comusers_id'] <> '' )
			{
				$out .= '<input type="hidden" name="comusers_id" value="'.$vals['comusers_id'].'">'.NR;
				$out .= '<input type="hidden" name="page_id" value="'.$pid.'">'.NR;
			}
		}
	}
	elseif( is_login_comuser() && isset($edit) && $edit )
	{
		if( isset($vals['comusers_id']) && $vals['comusers_id'] <> '' )
		{
			$out .= '<input type="hidden" name="comusers_id" value="'.$vals['comusers_id'].'">'.NR;
			$out .= '<input type="hidden" name="page_id" value="'.$pid.'">'.NR;
		}
	}
		
	# Заголовок
	$out .= '
			<div class="title unit">
				<label for="sa_title" class="ftitle ffirst">'.$fprefs['title']['title'].'</label>
				<span>
					<input id="sa_title" type="text"'.$fprefs['title']['req'].' maxlength=200 name="title" class="full98"'.$vals['title'].'>
				</span>
			</div>'.NR;
				
	# Текст
	$out .= '
		<div class="text unit">
			<label for="sa_text" class="ftitle ffirst">'.$fprefs['text']['title'].'</label>
			<span>
				<textarea id="sa_text"'.$fprefs['text']['req'].' name="text" cols="90" rows="20" maxlength="10000" class="full98" style="height:400px;">'.$vals['text'].'</textarea>
			</span>
		</div><div class="clearfix"></div>'.NR;
				
	# Загрузка картинок
	if( $options['can_upload'] )
	{
		$upl_files = $ins_files = '';
			
		$CI->load->helper('directory');
		if( !function_exists('mime_content_type') && function_exists('finfo_open') )
		{
			$finfo = finfo_open(FILEINFO_MIME_TYPE);
		}
			
		# формируем список файлов, загруженных во временную папку
		$folder = preg_replace('/[\/\\\]*$/msi', '', $options['temp_folder']); # убираем слеш в конце строки с названием временной папки
		if( !is_dir(getinfo('uploads_dir').$folder) ) # Проверка существования временной папки
		{
			@mkdir(getinfo('uploads_dir').$folder, 0777); # пробуем создать
			@mkdir(getinfo('uploads_dir').$folder.'/_mso_i', 0777); 
			@mkdir(getinfo('uploads_dir').$folder.'/mini', 0777);
		}
			
		# обработка ранее загруженных файлов
		$all_tmps = directory_map(getinfo('uploads_dir').$folder, 1); # карта каталога uploads
		ksort($all_tmps);
			
		foreach( $all_tmps as $tmps )
		{
			if( preg_match('/(.*?)\.'.$MSO->data['session']['session_id'].'$/msi', $tmps, $match) && file_exists(getinfo('uploads_dir').$folder.'/'.$match[1]) )
			{
				# определяем mime-тип файла
				$typ = '';
				$insfile = getinfo('uploads_dir').$folder.'/'.$match[1];
				if( function_exists('mime_content_type') )
				{
					$typ = mime_content_type($insfile);
				}
				elseif( !function_exists('mime_content_type') && function_exists('finfo_file') )
				{
					$typ = finfo_file($finfo, $insfile);
				}
					
				if( $typ == '' )
				{
					if( preg_match("/([^.]+?)$/i", $insfile, $fileSuffix) )
					{
						if( isset($fileSuffix[1]) && preg_match("/(jpg|jpeg|jpe|gif|png|tiff|bmp)/i", $fileSuffix[1]) )
						{
							$typ = 'image/'.strtolower($fileSuffix[1]);
						}
						elseif( isset($fileSuffix[1]) )
						{
							$typ = "unknown/".strtolower($fileSuffix[1]);
						}
						else
						{
							$typ = "unknown/unknown";
						}
					}
					else
					{
						$typ = "unknown/unknown";
					}
				}
					
				# формируем html-код для кнопок вставки и удаления файла
				$show_ins = ( isset($options['can_insert_upload']) && $options['can_insert_upload'] ) ? '<button class="insert" onclick="insertUpIMG(\''.$match[1].'\', \''.$typ.'\');return false;">Вставить</button>' : '';
				$preview_url = ( preg_match('/image\//i', $typ) ) ? getinfo('uploads_url').$folder.'/_mso_i/'.$match[1] : getinfo('plugins_url').basename(dirname(__FILE__)).'/images/'.'other.png';
				$show_preview = ( isset($options['upload_preview_width']) && $options['upload_preview_width'] > 0 ) ? '<img src="'. $preview_url .'" width="'.$options['upload_preview_width'].'">' : '';
				$upl_files .= '<div class="pic" name="'.$match[1].'">'.$show_preview.'<span><a href="/uploads/'.$folder.'/'.$match[1].'" target="_blank">'.$match[1].'</a></span>'.$show_ins.'<button class="drop" onclick="delUpIMG(\''.$match[1].'\');return false;">Удалить</button></div>'.NR;
				$ins_files .= '<input type="hidden" name="ins_files[]" value="'.$match[1].'">';
			}
		}
			
		# формируем список файлов для режима редактирования
		if( isset($edit) && $edit && ( $admin || $options['can_edit_saved'] ) )
		{
			$folder = '_pages/'.$pid;
				
			# Проверка существования 
			if( !is_dir(getinfo('uploads_dir').$folder) ) // нет каталога
			{
				if( !is_dir(getinfo('uploads_dir').'_pages') ) // нет _pages
				{
					@mkdir(getinfo('uploads_dir').'_pages', 0777); // пробуем создать
				}
			
				// нет каталога, пробуем создать
				@mkdir(getinfo('uploads_dir').$folder, 0777); 
				@mkdir(getinfo('uploads_dir').$folder.'/_mso_i', 0777); 
				@mkdir(getinfo('uploads_dir').$folder.'/mini', 0777);
			}
			
				
			$attaches = directory_map(getinfo('uploads_dir').$folder, 1); # карта каталога uploads
			ksort($attaches);
				
			foreach( $attaches as $attach )
			{
				# определяем mime-тип файла
				$typ = '';
				$insfile = getinfo('uploads_dir').$folder.'/'.$attach;
					
				if( !is_dir($insfile) )
				{
					if( function_exists('mime_content_type') )
					{
						$typ = mime_content_type($insfile);
					}
					elseif( !function_exists('mime_content_type') && function_exists('finfo_file') )
					{
						$typ = finfo_file($finfo, $insfile);
					}
						
					if( $typ == '' )
					{
						if( preg_match("/([^.]+?)$/i", $insfile, $fileSuffix) )
						{
							if( isset($fileSuffix[1]) && preg_match("/(jpg|jpeg|jpe|gif|png|tiff|bmp)/i", $fileSuffix[1]) )
							{
								$typ = 'image/'.strtolower($fileSuffix[1]);
							}
							elseif( isset($fileSuffix[1]) )
							{
								$typ = "unknown/".strtolower($fileSuffix[1]);
							}
							else
							{
								$typ = "unknown/unknown";
							}
						}
						else
						{
							$typ = "unknown/unknown";
						}
					}
						
					# формируем html-код для кнопок вставки и удаления файла
					$show_ins = ( isset($options['can_insert_upload']) && $options['can_insert_upload'] ) ? '<button class="insert" onclick="insertUpIMG(\''.$attach.'\', \''.$typ.'\');return false;">Вставить</button>' : '';
					$preview_url = ( preg_match('/image\//i', $typ) ) ? getinfo('uploads_url').$folder.'/_mso_i/'.$attach : getinfo('plugins_url').basename(dirname(__FILE__)).'/images/'.'other.png';
					$show_preview = ( isset($options['upload_preview_width']) && $options['upload_preview_width'] > 0 ) ? '<img src="'. $preview_url .'" width="'.$options['upload_preview_width'].'">' : '';
					$upl_files .= '<div class="pic" name="'.$attach.'">'.$show_preview.'<span><a href="'.getinfo('uploads_url').$folder.'/'.$attach.'" target="_blank">'.$attach.'</a></span>'.$show_ins.'<button class="drop" onclick="delUpIMG(\''.$attach.'\');return false;">Удалить</button></div>'.NR;
					$ins_files .= '<input type="hidden" name="ins_files[]" data-folder="'.$folder.'" value="'.$attach.'">';
				}
			}
		}
			
		if( isset($options['upload_allowed_size']) && $options['upload_allowed_size'] > 0 && strlen($options['allowed_size_counter_title']) > 0 )
		{
			$counter_div = NR.'					<div class="cnt">'.$options['allowed_size_counter_title'].'<span class="num"></span></div>';
		}
		else
		{
			$counter_div = '';
		}
		
		$out .= '
			<div class="attach unit">
				<label for="attach_img" class="ftitle ffirst">'.$fprefs['attach']['title'].'</label>
				<span>
					<input id="attach_img" type="file" name="attach" data-url="" multiple>
					<div class="loader"><img src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/images/loader.gif" width=16 height=11></div>
					<div class="uploaded">'.$upl_files.'</div>
					<div class="inserted">'.$ins_files.'</div>'.$counter_div.'
				</span>
			</div>'.NR;
		
	}
		
	# Краткое описание
	if( $options['show_field_description'] )
	{
		$out .= '
			<div class="desc unit">
				<label for="sa_desc" class="ftitle ffirst">'.$fprefs['desc']['title'].'</label>
				<span>
					<textarea id="sa_desc"'.$fprefs['desc']['req'].' name="desc" cols="90" rows="5" maxlength="500" class="full98">'.$vals['desc'].'</textarea>
				</span>
			</div>'.NR;
	}
		
	# Рубрики
	if( $options['show_categories'] )
	{
		$out .= '
			<div class="category unit">
				<label'.($options['cat_field_type'] == 0? ' for="sa_category"':'').' class="ftitle ffirst">'.$fprefs['category']['title'].'</label>
				<span>'.NR;
				
		if( $options['cat_field_type'] == 0 )
		{
			# <option value="0">Не задана</option>
			$out .= '
						<select id="sa_category"'.$fprefs['category']['req'].' name="category[]" class="full98" multiple="multiple">
							'.get_categories($options['allow_categories'], $vals['category'], 'select').'
							<!--option value="1">Разное</option-->
						</select>'.NR;
		}
		elseif( $options['cat_field_type'] == 1 )
		{
			$out .= get_categories($options['allow_categories'], $vals['category'], 'checkbox').NR;
		}
			
		$out .= '
				</span>
			</div>'.NR;
	}
		
	# Чекбокс «Черновик»
	if( $options['draft'] )
	{
		$out .= '
			<div class="draft unit">
				<label for="sa_draft" class="ftitle ffirst" title="Поставьте галочку, если материал ещё не готов к публикации">'.$fprefs['draft']['title'].'</label>
				<span>
					<input type="checkbox"'.$fprefs['draft']['req'].' id="sa_draft" name="draft" class="" value=1'.$vals['draft'].'>
				</span>
			</div>'.NR;
	}
		
	if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
		
	# Сообщение редактору
	if( $options['show_field_message_to_editor'] )
	{
		$out .= '
			<div class="editormsg unit">
				<label for="sa_editormsg" class="ftitle ffirst" title="Вы можете обратиться к редактору, например, с просьбой или комментарием к материалу. Буквально несолько слов.">'.$fprefs['editormsg']['title'].'</label>
				<span>
					<textarea id="sa_editormsg"'.$fprefs['editormsg']['req'].' name="editormsg" cols="90" rows="4" maxlength="1000" class="full98">'.$vals['editormsg'].'</textarea>
				</span>
			</div>'.NR;
			
		if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
	}	
		
	# Капча
	if( !is_login_comuser() && !is_login() )
	{
		if( $options['captcha'] == 1 )
		{
			$imgurl = false;
				
			if( function_exists('create_captha_img') ) # новый способ формирования капчи
			{
				$imgurl = create_captha_img( mso_md5( $MSO->data['session']['session_id'].mso_current_url() ) );
			}
			elseif( file_exists(getinfo('plugins_dir').'captcha/img.php') ) # старый способ
			{
				$imgurl = getinfo('plugins_url').'captcha/img.php?image='.$MSO->data['session']['session_id'].'&amp;page='.mso_slug(mso_current_url()).'&amp;code='.time();
			}
				
			if( $imgurl )
			{
				$out .= '<div class="captcha unit">
							<label for="sa_captcha" class="ftitle ffirst">'.$fprefs['captcha']['title'].'</label>
							<div>
								<img src="'.$imgurl.'" alt="" title="Защита от спама: введите только нижние символы"> 
								<input type="text" name="captcha" id="sa_captcha"'.$fprefs['captcha']['req'].' value="" maxlength="4">
								<span>(обязательно)</span>
							</div>
						</div>'.NR;
			}
			else
			{
				$out .= '<div class="captcha unit">
							<div class="message error small">Изображение капчи нечем формировать!</div>
						</div>'.NR;
			}
				
			if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
		}
			
		if( $options['captcha'] == 2 )
		{
			$out .= '
					<div class="captcha unit">
						<label for="sa_captcha" class="ftitle ffirst">'.$fprefs['captcha']['title'].'</label>
						<div>
							<span>'.$antispam1.' + '.$antispam2.' =</span> <input type="text" name="captcha" id="sa_captha"'.$fprefs['captcha']['req'].' value="" maxlength="4"> 
							<input type="hidden" name="antispam1" value="'.($antispam1*984).'">
							<input type="hidden" name="antispam2" value="'.($antispam2*765).'">
							<span>(обязательно)</span>
						</div>
					</div>'.NR;
				
			if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
		}
	}
		
	# Правила сайта
	if( isset($options['show_rules']) && $options['show_rules'] && (!is_login() && !is_login_comuser()) && ( !isset($options['hide_auth_block']) || !$options['hide_auth_block'] ) )
	{
		if( isset($fprefs['rules']['title']) )
		{
			$rules = $fprefs['rules']['title'];
		}
		else
		{
			if( $rules = mso_get_option('rules_site', 'general', '') )
			{
				$rules = 'Я принимаю <a href="'.$rules.'" target="_blank">правила сайта</a>';
			}
			else
			{
				$rules = 'Я принимаю правила сайта';
			}
		}
		$out .= '
			<div class="rules unit">
				<label for="sa_rules" class="ftitle ffirst" title="Поставьте галочку, если согласны с правилами сайта">'.$rules.'</label>
				<span>
					<input type="checkbox" required id="sa_rules" name="rules" class="" value="'.$vals['draft'].'">
				</span>
			</div>'.NR;

		if( $options['delimiter'] <> "" ) $out .= $options['delimiter'].NR;
	}
		
	# Кнопки
	$submit_text = (isset($options['submit_button_text']) && $options['submit_button_text'] != '') ? $options['submit_button_text'] : 'Отправить';
	$out .= '<div class="submit">
				'.mso_form_session('sa_session').'
				<button name="submit" type="submit" class="submit">'.$submit_text.'</button>'.
				(( isset($options['show_reset_button']) && $options['show_reset_button'] == 1 ) ? ' <button name="clear" type="reset" class="reset">Очистить форму</button>' : '').
				(( isset($options['show_preview_button']) && $options['show_preview_button'] == 1 ) ? ' <button type="button" class="preview">Предпросмотр</button>' : '').
			'</div>'.NR;
				
	$out .= '
	</form>'.NR;
	if( isset($options['text_after']) && $options['text_after'] )
	{
		$out .= '
		<div class="text_after">'.mso_hook('content', $options['text_after']).'</div>'.NR;
	}
	$out .= '
</div>';

# Формирование списка рубрик для поля выбора рубрики
function get_categories($allowed = '', $selected = '', $ftype = 'select')
{
	$allow = array_map('trim', explode(',', trim($allowed)));
	$CI = & get_instance();
	$out = '';
		
	if( $ftype == 'select' && (!is_array($selected) || in_array('0', $selected)) )
	{
		$out .= '<option value="0" selected>Не задана</option>'.NR;
	}
		
	# нужно выбрать все рубрики первого уровня
	$CI->db->from('category');
	$CI->db->where('category_id_parent', 0);
	$CI->db->where('category_type', 'page');
	$CI->db->order_by('category_menu_order', 'ASC');
	if($qry = $CI->db->get())
	{ 
		$cats = $qry->result_array();
		foreach( $cats as $c )
		{
			if( in_array($c['category_id'], $allow) || ( $allowed == '' || $allowed == '0' ))
			{
				if( $ftype == 'select' )
				{
					$sel = is_array($selected) && in_array($c['category_id'], $selected) ? ' selected' : '';
					$out .= '<option value="'.$c['category_id'].'" '.$sel.'>'.$c['category_name'].'</option>'.NR;
				}
				elseif( $ftype == 'checkbox' )
				{
					$check = '';
					if( is_array($selected) && in_array($c['category_id'], $selected) )
					{
						$check = ' checked="checked"';
					}
					$out .= '<label><input type="checkbox" class="checkbox" name="category[]" value="'.$c['category_id'].'"'.$check.'>'.$c['category_name'].'</label>'.NR;
				}
			}
		}
	}
		
	return $out;
}
?>